/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.painless.spi.Whitelist;
import org.elasticsearch.painless.spi.WhitelistClass;
import org.elasticsearch.painless.spi.WhitelistClassBinding;
import org.elasticsearch.painless.spi.WhitelistConstructor;
import org.elasticsearch.painless.spi.WhitelistField;
import org.elasticsearch.painless.spi.WhitelistMethod;

public final class WhitelistLoader {
    public static Whitelist loadFromResourceFiles(Class<?> resource, String ... filepaths) {
        ArrayList<WhitelistClass> whitelistClasses = new ArrayList<WhitelistClass>();
        ArrayList<WhitelistMethod> whitelistStatics = new ArrayList<WhitelistMethod>();
        ArrayList<WhitelistClassBinding> whitelistClassBindings = new ArrayList<WhitelistClassBinding>();
        for (String filepath : filepaths) {
            int number = -1;
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(resource.getResourceAsStream(filepath), StandardCharsets.UTF_8));){
                String line;
                String parseType = null;
                String whitelistClassOrigin = null;
                String javaClassName = null;
                boolean noImport = false;
                ArrayList<WhitelistConstructor> whitelistConstructors = null;
                ArrayList<WhitelistMethod> whitelistMethods = null;
                ArrayList<WhitelistField> whitelistFields = null;
                while ((line = reader.readLine()) != null) {
                    String methodName;
                    String[] tokens;
                    String origin;
                    number = reader.getLineNumber();
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    if (line.startsWith("class ")) {
                        if (!line.endsWith("{")) {
                            throw new IllegalArgumentException("invalid class definition: failed to parse class opening bracket [" + line + "]");
                        }
                        if (parseType != null) {
                            throw new IllegalArgumentException("invalid definition: cannot embed class definition [" + line + "]");
                        }
                        String[] tokens2 = line.substring(5, line.length() - 1).trim().split("\\s+");
                        if (tokens2.length == 2 && "no_import".equals(tokens2[1])) {
                            noImport = true;
                        } else if (tokens2.length != 1) {
                            throw new IllegalArgumentException("invalid class definition: failed to parse class name [" + line + "]");
                        }
                        parseType = "class";
                        whitelistClassOrigin = "[" + filepath + "]:[" + number + "]";
                        javaClassName = tokens2[0];
                        whitelistConstructors = new ArrayList<WhitelistConstructor>();
                        whitelistMethods = new ArrayList<WhitelistMethod>();
                        whitelistFields = new ArrayList<WhitelistField>();
                        continue;
                    }
                    if (line.startsWith("static_import ")) {
                        if (!line.endsWith("{")) {
                            throw new IllegalArgumentException("invalid static import definition: failed to parse static import opening bracket [" + line + "]");
                        }
                        if (parseType != null) {
                            throw new IllegalArgumentException("invalid definition: cannot embed static import definition [" + line + "]");
                        }
                        parseType = "static_import";
                        continue;
                    }
                    if (line.equals("}")) {
                        if (parseType == null) {
                            throw new IllegalArgumentException("invalid definition: extraneous closing bracket");
                        }
                        if ("class".equals(parseType)) {
                            whitelistClasses.add(new WhitelistClass(whitelistClassOrigin, javaClassName, noImport, whitelistConstructors, whitelistMethods, whitelistFields));
                            whitelistClassOrigin = null;
                            javaClassName = null;
                            noImport = false;
                            whitelistConstructors = null;
                            whitelistMethods = null;
                            whitelistFields = null;
                        }
                        parseType = null;
                        continue;
                    }
                    if ("static_import".equals(parseType)) {
                        origin = "[" + filepath + "]:[" + number + "]";
                        int parameterStartIndex = line.indexOf(40);
                        if (parameterStartIndex == -1) {
                            throw new IllegalArgumentException("illegal static import definition: start of method parameters not found [" + line + "]");
                        }
                        tokens = line.substring(0, parameterStartIndex).trim().split("\\s+");
                        if (tokens.length != 2) {
                            throw new IllegalArgumentException("invalid method definition: unexpected format [" + line + "]");
                        }
                        methodName = tokens[1];
                        String returnCanonicalTypeName = tokens[0];
                        int parameterEndIndex = line.indexOf(41);
                        if (parameterEndIndex == -1) {
                            throw new IllegalArgumentException("illegal static import definition: end of method parameters not found [" + line + "]");
                        }
                        String[] canonicalTypeNameParameters = line.substring(parameterStartIndex + 1, parameterEndIndex).replaceAll("\\s+", "").split(",");
                        if ("".equals(canonicalTypeNameParameters[0])) {
                            canonicalTypeNameParameters = new String[]{};
                        }
                        if ((tokens = line.substring(parameterEndIndex + 1).trim().split("\\s+")).length != 2) {
                            throw new IllegalArgumentException("invalid static import definition: unexpected format [" + line + "]");
                        }
                        String staticImportType = tokens[0];
                        String targetJavaClassName = tokens[1];
                        if ("from_class".equals(staticImportType)) {
                            whitelistStatics.add(new WhitelistMethod(origin, targetJavaClassName, methodName, returnCanonicalTypeName, Arrays.asList(canonicalTypeNameParameters)));
                            continue;
                        }
                        if ("bound_to".equals(staticImportType)) {
                            whitelistClassBindings.add(new WhitelistClassBinding(origin, targetJavaClassName, methodName, returnCanonicalTypeName, Arrays.asList(canonicalTypeNameParameters)));
                            continue;
                        }
                        throw new IllegalArgumentException("invalid static import definition: unexpected static import type [" + staticImportType + "] [" + line + "]");
                    }
                    if ("class".equals(parseType)) {
                        origin = "[" + filepath + "]:[" + number + "]";
                        if (line.startsWith("(")) {
                            if (!line.endsWith(")")) {
                                throw new IllegalArgumentException("invalid constructor definition: expected a closing parenthesis [" + line + "]");
                            }
                            String[] tokens3 = line.substring(1, line.length() - 1).replaceAll("\\s+", "").split(",");
                            if ("".equals(tokens3[0])) {
                                tokens3 = new String[]{};
                            }
                            whitelistConstructors.add(new WhitelistConstructor(origin, Arrays.asList(tokens3)));
                            continue;
                        }
                        if (line.contains("(")) {
                            String javaAugmentedClassName;
                            if (!line.endsWith(")")) {
                                throw new IllegalArgumentException("invalid method definition: expected a closing parenthesis [" + line + "]");
                            }
                            int parameterIndex = line.indexOf(40);
                            tokens = line.substring(0, parameterIndex).trim().split("\\s+");
                            if (tokens.length == 2) {
                                methodName = tokens[1];
                                javaAugmentedClassName = null;
                            } else if (tokens.length == 3) {
                                methodName = tokens[2];
                                javaAugmentedClassName = tokens[1];
                            } else {
                                throw new IllegalArgumentException("invalid method definition: unexpected format [" + line + "]");
                            }
                            String returnCanonicalTypeName = tokens[0];
                            tokens = line.substring(parameterIndex + 1, line.length() - 1).replaceAll("\\s+", "").split(",");
                            if ("".equals(tokens[0])) {
                                tokens = new String[]{};
                            }
                            whitelistMethods.add(new WhitelistMethod(origin, javaAugmentedClassName, methodName, returnCanonicalTypeName, Arrays.asList(tokens)));
                            continue;
                        }
                        String[] tokens4 = line.split("\\s+");
                        if (tokens4.length != 2) {
                            throw new IllegalArgumentException("invalid field definition: unexpected format [" + line + "]");
                        }
                        whitelistFields.add(new WhitelistField(origin, tokens4[1], tokens4[0]));
                        continue;
                    }
                    throw new IllegalArgumentException("invalid definition: unable to parse line [" + line + "]");
                }
                if (javaClassName == null) continue;
                throw new IllegalArgumentException("invalid definition: expected closing bracket");
            }
            catch (Exception exception) {
                throw new RuntimeException("error in [" + filepath + "] at line [" + number + "]", exception);
            }
        }
        ClassLoader loader = AccessController.doPrivileged(resource::getClassLoader);
        return new Whitelist(loader, whitelistClasses, whitelistStatics, whitelistClassBindings);
    }

    private WhitelistLoader() {
    }
}

