/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.artifacts.transform.ArtifactTransformException;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.api.internal.artifacts.transform.TransformArtifactsAction;
import org.gradle.api.internal.artifacts.transform.TransformedFileCache;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.type.ModelType;

class UserCodeBackedTransformer
implements VariantTransformRegistry.Registration,
ArtifactTransformer {
    private final ImmutableAttributes from;
    private final ImmutableAttributes to;
    private final HashCode inputsHash;
    private final TransformedFileCache transformedFileCache;
    private final TransformArtifactsAction transformer;

    public static UserCodeBackedTransformer create(ImmutableAttributes from, ImmutableAttributes to, Class<? extends ArtifactTransform> implementation, Object[] params, TransformedFileCache transformedFileCache, IsolatableFactory isolatableFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, Instantiator instantiator) {
        Isolatable paramsSnapshot;
        Hasher hasher = Hashing.newHasher();
        hasher.putString((CharSequence)implementation.getName());
        hasher.putHash(classLoaderHierarchyHasher.getClassLoaderHash(implementation.getClassLoader()));
        try {
            paramsSnapshot = isolatableFactory.isolate((Object)params);
        }
        catch (Exception e) {
            throw new VariantTransformConfigurationException(String.format("Could not snapshot configuration values for transform %s: %s", ModelType.of(implementation).getDisplayName(), Arrays.asList(params)), (Throwable)e);
        }
        paramsSnapshot.appendToHasher(hasher);
        TransformArtifactsAction transformer = new TransformArtifactsAction(implementation, (Isolatable<Object[]>)paramsSnapshot, instantiator);
        return new UserCodeBackedTransformer(from, to, transformer, hasher.hash(), transformedFileCache);
    }

    private UserCodeBackedTransformer(ImmutableAttributes from, ImmutableAttributes to, TransformArtifactsAction transformer, HashCode inputHash, TransformedFileCache cache) {
        this.from = from;
        this.to = to;
        this.transformer = transformer;
        this.inputsHash = inputHash;
        this.transformedFileCache = cache;
    }

    @Override
    public AttributeContainerInternal getFrom() {
        return this.from;
    }

    @Override
    public AttributeContainerInternal getTo() {
        return this.to;
    }

    @Override
    public ArtifactTransformer getArtifactTransform() {
        return this;
    }

    public List<File> transform(File input) {
        try {
            File absoluteFile = input.getAbsoluteFile();
            return this.transformedFileCache.getResult(absoluteFile, this.inputsHash, this.transformer);
        }
        catch (Exception t) {
            throw new ArtifactTransformException(input, (AttributeContainer)this.to, this.transformer.getImplementationClass(), (Throwable)t);
        }
    }

    public boolean hasCachedResult(File input) {
        return this.transformedFileCache.contains(input.getAbsoluteFile(), this.inputsHash);
    }

    public String getDisplayName() {
        return this.transformer.getDisplayName();
    }

    public void visitLeafTransformers(Action<? super ArtifactTransformer> action) {
        action.execute((Object)this);
    }

    public String toString() {
        return String.format("%s[%s => %s]@%s", this.transformer.getDisplayName(), this.from, this.to, this.inputsHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCodeBackedTransformer that = (UserCodeBackedTransformer)o;
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!this.to.equals(that.to)) {
            return false;
        }
        return this.inputsHash.equals((Object)that.inputsHash);
    }

    public int hashCode() {
        int result = this.from.hashCode();
        result = 31 * result + this.to.hashCode();
        result = 31 * result + this.inputsHash.hashCode();
        return result;
    }
}

