/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.MapRectangleImpl;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryDialog;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddTMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddWMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddWMTSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.CacheContentsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.CommonSettingsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.TMSSettingsPanel;
import org.openstreetmap.josm.gui.preferences.imagery.WMSSettingsPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;

public final class ImageryPreference
extends DefaultTabPreferenceSetting {
    private ImageryProvidersPanel imageryProviders;
    private ImageryLayerInfo layerInfo;
    private final CommonSettingsPanel commonSettings = new CommonSettingsPanel();
    private final WMSSettingsPanel wmsSettings = new WMSSettingsPanel();
    private final TMSSettingsPanel tmsSettings = new TMSSettingsPanel();

    private ImageryPreference() {
        super("imagery", I18n.tr("Imagery preferences", new Object[0]), I18n.tr("Modify list of imagery layers displayed in the Imagery menu", new Object[0]), false, new JTabbedPane());
    }

    private static void addSettingsSection(JPanel p, String name, JPanel section) {
        ImageryPreference.addSettingsSection(p, name, section, GBC.eol());
    }

    private static void addSettingsSection(JPanel p, String name, JPanel section, GBC gbc) {
        JLabel lbl = new JLabel(name);
        lbl.setFont(lbl.getFont().deriveFont(1));
        lbl.setLabelFor(section);
        p.add((Component)lbl, GBC.std());
        p.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 0, 0, 0));
        p.add((Component)section, gbc.insets(20, 5, 0, 10));
    }

    private Component buildSettingsPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ImageryPreference.addSettingsSection(p, I18n.tr("Common Settings", new Object[0]), this.commonSettings);
        ImageryPreference.addSettingsSection(p, I18n.tr("WMS Settings", new Object[0]), this.wmsSettings, GBC.eol().fill(2));
        ImageryPreference.addSettingsSection(p, I18n.tr("TMS Settings", new Object[0]), this.tmsSettings, GBC.eol().fill(2));
        p.add((Component)new JPanel(), GBC.eol().fill(1));
        return GuiHelper.setDefaultIncrement(new JScrollPane(p));
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        PreferenceTabbedPane.PreferencePanel p = gui.createPreferenceTab(this);
        JTabbedPane pane = this.getTabPane();
        this.layerInfo = new ImageryLayerInfo(ImageryLayerInfo.instance);
        this.imageryProviders = new ImageryProvidersPanel(gui, this.layerInfo);
        pane.addTab(I18n.tr("Imagery providers", new Object[0]), this.imageryProviders);
        pane.addTab(I18n.tr("Settings", new Object[0]), this.buildSettingsPanel());
        pane.addTab(I18n.tr("Offset bookmarks", new Object[0]), new OffsetBookmarksPanel(gui));
        pane.addTab(I18n.tr("Cache contents", new Object[0]), new CacheContentsPanel());
        this.loadSettings();
        p.add((Component)pane, GBC.std().fill(1));
    }

    public ImageryProvidersPanel getProvidersPanel() {
        return this.imageryProviders;
    }

    private void loadSettings() {
        this.commonSettings.loadSettings();
        this.wmsSettings.loadSettings();
        this.tmsSettings.loadSettings();
    }

    @Override
    public boolean ok() {
        this.layerInfo.save();
        ImageryLayerInfo.instance.clear();
        ImageryLayerInfo.instance.load(false);
        MainApplication.getMenu().imageryMenu.refreshOffsetMenu();
        OffsetBookmark.saveBookmarks();
        if (!GraphicsEnvironment.isHeadless()) {
            DownloadDialog.getInstance().refreshTileSources();
        }
        boolean commonRestartRequired = this.commonSettings.saveSettings();
        boolean wmsRestartRequired = this.wmsSettings.saveSettings();
        boolean tmsRestartRequired = this.tmsSettings.saveSettings();
        return commonRestartRequired || wmsRestartRequired || tmsRestartRequired;
    }

    public void setServerUrl(String server, String url) {
        for (int i = 0; i < this.imageryProviders.activeModel.getRowCount(); ++i) {
            if (!server.equals(this.imageryProviders.activeModel.getValueAt(i, 0).toString())) continue;
            this.imageryProviders.activeModel.setValueAt(url, i, 1);
            return;
        }
        this.imageryProviders.activeModel.addRow(new String[]{server, url});
    }

    public String getServerUrl(String server) {
        for (int i = 0; i < this.imageryProviders.activeModel.getRowCount(); ++i) {
            if (!server.equals(this.imageryProviders.activeModel.getValueAt(i, 0).toString())) continue;
            return this.imageryProviders.activeModel.getValueAt(i, 1).toString();
        }
        return null;
    }

    public static void initialize() {
        ImageryLayerInfo.instance.load(false);
        OffsetBookmark.loadBookmarks();
        MainApplication.getMenu().imageryMenu.refreshImageryMenu();
        MainApplication.getMenu().imageryMenu.refreshOffsetMenu();
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/Imagery");
    }

    static class OffsetBookmarksPanel
    extends JPanel {
        private final OffsetsBookmarksModel model = new OffsetsBookmarksModel();

        OffsetBookmarksPanel(PreferenceTabbedPane gui) {
            super(new GridBagLayout());
            JTable list = new JTable(this.model){

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    return model.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p)).toString();
                }
            };
            JScrollPane scroll = new JScrollPane(list);
            this.add((Component)scroll, GBC.eol().fill(1));
            scroll.setPreferredSize(new Dimension(200, 200));
            TableColumnModel mod = list.getColumnModel();
            mod.getColumn(0).setPreferredWidth(150);
            mod.getColumn(1).setPreferredWidth(200);
            mod.getColumn(2).setPreferredWidth(300);
            mod.getColumn(3).setPreferredWidth(150);
            mod.getColumn(4).setPreferredWidth(150);
            JPanel buttonPanel = new JPanel(new FlowLayout());
            JButton add = new JButton(I18n.tr("Add", new Object[0]));
            buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
            add.addActionListener(e -> this.model.addRow(new OffsetBookmark(ProjectionRegistry.getProjection().toCode(), "", "", "", 0.0, 0.0)));
            JButton delete = new JButton(I18n.tr("Delete", new Object[0]));
            buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 0, 0));
            delete.addActionListener(e -> {
                if (list.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(gui, I18n.tr("Please select the row to delete.", new Object[0]));
                } else {
                    Integer i;
                    while ((i = Integer.valueOf(list.getSelectedRow())) != -1) {
                        this.model.removeRow(i);
                    }
                }
            });
            this.add((Component)buttonPanel, GBC.eol());
        }

        private static class OffsetsBookmarksModel
        extends DefaultTableModel {
            OffsetsBookmarksModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Projection", new Object[0]), I18n.tr("Layer", new Object[0]), I18n.tr("Name", new Object[0]), I18n.tr("Easting", new Object[0]), I18n.tr("Northing", new Object[0])});
            }

            private static OffsetBookmark getRow(int row) {
                return OffsetBookmark.getBookmarkByIndex(row);
            }

            private void addRow(OffsetBookmark i) {
                OffsetBookmark.addBookmark(i);
                int p = this.getRowCount() - 1;
                this.fireTableRowsInserted(p, p);
            }

            @Override
            public void removeRow(int i) {
                OffsetBookmark.removeBookmark(OffsetsBookmarksModel.getRow(i));
                this.fireTableRowsDeleted(i, i);
            }

            @Override
            public int getRowCount() {
                return OffsetBookmark.getBookmarksSize();
            }

            @Override
            public Object getValueAt(int row, int column) {
                OffsetBookmark info = OffsetBookmark.getBookmarkByIndex(row);
                switch (column) {
                    case 0: {
                        if (info.getProjectionCode() == null) {
                            return "";
                        }
                        return info.getProjectionCode();
                    }
                    case 1: {
                        return info.getImageryName();
                    }
                    case 2: {
                        return info.getName();
                    }
                    case 3: {
                        return info.getDisplacement().east();
                    }
                    case 4: {
                        return info.getDisplacement().north();
                    }
                }
                throw new ArrayIndexOutOfBoundsException(column);
            }

            @Override
            public void setValueAt(Object o, int row, int column) {
                OffsetBookmark info = OffsetBookmark.getBookmarkByIndex(row);
                switch (column) {
                    case 1: {
                        String name = o.toString();
                        info.setImageryName(name);
                        List layers = ImageryLayerInfo.instance.getLayers().stream().filter(l -> Objects.equals(name, l.getName())).collect(Collectors.toList());
                        if (layers.size() == 1) {
                            info.setImageryId(((ImageryInfo)layers.get(0)).getId());
                            break;
                        }
                        Logging.warn("Not a single layer for the name '" + info.getImageryName() + "': " + layers);
                        break;
                    }
                    case 2: {
                        info.setName(o.toString());
                        break;
                    }
                    case 3: {
                        double dx = Double.parseDouble((String)o);
                        info.setDisplacement(new EastNorth(dx, info.getDisplacement().north()));
                        break;
                    }
                    case 4: {
                        double dy = Double.parseDouble((String)o);
                        info.setDisplacement(new EastNorth(info.getDisplacement().east(), dy));
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(column);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column >= 1;
            }
        }
    }

    public static class ImageryProvidersPanel
    extends JPanel {
        public final JTable activeTable;
        public final JTable defaultTable;
        private final transient DefListSelectionListener defaultTableListener;
        public final JMapViewer defaultMap;
        public final ImageryLayerTableModel activeModel;
        public final ImageryDefaultLayerTableModel defaultModel;
        public final JToolBar activeToolbar;
        public final JToolBar middleToolbar;
        public final JToolBar defaultToolbar;
        private final PreferenceTabbedPane gui;
        private final transient ImageryLayerInfo layerInfo;

        public ImageryProvidersPanel(PreferenceTabbedPane gui, ImageryLayerInfo layerInfoArg) {
            super(new GridBagLayout());
            this.gui = gui;
            this.layerInfo = layerInfoArg;
            this.activeModel = new ImageryLayerTableModel();
            this.activeTable = new JTable(this.activeModel){

                @Override
                public String getToolTipText(MouseEvent e) {
                    Point p = e.getPoint();
                    try {
                        return activeModel.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p)).toString();
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        Logging.debug(ex);
                        return null;
                    }
                }
            };
            this.activeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.defaultModel = new ImageryDefaultLayerTableModel();
            this.defaultTable = new JTable(this.defaultModel);
            this.defaultModel.addTableModelListener(e -> this.activeTable.repaint());
            this.activeModel.addTableModelListener(e -> this.defaultTable.repaint());
            TableColumnModel mod = this.defaultTable.getColumnModel();
            mod.getColumn(2).setPreferredWidth(800);
            mod.getColumn(2).setCellRenderer(new ImageryURLTableCellRenderer(this.layerInfo.getLayers()));
            mod.getColumn(1).setPreferredWidth(400);
            mod.getColumn(1).setCellRenderer(new ImageryNameTableCellRenderer());
            mod.getColumn(0).setPreferredWidth(50);
            mod = this.activeTable.getColumnModel();
            mod.getColumn(1).setPreferredWidth(800);
            mod.getColumn(1).setCellRenderer(new ImageryURLTableCellRenderer(this.layerInfo.getAllDefaultLayers()));
            mod.getColumn(0).setPreferredWidth(200);
            RemoveEntryAction remove = new RemoveEntryAction();
            this.activeTable.getSelectionModel().addListSelectionListener(remove);
            this.add((Component)new JLabel(I18n.tr("Available default entries:", new Object[0])), GBC.std().insets(5, 5, 0, 0));
            this.add((Component)new JLabel(I18n.tr("Boundaries of selected imagery entries:", new Object[0])), GBC.eol().insets(5, 5, 0, 0));
            JScrollPane scrolldef = new JScrollPane(this.defaultTable);
            scrolldef.setPreferredSize(new Dimension(200, 200));
            this.add((Component)scrolldef, GBC.std().insets(0, 5, 0, 0).fill(1).weight(1.0, 0.6).insets(5, 0, 0, 0));
            this.defaultMap = new JMapViewer();
            this.defaultMap.setTileSource(new OsmTileSource.Mapnik());
            this.defaultMap.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        defaultMap.getAttribution().handleAttribution(e.getPoint(), true);
                    }
                }
            });
            this.defaultMap.setZoomControlsVisible(false);
            this.defaultMap.setMinimumSize(new Dimension(100, 200));
            this.add((Component)this.defaultMap, GBC.std().insets(5, 5, 0, 0).fill(1).weight(0.33, 0.6).insets(5, 0, 0, 0));
            this.defaultTableListener = new DefListSelectionListener();
            this.defaultTable.getSelectionModel().addListSelectionListener(this.defaultTableListener);
            this.defaultToolbar = new JToolBar(1);
            this.defaultToolbar.setFloatable(false);
            this.defaultToolbar.setBorderPainted(false);
            this.defaultToolbar.setOpaque(false);
            this.defaultToolbar.add(new ReloadAction());
            this.add((Component)this.defaultToolbar, GBC.eol().anchor(15).insets(0, 0, 5, 0));
            HtmlPanel help = new HtmlPanel(I18n.tr("New default entries can be added in the <a href=\"{0}\">Wiki</a>.", Config.getUrls().getJOSMWebsite() + "/wiki/Maps"));
            help.enableClickableHyperlinks();
            this.add((Component)help, GBC.eol().insets(10, 0, 0, 0).fill(2));
            ActivateAction activate = new ActivateAction();
            this.defaultTable.getSelectionModel().addListSelectionListener(activate);
            JButton btnActivate = new JButton(activate);
            this.middleToolbar = new JToolBar(0);
            this.middleToolbar.setFloatable(false);
            this.middleToolbar.setBorderPainted(false);
            this.middleToolbar.setOpaque(false);
            this.middleToolbar.add(btnActivate);
            this.add((Component)this.middleToolbar, GBC.eol().anchor(10).insets(5, 5, 5, 0));
            this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
            this.add((Component)new JLabel(I18n.tr("Selected entries:", new Object[0])), GBC.eol().insets(5, 0, 0, 0));
            JScrollPane scroll = new JScrollPane(this.activeTable);
            this.add((Component)scroll, GBC.std().fill(1).span(-1).weight(1.0, 0.4).insets(5, 0, 0, 5));
            scroll.setPreferredSize(new Dimension(200, 200));
            this.activeToolbar = new JToolBar(1);
            this.activeToolbar.setFloatable(false);
            this.activeToolbar.setBorderPainted(false);
            this.activeToolbar.setOpaque(false);
            this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.WMS));
            this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.TMS));
            this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.WMTS));
            this.activeToolbar.add(remove);
            this.add((Component)this.activeToolbar, GBC.eol().anchor(11).insets(0, 0, 5, 5));
        }

        private static boolean confirmEulaAcceptance(PreferenceTabbedPane gui, String eulaUrl) {
            try {
                JosmEditorPane htmlPane;
                URL url = new URL(eulaUrl.replaceAll("\\{lang\\}", LanguageInfo.getWikiLanguagePrefix()));
                try {
                    htmlPane = new JosmEditorPane(url);
                }
                catch (IOException e1) {
                    Logging.trace(e1);
                    try {
                        url = new URL(eulaUrl.replaceAll("\\{lang\\}", ""));
                        htmlPane = new JosmEditorPane(url);
                    }
                    catch (IOException e2) {
                        Logging.debug(e2);
                        JOptionPane.showMessageDialog(gui, I18n.tr("EULA license URL not available: {0}", eulaUrl));
                        return false;
                    }
                }
                Box box = Box.createVerticalBox();
                htmlPane.setEditable(false);
                JScrollPane scrollPane = new JScrollPane(htmlPane);
                scrollPane.setPreferredSize(new Dimension(400, 400));
                box.add(scrollPane);
                int option = JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), box, I18n.tr("Please abort if you are not sure", new Object[0]), 0, 2);
                if (option == 0) {
                    return true;
                }
            }
            catch (MalformedURLException e2) {
                JOptionPane.showMessageDialog(gui, I18n.tr("Malformed URL for the EULA licence: {0}", eulaUrl));
            }
            return false;
        }

        public class ImageryDefaultLayerTableModel
        extends DefaultTableModel {
            public ImageryDefaultLayerTableModel() {
                this.setColumnIdentifiers(new String[]{"", I18n.tr("Menu Name (Default)", new Object[0]), I18n.tr("Imagery URL (Default)", new Object[0])});
            }

            public ImageryInfo getRow(int row) {
                return ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().get(row);
            }

            @Override
            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                ImageryInfo info = ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().get(row);
                switch (column) {
                    case 0: {
                        return info.getCountryCode();
                    }
                    case 1: {
                        return info;
                    }
                    case 2: {
                        return info.getExtendedUrl();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        }

        public class ImageryLayerTableModel
        extends DefaultTableModel {
            public ImageryLayerTableModel() {
                this.setColumnIdentifiers(new String[]{I18n.tr("Menu Name", new Object[0]), I18n.tr("Imagery URL", new Object[0])});
            }

            public ImageryInfo getRow(int row) {
                return ImageryProvidersPanel.this.layerInfo.getLayers().get(row);
            }

            public void addRow(ImageryInfo i) {
                ImageryProvidersPanel.this.layerInfo.add(i);
                int p = this.getRowCount() - 1;
                this.fireTableRowsInserted(p, p);
            }

            @Override
            public void removeRow(int i) {
                ImageryProvidersPanel.this.layerInfo.remove(this.getRow(i));
                this.fireTableRowsDeleted(i, i);
            }

            @Override
            public int getRowCount() {
                return ImageryProvidersPanel.this.layerInfo.getLayers().size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                ImageryInfo info = ImageryProvidersPanel.this.layerInfo.getLayers().get(row);
                switch (column) {
                    case 0: {
                        return info.getName();
                    }
                    case 1: {
                        return info.getExtendedUrl();
                    }
                }
                throw new ArrayIndexOutOfBoundsException(Integer.toString(column));
            }

            @Override
            public void setValueAt(Object o, int row, int column) {
                if (ImageryProvidersPanel.this.layerInfo.getLayers().size() <= row) {
                    return;
                }
                ImageryInfo info = ImageryProvidersPanel.this.layerInfo.getLayers().get(row);
                switch (column) {
                    case 0: {
                        info.setName((String)o);
                        info.clearId();
                        break;
                    }
                    case 1: {
                        info.setExtendedUrl((String)o);
                        info.clearId();
                        break;
                    }
                    default: {
                        throw new ArrayIndexOutOfBoundsException(Integer.toString(column));
                    }
                }
            }
        }

        private class ReloadAction
        extends AbstractAction {
            ReloadAction() {
                this.putValue("ShortDescription", I18n.tr("Update default entries", new Object[0]));
                new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageryProvidersPanel.this.layerInfo.loadDefaults(true, MainApplication.worker, false);
                ImageryProvidersPanel.this.defaultModel.fireTableDataChanged();
                ImageryProvidersPanel.this.defaultTable.getSelectionModel().clearSelection();
                ImageryProvidersPanel.this.defaultTableListener.clearMap();
                ImageryProvidersPanel.this.activeModel.fireTableDataChanged();
            }
        }

        private class ActivateAction
        extends AbstractAction
        implements ListSelectionListener {
            ActivateAction() {
                this.putValue("Name", I18n.tr("Activate", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Copy selected default entries from the list above into the list below.", new Object[0]));
                new ImageProvider("preferences", "activate-down").getResource().attachImageIcon(this, true);
            }

            protected void updateEnabledState() {
                this.setEnabled(ImageryProvidersPanel.this.defaultTable.getSelectedRowCount() > 0);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.updateEnabledState();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] lines = ImageryProvidersPanel.this.defaultTable.getSelectedRows();
                if (lines.length == 0) {
                    JOptionPane.showMessageDialog(ImageryProvidersPanel.this.gui, I18n.tr("Please select at least one row to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    return;
                }
                HashSet<String> acceptedEulas = new HashSet<String>();
                block0: for (int line : lines) {
                    ImageryInfo info = ImageryProvidersPanel.this.defaultModel.getRow(line);
                    for (int j = 0; j < ImageryProvidersPanel.this.activeModel.getRowCount(); ++j) {
                        if (!info.equalsBaseValues(ImageryProvidersPanel.this.activeModel.getRow(j))) continue;
                        ImageryProvidersPanel.this.activeTable.getSelectionModel().setSelectionInterval(j, j);
                        ImageryProvidersPanel.this.activeTable.scrollRectToVisible(ImageryProvidersPanel.this.activeTable.getCellRect(j, 0, true));
                        continue block0;
                    }
                    String eulaURL = info.getEulaAcceptanceRequired();
                    if (eulaURL != null && !acceptedEulas.contains(eulaURL)) {
                        if (!ImageryProvidersPanel.confirmEulaAcceptance(ImageryProvidersPanel.this.gui, eulaURL)) continue;
                        acceptedEulas.add(eulaURL);
                    }
                    ImageryProvidersPanel.this.activeModel.addRow(new ImageryInfo(info));
                    int lastLine = ImageryProvidersPanel.this.activeModel.getRowCount() - 1;
                    ImageryProvidersPanel.this.activeTable.getSelectionModel().setSelectionInterval(lastLine, lastLine);
                    ImageryProvidersPanel.this.activeTable.scrollRectToVisible(ImageryProvidersPanel.this.activeTable.getCellRect(lastLine, 0, true));
                }
            }
        }

        private class RemoveEntryAction
        extends AbstractAction
        implements ListSelectionListener {
            RemoveEntryAction() {
                this.putValue("Name", I18n.tr("Remove", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Remove entry", new Object[0]));
                new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
                this.updateEnabledState();
            }

            protected final void updateEnabledState() {
                this.setEnabled(ImageryProvidersPanel.this.activeTable.getSelectedRowCount() > 0);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.updateEnabledState();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer i;
                while ((i = Integer.valueOf(ImageryProvidersPanel.this.activeTable.getSelectedRow())) != -1) {
                    ImageryProvidersPanel.this.activeModel.removeRow(i);
                }
            }
        }

        private class NewEntryAction
        extends AbstractAction {
            private final ImageryInfo.ImageryType type;

            NewEntryAction(ImageryInfo.ImageryType type) {
                this.putValue("Name", type.toString());
                this.putValue("ShortDescription", I18n.tr("Add a new {0} entry by entering the URL", type.toString()));
                String icon = "add";
                switch (type) {
                    case WMS: {
                        icon = "add_wms";
                        break;
                    }
                    case TMS: {
                        icon = "add_tms";
                        break;
                    }
                    case WMTS: {
                        icon = "add_wmts";
                        break;
                    }
                }
                new ImageProvider("dialogs", icon).getResource().attachImageIcon(this, true);
                this.type = type;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddImageryPanel p;
                switch (this.type) {
                    case WMS: {
                        p = new AddWMSLayerPanel();
                        break;
                    }
                    case TMS: {
                        p = new AddTMSLayerPanel();
                        break;
                    }
                    case WMTS: {
                        p = new AddWMTSLayerPanel();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Type " + (Object)((Object)this.type) + " not supported");
                    }
                }
                AddImageryDialog addDialog = new AddImageryDialog(ImageryProvidersPanel.this.gui, p);
                addDialog.showDialog();
                if (addDialog.getValue() == 1) {
                    try {
                        ImageryProvidersPanel.this.activeModel.addRow(p.getImageryInfo());
                    }
                    catch (IllegalArgumentException ex) {
                        if (ex.getMessage() == null || ex.getMessage().isEmpty()) {
                            throw ex;
                        }
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
                    }
                }
            }
        }

        private final class DefListSelectionListener
        implements ListSelectionListener {
            private final Map<Integer, MapRectangle> mapRectangles = new HashMap<Integer, MapRectangle>();
            private final Map<Integer, List<MapPolygon>> mapPolygons = new HashMap<Integer, List<MapPolygon>>();

            private DefListSelectionListener() {
            }

            private void clearMap() {
                ImageryProvidersPanel.this.defaultMap.removeAllMapRectangles();
                ImageryProvidersPanel.this.defaultMap.removeAllMapPolygons();
                this.mapRectangles.clear();
                this.mapPolygons.clear();
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() == -1) {
                    this.clearMap();
                } else if (!e.getValueIsAdjusting()) {
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        this.updateBoundsAndShapes(i);
                    }
                    if (!this.mapRectangles.isEmpty() || !this.mapPolygons.isEmpty()) {
                        ImageryProvidersPanel.this.defaultMap.setDisplayToFitMapElements(false, true, true);
                        ImageryProvidersPanel.this.defaultMap.zoomOut();
                    }
                }
            }

            private void updateBoundsAndShapes(int i) {
                ImageryInfo.ImageryBounds bounds = ImageryProvidersPanel.this.defaultModel.getRow(i).getBounds();
                if (bounds != null) {
                    List<Shape> shapes = bounds.getShapes();
                    if (shapes != null && !shapes.isEmpty()) {
                        if (ImageryProvidersPanel.this.defaultTable.getSelectionModel().isSelectedIndex(i)) {
                            if (!this.mapPolygons.containsKey(i)) {
                                ArrayList<MapPolygonImpl> list = new ArrayList<MapPolygonImpl>();
                                this.mapPolygons.put(i, list);
                                for (Shape shape : shapes) {
                                    MapPolygonImpl polygon = new MapPolygonImpl(shape.getPoints());
                                    list.add(polygon);
                                    ImageryProvidersPanel.this.defaultMap.addMapPolygon(polygon);
                                }
                            }
                        } else if (this.mapPolygons.containsKey(i)) {
                            for (MapPolygon polygon : this.mapPolygons.get(i)) {
                                ImageryProvidersPanel.this.defaultMap.removeMapPolygon(polygon);
                            }
                            this.mapPolygons.remove(i);
                        }
                    } else if (ImageryProvidersPanel.this.defaultTable.getSelectionModel().isSelectedIndex(i)) {
                        if (!this.mapRectangles.containsKey(i)) {
                            Coordinate topLeft = new Coordinate(bounds.getMaxLat(), bounds.getMinLon());
                            Coordinate bottomRight = new Coordinate(bounds.getMinLat(), bounds.getMaxLon());
                            MapRectangleImpl rectangle = new MapRectangleImpl(topLeft, bottomRight);
                            this.mapRectangles.put(i, rectangle);
                            ImageryProvidersPanel.this.defaultMap.addMapRectangle(rectangle);
                        }
                    } else if (this.mapRectangles.containsKey(i)) {
                        ImageryProvidersPanel.this.defaultMap.removeMapRectangle(this.mapRectangles.get(i));
                        this.mapRectangles.remove(i);
                    }
                }
            }
        }

        private static class ImageryNameTableCellRenderer
        extends DefaultTableCellRenderer {
            private ImageryNameTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ImageryInfo info = (ImageryInfo)value;
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, info == null ? null : info.getName(), isSelected, hasFocus, row, column);
                GuiHelper.setBackgroundReadable(label, UIManager.getColor("Table.background"));
                if (info != null) {
                    label.setToolTipText(info.getToolTipText());
                }
                return label;
            }
        }

        private static class ImageryURLTableCellRenderer
        extends DefaultTableCellRenderer {
            private static final NamedColorProperty IMAGERY_BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("Imagery Background: Default"), new Color(200, 255, 200));
            private final transient List<ImageryInfo> layers;

            ImageryURLTableCellRenderer(List<ImageryInfo> layers) {
                this.layers = layers;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                GuiHelper.setBackgroundReadable(label, UIManager.getColor("Table.background"));
                if (value != null) {
                    String t = value.toString();
                    for (ImageryInfo l : this.layers) {
                        if (!l.getExtendedUrl().equals(t)) continue;
                        GuiHelper.setBackgroundReadable(label, IMAGERY_BACKGROUND_COLOR.get());
                        break;
                    }
                    label.setToolTipText((String)value);
                }
                return label;
            }
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ImageryPreference();
        }
    }
}

