# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.Qt3DInput, except for defaults which are replaced by "...".
"""

# Module PySide2.Qt3DInput
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.Qt3DInput


class Qt3DInput(Shiboken.Object):


    class QAbstractActionInput: ...

    class QAbstractAxisInput(PySide2.Qt3DCore.Qt3DCore.QNode):

        def setSourceDevice(self, sourceDevice: PySide2.Qt3DInput.Qt3DInput.QAbstractPhysicalDevice): ...
        def sourceDevice(self) -> PySide2.Qt3DInput.Qt3DInput.QAbstractPhysicalDevice: ...

    class QAbstractPhysicalDevice(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addAxisSetting(self, axisSetting: PySide2.Qt3DInput.Qt3DInput.QAxisSetting): ...
        def axisCount(self) -> int: ...
        def axisIdentifier(self, name: str) -> int: ...
        def axisNames(self) -> typing.List[str]: ...
        def axisSettings(self) -> PySide2.Qt3DInput.Qt3DInput.QAxisSetting: ...
        def buttonCount(self) -> int: ...
        def buttonIdentifier(self, name: str) -> int: ...
        def buttonNames(self) -> typing.List[str]: ...
        def removeAxisSetting(self, axisSetting: PySide2.Qt3DInput.Qt3DInput.QAxisSetting): ...

    class QAction(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addInput(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput): ...
        def inputs(self) -> PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput: ...
        def isActive(self) -> bool: ...
        def removeInput(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput): ...

    class QActionInput(PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def buttons(self) -> int: ...
        def setButtons(self, buttons: list): ...
        def setSourceDevice(self, sourceDevice: PySide2.Qt3DInput.Qt3DInput.QAbstractPhysicalDevice): ...
        def sourceDevice(self) -> PySide2.Qt3DInput.Qt3DInput.QAbstractPhysicalDevice: ...

    class QAnalogAxisInput(PySide2.Qt3DInput.Qt3DInput.QAbstractAxisInput):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def axis(self) -> int: ...
        def setAxis(self, axis: int): ...

    class QAxis(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addInput(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractAxisInput): ...
        def inputs(self) -> PySide2.Qt3DInput.Qt3DInput.QAbstractAxisInput: ...
        def removeInput(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractAxisInput): ...
        def value(self) -> float: ...

    class QAxisAccumulator(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def scale(self) -> float: ...
        def setScale(self, scale: float): ...
        def setSourceAxis(self, sourceAxis: PySide2.Qt3DInput.Qt3DInput.QAxis): ...
        def setSourceAxisType(self, sourceAxisType: PySide2.Qt3DInput.Qt3DInput.QAxisAccumulator.SourceAxisType): ...
        def sourceAxis(self) -> PySide2.Qt3DInput.Qt3DInput.QAxis: ...
        def sourceAxisType(self) -> PySide2.Qt3DInput.Qt3DInput.QAxisAccumulator.SourceAxisType: ...
        def value(self) -> float: ...
        def velocity(self) -> float: ...

    class QAxisSetting(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def axes(self) -> int: ...
        def deadZoneRadius(self) -> float: ...
        def isSmoothEnabled(self) -> bool: ...
        def setAxes(self, axes: list): ...
        def setDeadZoneRadius(self, deadZoneRadius: float): ...
        def setSmoothEnabled(self, enabled: bool): ...

    class QButtonAxisInput(PySide2.Qt3DInput.Qt3DInput.QAbstractAxisInput):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def acceleration(self) -> float: ...
        def buttons(self) -> int: ...
        def deceleration(self) -> float: ...
        def scale(self) -> float: ...
        def setAcceleration(self, acceleration: float): ...
        def setButtons(self, buttons: list): ...
        def setDeceleration(self, deceleration: float): ...
        def setScale(self, scale: float): ...

    class QInputAspect(PySide2.Qt3DCore.Qt3DCore.QAbstractAspect):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def availablePhysicalDevices(self) -> typing.List[str]: ...
        def createPhysicalDevice(self, name: str) -> PySide2.Qt3DInput.Qt3DInput.QAbstractPhysicalDevice: ...

    class QInputChord(PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addChord(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput): ...
        def chords(self) -> PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput: ...
        def removeChord(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput): ...
        def setTimeout(self, timeout: int): ...
        def timeout(self) -> int: ...

    class QInputSequence(PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addSequence(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput): ...
        def buttonInterval(self) -> int: ...
        def removeSequence(self, input: PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput): ...
        def sequences(self) -> PySide2.Qt3DInput.Qt3DInput.QAbstractActionInput: ...
        def setButtonInterval(self, buttonInterval: int): ...
        def setTimeout(self, timeout: int): ...
        def timeout(self) -> int: ...

    class QInputSettings(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def eventSource(self) -> PySide2.QtCore.QObject: ...
        def setEventSource(self, eventSource: PySide2.QtCore.QObject): ...

    class QKeyEvent(PySide2.QtCore.QObject):

        def __init__(self, type: PySide2.QtCore.QEvent.Type, key: int, modifiers: PySide2.QtCore.Qt.KeyboardModifiers, text: str = ..., autorep: bool = ..., count: int = ...): ...
        def count(self) -> int: ...
        def isAccepted(self) -> bool: ...
        def isAutoRepeat(self) -> bool: ...
        def key(self) -> int: ...
        def matches(self, key_: PySide2.QtGui.QKeySequence.StandardKey) -> bool: ...
        def modifiers(self) -> int: ...
        def nativeScanCode(self) -> int: ...
        def setAccepted(self, accepted: bool): ...
        def text(self) -> str: ...
        def type(self) -> PySide2.QtCore.QEvent.Type: ...

    class QKeyboardDevice(PySide2.Qt3DInput.Qt3DInput.QAbstractPhysicalDevice):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def activeInput(self) -> PySide2.Qt3DInput.Qt3DInput.QKeyboardHandler: ...
        def axisCount(self) -> int: ...
        def axisIdentifier(self, name: str) -> int: ...
        def axisNames(self) -> typing.List[str]: ...
        def buttonCount(self) -> int: ...
        def buttonIdentifier(self, name: str) -> int: ...
        def buttonNames(self) -> typing.List[str]: ...

    class QKeyboardHandler(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def focus(self) -> bool: ...
        def setFocus(self, focus: bool): ...
        def setSourceDevice(self, keyboardDevice: PySide2.Qt3DInput.Qt3DInput.QKeyboardDevice): ...
        def sourceDevice(self) -> PySide2.Qt3DInput.Qt3DInput.QKeyboardDevice: ...

    class QLogicalDevice(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def actions(self) -> PySide2.Qt3DInput.Qt3DInput.QAction: ...
        def addAction(self, action: PySide2.Qt3DInput.Qt3DInput.QAction): ...
        def addAxis(self, axis: PySide2.Qt3DInput.Qt3DInput.QAxis): ...
        def axes(self) -> PySide2.Qt3DInput.Qt3DInput.QAxis: ...
        def removeAction(self, action: PySide2.Qt3DInput.Qt3DInput.QAction): ...
        def removeAxis(self, axis: PySide2.Qt3DInput.Qt3DInput.QAxis): ...

    class QMouseDevice(PySide2.Qt3DInput.Qt3DInput.QAbstractPhysicalDevice):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def axisCount(self) -> int: ...
        def axisIdentifier(self, name: str) -> int: ...
        def axisNames(self) -> typing.List[str]: ...
        def buttonCount(self) -> int: ...
        def buttonIdentifier(self, name: str) -> int: ...
        def buttonNames(self) -> typing.List[str]: ...
        def sensitivity(self) -> float: ...
        def setSensitivity(self, value: float): ...

    class QMouseEvent(PySide2.QtCore.QObject):

        def button(self) -> PySide2.Qt3DInput.Qt3DInput.QMouseEvent.Buttons: ...
        def buttons(self) -> int: ...
        def isAccepted(self) -> bool: ...
        def modifiers(self) -> PySide2.Qt3DInput.Qt3DInput.QMouseEvent.Modifiers: ...
        def setAccepted(self, accepted: bool): ...
        def type(self) -> PySide2.QtCore.QEvent.Type: ...
        def wasHeld(self) -> bool: ...
        def x(self) -> int: ...
        def y(self) -> int: ...

    class QMouseHandler(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def containsMouse(self) -> bool: ...
        def setContainsMouse(self, contains: bool): ...
        def setSourceDevice(self, mouseDevice: PySide2.Qt3DInput.Qt3DInput.QMouseDevice): ...
        def sourceDevice(self) -> PySide2.Qt3DInput.Qt3DInput.QMouseDevice: ...

    class QWheelEvent(PySide2.QtCore.QObject):

        def angleDelta(self) -> PySide2.QtCore.QPoint: ...
        def buttons(self) -> int: ...
        def isAccepted(self) -> bool: ...
        def modifiers(self) -> PySide2.Qt3DInput.Qt3DInput.QWheelEvent.Modifiers: ...
        def setAccepted(self, accepted: bool): ...
        def type(self) -> PySide2.QtCore.QEvent.Type: ...
        def x(self) -> int: ...
        def y(self) -> int: ...

# eof
