/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;
import org.jmol.util.GData;

public final class CircleRenderer
implements G3DRenderer {
    private Graphics3D g3d;

    @Override
    public G3DRenderer set(JmolRendererInterface g3d, GData gdata) {
        try {
            this.g3d = (Graphics3D)g3d;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    void plotCircleCenteredClipped(int xCenter, int yCenter, int zCenter, int diameter) {
        Graphics3D g = this.g3d;
        int c = g.argbCurrent;
        int width = g.width;
        int[] zbuf = g.zbuf;
        Pixelator p = g.pixel;
        int r = diameter / 2;
        int sizeCorrection = 1 - (diameter & 1);
        int x = r;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        for (int y = 0; x >= y; ++y) {
            g.plotPixelClippedArgb(c, xCenter + x - sizeCorrection, yCenter + y - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelClippedArgb(c, xCenter + x - sizeCorrection, yCenter - y, zCenter, width, zbuf, p);
            g.plotPixelClippedArgb(c, xCenter - x, yCenter + y - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelClippedArgb(c, xCenter - x, yCenter - y, zCenter, width, zbuf, p);
            g.plotPixelClippedArgb(c, xCenter + y - sizeCorrection, yCenter + x - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelClippedArgb(c, xCenter + y - sizeCorrection, yCenter - x, zCenter, width, zbuf, p);
            g.plotPixelClippedArgb(c, xCenter - y, yCenter + x - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelClippedArgb(c, xCenter - y, yCenter - x, zCenter, width, zbuf, p);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }

    void plotCircleCenteredUnclipped(int xCenter, int yCenter, int zCenter, int diameter) {
        int r = diameter / 2;
        int sizeCorrection = 1 - (diameter & 1);
        int x = r;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        Graphics3D g = this.g3d;
        Pixelator p = g.pixel;
        int width = g.width;
        int[] zbuf = g.zbuf;
        int c = g.argbCurrent;
        for (int y = 0; x >= y; ++y) {
            g.plotPixelUnclipped(c, xCenter + x - sizeCorrection, yCenter + y - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelUnclipped(c, xCenter + x - sizeCorrection, yCenter - y, zCenter, width, zbuf, p);
            g.plotPixelUnclipped(c, xCenter - x, yCenter + y - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelUnclipped(c, xCenter - x, yCenter - y, zCenter, width, zbuf, p);
            g.plotPixelUnclipped(c, xCenter + y - sizeCorrection, yCenter + x - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelUnclipped(c, xCenter + y - sizeCorrection, yCenter - x, zCenter, width, zbuf, p);
            g.plotPixelUnclipped(c, xCenter - y, yCenter + x - sizeCorrection, zCenter, width, zbuf, p);
            g.plotPixelUnclipped(c, xCenter - y, yCenter - x, zCenter, width, zbuf, p);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }

    void plotFilledCircleCenteredClipped(int xCenter, int yCenter, int zCenter, int diameter) {
        int r = diameter / 2;
        int sizeCorrection = 1 - (diameter & 1);
        int x = r;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        Graphics3D g = this.g3d;
        int c = g.argbCurrent;
        int width = g.width;
        int height = g.height;
        int[] zbuf = g.zbuf;
        Pixelator p = g.pixel;
        for (int y = 0; x >= y; ++y) {
            this.plotPixelsClipped(c, 2 * x + 1 - sizeCorrection, xCenter - x, yCenter + y - sizeCorrection, zCenter, width, height, zbuf, p);
            this.plotPixelsClipped(c, 2 * x + 1 - sizeCorrection, xCenter - x, yCenter - y, zCenter, width, height, zbuf, p);
            this.plotPixelsClipped(c, 2 * y + 1 - sizeCorrection, xCenter - y, yCenter + x - sizeCorrection, zCenter, width, height, zbuf, p);
            this.plotPixelsClipped(c, 2 * y + 1 - sizeCorrection, xCenter - y, yCenter - x, zCenter, width, height, zbuf, p);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }

    private void plotPixelsClipped(int argb, int count, int x, int y, int z, int width, int height, int[] zbuf, Pixelator p) {
        int offsetPbuf;
        if (y < 0 || y >= height || x >= width) {
            return;
        }
        if (x < 0) {
            count += x;
            x = 0;
        }
        if (count + x > width) {
            count = width - x;
        }
        if (count <= 0) {
            return;
        }
        int offsetMax = offsetPbuf + count;
        for (offsetPbuf = y * width + x; offsetPbuf < offsetMax; ++offsetPbuf) {
            if (z >= zbuf[offsetPbuf]) continue;
            p.addPixel(offsetPbuf, z, argb);
        }
    }

    void plotFilledCircleCenteredUnclipped(int xCenter, int yCenter, int zCenter, int diameter) {
        int r;
        int x = r = diameter / 2;
        int xChange = 1 - 2 * r;
        int yChange = 1;
        int radiusError = 0;
        Graphics3D g = this.g3d;
        int c = g.argbCurrent;
        int width = g.width;
        int[] zbuf = g.zbuf;
        Pixelator p = g.pixel;
        for (int y = 0; x >= y; ++y) {
            g.plotPixelsUnclippedCount(c, 2 * x + 1, xCenter - x, yCenter + y, zCenter, width, zbuf, p);
            g.plotPixelsUnclippedCount(c, 2 * x + 1, xCenter - x, yCenter - y, zCenter, width, zbuf, p);
            g.plotPixelsUnclippedCount(c, 2 * y + 1, xCenter - y, yCenter + x, zCenter, width, zbuf, p);
            g.plotPixelsUnclippedCount(c, 2 * y + 1, xCenter - y, yCenter - x, zCenter, width, zbuf, p);
            if (2 * (radiusError += (yChange += 2)) + xChange <= 0) continue;
            --x;
            radiusError += xChange;
            xChange += 2;
        }
    }
}

