// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `FileInfo.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IcePatch2;

/**
 * Basic information about a single file.
 **/
public class LargeFileInfo implements java.lang.Cloneable,
                                      java.io.Serializable
{
    /**
     * The pathname.
     **/
    public String path;

    /**
     * The SHA-1 checksum of the file.
     **/
    public byte[] checksum;

    /**
     * The size of the compressed file in number of bytes.
     **/
    public long size;

    /**
     * The executable flag.
     **/
    public boolean executable;

    public LargeFileInfo()
    {
        this.path = "";
    }

    public LargeFileInfo(String path, byte[] checksum, long size, boolean executable)
    {
        this.path = path;
        this.checksum = checksum;
        this.size = size;
        this.executable = executable;
    }

    public boolean equals(java.lang.Object rhs)
    {
        if(this == rhs)
        {
            return true;
        }
        LargeFileInfo r = null;
        if(rhs instanceof LargeFileInfo)
        {
            r = (LargeFileInfo)rhs;
        }

        if(r != null)
        {
            if(this.path != r.path)
            {
                if(this.path == null || r.path == null || !this.path.equals(r.path))
                {
                    return false;
                }
            }
            if(!java.util.Arrays.equals(this.checksum, r.checksum))
            {
                return false;
            }
            if(this.size != r.size)
            {
                return false;
            }
            if(this.executable != r.executable)
            {
                return false;
            }

            return true;
        }

        return false;
    }

    public int hashCode()
    {
        int h_ = 5381;
        h_ = com.zeroc.IceInternal.HashUtil.hashAdd(h_, "::IcePatch2::LargeFileInfo");
        h_ = com.zeroc.IceInternal.HashUtil.hashAdd(h_, path);
        h_ = com.zeroc.IceInternal.HashUtil.hashAdd(h_, checksum);
        h_ = com.zeroc.IceInternal.HashUtil.hashAdd(h_, size);
        h_ = com.zeroc.IceInternal.HashUtil.hashAdd(h_, executable);
        return h_;
    }

    public LargeFileInfo clone()
    {
        LargeFileInfo c = null;
        try
        {
            c = (LargeFileInfo)super.clone();
        }
        catch(CloneNotSupportedException ex)
        {
            assert false; // impossible
        }
        return c;
    }

    public void ice_writeMembers(com.zeroc.Ice.OutputStream ostr)
    {
        ostr.writeString(this.path);
        ostr.writeByteSeq(this.checksum);
        ostr.writeLong(this.size);
        ostr.writeBool(this.executable);
    }

    public void ice_readMembers(com.zeroc.Ice.InputStream istr)
    {
        this.path = istr.readString();
        this.checksum = istr.readByteSeq();
        this.size = istr.readLong();
        this.executable = istr.readBool();
    }

    static public void ice_write(com.zeroc.Ice.OutputStream ostr, LargeFileInfo v)
    {
        if(v == null)
        {
            _nullMarshalValue.ice_writeMembers(ostr);
        }
        else
        {
            v.ice_writeMembers(ostr);
        }
    }

    static public LargeFileInfo ice_read(com.zeroc.Ice.InputStream istr)
    {
        LargeFileInfo v = new LargeFileInfo();
        v.ice_readMembers(istr);
        return v;
    }

    static public void ice_write(com.zeroc.Ice.OutputStream ostr, int tag, java.util.Optional<LargeFileInfo> v)
    {
        if(v != null && v.isPresent())
        {
            ice_write(ostr, tag, v.get());
        }
    }

    static public void ice_write(com.zeroc.Ice.OutputStream ostr, int tag, LargeFileInfo v)
    {
        if(ostr.writeOptional(tag, com.zeroc.Ice.OptionalFormat.FSize))
        {
            int pos = ostr.startSize();
            ice_write(ostr, v);
            ostr.endSize(pos);
        }
    }

    static public java.util.Optional<LargeFileInfo> ice_read(com.zeroc.Ice.InputStream istr, int tag)
    {
        if(istr.readOptional(tag, com.zeroc.Ice.OptionalFormat.FSize))
        {
            istr.skip(4);
            return java.util.Optional.of(LargeFileInfo.ice_read(istr));
        }
        else
        {
            return java.util.Optional.empty();
        }
    }

    private static final LargeFileInfo _nullMarshalValue = new LargeFileInfo();

    public static final long serialVersionUID = 1105566963219174392L;
}
