/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XSetWindowAttributes
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 112;
    }

    @Override
    public int getDataSize() {
        return XSetWindowAttributes.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XSetWindowAttributes(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XSetWindowAttributes() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XSetWindowAttributes.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_background_pixmap() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_background_pixmap(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public long get_background_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 8L);
    }

    public void set_background_pixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 8L, v);
    }

    public long get_border_pixmap() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_border_pixmap(long v) {
        log.finest("");
        Native.putLong(this.pData + 16L, v);
    }

    public long get_border_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 24L);
    }

    public void set_border_pixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 24L, v);
    }

    public int get_bit_gravity() {
        log.finest("");
        return Native.getInt(this.pData + 32L);
    }

    public void set_bit_gravity(int v) {
        log.finest("");
        Native.putInt(this.pData + 32L, v);
    }

    public int get_win_gravity() {
        log.finest("");
        return Native.getInt(this.pData + 36L);
    }

    public void set_win_gravity(int v) {
        log.finest("");
        Native.putInt(this.pData + 36L, v);
    }

    public int get_backing_store() {
        log.finest("");
        return Native.getInt(this.pData + 40L);
    }

    public void set_backing_store(int v) {
        log.finest("");
        Native.putInt(this.pData + 40L, v);
    }

    public long get_backing_planes() {
        log.finest("");
        return Native.getLong(this.pData + 48L);
    }

    public void set_backing_planes(long v) {
        log.finest("");
        Native.putLong(this.pData + 48L, v);
    }

    public long get_backing_pixel() {
        log.finest("");
        return Native.getLong(this.pData + 56L);
    }

    public void set_backing_pixel(long v) {
        log.finest("");
        Native.putLong(this.pData + 56L, v);
    }

    public boolean get_save_under() {
        log.finest("");
        return Native.getBool(this.pData + 64L);
    }

    public void set_save_under(boolean v) {
        log.finest("");
        Native.putBool(this.pData + 64L, v);
    }

    public long get_event_mask() {
        log.finest("");
        return Native.getLong(this.pData + 72L);
    }

    public void set_event_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 72L, v);
    }

    public long get_do_not_propagate_mask() {
        log.finest("");
        return Native.getLong(this.pData + 80L);
    }

    public void set_do_not_propagate_mask(long v) {
        log.finest("");
        Native.putLong(this.pData + 80L, v);
    }

    public boolean get_override_redirect() {
        log.finest("");
        return Native.getBool(this.pData + 88L);
    }

    public void set_override_redirect(boolean v) {
        log.finest("");
        Native.putBool(this.pData + 88L, v);
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + 96L);
    }

    public void set_colormap(long v) {
        log.finest("");
        Native.putLong(this.pData + 96L, v);
    }

    public long get_cursor() {
        log.finest("");
        return Native.getLong(this.pData + 104L);
    }

    public void set_cursor(long v) {
        log.finest("");
        Native.putLong(this.pData + 104L, v);
    }

    @Override
    String getName() {
        return "XSetWindowAttributes";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(600);
        ret.append("background_pixmap = ").append(this.get_background_pixmap()).append(", ");
        ret.append("background_pixel = ").append(this.get_background_pixel()).append(", ");
        ret.append("border_pixmap = ").append(this.get_border_pixmap()).append(", ");
        ret.append("border_pixel = ").append(this.get_border_pixel()).append(", ");
        ret.append("bit_gravity = ").append(this.get_bit_gravity()).append(", ");
        ret.append("win_gravity = ").append(this.get_win_gravity()).append(", ");
        ret.append("backing_store = ").append(this.get_backing_store()).append(", ");
        ret.append("backing_planes = ").append(this.get_backing_planes()).append(", ");
        ret.append("backing_pixel = ").append(this.get_backing_pixel()).append(", ");
        ret.append("save_under = ").append(this.get_save_under()).append(", ");
        ret.append("event_mask = ").append(this.get_event_mask()).append(", ");
        ret.append("do_not_propagate_mask = ").append(this.get_do_not_propagate_mask()).append(", ");
        ret.append("override_redirect = ").append(this.get_override_redirect()).append(", ");
        ret.append("colormap = ").append(this.get_colormap()).append(", ");
        ret.append("cursor = ").append(this.get_cursor()).append(", ");
        return ret.toString();
    }
}

