# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.Qt3DRender, except for defaults which are replaced by "...".
"""

# Module PySide2.Qt3DRender
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.Qt3DRender


class Qt3DRender(Shiboken.Object):


    class PropertyReaderInterface(Shiboken.Object):

        def __init__(self): ...
        def readProperty(self, v: typing.Any) -> typing.Any: ...

    class QAbstractFunctor(Shiboken.Object):

        def __init__(self): ...
        def id(self) -> int: ...

    class QAbstractLight(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def color(self) -> PySide2.QtGui.QColor: ...
        def intensity(self) -> float: ...
        def setColor(self, color: PySide2.QtGui.QColor): ...
        def setIntensity(self, intensity: float): ...
        def type(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractLight.Type: ...

    class QAbstractRayCaster(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addLayer(self, layer: PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def filterMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode: ...
        def hits(self) -> PySide2.Qt3DRender.Qt3DRender.QRayCasterHit: ...
        def layers(self) -> PySide2.Qt3DRender.Qt3DRender.QLayer: ...
        def removeLayer(self, layer: PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def runMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode: ...
        def setFilterMode(self, filterMode: PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.FilterMode): ...
        def setRunMode(self, runMode: PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster.RunMode): ...

    class QAbstractTexture(PySide2.Qt3DCore.Qt3DCore.QNode):

        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def __init__(self, target: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addTextureImage(self, textureImage: PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage): ...
        def comparisonFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction: ...
        def comparisonMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode: ...
        def depth(self) -> int: ...
        def format(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat: ...
        def generateMipMaps(self) -> bool: ...
        def height(self) -> int: ...
        def layers(self) -> int: ...
        def magnificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def maximumAnisotropy(self) -> float: ...
        def minificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def removeTextureImage(self, textureImage: PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage): ...
        def samples(self) -> int: ...
        def setComparisonFunction(self, function: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction): ...
        def setComparisonMode(self, mode: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode): ...
        def setDepth(self, depth: int): ...
        def setFormat(self, format: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat): ...
        def setGenerateMipMaps(self, gen: bool): ...
        def setHeight(self, height: int): ...
        def setLayers(self, layers: int): ...
        def setMagnificationFilter(self, f: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setMaximumAnisotropy(self, anisotropy: float): ...
        def setMinificationFilter(self, f: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setSamples(self, samples: int): ...
        def setSize(self, width: int, height: int = ..., depth: int = ...): ...
        def setStatus(self, status: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Status): ...
        def setWidth(self, width: int): ...
        def setWrapMode(self, wrapMode: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode): ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Status: ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target: ...
        def textureImages(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage: ...
        def width(self) -> int: ...
        def wrapMode(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode: ...

    class QAbstractTextureImage(PySide2.Qt3DCore.Qt3DCore.QNode):

        def face(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace: ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...
        def notifyDataGeneratorChanged(self): ...
        def setFace(self, face: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace): ...
        def setLayer(self, layer: int): ...
        def setMipLevel(self, level: int): ...

    class QAlphaCoverage(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QAlphaTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def alphaFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QAlphaTest.AlphaFunction: ...
        def referenceValue(self) -> float: ...
        def setAlphaFunction(self, alphaFunction: PySide2.Qt3DRender.Qt3DRender.QAlphaTest.AlphaFunction): ...
        def setReferenceValue(self, referenceValue: float): ...

    class QAttribute(PySide2.Qt3DCore.Qt3DCore.QNode):

        @typing.overload
        def __init__(self, buf: PySide2.Qt3DRender.Qt3DRender.QBuffer, name: str, vertexBaseType: PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType, vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def __init__(self, buf: PySide2.Qt3DRender.Qt3DRender.QBuffer, vertexBaseType: PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType, vertexSize: int, count: int, offset: int = ..., stride: int = ..., parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def attributeType(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute.AttributeType: ...
        def buffer(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer: ...
        def byteOffset(self) -> int: ...
        def byteStride(self) -> int: ...
        def count(self) -> int: ...
        @staticmethod
        def defaultColorAttributeName() -> str: ...
        @staticmethod
        def defaultJointIndicesAttributeName() -> str: ...
        @staticmethod
        def defaultJointWeightsAttributeName() -> str: ...
        @staticmethod
        def defaultNormalAttributeName() -> str: ...
        @staticmethod
        def defaultPositionAttributeName() -> str: ...
        @staticmethod
        def defaultTangentAttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinate1AttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinate2AttributeName() -> str: ...
        @staticmethod
        def defaultTextureCoordinateAttributeName() -> str: ...
        def divisor(self) -> int: ...
        def name(self) -> str: ...
        def setAttributeType(self, attributeType: PySide2.Qt3DRender.Qt3DRender.QAttribute.AttributeType): ...
        def setBuffer(self, buffer: PySide2.Qt3DRender.Qt3DRender.QBuffer): ...
        def setByteOffset(self, byteOffset: int): ...
        def setByteStride(self, byteStride: int): ...
        def setCount(self, count: int): ...
        def setDataSize(self, size: int): ...
        def setDataType(self, type: PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType): ...
        def setDivisor(self, divisor: int): ...
        def setName(self, name: str): ...
        def setVertexBaseType(self, type: PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType): ...
        def setVertexSize(self, size: int): ...
        def vertexBaseType(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute.VertexBaseType: ...
        def vertexSize(self) -> int: ...

    class QBlendEquation(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def blendFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction: ...
        def setBlendFunction(self, blendFunction: PySide2.Qt3DRender.Qt3DRender.QBlendEquation.BlendFunction): ...

    class QBlendEquationArguments(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def bufferIndex(self) -> int: ...
        def destinationAlpha(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def destinationRgb(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def setBufferIndex(self, index: int): ...
        def setDestinationAlpha(self, destinationAlpha: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setDestinationRgb(self, destinationRgb: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setDestinationRgba(self, destinationRgba: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setSourceAlpha(self, sourceAlpha: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setSourceRgb(self, sourceRgb: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def setSourceRgba(self, sourceRgba: PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending): ...
        def sourceAlpha(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...
        def sourceRgb(self) -> PySide2.Qt3DRender.Qt3DRender.QBlendEquationArguments.Blending: ...

    class QBlitFramebuffer(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def destination(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTarget: ...
        def destinationAttachmentPoint(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def destinationRect(self) -> PySide2.QtCore.QRectF: ...
        def interpolationMethod(self) -> PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod: ...
        def setDestination(self, destination: PySide2.Qt3DRender.Qt3DRender.QRenderTarget): ...
        def setDestinationAttachmentPoint(self, destinationAttachmentPoint: PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint): ...
        def setDestinationRect(self, destinationRect: PySide2.QtCore.QRectF): ...
        def setInterpolationMethod(self, interpolationMethod: PySide2.Qt3DRender.Qt3DRender.QBlitFramebuffer.InterpolationMethod): ...
        def setSource(self, source: PySide2.Qt3DRender.Qt3DRender.QRenderTarget): ...
        def setSourceAttachmentPoint(self, sourceAttachmentPoint: PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint): ...
        def setSourceRect(self, sourceRect: PySide2.QtCore.QRectF): ...
        def source(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTarget: ...
        def sourceAttachmentPoint(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def sourceRect(self) -> PySide2.QtCore.QRectF: ...

    class QBuffer(PySide2.Qt3DCore.Qt3DCore.QNode):

        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def __init__(self, ty: PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def accessType(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer.AccessType: ...
        def data(self) -> PySide2.QtCore.QByteArray: ...
        def isSyncData(self) -> bool: ...
        def setAccessType(self, access: PySide2.Qt3DRender.Qt3DRender.QBuffer.AccessType): ...
        def setData(self, bytes: PySide2.QtCore.QByteArray): ...
        def setSyncData(self, syncData: bool): ...
        def setType(self, type: PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType): ...
        def setUsage(self, usage: PySide2.Qt3DRender.Qt3DRender.QBuffer.UsageType): ...
        def type(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer.BufferType: ...
        def updateData(self, offset: int, bytes: PySide2.QtCore.QByteArray): ...
        def usage(self) -> PySide2.Qt3DRender.Qt3DRender.QBuffer.UsageType: ...

    class QBufferCapture(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QBufferDataGenerator(PySide2.Qt3DRender.Qt3DRender.QAbstractFunctor):

        def __init__(self): ...

    class QCamera(PySide2.Qt3DCore.Qt3DCore.QEntity):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def aspectRatio(self) -> float: ...
        def bottom(self) -> float: ...
        def exposure(self) -> float: ...
        def farPlane(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def left(self) -> float: ...
        def lens(self) -> PySide2.Qt3DRender.Qt3DRender.QCameraLens: ...
        def nearPlane(self) -> float: ...
        @typing.overload
        def pan(self, angle: float): ...
        @typing.overload
        def pan(self, angle: float, axis: PySide2.QtGui.QVector3D): ...
        @typing.overload
        def panAboutViewCenter(self, angle: float): ...
        @typing.overload
        def panAboutViewCenter(self, angle: float, axis: PySide2.QtGui.QVector3D): ...
        def panRotation(self, angle: float) -> PySide2.QtGui.QQuaternion: ...
        def position(self) -> PySide2.QtGui.QVector3D: ...
        def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def projectionType(self) -> PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType: ...
        def right(self) -> float: ...
        def roll(self, angle: float): ...
        def rollAboutViewCenter(self, angle: float): ...
        def rollRotation(self, angle: float) -> PySide2.QtGui.QQuaternion: ...
        def rotate(self, q: PySide2.QtGui.QQuaternion): ...
        def rotateAboutViewCenter(self, q: PySide2.QtGui.QQuaternion): ...
        def rotation(self, angle: float, axis: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
        def setAspectRatio(self, aspectRatio: float): ...
        def setBottom(self, bottom: float): ...
        def setExposure(self, exposure: float): ...
        def setFarPlane(self, farPlane: float): ...
        def setFieldOfView(self, fieldOfView: float): ...
        def setLeft(self, left: float): ...
        def setNearPlane(self, nearPlane: float): ...
        def setPosition(self, position: PySide2.QtGui.QVector3D): ...
        def setProjectionMatrix(self, projectionMatrix: PySide2.QtGui.QMatrix4x4): ...
        def setProjectionType(self, type: PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType): ...
        def setRight(self, right: float): ...
        def setTop(self, top: float): ...
        def setUpVector(self, upVector: PySide2.QtGui.QVector3D): ...
        def setViewCenter(self, viewCenter: PySide2.QtGui.QVector3D): ...
        def tilt(self, angle: float): ...
        def tiltAboutViewCenter(self, angle: float): ...
        def tiltRotation(self, angle: float) -> PySide2.QtGui.QQuaternion: ...
        def top(self) -> float: ...
        def transform(self) -> PySide2.Qt3DCore.Qt3DCore.QTransform: ...
        def translate(self, vLocal: PySide2.QtGui.QVector3D, option: PySide2.Qt3DRender.Qt3DRender.QCamera.CameraTranslationOption = ...): ...
        def translateWorld(self, vWorld: PySide2.QtGui.QVector3D, option: PySide2.Qt3DRender.Qt3DRender.QCamera.CameraTranslationOption = ...): ...
        def upVector(self) -> PySide2.QtGui.QVector3D: ...
        def viewAll(self): ...
        def viewCenter(self) -> PySide2.QtGui.QVector3D: ...
        def viewEntity(self, entity: PySide2.Qt3DCore.Qt3DCore.QEntity): ...
        def viewMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def viewSphere(self, center: PySide2.QtGui.QVector3D, radius: float): ...
        def viewVector(self) -> PySide2.QtGui.QVector3D: ...

    class QCameraLens(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def aspectRatio(self) -> float: ...
        def bottom(self) -> float: ...
        def exposure(self) -> float: ...
        def farPlane(self) -> float: ...
        def fieldOfView(self) -> float: ...
        def left(self) -> float: ...
        def nearPlane(self) -> float: ...
        def projectionMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def projectionType(self) -> PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType: ...
        def right(self) -> float: ...
        def setAspectRatio(self, aspectRatio: float): ...
        def setBottom(self, bottom: float): ...
        def setExposure(self, exposure: float): ...
        def setFarPlane(self, farPlane: float): ...
        def setFieldOfView(self, fieldOfView: float): ...
        def setFrustumProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float): ...
        def setLeft(self, left: float): ...
        def setNearPlane(self, nearPlane: float): ...
        def setOrthographicProjection(self, left: float, right: float, bottom: float, top: float, nearPlane: float, farPlane: float): ...
        def setPerspectiveProjection(self, fieldOfView: float, aspect: float, nearPlane: float, farPlane: float): ...
        def setProjectionMatrix(self, projectionMatrix: PySide2.QtGui.QMatrix4x4): ...
        def setProjectionType(self, projectionType: PySide2.Qt3DRender.Qt3DRender.QCameraLens.ProjectionType): ...
        def setRight(self, right: float): ...
        def setTop(self, top: float): ...
        def top(self) -> float: ...
        def viewAll(self, cameraId: PySide2.Qt3DCore.Qt3DCore.QNodeId): ...
        def viewEntity(self, entityId: PySide2.Qt3DCore.Qt3DCore.QNodeId, cameraId: PySide2.Qt3DCore.Qt3DCore.QNodeId): ...

    class QCameraSelector(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def camera(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def setCamera(self, camera: PySide2.Qt3DCore.Qt3DCore.QEntity): ...

    class QClearBuffers(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def buffers(self) -> PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType: ...
        def clearColor(self) -> PySide2.QtGui.QColor: ...
        def clearDepthValue(self) -> float: ...
        def clearStencilValue(self) -> int: ...
        def colorBuffer(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput: ...
        def setBuffers(self, buffers: PySide2.Qt3DRender.Qt3DRender.QClearBuffers.BufferType): ...
        def setClearColor(self, color: PySide2.QtGui.QColor): ...
        def setClearDepthValue(self, clearDepthValue: float): ...
        def setClearStencilValue(self, clearStencilValue: int): ...
        def setColorBuffer(self, buffer: PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput): ...

    class QClipPlane(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def distance(self) -> float: ...
        def normal(self) -> PySide2.QtGui.QVector3D: ...
        def planeIndex(self) -> int: ...
        def setDistance(self, arg__1: float): ...
        def setNormal(self, arg__1: PySide2.QtGui.QVector3D): ...
        def setPlaneIndex(self, arg__1: int): ...

    class QColorMask(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def isAlphaMasked(self) -> bool: ...
        def isBlueMasked(self) -> bool: ...
        def isGreenMasked(self) -> bool: ...
        def isRedMasked(self) -> bool: ...
        def setAlphaMasked(self, alphaMasked: bool): ...
        def setBlueMasked(self, blueMasked: bool): ...
        def setGreenMasked(self, greenMasked: bool): ...
        def setRedMasked(self, redMasked: bool): ...

    class QComputeCommand(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def setWorkGroupX(self, workGroupX: int): ...
        def setWorkGroupY(self, workGroupY: int): ...
        def setWorkGroupZ(self, workGroupZ: int): ...
        def workGroupX(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupZ(self) -> int: ...

    class QCullFace(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def mode(self) -> PySide2.Qt3DRender.Qt3DRender.QCullFace.CullingMode: ...
        def setMode(self, mode: PySide2.Qt3DRender.Qt3DRender.QCullFace.CullingMode): ...

    class QDepthTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def depthFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QDepthTest.DepthFunction: ...
        def setDepthFunction(self, depthFunction: PySide2.Qt3DRender.Qt3DRender.QDepthTest.DepthFunction): ...

    class QDirectionalLight(PySide2.Qt3DRender.Qt3DRender.QAbstractLight):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def setWorldDirection(self, worldDirection: PySide2.QtGui.QVector3D): ...
        def worldDirection(self) -> PySide2.QtGui.QVector3D: ...

    class QDispatchCompute(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def setWorkGroupX(self, workGroupX: int): ...
        def setWorkGroupY(self, workGroupY: int): ...
        def setWorkGroupZ(self, workGroupZ: int): ...
        def workGroupX(self) -> int: ...
        def workGroupY(self) -> int: ...
        def workGroupZ(self) -> int: ...

    class QDithering(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QEffect(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addParameter(self, parameter: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def addTechnique(self, t: PySide2.Qt3DRender.Qt3DRender.QTechnique): ...
        def parameters(self) -> PySide2.Qt3DRender.Qt3DRender.QParameter: ...
        def removeParameter(self, parameter: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def removeTechnique(self, t: PySide2.Qt3DRender.Qt3DRender.QTechnique): ...
        def techniques(self) -> PySide2.Qt3DRender.Qt3DRender.QTechnique: ...

    class QEnvironmentLight(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def irradiance(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...
        def setIrradiance(self, irradiance: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture): ...
        def setSpecular(self, specular: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture): ...
        def specular(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...

    class QFilterKey(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def name(self) -> str: ...
        def setName(self, customType: str): ...
        def setValue(self, value: typing.Any): ...
        def value(self) -> typing.Any: ...

    class QFrameGraphNode(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def parentFrameGraphNode(self) -> PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode: ...

    class QFrameGraphNodeCreatedChangeBase(PySide2.Qt3DCore.Qt3DCore.QNodeCreatedChangeBase):

        def __init__(self, node: PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode): ...
        def parentFrameGraphNodeId(self) -> PySide2.Qt3DCore.Qt3DCore.QNodeId: ...

    class QFrontFace(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def direction(self) -> PySide2.Qt3DRender.Qt3DRender.QFrontFace.WindingDirection: ...
        def setDirection(self, direction: PySide2.Qt3DRender.Qt3DRender.QFrontFace.WindingDirection): ...

    class QFrustumCulling(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QGeometry(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addAttribute(self, attribute: PySide2.Qt3DRender.Qt3DRender.QAttribute): ...
        def attributes(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def boundingVolumePositionAttribute(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def removeAttribute(self, attribute: PySide2.Qt3DRender.Qt3DRender.QAttribute): ...
        def setBoundingVolumePositionAttribute(self, boundingVolumePositionAttribute: PySide2.Qt3DRender.Qt3DRender.QAttribute): ...

    class QGeometryFactory(PySide2.Qt3DRender.Qt3DRender.QAbstractFunctor):

        def __init__(self): ...

    class QGeometryRenderer(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def firstInstance(self) -> int: ...
        def firstVertex(self) -> int: ...
        def geometry(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometry: ...
        def indexBufferByteOffset(self) -> int: ...
        def indexOffset(self) -> int: ...
        def instanceCount(self) -> int: ...
        def primitiveRestartEnabled(self) -> bool: ...
        def primitiveType(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType: ...
        def restartIndexValue(self) -> int: ...
        def setFirstInstance(self, firstInstance: int): ...
        def setFirstVertex(self, firstVertex: int): ...
        def setGeometry(self, geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry): ...
        def setIndexBufferByteOffset(self, offset: int): ...
        def setIndexOffset(self, indexOffset: int): ...
        def setInstanceCount(self, instanceCount: int): ...
        def setPrimitiveRestartEnabled(self, enabled: bool): ...
        def setPrimitiveType(self, primitiveType: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer.PrimitiveType): ...
        def setRestartIndexValue(self, index: int): ...
        def setVertexCount(self, vertexCount: int): ...
        def setVerticesPerPatch(self, verticesPerPatch: int): ...
        def vertexCount(self) -> int: ...
        def verticesPerPatch(self) -> int: ...

    class QGraphicsApiFilter(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def api(self) -> PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api: ...
        def extensions(self) -> typing.List[str]: ...
        def majorVersion(self) -> int: ...
        def minorVersion(self) -> int: ...
        def profile(self) -> PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile: ...
        def setApi(self, api: PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.Api): ...
        def setExtensions(self, extensions: typing.List[str]): ...
        def setMajorVersion(self, majorVersion: int): ...
        def setMinorVersion(self, minorVersion: int): ...
        def setProfile(self, profile: PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter.OpenGLProfile): ...
        def setVendor(self, vendor: str): ...
        def vendor(self) -> str: ...

    class QLayer(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def recursive(self) -> bool: ...
        def setRecursive(self, recursive: bool): ...

    class QLayerFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addLayer(self, layer: PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def filterMode(self) -> PySide2.Qt3DRender.Qt3DRender.QLayerFilter.FilterMode: ...
        def layers(self) -> PySide2.Qt3DRender.Qt3DRender.QLayer: ...
        def removeLayer(self, layer: PySide2.Qt3DRender.Qt3DRender.QLayer): ...
        def setFilterMode(self, filterMode: PySide2.Qt3DRender.Qt3DRender.QLayerFilter.FilterMode): ...

    class QLevelOfDetail(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def camera(self) -> PySide2.Qt3DRender.Qt3DRender.QCamera: ...
        def createBoundingSphere(self, center: PySide2.QtGui.QVector3D, radius: float) -> PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere: ...
        def currentIndex(self) -> int: ...
        def setCamera(self, camera: PySide2.Qt3DRender.Qt3DRender.QCamera): ...
        def setCurrentIndex(self, currentIndex: int): ...
        def setThresholdType(self, thresholdType: PySide2.Qt3DRender.Qt3DRender.QLevelOfDetail.ThresholdType): ...
        def setThresholds(self, thresholds: list): ...
        def setVolumeOverride(self, volumeOverride: PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere): ...
        def thresholdType(self) -> PySide2.Qt3DRender.Qt3DRender.QLevelOfDetail.ThresholdType: ...
        def thresholds(self) -> float: ...
        def volumeOverride(self) -> PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere: ...

    class QLevelOfDetailBoundingSphere(Shiboken.Object):

        @typing.overload
        def __init__(self, center: PySide2.QtGui.QVector3D = ..., radius: float = ...): ...
        @typing.overload
        def __init__(self, other: PySide2.Qt3DRender.Qt3DRender.QLevelOfDetailBoundingSphere): ...
        def center(self) -> PySide2.QtGui.QVector3D: ...
        def isEmpty(self) -> bool: ...
        def radius(self) -> float: ...

    class QLevelOfDetailSwitch(PySide2.Qt3DRender.Qt3DRender.QLevelOfDetail):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QLineWidth(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def setSmooth(self, enabled: bool): ...
        def setValue(self, value: float): ...
        def smooth(self) -> bool: ...
        def value(self) -> float: ...

    class QMaterial(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addParameter(self, parameter: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def effect(self) -> PySide2.Qt3DRender.Qt3DRender.QEffect: ...
        def parameters(self) -> PySide2.Qt3DRender.Qt3DRender.QParameter: ...
        def removeParameter(self, parameter: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def setEffect(self, effect: PySide2.Qt3DRender.Qt3DRender.QEffect): ...

    class QMemoryBarrier(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def setWaitOperations(self, operations: PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations): ...
        def waitOperations(self) -> PySide2.Qt3DRender.Qt3DRender.QMemoryBarrier.Operations: ...

    class QMesh(PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def meshName(self) -> str: ...
        def setMeshName(self, meshName: str): ...
        def setSource(self, source: PySide2.QtCore.QUrl): ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QMesh.Status: ...

    class QMultiSampleAntiAliasing(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QNoDepthMask(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QNoDraw(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QObjectPicker(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def containsMouse(self) -> bool: ...
        def isDragEnabled(self) -> bool: ...
        def isHoverEnabled(self) -> bool: ...
        def isPressed(self) -> bool: ...
        def setDragEnabled(self, dragEnabled: bool): ...
        def setHoverEnabled(self, hoverEnabled: bool): ...

    class QPaintedTextureImage(PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def height(self) -> int: ...
        def paint(self, painter: PySide2.QtGui.QPainter): ...
        def setHeight(self, h: int): ...
        def setSize(self, size: PySide2.QtCore.QSize): ...
        def setWidth(self, w: int): ...
        def size(self) -> PySide2.QtCore.QSize: ...
        def update(self, rect: PySide2.QtCore.QRect = ...): ...
        def width(self) -> int: ...

    class QParameter(PySide2.Qt3DCore.Qt3DCore.QNode):

        @typing.overload
        def __init__(self, name: str, texture: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def __init__(self, name: str, value: typing.Any, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def name(self) -> str: ...
        def setName(self, name: str): ...
        def setValue(self, dv: typing.Any): ...
        def value(self) -> typing.Any: ...

    class QPickEvent(PySide2.QtCore.QObject):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float): ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, button: PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int): ...
        def button(self) -> PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons: ...
        def buttons(self) -> int: ...
        def distance(self) -> float: ...
        def isAccepted(self) -> bool: ...
        def localIntersection(self) -> PySide2.QtGui.QVector3D: ...
        def modifiers(self) -> int: ...
        def position(self) -> PySide2.QtCore.QPointF: ...
        def setAccepted(self, accepted: bool): ...
        def worldIntersection(self) -> PySide2.QtGui.QVector3D: ...

    class QPickLineEvent(PySide2.Qt3DRender.Qt3DRender.QPickEvent):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, edgeIndex: int, vertex1Index: int, vertex2Index: int, button: PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int): ...
        def edgeIndex(self) -> int: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...

    class QPickPointEvent(PySide2.Qt3DRender.Qt3DRender.QPickEvent):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, pointIndex: int, button: PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int): ...
        def pointIndex(self) -> int: ...

    class QPickTriangleEvent(PySide2.Qt3DRender.Qt3DRender.QPickEvent):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int): ...
        @typing.overload
        def __init__(self, position: PySide2.QtCore.QPointF, worldIntersection: PySide2.QtGui.QVector3D, localIntersection: PySide2.QtGui.QVector3D, distance: float, triangleIndex: int, vertex1Index: int, vertex2Index: int, vertex3Index: int, button: PySide2.Qt3DRender.Qt3DRender.QPickEvent.Buttons, buttons: int, modifiers: int, uvw: PySide2.QtGui.QVector3D): ...
        def triangleIndex(self) -> int: ...
        def uvw(self) -> PySide2.QtGui.QVector3D: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...
        def vertex3Index(self) -> int: ...

    class QPickingSettings(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def faceOrientationPickingMode(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings.FaceOrientationPickingMode: ...
        def pickMethod(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickMethod: ...
        def pickResultMode(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickResultMode: ...
        def setFaceOrientationPickingMode(self, faceOrientationPickingMode: PySide2.Qt3DRender.Qt3DRender.QPickingSettings.FaceOrientationPickingMode): ...
        def setPickMethod(self, pickMethod: PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickMethod): ...
        def setPickResultMode(self, pickResultMode: PySide2.Qt3DRender.Qt3DRender.QPickingSettings.PickResultMode): ...
        def setWorldSpaceTolerance(self, worldSpaceTolerance: float): ...
        def worldSpaceTolerance(self) -> float: ...

    class QPointLight(PySide2.Qt3DRender.Qt3DRender.QAbstractLight):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def constantAttenuation(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def quadraticAttenuation(self) -> float: ...
        def setConstantAttenuation(self, value: float): ...
        def setLinearAttenuation(self, value: float): ...
        def setQuadraticAttenuation(self, value: float): ...

    class QPointSize(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def setSizeMode(self, sizeMode: PySide2.Qt3DRender.Qt3DRender.QPointSize.SizeMode): ...
        def setValue(self, value: float): ...
        def sizeMode(self) -> PySide2.Qt3DRender.Qt3DRender.QPointSize.SizeMode: ...
        def value(self) -> float: ...

    class QPolygonOffset(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def depthSteps(self) -> float: ...
        def scaleFactor(self) -> float: ...
        def setDepthSteps(self, depthSteps: float): ...
        def setScaleFactor(self, scaleFactor: float): ...

    class QProximityFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def distanceThreshold(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def setDistanceThreshold(self, distanceThreshold: float): ...
        def setEntity(self, entity: PySide2.Qt3DCore.Qt3DCore.QEntity): ...

    class QRayCaster(PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def direction(self) -> PySide2.QtGui.QVector3D: ...
        def length(self) -> float: ...
        def origin(self) -> PySide2.QtGui.QVector3D: ...
        def setDirection(self, direction: PySide2.QtGui.QVector3D): ...
        def setLength(self, length: float): ...
        def setOrigin(self, origin: PySide2.QtGui.QVector3D): ...
        @typing.overload
        def trigger(self): ...
        @typing.overload
        def trigger(self, origin: PySide2.QtGui.QVector3D, direction: PySide2.QtGui.QVector3D, length: float): ...

    class QRayCasterHit(Shiboken.Object):

        @typing.overload
        def __init__(self): ...
        @typing.overload
        def __init__(self, other: PySide2.Qt3DRender.Qt3DRender.QRayCasterHit): ...
        @typing.overload
        def __init__(self, type: PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.HitType, id: PySide2.Qt3DCore.Qt3DCore.QNodeId, distance: float, localIntersect: PySide2.QtGui.QVector3D, worldIntersect: PySide2.QtGui.QVector3D, primitiveIndex: int, v1: int, v2: int, v3: int): ...
        def __copy__(self): ...
        def distance(self) -> float: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def entityId(self) -> PySide2.Qt3DCore.Qt3DCore.QNodeId: ...
        def localIntersection(self) -> PySide2.QtGui.QVector3D: ...
        def primitiveIndex(self) -> int: ...
        def type(self) -> PySide2.Qt3DRender.Qt3DRender.QRayCasterHit.HitType: ...
        def vertex1Index(self) -> int: ...
        def vertex2Index(self) -> int: ...
        def vertex3Index(self) -> int: ...
        def worldIntersection(self) -> PySide2.QtGui.QVector3D: ...

    class QRenderAspect(PySide2.Qt3DCore.Qt3DCore.QAbstractAspect):

        @typing.overload
        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, type: PySide2.Qt3DRender.Qt3DRender.QRenderAspect.RenderType, parent: PySide2.QtCore.QObject = ...): ...

    class QRenderCapture(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def requestCapture(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderCaptureReply: ...
        @typing.overload
        def requestCapture(self, captureId: int) -> PySide2.Qt3DRender.Qt3DRender.QRenderCaptureReply: ...
        @typing.overload
        def requestCapture(self, rect: PySide2.QtCore.QRect) -> PySide2.Qt3DRender.Qt3DRender.QRenderCaptureReply: ...

    class QRenderCaptureReply(PySide2.QtCore.QObject):

        def captureId(self) -> int: ...
        def image(self) -> PySide2.QtGui.QImage: ...
        def isComplete(self) -> bool: ...
        def saveImage(self, fileName: str) -> bool: ...
        def saveToFile(self, fileName: str): ...

    class QRenderPass(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addFilterKey(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, p: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def addRenderState(self, state: PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def filterKeys(self) -> PySide2.Qt3DRender.Qt3DRender.QFilterKey: ...
        def parameters(self) -> PySide2.Qt3DRender.Qt3DRender.QParameter: ...
        def removeFilterKey(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, p: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def removeRenderState(self, state: PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def renderStates(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderState: ...
        def setShaderProgram(self, shaderProgram: PySide2.Qt3DRender.Qt3DRender.QShaderProgram): ...
        def shaderProgram(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderProgram: ...

    class QRenderPassFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addMatch(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, parameter: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def matchAny(self) -> PySide2.Qt3DRender.Qt3DRender.QFilterKey: ...
        def parameters(self) -> PySide2.Qt3DRender.Qt3DRender.QParameter: ...
        def removeMatch(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, parameter: PySide2.Qt3DRender.Qt3DRender.QParameter): ...

    class QRenderSettings(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def activeFrameGraph(self) -> PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode: ...
        def pickingSettings(self) -> PySide2.Qt3DRender.Qt3DRender.QPickingSettings: ...
        def renderPolicy(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderSettings.RenderPolicy: ...
        def setActiveFrameGraph(self, activeFrameGraph: PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode): ...
        def setRenderPolicy(self, renderPolicy: PySide2.Qt3DRender.Qt3DRender.QRenderSettings.RenderPolicy): ...

    class QRenderState: ...

    class QRenderStateSet(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addRenderState(self, state: PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def removeRenderState(self, state: PySide2.Qt3DRender.Qt3DRender.QRenderState): ...
        def renderStates(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderState: ...

    class QRenderSurfaceSelector(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def externalRenderTargetSize(self) -> PySide2.QtCore.QSize: ...
        def setExternalRenderTargetSize(self, size: PySide2.QtCore.QSize): ...
        def setSurface(self, surfaceObject: PySide2.QtCore.QObject): ...
        def setSurfacePixelRatio(self, ratio: float): ...
        def surface(self) -> PySide2.QtCore.QObject: ...
        def surfacePixelRatio(self) -> float: ...

    class QRenderTarget(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addOutput(self, output: PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput): ...
        def outputs(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput: ...
        def removeOutput(self, output: PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput): ...

    class QRenderTargetOutput(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def attachmentPoint(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def face(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace: ...
        def layer(self) -> int: ...
        def mipLevel(self) -> int: ...
        def setAttachmentPoint(self, attachmentPoint: PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint): ...
        def setFace(self, face: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.CubeMapFace): ...
        def setLayer(self, layer: int): ...
        def setMipLevel(self, level: int): ...
        def setTexture(self, texture: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture): ...
        def texture(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture: ...

    class QRenderTargetSelector(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def outputs(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTargetOutput.AttachmentPoint: ...
        def setOutputs(self, buffers: list): ...
        def setTarget(self, target: PySide2.Qt3DRender.Qt3DRender.QRenderTarget): ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderTarget: ...

    class QSceneLoader(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def component(self, entityName: str, componentType: PySide2.Qt3DRender.Qt3DRender.QSceneLoader.ComponentType) -> PySide2.Qt3DCore.Qt3DCore.QComponent: ...
        def entity(self, entityName: str) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def entityNames(self) -> typing.List[str]: ...
        def setSource(self, arg: PySide2.QtCore.QUrl): ...
        def setStatus(self, status: PySide2.Qt3DRender.Qt3DRender.QSceneLoader.Status): ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QSceneLoader.Status: ...

    class QScissorTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def bottom(self) -> int: ...
        def height(self) -> int: ...
        def left(self) -> int: ...
        def setBottom(self, bottom: int): ...
        def setHeight(self, height: int): ...
        def setLeft(self, left: int): ...
        def setWidth(self, width: int): ...
        def width(self) -> int: ...

    class QScreenRayCaster(PySide2.Qt3DRender.Qt3DRender.QAbstractRayCaster):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def position(self) -> PySide2.QtCore.QPoint: ...
        def setPosition(self, position: PySide2.QtCore.QPoint): ...
        @typing.overload
        def trigger(self): ...
        @typing.overload
        def trigger(self, position: PySide2.QtCore.QPoint): ...

    class QSeamlessCubemap(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QShaderData(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def event(self, event: PySide2.QtCore.QEvent) -> bool: ...

    class QShaderProgram(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def computeShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def fragmentShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def geometryShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        @staticmethod
        def loadSource(sourceUrl: PySide2.QtCore.QUrl) -> PySide2.QtCore.QByteArray: ...
        def log(self) -> str: ...
        def setComputeShaderCode(self, computeShaderCode: PySide2.QtCore.QByteArray): ...
        def setFragmentShaderCode(self, fragmentShaderCode: PySide2.QtCore.QByteArray): ...
        def setGeometryShaderCode(self, geometryShaderCode: PySide2.QtCore.QByteArray): ...
        def setShaderCode(self, type: PySide2.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType, shaderCode: PySide2.QtCore.QByteArray): ...
        def setTessellationControlShaderCode(self, tessellationControlShaderCode: PySide2.QtCore.QByteArray): ...
        def setTessellationEvaluationShaderCode(self, tessellationEvaluationShaderCode: PySide2.QtCore.QByteArray): ...
        def setVertexShaderCode(self, vertexShaderCode: PySide2.QtCore.QByteArray): ...
        def shaderCode(self, type: PySide2.Qt3DRender.Qt3DRender.QShaderProgram.ShaderType) -> PySide2.QtCore.QByteArray: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderProgram.Status: ...
        def tessellationControlShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def tessellationEvaluationShaderCode(self) -> PySide2.QtCore.QByteArray: ...
        def vertexShaderCode(self) -> PySide2.QtCore.QByteArray: ...

    class QShaderProgramBuilder(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def computeShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def enabledLayers(self) -> typing.List[str]: ...
        def fragmentShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def geometryShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def setComputeShaderGraph(self, computeShaderGraph: PySide2.QtCore.QUrl): ...
        def setEnabledLayers(self, layers: typing.List[str]): ...
        def setFragmentShaderGraph(self, fragmentShaderGraph: PySide2.QtCore.QUrl): ...
        def setGeometryShaderGraph(self, geometryShaderGraph: PySide2.QtCore.QUrl): ...
        def setShaderProgram(self, program: PySide2.Qt3DRender.Qt3DRender.QShaderProgram): ...
        def setTessellationControlShaderGraph(self, tessellationControlShaderGraph: PySide2.QtCore.QUrl): ...
        def setTessellationEvaluationShaderGraph(self, tessellationEvaluationShaderGraph: PySide2.QtCore.QUrl): ...
        def setVertexShaderGraph(self, vertexShaderGraph: PySide2.QtCore.QUrl): ...
        def shaderProgram(self) -> PySide2.Qt3DRender.Qt3DRender.QShaderProgram: ...
        def tessellationControlShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def tessellationEvaluationShaderGraph(self) -> PySide2.QtCore.QUrl: ...
        def vertexShaderGraph(self) -> PySide2.QtCore.QUrl: ...

    class QSortPolicy(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        @typing.overload
        def setSortTypes(self, sortTypes: list): ...
        @typing.overload
        def setSortTypes(self, sortTypesInt: list): ...
        def sortTypes(self) -> PySide2.Qt3DRender.Qt3DRender.QSortPolicy.SortType: ...
        def sortTypesInt(self) -> int: ...

    class QSpotLight(PySide2.Qt3DRender.Qt3DRender.QAbstractLight):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def constantAttenuation(self) -> float: ...
        def cutOffAngle(self) -> float: ...
        def linearAttenuation(self) -> float: ...
        def localDirection(self) -> PySide2.QtGui.QVector3D: ...
        def quadraticAttenuation(self) -> float: ...
        def setConstantAttenuation(self, value: float): ...
        def setCutOffAngle(self, cutOffAngle: float): ...
        def setLinearAttenuation(self, value: float): ...
        def setLocalDirection(self, localDirection: PySide2.QtGui.QVector3D): ...
        def setQuadraticAttenuation(self, value: float): ...

    class QStencilMask(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def backOutputMask(self) -> int: ...
        def frontOutputMask(self) -> int: ...
        def setBackOutputMask(self, backOutputMask: int): ...
        def setFrontOutputMask(self, frontOutputMask: int): ...

    class QStencilOperation(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def back(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments: ...
        def front(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments: ...

    class QStencilOperationArguments(PySide2.QtCore.QObject):

        def allTestsPassOperation(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation: ...
        def depthTestFailureOperation(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation: ...
        def faceMode(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.FaceMode: ...
        def setAllTestsPassOperation(self, operation: PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation): ...
        def setDepthTestFailureOperation(self, operation: PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation): ...
        def setStencilTestFailureOperation(self, operation: PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation): ...
        def stencilTestFailureOperation(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilOperationArguments.Operation: ...

    class QStencilTest(PySide2.Qt3DRender.Qt3DRender.QRenderState):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def back(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments: ...
        def front(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments: ...

    class QStencilTestArguments(PySide2.QtCore.QObject):

        def comparisonMask(self) -> int: ...
        def faceMode(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFaceMode: ...
        def referenceValue(self) -> int: ...
        def setComparisonMask(self, comparisonMask: int): ...
        def setReferenceValue(self, referenceValue: int): ...
        def setStencilFunction(self, stencilFunction: PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction): ...
        def stencilFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QStencilTestArguments.StencilFunction: ...

    class QTechnique(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addFilterKey(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, p: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def addRenderPass(self, pass_: PySide2.Qt3DRender.Qt3DRender.QRenderPass): ...
        def filterKeys(self) -> PySide2.Qt3DRender.Qt3DRender.QFilterKey: ...
        def graphicsApiFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QGraphicsApiFilter: ...
        def parameters(self) -> PySide2.Qt3DRender.Qt3DRender.QParameter: ...
        def removeFilterKey(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, p: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def removeRenderPass(self, pass_: PySide2.Qt3DRender.Qt3DRender.QRenderPass): ...
        def renderPasses(self) -> PySide2.Qt3DRender.Qt3DRender.QRenderPass: ...

    class QTechniqueFilter(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def addMatch(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def addParameter(self, p: PySide2.Qt3DRender.Qt3DRender.QParameter): ...
        def matchAll(self) -> PySide2.Qt3DRender.Qt3DRender.QFilterKey: ...
        def parameters(self) -> PySide2.Qt3DRender.Qt3DRender.QParameter: ...
        def removeMatch(self, filterKey: PySide2.Qt3DRender.Qt3DRender.QFilterKey): ...
        def removeParameter(self, p: PySide2.Qt3DRender.Qt3DRender.QParameter): ...

    class QTexture1D(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTexture1DArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTexture2D(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTexture2DArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTexture2DMultisample(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTexture2DMultisampleArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTexture3D(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTextureBuffer(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTextureCubeMap(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTextureCubeMapArray(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTextureData(Shiboken.Object):

        def __init__(self): ...
        def comparisonFunction(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction: ...
        def comparisonMode(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode: ...
        def depth(self) -> int: ...
        def format(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat: ...
        def height(self) -> int: ...
        def isAutoMipMapGenerationEnabled(self) -> bool: ...
        def layers(self) -> int: ...
        def magnificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def maximumAnisotropy(self) -> float: ...
        def minificationFilter(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter: ...
        def setAutoMipMapGenerationEnabled(self, isAutoMipMapGenerationEnabled: bool): ...
        def setComparisonFunction(self, comparisonFunction: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonFunction): ...
        def setComparisonMode(self, comparisonMode: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.ComparisonMode): ...
        def setDepth(self, depth: int): ...
        def setFormat(self, arg__1: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.TextureFormat): ...
        def setHeight(self, height: int): ...
        def setLayers(self, layers: int): ...
        def setMagnificationFilter(self, filter: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setMaximumAnisotropy(self, maximumAnisotropy: float): ...
        def setMinificationFilter(self, filter: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Filter): ...
        def setTarget(self, target: PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target): ...
        def setWidth(self, width: int): ...
        def setWrapModeX(self, wrapModeX: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setWrapModeY(self, wrapModeY: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setWrapModeZ(self, wrapModeZ: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QAbstractTexture.Target: ...
        def width(self) -> int: ...
        def wrapModeX(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def wrapModeY(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def wrapModeZ(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...

    class QTextureGenerator: ...

    class QTextureImage(PySide2.Qt3DRender.Qt3DRender.QAbstractTextureImage):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def isMirrored(self) -> bool: ...
        def setMirrored(self, mirrored: bool): ...
        def setSource(self, source: PySide2.QtCore.QUrl): ...
        def setStatus(self, status: PySide2.Qt3DRender.Qt3DRender.QTextureImage.Status): ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureImage.Status: ...

    class QTextureImageData(Shiboken.Object):

        def __init__(self): ...
        def cleanup(self): ...
        def data(self, layer: int = ..., face: int = ..., mipmapLevel: int = ...) -> PySide2.QtCore.QByteArray: ...
        def depth(self) -> int: ...
        def faces(self) -> int: ...
        def format(self) -> PySide2.QtGui.QOpenGLTexture.TextureFormat: ...
        def height(self) -> int: ...
        def isCompressed(self) -> bool: ...
        def layers(self) -> int: ...
        def mipLevels(self) -> int: ...
        def pixelFormat(self) -> PySide2.QtGui.QOpenGLTexture.PixelFormat: ...
        def pixelType(self) -> PySide2.QtGui.QOpenGLTexture.PixelType: ...
        def setData(self, data: PySide2.QtCore.QByteArray, blockSize: int, isCompressed: bool = ...): ...
        def setDepth(self, depth: int): ...
        def setFaces(self, faces: int): ...
        def setFormat(self, format: PySide2.QtGui.QOpenGLTexture.TextureFormat): ...
        def setHeight(self, height: int): ...
        def setImage(self, arg__1: PySide2.QtGui.QImage): ...
        def setLayers(self, layers: int): ...
        def setMipLevels(self, mipLevels: int): ...
        def setPixelFormat(self, pixelFormat: PySide2.QtGui.QOpenGLTexture.PixelFormat): ...
        def setPixelType(self, pixelType: PySide2.QtGui.QOpenGLTexture.PixelType): ...
        def setTarget(self, target: PySide2.QtGui.QOpenGLTexture.Target): ...
        def setWidth(self, width: int): ...
        def target(self) -> PySide2.QtGui.QOpenGLTexture.Target: ...
        def width(self) -> int: ...

    class QTextureImageDataGenerator: ...

    class QTextureLoader(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def isMirrored(self) -> bool: ...
        def setMirrored(self, mirrored: bool): ...
        def setSource(self, source: PySide2.QtCore.QUrl): ...
        def source(self) -> PySide2.QtCore.QUrl: ...

    class QTextureRectangle(PySide2.Qt3DRender.Qt3DRender.QAbstractTexture):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QTextureWrapMode(PySide2.QtCore.QObject):

        @typing.overload
        def __init__(self, wrapMode: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode = ..., parent: PySide2.QtCore.QObject = ...): ...
        @typing.overload
        def __init__(self, x: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode, y: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode, z: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode, parent: PySide2.QtCore.QObject = ...): ...
        def setX(self, x: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setY(self, y: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def setZ(self, z: PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode): ...
        def x(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def y(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...
        def z(self) -> PySide2.Qt3DRender.Qt3DRender.QTextureWrapMode.WrapMode: ...

    class QViewport(PySide2.Qt3DRender.Qt3DRender.QFrameGraphNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def gamma(self) -> float: ...
        def normalizedRect(self) -> PySide2.QtCore.QRectF: ...
        def setGamma(self, gamma: float): ...
        def setNormalizedRect(self, normalizedRect: PySide2.QtCore.QRectF): ...

# eof
