# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.Qt3DAnimation, except for defaults which are replaced by "...".
"""

# Module PySide2.Qt3DAnimation
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.Qt3DAnimation


class Qt3DAnimation(Shiboken.Object):


    class QAbstractAnimation(PySide2.QtCore.QObject):

        def animationName(self) -> str: ...
        def animationType(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation.AnimationType: ...
        def duration(self) -> float: ...
        def position(self) -> float: ...
        def setAnimationName(self, name: str): ...
        def setDuration(self, duration: float): ...
        def setPosition(self, position: float): ...

    class QAbstractAnimationClip(PySide2.Qt3DCore.Qt3DCore.QNode):

        def duration(self) -> float: ...

    class QAbstractClipAnimator(PySide2.Qt3DCore.Qt3DCore.QComponent):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def isRunning(self) -> bool: ...
        def loopCount(self) -> int: ...
        def normalizedTime(self) -> float: ...
        def setLoopCount(self, loops: int): ...
        def setNormalizedTime(self, timeFraction: float): ...
        def setRunning(self, running: bool): ...
        def start(self): ...
        def stop(self): ...

    class QAbstractClipBlendNode(PySide2.Qt3DCore.Qt3DCore.QNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...

    class QAdditiveClipBlend(PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def additiveClip(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def additiveFactor(self) -> float: ...
        def baseClip(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def setAdditiveClip(self, additiveClip: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode): ...
        def setAdditiveFactor(self, additiveFactor: float): ...
        def setBaseClip(self, baseClip: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode): ...

    class QAnimationAspect(PySide2.Qt3DCore.Qt3DCore.QAbstractAspect):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...

    class QAnimationController(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def activeAnimationGroup(self) -> int: ...
        def addAnimationGroup(self, animationGroups: PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationGroup): ...
        def animationGroupList(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationGroup: ...
        def entity(self) -> PySide2.Qt3DCore.Qt3DCore.QEntity: ...
        def getAnimationIndex(self, name: str) -> int: ...
        def getGroup(self, index: int) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationGroup: ...
        def position(self) -> float: ...
        def positionOffset(self) -> float: ...
        def positionScale(self) -> float: ...
        def recursive(self) -> bool: ...
        def removeAnimationGroup(self, animationGroups: PySide2.Qt3DAnimation.Qt3DAnimation.QAnimationGroup): ...
        def setActiveAnimationGroup(self, index: int): ...
        def setAnimationGroups(self, animationGroups: list): ...
        def setEntity(self, entity: PySide2.Qt3DCore.Qt3DCore.QEntity): ...
        def setPosition(self, position: float): ...
        def setPositionOffset(self, offset: float): ...
        def setPositionScale(self, scale: float): ...
        def setRecursive(self, recursive: bool): ...

    class QAnimationGroup(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def addAnimation(self, animation: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation): ...
        def animationList(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation: ...
        def duration(self) -> float: ...
        def name(self) -> str: ...
        def position(self) -> float: ...
        def removeAnimation(self, animation: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation): ...
        def setAnimations(self, animations: list): ...
        def setName(self, name: str): ...
        def setPosition(self, position: float): ...

    class QBlendedClipAnimator(PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipAnimator):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def blendTree(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def setBlendTree(self, blendTree: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode): ...

    class QClipAnimator(PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipAnimator):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def clip(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimationClip: ...
        def setClip(self, clip: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimationClip): ...

    class QKeyframeAnimation(PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def addKeyframe(self, keyframe: PySide2.Qt3DCore.Qt3DCore.QTransform): ...
        def easing(self) -> PySide2.QtCore.QEasingCurve: ...
        def endMode(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
        def framePositions(self) -> float: ...
        def keyframeList(self) -> PySide2.Qt3DCore.Qt3DCore.QTransform: ...
        def removeKeyframe(self, keyframe: PySide2.Qt3DCore.Qt3DCore.QTransform): ...
        def setEasing(self, easing: PySide2.QtCore.QEasingCurve): ...
        def setEndMode(self, mode: PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode): ...
        def setFramePositions(self, positions: list): ...
        def setKeyframes(self, keyframes: list): ...
        def setStartMode(self, mode: PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode): ...
        def setTarget(self, target: PySide2.Qt3DCore.Qt3DCore.QTransform): ...
        def setTargetName(self, name: str): ...
        def startMode(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QKeyframeAnimation.RepeatMode: ...
        def target(self) -> PySide2.Qt3DCore.Qt3DCore.QTransform: ...
        def targetName(self) -> str: ...

    class QLerpClipBlend(PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode):

        def __init__(self, parent: PySide2.Qt3DCore.Qt3DCore.QNode = ...): ...
        def blendFactor(self) -> float: ...
        def endClip(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...
        def setBlendFactor(self, blendFactor: float): ...
        def setEndClip(self, endClip: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode): ...
        def setStartClip(self, startClip: PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode): ...
        def startClip(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractClipBlendNode: ...

    class QMorphTarget(PySide2.QtCore.QObject):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def addAttribute(self, attribute: PySide2.Qt3DRender.Qt3DRender.QAttribute): ...
        def attributeList(self) -> PySide2.Qt3DRender.Qt3DRender.QAttribute: ...
        def attributeNames(self) -> typing.List[str]: ...
        @staticmethod
        def fromGeometry(geometry: PySide2.Qt3DRender.Qt3DRender.QGeometry, attributes: typing.List[str]) -> PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget: ...
        def removeAttribute(self, attribute: PySide2.Qt3DRender.Qt3DRender.QAttribute): ...
        def setAttributes(self, attributes: list): ...

    class QMorphingAnimation(PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def addMorphTarget(self, target: PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget): ...
        def easing(self) -> PySide2.QtCore.QEasingCurve: ...
        def getWeights(self, positionIndex: int) -> float: ...
        def interpolator(self) -> float: ...
        def method(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.Method: ...
        def morphTargetList(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget: ...
        def removeMorphTarget(self, target: PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget): ...
        def setEasing(self, easing: PySide2.QtCore.QEasingCurve): ...
        def setMethod(self, method: PySide2.Qt3DAnimation.Qt3DAnimation.QMorphingAnimation.Method): ...
        def setMorphTargets(self, targets: list): ...
        def setTarget(self, target: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer): ...
        def setTargetName(self, name: str): ...
        def setTargetPositions(self, targetPositions: list): ...
        def setWeights(self, positionIndex: int, weights: list): ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer: ...
        def targetName(self) -> str: ...
        def targetPositions(self) -> float: ...

    class QVertexBlendAnimation(PySide2.Qt3DAnimation.Qt3DAnimation.QAbstractAnimation):

        def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
        def addMorphTarget(self, target: PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget): ...
        def interpolator(self) -> float: ...
        def morphTargetList(self) -> PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget: ...
        def removeMorphTarget(self, target: PySide2.Qt3DAnimation.Qt3DAnimation.QMorphTarget): ...
        def setMorphTargets(self, targets: list): ...
        def setTarget(self, target: PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer): ...
        def setTargetName(self, name: str): ...
        def setTargetPositions(self, targetPositions: list): ...
        def target(self) -> PySide2.Qt3DRender.Qt3DRender.QGeometryRenderer: ...
        def targetName(self) -> str: ...
        def targetPositions(self) -> float: ...

# eof
