# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtHelp, except for defaults which are replaced by "...".
"""

# Module PySide2.QtHelp
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.QtHelp


class QHelpContentItem(Shiboken.Object):

    def __copy__(self): ...
    def child(self, row: int) -> PySide2.QtHelp.QHelpContentItem: ...
    def childCount(self) -> int: ...
    def childPosition(self, child: PySide2.QtHelp.QHelpContentItem) -> int: ...
    def parent(self) -> PySide2.QtHelp.QHelpContentItem: ...
    def row(self) -> int: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QHelpContentModel(PySide2.QtCore.QAbstractItemModel):

    def columnCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...
    def contentItemAt(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtHelp.QHelpContentItem: ...
    def createContents(self, customFilterName: str): ...
    def data(self, index: PySide2.QtCore.QModelIndex, role: int) -> typing.Any: ...
    def index(self, row: int, column: int, parent: PySide2.QtCore.QModelIndex = ...) -> PySide2.QtCore.QModelIndex: ...
    def isCreatingContents(self) -> bool: ...
    @typing.overload
    def parent(self) -> PySide2.QtCore.QObject: ...
    @typing.overload
    def parent(self, index: PySide2.QtCore.QModelIndex) -> PySide2.QtCore.QModelIndex: ...
    def rowCount(self, parent: PySide2.QtCore.QModelIndex = ...) -> int: ...


class QHelpContentWidget(PySide2.QtWidgets.QTreeView):

    def indexOf(self, link: PySide2.QtCore.QUrl) -> PySide2.QtCore.QModelIndex: ...


class QHelpEngine(PySide2.QtHelp.QHelpEngineCore):

    def __init__(self, collectionFile: str, parent: PySide2.QtCore.QObject = ...): ...
    def contentModel(self) -> PySide2.QtHelp.QHelpContentModel: ...
    def contentWidget(self) -> PySide2.QtHelp.QHelpContentWidget: ...
    def indexModel(self) -> PySide2.QtHelp.QHelpIndexModel: ...
    def indexWidget(self) -> PySide2.QtHelp.QHelpIndexWidget: ...
    def searchEngine(self) -> PySide2.QtHelp.QHelpSearchEngine: ...


class QHelpEngineCore(PySide2.QtCore.QObject):

    def __init__(self, collectionFile: str, parent: PySide2.QtCore.QObject = ...): ...
    def addCustomFilter(self, filterName: str, attributes: typing.List[str]) -> bool: ...
    def autoSaveFilter(self) -> bool: ...
    def collectionFile(self) -> str: ...
    def copyCollectionFile(self, fileName: str) -> bool: ...
    def currentFilter(self) -> str: ...
    def customFilters(self) -> typing.List[str]: ...
    def customValue(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def documentationFileName(self, namespaceName: str) -> str: ...
    def error(self) -> str: ...
    def fileData(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QByteArray: ...
    def files(self, namespaceName: str, filterAttributes: typing.List[str], extensionFilter: str = ...) -> PySide2.QtCore.QUrl: ...
    def filterAttributeSets(self, namespaceName: str) -> typing.List[str]: ...
    @typing.overload
    def filterAttributes(self) -> typing.List[str]: ...
    @typing.overload
    def filterAttributes(self, filterName: str) -> typing.List[str]: ...
    def findFile(self, url: PySide2.QtCore.QUrl) -> PySide2.QtCore.QUrl: ...
    def linksForIdentifier(self, id: str) -> dict: ...
    def linksForKeyword(self, keyword: str) -> dict: ...
    @staticmethod
    def metaData(documentationFileName: str, name: str) -> typing.Any: ...
    @staticmethod
    def namespaceName(documentationFileName: str) -> str: ...
    def registerDocumentation(self, documentationFileName: str) -> bool: ...
    def registeredDocumentations(self) -> typing.List[str]: ...
    def removeCustomFilter(self, filterName: str) -> bool: ...
    def removeCustomValue(self, key: str) -> bool: ...
    def setAutoSaveFilter(self, save: bool): ...
    def setCollectionFile(self, fileName: str): ...
    def setCurrentFilter(self, filterName: str): ...
    def setCustomValue(self, key: str, value: typing.Any) -> bool: ...
    def setupData(self) -> bool: ...
    def unregisterDocumentation(self, namespaceName: str) -> bool: ...


class QHelpIndexModel(PySide2.QtCore.QStringListModel):

    @typing.overload
    def createIndex(self, customFilterName: str): ...
    @typing.overload
    def createIndex(self, row: int, column: int, id: int = ...) -> PySide2.QtCore.QModelIndex: ...
    def filter(self, filter: str, wildcard: str = ...) -> PySide2.QtCore.QModelIndex: ...
    def isCreatingIndex(self) -> bool: ...
    def linksForKeyword(self, keyword: str) -> dict: ...


class QHelpIndexWidget(PySide2.QtWidgets.QListView):

    def activateCurrentItem(self): ...
    def filterIndices(self, filter: str, wildcard: str = ...): ...


class QHelpSearchEngine(PySide2.QtCore.QObject):

    def __init__(self, helpEngine: PySide2.QtHelp.QHelpEngineCore, parent: PySide2.QtCore.QObject = ...): ...
    def cancelIndexing(self): ...
    def cancelSearching(self): ...
    def hitCount(self) -> int: ...
    def hits(self, start: int, end: int) -> typing.Tuple[typing.Any, typing.Any]: ...
    def hitsCount(self) -> int: ...
    def query(self) -> PySide2.QtHelp.QHelpSearchQuery: ...
    def queryWidget(self) -> PySide2.QtHelp.QHelpSearchQueryWidget: ...
    def reindexDocumentation(self): ...
    def resultWidget(self) -> PySide2.QtHelp.QHelpSearchResultWidget: ...
    def scheduleIndexDocumentation(self): ...
    @typing.overload
    def search(self, queryList: list): ...
    @typing.overload
    def search(self, searchInput: str): ...
    def searchInput(self) -> str: ...
    def searchResultCount(self) -> int: ...
    def searchResults(self, start: int, end: int) -> PySide2.QtHelp.QHelpSearchResult: ...


class QHelpSearchQuery(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, QHelpSearchQuery: PySide2.QtHelp.QHelpSearchQuery): ...
    @typing.overload
    def __init__(self, field: PySide2.QtHelp.QHelpSearchQuery.FieldName, wordList_: typing.List[str]): ...
    def __copy__(self): ...


class QHelpSearchQueryWidget(PySide2.QtWidgets.QWidget):

    def __init__(self, parent: PySide2.QtWidgets.QWidget = ...): ...
    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def collapseExtendedSearch(self): ...
    def expandExtendedSearch(self): ...
    def focusInEvent(self, focusEvent: PySide2.QtGui.QFocusEvent): ...
    def isCompactMode(self) -> bool: ...
    def query(self) -> PySide2.QtHelp.QHelpSearchQuery: ...
    def searchInput(self) -> str: ...
    def setCompactMode(self, on: bool): ...
    def setQuery(self, queryList: list): ...
    def setSearchInput(self, searchInput: str): ...


class QHelpSearchResult(Shiboken.Object):

    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, other: PySide2.QtHelp.QHelpSearchResult): ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl, title: str, snippet: str): ...
    def snippet(self) -> str: ...
    def title(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QHelpSearchResultWidget(PySide2.QtWidgets.QWidget):

    def changeEvent(self, event: PySide2.QtCore.QEvent): ...
    def linkAt(self, point: PySide2.QtCore.QPoint) -> PySide2.QtCore.QUrl: ...

# eof
