# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2018 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.QtWebEngineCore, except for defaults which are replaced by "...".
"""

# Module PySide2.QtWebEngineCore
import shiboken2 as Shiboken
from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

Shiboken.Object = Object

import PySide2.QtWebEngineCore


class QWebEngineCookieStore(PySide2.QtCore.QObject):

    def deleteAllCookies(self): ...
    def deleteSessionCookies(self): ...
    def loadAllCookies(self): ...


class QWebEngineHttpRequest(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide2.QtWebEngineCore.QWebEngineHttpRequest): ...
    @typing.overload
    def __init__(self, url: PySide2.QtCore.QUrl = ..., method: PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method = ...): ...
    def hasHeader(self, headerName: PySide2.QtCore.QByteArray) -> bool: ...
    def header(self, headerName: PySide2.QtCore.QByteArray) -> PySide2.QtCore.QByteArray: ...
    def headers(self) -> PySide2.QtCore.QByteArray: ...
    def method(self) -> PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method: ...
    def postData(self) -> PySide2.QtCore.QByteArray: ...
    @staticmethod
    def postRequest(url: PySide2.QtCore.QUrl, postData: dict) -> PySide2.QtWebEngineCore.QWebEngineHttpRequest: ...
    def setHeader(self, headerName: PySide2.QtCore.QByteArray, value: PySide2.QtCore.QByteArray): ...
    def setMethod(self, method: PySide2.QtWebEngineCore.QWebEngineHttpRequest.Method): ...
    def setPostData(self, postData: PySide2.QtCore.QByteArray): ...
    def setUrl(self, url: PySide2.QtCore.QUrl): ...
    def swap(self, other: PySide2.QtWebEngineCore.QWebEngineHttpRequest): ...
    def unsetHeader(self, headerName: PySide2.QtCore.QByteArray): ...
    def url(self) -> PySide2.QtCore.QUrl: ...


class QWebEngineUrlRequestInfo(Shiboken.Object):

    def block(self, shouldBlock: bool): ...
    def changed(self) -> bool: ...
    def firstPartyUrl(self) -> PySide2.QtCore.QUrl: ...
    def navigationType(self) -> PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.NavigationType: ...
    def redirect(self, url: PySide2.QtCore.QUrl): ...
    def requestMethod(self) -> PySide2.QtCore.QByteArray: ...
    def requestUrl(self) -> PySide2.QtCore.QUrl: ...
    def resourceType(self) -> PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo.ResourceType: ...
    def setHttpHeader(self, name: PySide2.QtCore.QByteArray, value: PySide2.QtCore.QByteArray): ...


class QWebEngineUrlRequestInterceptor(PySide2.QtCore.QObject):

    def __init__(self, p: PySide2.QtCore.QObject = ...): ...
    def interceptRequest(self, info: PySide2.QtWebEngineCore.QWebEngineUrlRequestInfo): ...


class QWebEngineUrlRequestJob(PySide2.QtCore.QObject):

    def fail(self, error: PySide2.QtWebEngineCore.QWebEngineUrlRequestJob.Error): ...
    def initiator(self) -> PySide2.QtCore.QUrl: ...
    def redirect(self, url: PySide2.QtCore.QUrl): ...
    def reply(self, contentType: PySide2.QtCore.QByteArray, device: PySide2.QtCore.QIODevice): ...
    def requestMethod(self) -> PySide2.QtCore.QByteArray: ...
    def requestUrl(self) -> PySide2.QtCore.QUrl: ...


class QWebEngineUrlSchemeHandler(PySide2.QtCore.QObject):

    def __init__(self, parent: PySide2.QtCore.QObject = ...): ...
    def requestStarted(self, arg__1: PySide2.QtWebEngineCore.QWebEngineUrlRequestJob): ...

# eof
