/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.instrumentation.Instrumentor;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.EventBufferProcessor;
import org.netbeans.lib.profiler.results.EventBufferResultsProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.HeapHistogram;
import org.netbeans.lib.profiler.results.memory.HeapHistogramManager;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryCallGraphBuilder;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.threads.ThreadDump;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.wireprotocol.CalibrationDataResponse;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.DefiningLoaderResponse;
import org.netbeans.lib.profiler.wireprotocol.DumpResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassFileBytesCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassFileBytesResponse;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdResponse;
import org.netbeans.lib.profiler.wireprotocol.GetDefiningClassLoaderCommand;
import org.netbeans.lib.profiler.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.netbeans.lib.profiler.wireprotocol.HeapHistogramResponse;
import org.netbeans.lib.profiler.wireprotocol.InitiateProfilingCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.SetChangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.TakeHeapDumpCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadDumpResponse;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;
import org.netbeans.lib.profiler.wireprotocol.VMPropertiesResponse;
import org.netbeans.lib.profiler.wireprotocol.WireIO;

public class ProfilerClient
implements CommonConstants {
    private static final String CANNOT_OPEN_SERVER_TEMPFILE_MSG;
    private static final String PERFORMING_INSTRUMENTATION_STRING;
    private static final String INVALID_CODE_REGION_MSG;
    private static final String CLASS_NOT_FOUND_MSG;
    private static final String OUT_OF_MEMORY_MSG;
    private static final String INCORRECT_AGENT_VERSION_MSG;
    private static final String ERROR_GETTING_CALIBRATION_DATA_MSG;
    private static final String MUST_CALIBRATE_FIRST_MSG;
    private static final String MUST_CALIBRATE_FIRST_SHORT_MSG;
    private static final String INSTRUMENTATION_LIMIT_REACHED_MSG;
    private static final String CORRUPTED_TARGET_CALIBRATION_DATA_MSG;
    private static final String CONNECT_VM_MSG;
    private static final String TARGET_JVM_ERROR_MSG;
    private static final String UNSUPPORTED_JVM_MSG;
    private AppStatusHandler.ServerCommandHandler serverCommandHandler;
    private AppStatusHandler appStatusHandler;
    private CPUCCTProvider cpuCctProvider;
    private Command execInSeparateThreadCmd;
    private FlatProfileProvider flatProvider;
    private InitiateProfilingCommand commandOnStartup = null;
    private Instrumentor instrumentor;
    private MemoryCCTProvider memCctProvider;
    private JdbcCCTProvider jdbcCctProvider;
    private final Object execInSeparateThreadLock = new Object();
    private final Object forceObtainedResultsDumpLock = new Object();
    private final Object instrumentationLock = new Object();
    private final Object responseLock = new Object();
    private ObjectInputStream socketIn;
    private ObjectOutputStream socketOut;
    private ProfilerEngineSettings settings;
    private ProfilingSessionStatus status;
    private volatile Response lastResponse;
    private SeparateCmdExecutionThread separateCmdExecThread;
    private ServerListener serverListener;
    private HeapHistogramManager histogramManager;
    private Socket clientSocket;
    private WireIO wireIO;
    private int[] savedAllocatedObjectsCountResults;
    private volatile boolean forceObtainedResultsDumpCalled;
    private volatile boolean handlingEventBufferDump;
    private volatile boolean instrMethodsLimitReported;
    private boolean serverClassesInitialized;
    private volatile boolean targetVMAlive;
    private volatile boolean terminateOrDetachCommandIssued;
    private int currentAgentId = -1;
    private long instrProcessingTime;
    private long resultsStart;

    public ProfilerClient(ProfilerEngineSettings profilerEngineSettings, ProfilingSessionStatus profilingSessionStatus, AppStatusHandler appStatusHandler, AppStatusHandler.ServerCommandHandler serverCommandHandler) {
        this.settings = profilerEngineSettings;
        this.status = profilingSessionStatus;
        this.appStatusHandler = appStatusHandler;
        this.serverCommandHandler = serverCommandHandler;
        this.instrumentor = new Instrumentor(profilingSessionStatus, profilerEngineSettings);
        this.histogramManager = new HeapHistogramManager(profilerEngineSettings);
        EventBufferProcessor.initialize(this);
        EventBufferResultsProvider.getDefault().addDispatcher(ProfilingResultsDispatcher.getDefault());
    }

    public synchronized int[] getAllocatedObjectsCountResults() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetVMAlive) {
            if (this.savedAllocatedObjectsCountResults != null) {
                return this.savedAllocatedObjectsCountResults;
            }
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        this.savedAllocatedObjectsCountResults = null;
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(30);
        ObjectAllocationResultsResponse objectAllocationResultsResponse = (ObjectAllocationResultsResponse)this.getAndCheckLastResponse("Unknown problem when trying to get allocated object count results.");
        return objectAllocationResultsResponse.getResults();
    }

    public synchronized CPUResultsSnapshot getCPUProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        return this.getCPUProfilingResultsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPUResultsSnapshot getCPUProfilingResultsSnapshot(boolean bl) throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        this.checkForTargetVMAlive();
        if (bl && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            CPUResultsSnapshot cPUResultsSnapshot;
            try {
                this.status.beginTrans(false);
                boolean bl2 = this.status.collectingTwoTimeStamps();
                int n = this.status.getNInstrMethods();
                String[] stringArray = new String[n];
                System.arraycopy(this.status.getInstrMethodClasses(), 0, stringArray, 0, n);
                String[] stringArray2 = new String[n];
                System.arraycopy(this.status.getInstrMethodNames(), 0, stringArray2, 0, n);
                String[] stringArray3 = new String[n];
                System.arraycopy(this.status.getInstrMethodSignatures(), 0, stringArray3, 0, n);
                cPUResultsSnapshot = new CPUResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.cpuCctProvider, bl2, stringArray, stringArray2, stringArray3, n);
                this.status.endTrans();
            }
            catch (Throwable throwable) {
                this.status.endTrans();
                throw throwable;
            }
            return cPUResultsSnapshot;
        }
    }

    public synchronized CodeRegionResultsSnapshot getCodeRegionProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(8);
        CodeRegionCPUResultsResponse codeRegionCPUResultsResponse = (CodeRegionCPUResultsResponse)this.getAndCheckLastResponse("Unknown problem when trying to get code region CPU results.");
        return new CodeRegionResultsSnapshot(this.resultsStart, System.currentTimeMillis(), codeRegionCPUResultsResponse.getResults(), this.status.timerCountsInSecond[0]);
    }

    public int getCurrentAgentId() {
        return this.currentAgentId;
    }

    public void setCurrentInstrType(int n) {
        this.status.currentInstrType = n;
    }

    public int getCurrentInstrType() {
        return this.status.currentInstrType;
    }

    public synchronized byte[] getCurrentThreadsLivenessStatus() {
        try {
            this.checkForTargetVMAlive();
            this.sendSimpleCmdToServer(16);
            ThreadLivenessStatusResponse threadLivenessStatusResponse = (ThreadLivenessStatusResponse)this.getAndCheckLastResponse("Unknown problem when trying to get thread liveness information.");
            return threadLivenessStatusResponse.getStatus();
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            if (this.serverListener.isRunning()) {
                ProfilerLogger.log("in getCurrentThreadLivenessStatus(), caught exception: " + targetAppOrVMTerminated);
            }
            return null;
        }
    }

    public synchronized int getDefiningClassLoaderId(String string, int n) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        GetDefiningClassLoaderCommand getDefiningClassLoaderCommand = new GetDefiningClassLoaderCommand(string, n);
        this.sendComplexCmdToServer(getDefiningClassLoaderCommand);
        DefiningLoaderResponse definingLoaderResponse = (DefiningLoaderResponse)this.getAndCheckLastResponse("Unknown problem when trying to get a defining loader for class");
        return definingLoaderResponse.getLoaderId();
    }

    public FlatProfileProvider getFlatProfileProvider() {
        return this.flatProvider;
    }

    public long getInstrProcessingTime() {
        return this.instrProcessingTime;
    }

    public synchronized InternalStatsResponse getInternalStats() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(24);
        InternalStatsResponse internalStatsResponse = (InternalStatsResponse)this.getLastResponse();
        return internalStatsResponse;
    }

    public MemoryCCTProvider getMemoryCCTProvider() {
        return this.memCctProvider;
    }

    public MemoryResultsSnapshot getMemoryProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        return this.getMemoryProfilingResultsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MemoryResultsSnapshot getMemoryProfilingResultsSnapshot(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        int n = this.getCurrentInstrType();
        if (n == 7) {
            if (this.settings.getRunGCOnGetResultsInMemoryProfiling()) {
                this.runGC();
            }
            return new SampledMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this);
        }
        if (bl && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            this.memCctProvider.beginTrans(false);
            try {
                this.memCctProvider.updateInternals();
                if (n == 5) {
                    AllocMemoryResultsSnapshot allocMemoryResultsSnapshot = new AllocMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.memCctProvider, this);
                    return allocMemoryResultsSnapshot;
                }
                LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot = new LivenessMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.memCctProvider, this);
                return livenessMemoryResultsSnapshot;
            }
            finally {
                this.memCctProvider.endTrans();
            }
        }
    }

    public JdbcResultsSnapshot getJdbcProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        return this.getJdbcProfilingResultsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcResultsSnapshot getJdbcProfilingResultsSnapshot(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        if (bl && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            return new JdbcResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.jdbcCctProvider, this);
        }
    }

    public Marker getMethodMarker() {
        return this.settings.getMethodMarker();
    }

    public synchronized String[][] getMethodNamesForJMethodIds(int[] nArray) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        GetMethodNamesForJMethodIdsCommand getMethodNamesForJMethodIdsCommand = new GetMethodNamesForJMethodIdsCommand(nArray);
        this.sendComplexCmdToServer(getMethodNamesForJMethodIdsCommand);
        MethodNamesResponse methodNamesResponse = (MethodNamesResponse)this.getAndCheckLastResponse("Unknown problem when trying to get method names for jmethodIds");
        return StringUtils.convertPackedStringsIntoStringArrays(methodNamesResponse.getPackedData(), methodNamesResponse.getPackedArrayOffsets(), 4);
    }

    public synchronized HeapHistogram getHeapHistogram() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(45);
        HeapHistogramResponse heapHistogramResponse = (HeapHistogramResponse)this.getAndCheckLastResponse("Unknown problem when trying to get heap histogram");
        return this.histogramManager.getHistogram(heapHistogramResponse);
    }

    public synchronized ThreadDump takeThreadDump() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(46);
        ThreadDumpResponse threadDumpResponse = (ThreadDumpResponse)this.getAndCheckLastResponse("Unknown problem when trying to take thread dump");
        return new ThreadDump(threadDumpResponse.isJDK15(), threadDumpResponse.getTime(), threadDumpResponse.getThreads());
    }

    public synchronized byte[][] getCachedClassFileBytes(String[] stringArray, int[] nArray) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        GetClassFileBytesCommand getClassFileBytesCommand = new GetClassFileBytesCommand(stringArray, nArray);
        this.sendComplexCmdToServer(getClassFileBytesCommand);
        GetClassFileBytesResponse getClassFileBytesResponse = (GetClassFileBytesResponse)this.getAndCheckLastResponse("Unknown problem when trying to get cached class file bytes");
        return getClassFileBytesResponse.getClassBytes();
    }

    public synchronized MonitoredData getMonitoredData() {
        try {
            this.checkForTargetVMAlive();
            this.sendSimpleCmdToServer(32);
            Response response = this.getAndCheckLastResponse("Unknown problem when trying to get memory numbers.");
            try {
                MonitoredNumbersResponse monitoredNumbersResponse = (MonitoredNumbersResponse)response;
                return MonitoredData.getMonitoredData(monitoredNumbersResponse);
            }
            catch (ClassCastException classCastException) {
                MiscUtils.printErrorMessage("caught ClassCastException in getMonitoredNumbers. The real class of resp is " + response.getClass().getName() + ", resp = " + response);
                throw classCastException;
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            if (this.serverListener.isRunning()) {
                ProfilerLogger.log("in getMonitoredData(), caught exception: " + targetAppOrVMTerminated);
            }
            return null;
        }
    }

    public ProfilerEngineSettings getSettings() {
        return this.settings;
    }

    public ObjectInputStream getSocketInputStream() {
        return this.socketIn;
    }

    public ProfilingSessionStatus getStatus() {
        return this.status;
    }

    public synchronized boolean cpuResultsExist() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(6);
        Response response = this.getAndCheckLastResponse("Unknown problem when trying to check for CPU profiling results.");
        return response.yes();
    }

    public boolean currentInstrTypeIsMemoryProfiling() {
        return this.status.currentInstrType == 5 || this.status.currentInstrType == 6;
    }

    public boolean currentInstrTypeIsRecursiveCPUProfiling() {
        return this.status.currentInstrType == 3 || this.status.currentInstrType == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstrumentMemoryProfiledClasses(boolean[] blArray) throws InstrumentationException, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            if (this.getCurrentInstrType() == 0 || this.getCurrentInstrType() == 2) {
                return;
            }
            this.checkForTargetAppRunning();
            long l = System.currentTimeMillis();
            InstrumentMethodGroupCommand instrumentMethodGroupCommand = this.instrumentor.getCommandToUnprofileClasses(blArray);
            if (!instrumentMethodGroupCommand.isEmpty()) {
                Response response;
                ProfilerClient profilerClient = this;
                synchronized (profilerClient) {
                    this.sendComplexCmdToServer(instrumentMethodGroupCommand);
                    this.instrProcessingTime += System.currentTimeMillis() - l;
                    response = this.getLastResponse();
                }
                if (!response.isOK()) {
                    throw new InstrumentationException(response.getErrorMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareDetachFromTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        while (true) {
            ProfilerClient profilerClient = this;
            synchronized (profilerClient) {
                this.sendSimpleCmdToServer(44);
                Response response = this.getAndCheckLastResponse("prepareDetachFromTargetJVM");
                if (!response.isOK()) {
                    return;
                }
                if (response.yes()) {
                    break;
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                MiscUtils.printWarningMessage("Interrupted while waiting for prepare detach");
            }
        }
    }

    public synchronized void detachFromTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.terminateOrDetachCommandIssued = true;
        this.sendSimpleCmdToServer(25);
        try {
            this.getLastResponse();
        }
        finally {
            this.closeConnection();
            EventBufferProcessor.removeEventBufferFile();
        }
    }

    public boolean establishConnectionWithServer(int n, boolean bl, AtomicBoolean atomicBoolean) {
        this.status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        return this.connectToServer(n, bl, atomicBoolean);
    }

    public boolean forceObtainedResultsDump() throws ClientUtils.TargetAppOrVMTerminated {
        return this.forceObtainedResultsDump(false, 0);
    }

    public boolean forceObtainedResultsDump(boolean bl, int n) throws ClientUtils.TargetAppOrVMTerminated {
        boolean bl2 = false;
        int n2 = n;
        do {
            if (bl2 = this.forceObtainedResultsDump(bl)) continue;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        } while (!bl2 && --n2 > 0);
        if (bl2) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceObtainedResultsDump(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            Object object = this.forceObtainedResultsDumpLock;
            synchronized (object) {
                if (this.handlingEventBufferDump) {
                    return true;
                }
                this.checkForTargetVMAlive();
                this.forceObtainedResultsDumpCalled = true;
                this.sendSimpleCmdToServer(bl ? 40 : 27);
                DumpResultsResponse dumpResultsResponse = (DumpResultsResponse)this.getLastResponse();
                if (dumpResultsResponse.yes()) {
                    this.status.dumpAbsTimeStamp = dumpResultsResponse.getDumpAbsTimeStamp();
                } else if (ProfilerLogger.isDebug()) {
                    ProfilerLogger.debug("Force Obtained Results - Received Dump Error ");
                }
                this.forceObtainedResultsDumpCalled = false;
                return dumpResultsResponse.yes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateCodeRegionInstrumentation(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) throws ClassNotFoundException, BadLocationException, InstrumentationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand initiateProfilingCommand;
            this.removeAllInstrumentation();
            if (this.status.targetAppRunning && this.status.remoteProfiling && !this.getCalibrationData(true)) {
                return;
            }
            this.instrumentor.setStatusInfoFromSourceCodeSelection(sourceCodeSelectionArray);
            this.instrumentor.setSavedSourceCodeSelection(sourceCodeSelectionArray);
            String string = this.instrumentor.getRootClassNames()[0].replace('/', '.');
            this.commandOnStartup = initiateProfilingCommand = new InitiateProfilingCommand(1, string, false, this.status.startProfilingPointsActive);
            this.setCurrentInstrType(1);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String string2 = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (string2 != null) {
                    this.appStatusHandler.displayWarning(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateMonitoring() throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand initiateProfilingCommand;
            this.removeAllInstrumentation();
            this.commandOnStartup = initiateProfilingCommand = new InitiateProfilingCommand(0);
            this.setCurrentInstrType(0);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String string = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (string != null) {
                    this.appStatusHandler.displayWarning(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateMemoryProfInstrumentation(int n) throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            Object object2;
            this.removeAllInstrumentation();
            if (n == 7) {
                this.commandOnStartup = new InitiateProfilingCommand(7);
            } else {
                object2 = new String[]{this.settings.getMainClassName()};
                this.commandOnStartup = this.createInitiateInstrumnetation(n, (String[])object2, false, this.status.startProfilingPointsActive);
            }
            this.setCurrentInstrType(n);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                object2 = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (object2 != null) {
                    this.appStatusHandler.displayWarning((String)object2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateRecursiveCPUProfInstrumentation(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) throws ClassNotFoundException, BadLocationException, InstrumentationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand initiateProfilingCommand;
            this.removeAllInstrumentation();
            if (this.status.targetAppRunning && this.status.remoteProfiling && !this.getCalibrationData(true)) {
                return;
            }
            this.instrumentor.setStatusInfoFromSourceCodeSelection(sourceCodeSelectionArray);
            boolean bl = this.settings.getInstrumentSpawnedThreads();
            String[] stringArray = this.instrumentor.getRootClassNames();
            int n = this.settings.getCPUProfilingType() == 0 ? 3 : 4;
            this.commandOnStartup = initiateProfilingCommand = this.createInitiateInstrumnetation(n, stringArray, bl, this.status.startProfilingPointsActive);
            this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
            this.setCurrentInstrType(n);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String string = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (string != null) {
                    this.appStatusHandler.displayWarning(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateCPUSampling() throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateProfilingCommand initiateProfilingCommand;
            this.removeAllInstrumentation();
            this.commandOnStartup = initiateProfilingCommand = new InitiateProfilingCommand(2);
            this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
            this.setCurrentInstrType(2);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String string = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (string != null) {
                    this.appStatusHandler.displayWarning(string);
                }
            }
        }
    }

    public synchronized boolean memoryResultsExist() {
        return this.getMemoryCCTProvider() != null && this.getMemoryCCTProvider().getStacksForClasses() != null;
    }

    public void registerCPUCCTProvider(CPUCCTProvider cPUCCTProvider) {
        this.cpuCctProvider = cPUCCTProvider;
    }

    public void registerFlatProfileProvider(FlatProfileProvider flatProfileProvider) {
        this.flatProvider = flatProfileProvider;
    }

    public void registerMemoryCCTProvider(MemoryCCTProvider memoryCCTProvider) {
        this.memCctProvider = memoryCCTProvider;
    }

    public void registerJdbcCCTProvider(JdbcCCTProvider jdbcCCTProvider) {
        this.jdbcCctProvider = jdbcCCTProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllInstrumentation(boolean bl) throws InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            this.commandOnStartup = null;
            if (bl) {
                this.status.resetInstrClassAndMethodInfo();
            }
            try {
                this.clearPreviousInstrumentationInServer();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            this.setCurrentInstrType(0);
        }
    }

    public void removeAllInstrumentation() throws InstrumentationException {
        this.removeAllInstrumentation(true);
    }

    public void resetClientData() {
        if (this.targetJVMIsAlive()) {
            return;
        }
        this.status.resetInstrClassAndMethodInfo();
        this.instrumentor.resetPerVMInstanceData();
    }

    public synchronized void resetProfilerCollectors() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(29);
        this.getAndCheckLastResponse("Unknown problem when trying to reset profiler collectors.");
    }

    public synchronized void resumeTargetAppThreads() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetAppRunning();
        this.sendSimpleCmdToServer(11);
        this.getAndCheckLastResponse("Unknown problem when trying to resume app threads.");
    }

    public synchronized void runGC() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(33);
        this.getAndCheckLastResponse("Unknown problem when trying to run GC");
    }

    public void sendSetInstrumentationParamsCmd(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        SetUnchangeableInstrParamsCommand setUnchangeableInstrParamsCommand;
        SetChangeableInstrParamsCommand setChangeableInstrParamsCommand = new SetChangeableInstrParamsCommand(this.settings.isLockContentionMonitoringEnabled(), this.settings.getNProfiledThreadsLimit(), this.settings.getStackDepthLimit(), this.settings.getSamplingInterval(), this.settings.getAllocTrackEvery(), this.settings.getAllocStackTraceLimit(), this.settings.getRunGCOnGetResultsInMemoryProfiling(), this.settings.getExcludeWaitTime(), this.settings.getExcludeWaitTime(), this.settings.isThreadsSamplingEnabled(), this.settings.getSamplingFrequency());
        String string = this.sendCommandAndGetResponse(setChangeableInstrParamsCommand);
        if (string != null) {
            this.appStatusHandler.displayWarning(string);
        }
        if (!bl && (string = this.sendCommandAndGetResponse(setUnchangeableInstrParamsCommand = new SetUnchangeableInstrParamsCommand(this.status.remoteProfiling, this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn(), this.settings.getInstrScheme(), this.settings.getCodeRegionCPUResBufSize()))) != null) {
            this.appStatusHandler.displayWarning(string);
        }
    }

    public boolean startTargetApp(boolean bl) throws ClientUtils.TargetAppOrVMTerminated, ClientUtils.TargetAppFailedToStart {
        String string;
        this.status.resetInstrClassAndMethodInfo();
        this.instrumentor.resetPerVMInstanceData();
        this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
        this.serverCommandHandler.handleServerCommand(null);
        this.checkForTargetVMAlive();
        this.instrProcessingTime = 0L;
        this.instrMethodsLimitReported = false;
        if (this.currentInstrTypeIsRecursiveCPUProfiling()) {
            this.setCurrentInstrType(this.settings.getCPUProfilingType() == 0 ? 3 : 4);
            if (this.commandOnStartup != null) {
                this.commandOnStartup.setInstrType(this.getCurrentInstrType());
            }
        }
        if (this.commandOnStartup != null) {
            this.sendSetInstrumentationParamsCmd(false);
            switch (this.getCurrentInstrType()) {
                case 1: {
                    if (!this.status.remoteProfiling || this.getCalibrationData(true)) break;
                    try {
                        this.terminateTargetJVM();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                        // empty catch block
                    }
                    return false;
                }
                case 3: 
                case 4: {
                    if (this.status.remoteProfiling && !this.getCalibrationData(true)) {
                        try {
                            this.terminateTargetJVM();
                        }
                        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                            // empty catch block
                        }
                        return false;
                    }
                    if (!this.settings.getInstrumentMethodInvoke() || (string = this.sendSimpleCommandAndGetResponse(20)) == null) break;
                    throw new ClientUtils.TargetAppFailedToStart(string);
                }
            }
            string = this.sendCommandAndGetResponse(this.commandOnStartup);
            if (string != null) {
                this.appStatusHandler.displayWarning("Profiler Agent Error: " + string);
            }
            this.commandOnStartup = null;
        } else {
            this.setCurrentInstrType(0);
        }
        if (bl && (string = this.sendSimpleCommandAndGetResponse(2)) != null) {
            throw new ClientUtils.TargetAppFailedToStart(string);
        }
        this.status.targetAppRunning = true;
        this.checkForInstrMethodsLimitReached();
        EventBufferResultsProvider.getDefault().startup(this);
        return true;
    }

    public synchronized void suspendTargetAppThreads() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetAppRunning();
        this.sendSimpleCmdToServer(10);
        this.getAndCheckLastResponse("Unknown problem when trying to suspend app threads.");
    }

    public synchronized boolean takeHeapDump(String string) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendComplexCmdToServer(new TakeHeapDumpCommand(string));
        Response response = this.getAndCheckLastResponse("takeHeapDump.");
        return response.isOK();
    }

    public boolean targetAppIsRunning() {
        return this.status.targetAppRunning;
    }

    public boolean targetJVMIsAlive() {
        return this.targetVMAlive;
    }

    public synchronized void terminateTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.terminateOrDetachCommandIssued = true;
        this.sendSimpleCmdToServer(12);
        if (!this.getLastResponse().isOK()) {
            throw new ClientUtils.TargetAppOrVMTerminated(1, "Target JVM terminated or not responding");
        }
        this.closeConnection();
    }

    private synchronized Response getAndCheckLastResponse(String string) throws ClientUtils.TargetAppOrVMTerminated {
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            MiscUtils.printErrorMessage("error in getAndCheckLastResponse: for " + response + " got error message: " + response.getErrorMessage() + " and context message " + string);
        }
        return response;
    }

    private synchronized boolean getCalibrationData(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        int n = bl ? 37 : 34;
        this.sendSimpleCmdToServer(n);
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            String string = response.getErrorMessage();
            if (bl) {
                string = MessageFormat.format(CORRUPTED_TARGET_CALIBRATION_DATA_MSG, string);
            }
            this.appStatusHandler.displayError(string);
            return false;
        }
        CalibrationDataResponse calibrationDataResponse = (CalibrationDataResponse)response;
        this.status.methodEntryExitCallTime = calibrationDataResponse.getMethodEntryExitCallTime();
        this.status.methodEntryExitInnerTime = calibrationDataResponse.getMethodEntryExitInnerTime();
        this.status.methodEntryExitOuterTime = calibrationDataResponse.getMethodEntryExitOuterTime();
        this.status.timerCountsInSecond = calibrationDataResponse.getTimerCountsInSecond();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastResponse(Response response) {
        Object object = this.responseLock;
        synchronized (object) {
            this.lastResponse = response;
            try {
                this.responseLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                MiscUtils.internalError("ProfilerClient.setLastResponse()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Response getLastResponse() throws ClientUtils.TargetAppOrVMTerminated {
        Response response;
        this.checkForTargetVMAlive();
        Object object = this.responseLock;
        synchronized (object) {
            while (this.lastResponse == null) {
                long l = System.currentTimeMillis();
                try {
                    this.responseLock.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    MiscUtils.internalError("InterruptedException in ProfilerClient.getLastResponse()");
                }
                if (!this.targetVMAlive) {
                    this.status.targetAppRunning = false;
                    throw new ClientUtils.TargetAppOrVMTerminated(1);
                }
                if (this.lastResponse != null || this.wireIO.wasAlive() >= l || this.appStatusHandler.confirmWaitForConnectionReply()) continue;
                this.status.targetAppRunning = false;
                this.targetVMAlive = false;
                throw new ClientUtils.TargetAppOrVMTerminated(1);
            }
            response = this.lastResponse;
            this.lastResponse = null;
        }
        return response;
    }

    private boolean setVMProperties(VMPropertiesResponse vMPropertiesResponse, boolean bl) {
        String string;
        if (vMPropertiesResponse.getAgentVersion() != 18) {
            this.appStatusHandler.displayWarning(INCORRECT_AGENT_VERSION_MSG);
        }
        if (!MiscUtils.isSupportedRunningJVMVersion(string = vMPropertiesResponse.getJDKVersionString())) {
            String string2 = MessageFormat.format(UNSUPPORTED_JVM_MSG, string);
            this.appStatusHandler.displayErrorAndWaitForConfirm(string2);
            try {
                if (bl) {
                    this.terminateTargetJVM();
                } else {
                    this.detachFromTargetJVM();
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            return false;
        }
        String string3 = Platform.getJDKVersionString(string);
        this.settings.setTargetJDKVersionString(string3);
        this.status.targetJDKVersionString = string3;
        this.status.fullTargetJDKVersionString = string;
        this.currentAgentId = vMPropertiesResponse.getAgentId();
        if (!this.status.remoteProfiling) {
            int n = CalibrationDataFileIO.readSavedCalibrationData(this.status);
            if (n < 0) {
                String string4 = MessageFormat.format(ERROR_GETTING_CALIBRATION_DATA_MSG, CalibrationDataFileIO.getErrorMessage());
                this.appStatusHandler.displayErrorAndWaitForConfirm(string4);
                return false;
            }
            if (n > 0) {
                this.appStatusHandler.displayErrorWithDetailsAndWaitForConfirm(MUST_CALIBRATE_FIRST_SHORT_MSG, MUST_CALIBRATE_FIRST_MSG);
                try {
                    if (bl) {
                        this.terminateTargetJVM();
                    } else {
                        this.detachFromTargetJVM();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
                return false;
            }
        }
        this.status.jvmArguments = vMPropertiesResponse.getJVMArguments();
        this.status.javaCommand = vMPropertiesResponse.getJavaCommand();
        this.status.targetMachineOSName = vMPropertiesResponse.getTargetMachineOSName();
        this.status.maxHeapSize = vMPropertiesResponse.getMaxHeapSize();
        this.status.startupTimeMillis = vMPropertiesResponse.getStartupTimeMillis();
        this.status.startupTimeInCounts = vMPropertiesResponse.getStartupTimeInCounts();
        this.status.canInstrumentConstructor = vMPropertiesResponse.canInstrumentConstructor();
        if (!this.status.remoteProfiling && this.settings.getTargetJDKVersionString() != "jdk19" && this.settings.getTargetJDKVersionString() != "jdk110" && this.settings.getTargetJDKVersionString() != "jdk110") {
            this.settings.setWorkingDir(vMPropertiesResponse.getWorkingDir());
            this.settings.setVMClassPaths(vMPropertiesResponse.getJavaClassPath(), vMPropertiesResponse.getJavaExtDirs(), vMPropertiesResponse.getBootClassPath());
        } else {
            this.settings.setWorkingDir("");
            this.settings.setVMClassPaths("", null, null);
        }
        ClassRepository.initClassPaths(this.settings.getWorkingDir(), this.settings.getVMClassPaths());
        return true;
    }

    private void checkForInstrMethodsLimitReached() {
        if (this.status.getStartingMethodId() >= 65535 && !this.instrMethodsLimitReported && this.status.targetAppRunning) {
            this.appStatusHandler.displayWarningAndWaitForConfirm(INSTRUMENTATION_LIMIT_REACHED_MSG);
            this.instrMethodsLimitReported = true;
        }
    }

    private void checkForTargetAppRunning() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.status.targetAppRunning) {
            this.serverCommandHandler.handleServerCommand(null);
            throw new ClientUtils.TargetAppOrVMTerminated(2);
        }
    }

    private void checkForTargetVMAlive() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetVMAlive) {
            this.serverCommandHandler.handleServerCommand(null);
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPreviousInstrumentationInServer() throws InstrumentationException, ClientUtils.TargetAppOrVMTerminated {
        Response response;
        String string;
        this.checkForTargetAppRunning();
        if (this.handlingEventBufferDump) {
            while (this.handlingEventBufferDump) {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
        }
        if ((string = this.sendSimpleCommandAndGetResponse(9)) != null) {
            throw new InstrumentationException(string);
        }
        long l = System.currentTimeMillis();
        InstrumentMethodGroupCommand instrumentMethodGroupCommand = this.instrumentor.createClearAllInstrumentationCommand();
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            this.sendComplexCmdToServer(instrumentMethodGroupCommand);
            this.instrProcessingTime += System.currentTimeMillis() - l;
            response = this.getLastResponse();
        }
        if (!response.isOK()) {
            throw new InstrumentationException(response.getErrorMessage());
        }
    }

    private void closeConnection() {
        if (!this.serverListener.isRunning()) {
            return;
        }
        try {
            this.status.targetAppRunning = false;
            this.targetVMAlive = false;
            this.serverListener.shutdown();
            this.setLastResponse(null);
            this.socketOut.close();
            this.socketIn.close();
            this.clientSocket.close();
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
        }
        finally {
            EventBufferResultsProvider.getDefault().shutdown();
            EventBufferProcessor.removeEventBufferFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToServer(int n, boolean bl, final AtomicBoolean atomicBoolean) {
        String string;
        this.status.targetAppRunning = false;
        this.targetVMAlive = false;
        this.terminateOrDetachCommandIssued = false;
        String string2 = string = n == 1 ? this.settings.getRemoteHost() : "";
        if (string.isEmpty()) {
            this.status.remoteProfiling = false;
            string = "127.0.0.1";
        } else {
            this.status.remoteProfiling = true;
        }
        String string3 = string;
        int n2 = this.settings.getPortNo();
        int n3 = 600;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                atomicBoolean.set(true);
                ProfilerClient.this.serverListener.cancel();
            }
        };
        try (AppStatusHandler.AsyncDialog asyncDialog = this.appStatusHandler.getAsyncDialogInstance(CONNECT_VM_MSG, true, runnable);){
            this.serverListener = new ServerListener();
            asyncDialog.display();
            this.serverListener.start();
            while (!atomicBoolean.get()) {
                try {
                    this.clientSocket = new Socket(string3, n2);
                    this.clientSocket.setSoTimeout(0);
                    this.clientSocket.setTcpNoDelay(true);
                    this.socketOut = new ObjectOutputStream(this.clientSocket.getOutputStream());
                    this.socketIn = new ObjectInputStream(this.clientSocket.getInputStream());
                    this.wireIO = new WireIO(this.socketOut, this.socketIn);
                    this.targetVMAlive = true;
                    this.serverListener.startRunning();
                }
                catch (ConnectException connectException) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (--n3 != 0) continue;
                    MiscUtils.printWarningMessage("timed out while trying to connect to the target JVM.");
                    this.serverListener.cancel();
                }
                break;
            }
        }
        if (!this.serverListener.isRunning()) {
            MiscUtils.printErrorMessage("connection with server not open");
            return false;
        }
        try {
            String string4 = this.sendSimpleCommandAndGetResponse(1);
            if (string4 != null) {
                this.targetVMAlive = false;
                MiscUtils.printErrorMessage("got error message from agent:" + string4);
                return false;
            }
            if (bl) {
                boolean bl2 = this.getCalibrationData(false);
                try {
                    this.terminateTargetJVM();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    ProfilerLogger.log("terminateTargetJVM failed with TargetAppOrVMTerminated exception:");
                    ProfilerLogger.log(targetAppOrVMTerminated.getMessage());
                }
                return bl2;
            }
            boolean bl3 = n != 2;
            ProfilerClient profilerClient = this;
            synchronized (profilerClient) {
                this.sendSimpleCmdToServer(28);
                Response response = this.getLastResponse();
                if (!(response instanceof VMPropertiesResponse)) {
                    System.err.println("SEVERE: Received " + response.getClass().getName() + "(" + response.toString() + ") instead of VMPropertiesResponse");
                }
                if (!this.setVMProperties((VMPropertiesResponse)response, bl3)) {
                    return false;
                }
            }
            this.serverClassesInitialized = false;
            string4 = this.sendCommandAndGetResponse(new InitiateProfilingCommand(3, "*FAKE_CLASS_FOR_INTERNAL_TEST*"));
            if (string4 != null) {
                MiscUtils.printErrorMessage("got error message from agent:" + string4);
                this.targetVMAlive = false;
                return false;
            }
            n3 = 20;
            while (!this.serverClassesInitialized && --n3 > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.serverClassesInitialized) {
                MiscUtils.printErrorMessage("timed out while trying to initialize internals in the target JVM.");
                this.targetVMAlive = false;
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            this.targetVMAlive = false;
            MiscUtils.printWarningMessage("target app terminated:" + targetAppOrVMTerminated.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateThread(Command command) {
        Object object = this.execInSeparateThreadLock;
        synchronized (object) {
            this.execInSeparateThreadCmd = command;
            try {
                this.execInSeparateThreadLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                MiscUtils.internalError("ProfilerClient.executeInSeparateThread()");
            }
        }
    }

    private void startSeparateCmdExecThread() {
        assert (this.separateCmdExecThread == null);
        SeparateCmdExecutionThread separateCmdExecutionThread = new SeparateCmdExecutionThread();
        separateCmdExecutionThread.setDaemon(true);
        separateCmdExecutionThread.start();
        this.separateCmdExecThread = separateCmdExecutionThread;
    }

    private void stopSeparateCmdExecThread() {
        assert (this.separateCmdExecThread != null);
        this.executeInSeparateThread(null);
        this.separateCmdExecThread = null;
    }

    private boolean handleFakeClassLoad(RootClassLoadedCommand rootClassLoadedCommand) {
        if (rootClassLoadedCommand.getAllLoadedClassNames()[0].equals("*FAKE_CLASS_1*")) {
            this.sendComplexRespToServer(new InstrumentMethodGroupResponse(new String[]{"*FAKE_CLASS_1*", "*FAKE_CLASS_2*"}, new int[]{0, 0}, new byte[][]{{0}, {0}}, null, 0));
            this.serverClassesInitialized = true;
            return true;
        }
        return false;
    }

    private void handleIOExceptionOnSend(IOException iOException) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.appStatusHandler.displayError(MessageFormat.format(TARGET_JVM_ERROR_MSG, iOException.getMessage()));
        this.closeConnection();
        throw new ClientUtils.TargetAppOrVMTerminated(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentMethodGroupFollowUp(Command command) {
        Object object = this.instrumentationLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            InstrumentMethodGroupResponse instrumentMethodGroupResponse = this.instrumentor.createFollowUpInstrumentMethodGroupResponse(command);
            this.instrProcessingTime += System.currentTimeMillis() - l;
            this.sendComplexRespToServer(instrumentMethodGroupResponse);
        }
        this.checkForInstrMethodsLimitReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentMethodGroupFromRoot(RootClassLoadedCommand rootClassLoadedCommand) {
        Object object = this.instrumentationLock;
        synchronized (object) {
            AppStatusHandler.AsyncDialog asyncDialog = null;
            try {
                InstrumentMethodGroupResponse instrumentMethodGroupResponse;
                if (!this.serverClassesInitialized && this.handleFakeClassLoad(rootClassLoadedCommand)) {
                    return;
                }
                this.appStatusHandler.pauseLiveUpdates();
                if (this.status.targetAppRunning) {
                    asyncDialog = this.appStatusHandler.getAsyncDialogInstance(PERFORMING_INSTRUMENTATION_STRING, true, null);
                    asyncDialog.display();
                }
                try {
                    long l = System.currentTimeMillis();
                    instrumentMethodGroupResponse = this.instrumentor.createInitialInstrumentMethodGroupResponse(rootClassLoadedCommand);
                    this.instrProcessingTime += System.currentTimeMillis() - l;
                }
                catch (BadLocationException badLocationException) {
                    instrumentMethodGroupResponse = new InstrumentMethodGroupResponse((Object)null);
                    this.appStatusHandler.displayError(INVALID_CODE_REGION_MSG);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    instrumentMethodGroupResponse = new InstrumentMethodGroupResponse((Object)null);
                    if (this.getCurrentInstrType() == 1) {
                        this.appStatusHandler.displayError(MessageFormat.format(CLASS_NOT_FOUND_MSG, classNotFoundException.getMessage()));
                    }
                    MiscUtils.printErrorMessage("problem in instrumentMethodGroupFromRoot: " + classNotFoundException);
                }
                this.sendComplexRespToServer(instrumentMethodGroupResponse);
            }
            finally {
                if (asyncDialog != null) {
                    asyncDialog.close();
                }
                this.appStatusHandler.resumeLiveUpdates();
            }
        }
    }

    private void readAndProcessProfilingResults(EventBufferDumpedCommand eventBufferDumpedCommand) {
        int n = eventBufferDumpedCommand.getBufSize();
        if (n == 0) {
            this.sendSimpleRespToServer(true, null);
            return;
        }
        this.handlingEventBufferDump = true;
        if (!this.status.remoteProfiling && !this.forceObtainedResultsDumpCalled) {
            this.executeInSeparateThread(eventBufferDumpedCommand);
            this.handlingEventBufferDump = false;
        } else {
            byte[] byArray = EventBufferProcessor.readDataAndPrepareForProcessing(eventBufferDumpedCommand);
            EventBufferResultsProvider.getDefault().dataReady(byArray, this.getCurrentInstrType());
            this.handlingEventBufferDump = false;
            this.sendSimpleRespToServer(true, null);
            this.forceObtainedResultsDumpCalled = false;
        }
    }

    private synchronized String sendCommandAndGetResponse(Command command) throws ClientUtils.TargetAppOrVMTerminated {
        this.sendComplexCmdToServer(command);
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            MiscUtils.printErrorMessage("error in sendCommandAndGetResponse: for cmd = " + command + " and resp = " + response + " got error message: " + response.getErrorMessage());
            return response.getErrorMessage();
        }
        return null;
    }

    private void sendComplexCmdToServer(Command command) throws ClientUtils.TargetAppOrVMTerminated {
        try {
            this.wireIO.sendComplexCommand(command);
        }
        catch (IOException iOException) {
            this.handleIOExceptionOnSend(iOException);
        }
    }

    private void sendComplexRespToServer(Response response) {
        try {
            this.wireIO.sendComplexResponse(response);
        }
        catch (IOException iOException) {
            MiscUtils.printErrorMessage("exception when trying to send a response: " + iOException);
            try {
                this.handleIOExceptionOnSend(iOException);
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
        }
    }

    private void sendSimpleCmdToServer(int n) throws ClientUtils.TargetAppOrVMTerminated {
        try {
            this.wireIO.sendSimpleCommand(n);
        }
        catch (IOException iOException) {
            this.handleIOExceptionOnSend(iOException);
        }
    }

    private synchronized String sendSimpleCommandAndGetResponse(int n) throws ClientUtils.TargetAppOrVMTerminated {
        this.sendSimpleCmdToServer(n);
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            MiscUtils.printErrorMessage("error in sendCommandAndGetResponse: for cmdType = " + n + " and resp = " + response + " got error message: " + response.getErrorMessage());
            return response.getErrorMessage();
        }
        return null;
    }

    private void sendSimpleRespToServer(boolean bl, String string) {
        try {
            this.wireIO.sendSimpleResponse(bl, string);
        }
        catch (IOException iOException) {
            try {
                this.handleIOExceptionOnSend(iOException);
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
        }
    }

    private InitiateProfilingCommand createInitiateInstrumnetation(int n, String[] stringArray, boolean bl, boolean bl2) {
        Object[] objectArray = this.settings.getRuntimeProfilingPoints();
        String[] stringArray2 = new String[objectArray.length];
        String[] stringArray3 = new String[objectArray.length];
        int[] nArray = new int[objectArray.length];
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            nArray[i] = ((RuntimeProfilingPoint)object).getId();
            stringArray2[i] = ((RuntimeProfilingPoint)object).getServerHandlerClass();
            stringArray3[i] = ((RuntimeProfilingPoint)object).getServerInfo();
        }
        return new InitiateProfilingCommand(n, stringArray, nArray, stringArray2, stringArray3, bl, bl2);
    }

    static /* synthetic */ int[] access$1502(ProfilerClient profilerClient, int[] nArray) {
        profilerClient.savedAllocatedObjectsCountResults = nArray;
        return nArray;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.Bundle");
        CANNOT_OPEN_SERVER_TEMPFILE_MSG = resourceBundle.getString("ProfilerClient_CannotOpenServerTempFileMsg");
        PERFORMING_INSTRUMENTATION_STRING = resourceBundle.getString("ProfilerClient_PerformingInstrumentationString");
        INVALID_CODE_REGION_MSG = resourceBundle.getString("ProfilerClient_InvalidCodeRegionMsg");
        CLASS_NOT_FOUND_MSG = resourceBundle.getString("ProfilerClient_ClassNotFoundMsg");
        OUT_OF_MEMORY_MSG = resourceBundle.getString("ProfilerClient_OutOfMemoryMsg");
        INCORRECT_AGENT_VERSION_MSG = resourceBundle.getString("ProfilerClient_IncorrectAgentVersionMsg");
        ERROR_GETTING_CALIBRATION_DATA_MSG = resourceBundle.getString("ProfilerClient_ErrorGettingCalibrationDataMsg");
        MUST_CALIBRATE_FIRST_MSG = resourceBundle.getString("ProfilerClient_MustCalibrateFirstMsg");
        MUST_CALIBRATE_FIRST_SHORT_MSG = resourceBundle.getString("ProfilerClient_MustCalibrateFirstShortMsg");
        INSTRUMENTATION_LIMIT_REACHED_MSG = resourceBundle.getString("ProfilerClient_InstrumentationLimitReachedMsg");
        CORRUPTED_TARGET_CALIBRATION_DATA_MSG = resourceBundle.getString("ProfilerClient_CorruptedTargetCalibrationDataMsg");
        CONNECT_VM_MSG = resourceBundle.getString("ProfilerClient_ConnectVmMsg");
        TARGET_JVM_ERROR_MSG = resourceBundle.getString("ProfilerClient_TargetJvmErrorMsg");
        UNSUPPORTED_JVM_MSG = resourceBundle.getString("ProfilerClient_UnsupportedJvmMsg");
    }

    private class ServerListener
    extends Thread {
        private final Object startedFlagLock = new Object();
        private int startedFlag = 0;

        private ServerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                return this.startedFlag == 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = -1;
                this.startedFlagLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                while (this.startedFlag == 0) {
                    try {
                        this.startedFlagLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.startedFlag = -1;
                    }
                }
                if (this.startedFlag == -1) {
                    return;
                }
            }
            ProfilerClient.this.startSeparateCmdExecThread();
            try {
                while (ProfilerClient.this.targetVMAlive) {
                    try {
                        object = ProfilerClient.this.wireIO.receiveCommandOrResponse();
                        if (object == null) {
                            ProfilerClient.this.closeConnection();
                            continue;
                        }
                        if (object instanceof Command) {
                            this.handleServerCommand((Command)object);
                            continue;
                        }
                        ProfilerClient.this.setLastResponse((Response)object);
                    }
                    catch (IOException iOException) {
                        if (!ProfilerClient.this.targetVMAlive || ProfilerClient.this.terminateOrDetachCommandIssued) continue;
                        MiscUtils.printErrorMessage("exception while trying to get response from the target JVM:\n" + iOException);
                        ProfilerClient.this.closeConnection();
                    }
                }
                return;
            }
            finally {
                ProfilerClient.this.stopSeparateCmdExecThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = 0;
                this.startedFlagLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRunning() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = 1;
                this.startedFlagLock.notifyAll();
            }
        }

        private void handleServerCommand(Command command) {
            switch (command.getType()) {
                case 18: {
                    ((ProfilerClient)ProfilerClient.this).status.targetAppRunning = false;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                if (ProfilerClient.this.currentInstrTypeIsRecursiveCPUProfiling() || ProfilerClient.this.currentInstrTypeIsMemoryProfiling()) {
                                    ProfilerClient.this.forceObtainedResultsDump(false, 15);
                                }
                                if (ProfilerClient.this.currentInstrTypeIsMemoryProfiling()) {
                                    ProfilerClient.access$1502(ProfilerClient.this, ProfilerClient.this.getAllocatedObjectsCountResults());
                                    if (ProfilerClient.this.memCctProvider instanceof MemoryCallGraphBuilder) {
                                        ((MemoryCallGraphBuilder)ProfilerClient.this.memCctProvider).updateInternals();
                                    }
                                }
                                ((ProfilerClient)ProfilerClient.this).status.savedInternalStats = ProfilerClient.this.getInternalStats();
                                ProfilerClient.this.appStatusHandler.handleShutdown();
                                ProfilerClient.this.sendSimpleCmdToServer(15);
                            }
                            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                                // empty catch block
                            }
                        }
                    }.start();
                    break;
                }
                case 19: {
                    ProfilerClient.this.targetVMAlive = false;
                    ((ProfilerClient)ProfilerClient.this).status.targetAppRunning = false;
                    EventBufferProcessor.removeEventBufferFile();
                    break;
                }
                case 17: {
                    ProfilerClient.this.executeInSeparateThread(command);
                    break;
                }
                case 3: 
                case 22: 
                case 23: {
                    ProfilerClient.this.executeInSeparateThread(command);
                    break;
                }
                case 26: {
                    EventBufferDumpedCommand eventBufferDumpedCommand = (EventBufferDumpedCommand)command;
                    String string = eventBufferDumpedCommand.getEventBufferFileName();
                    if (string.length() > 0) {
                        if (!EventBufferProcessor.bufFileExists() && !EventBufferProcessor.setEventBufferFile(string)) {
                            ProfilerClient.this.appStatusHandler.displayError(MessageFormat.format(CANNOT_OPEN_SERVER_TEMPFILE_MSG, eventBufferDumpedCommand.getEventBufferFileName()));
                        }
                        JMethodIdTable.reset();
                    }
                    ProfilerClient.this.readAndProcessProfilingResults(eventBufferDumpedCommand);
                    break;
                }
                case 36: {
                    ProfilerClient.this.executeInSeparateThread(command);
                    break;
                }
                case 38: {
                    ProfilerClient.this.resultsStart = System.currentTimeMillis();
                    break;
                }
                case 42: {
                    GetClassIdCommand getClassIdCommand = (GetClassIdCommand)command;
                    int n = ProfilerClient.this.instrumentor.getClassId(getClassIdCommand.getClassName(), getClassIdCommand.getClassLoaderId());
                    ProfilerClient.this.sendComplexRespToServer(new GetClassIdResponse(n != -1, n));
                    break;
                }
            }
            if (!ProfilerClient.this.targetVMAlive) {
                ProfilerClient.this.closeConnection();
            }
            ProfilerClient.this.serverCommandHandler.handleServerCommand(command);
        }
    }

    private class SeparateCmdExecutionThread
    extends Thread {
        private SeparateCmdExecutionThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("*** JFluid Separate Command Execution Thread");
            Object object = ProfilerClient.this.execInSeparateThreadLock;
            synchronized (object) {
                while (true) {
                    try {
                        ProfilerClient.this.execInSeparateThreadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        MiscUtils.internalError("ProfilerClient.SpecialExecutionThread.run()");
                    }
                    if (ProfilerClient.this.execInSeparateThreadCmd == null) {
                        return;
                    }
                    Command command = ProfilerClient.this.execInSeparateThreadCmd;
                    ProfilerClient.this.execInSeparateThreadCmd = null;
                    switch (command.getType()) {
                        case 17: {
                            ProfilerClient.this.instrumentMethodGroupFromRoot((RootClassLoadedCommand)command);
                            break;
                        }
                        case 3: 
                        case 22: 
                        case 23: {
                            ProfilerClient.this.instrumentMethodGroupFollowUp(command);
                            break;
                        }
                        case 26: {
                            EventBufferDumpedCommand eventBufferDumpedCommand = (EventBufferDumpedCommand)command;
                            byte[] byArray = EventBufferProcessor.readDataAndPrepareForProcessing(eventBufferDumpedCommand);
                            EventBufferResultsProvider.getDefault().dataReady(byArray, ProfilerClient.this.getCurrentInstrType());
                            ProfilerClient.this.sendSimpleRespToServer(true, null);
                            break;
                        }
                        case 36: {
                            ProfilerClient profilerClient = ProfilerClient.this;
                            synchronized (profilerClient) {
                                Object object2 = ProfilerClient.this.forceObtainedResultsDumpLock;
                                synchronized (object2) {
                                    if (ProfilerClient.this.memCctProvider != null) {
                                        ProfilerClient.this.memCctProvider.updateInternals();
                                    }
                                    ProfilerClient.this.sendSimpleRespToServer(true, null);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

