/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.sheets.csv;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.io.importer.plugin.file.spreadsheet.sheets.csv.CSVSheetRow;

public class CSVSheetParser
implements SheetParser {
    private final CSVParser parser;

    public CSVSheetParser(CSVParser parser) {
        this.parser = parser;
    }

    @Override
    public Map<String, Integer> getHeaderMap() {
        Map map = this.parser.getHeaderMap();
        if (map == null) {
            return Collections.emptyMap();
        }
        if (map.containsKey(null)) {
            map.remove(null);
        }
        return map;
    }

    @Override
    public long getCurrentRecordNumber() {
        return this.parser.getRecordNumber();
    }

    @Override
    public Iterator<SheetRow> iterator() {
        return new CSVIterator();
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    private class CSVIterator
    implements Iterator<SheetRow> {
        private final Iterator<CSVRecord> iterator;

        public CSVIterator() {
            this.iterator = CSVSheetParser.this.parser.iterator();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iterator.hasNext();
            }
            catch (Exception e) {
                Logger.getLogger("").severe(e.getMessage());
                return false;
            }
        }

        @Override
        public SheetRow next() {
            return new CSVSheetRow(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

