/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.OutputStream;
import java.util.Hashtable;
import javajs.api.GenericColor;
import javajs.awt.Font;
import javajs.export.PDFCreator;
import javajs.util.CU;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPdfWriter;
import jspecview.common.JSVersion;
import jspecview.common.PrintLayout;
import org.jmol.api.GenericGraphics;

public class PDFWriter
implements GenericGraphics,
JSVPdfWriter {
    private GenericGraphics g2d;
    private String date;
    private PDFCreator pdf;
    private boolean inPath;
    private float[] rgb = new float[3];

    public PDFWriter() {
        this.pdf = new PDFCreator();
    }

    @Override
    public void createPdfDocument(JSVPanel jSVPanel, PrintLayout printLayout, OutputStream outputStream) {
        boolean bl = printLayout.layout.equals("landscape");
        this.date = printLayout.date;
        this.pdf.setOutputStream(outputStream);
        this.g2d = jSVPanel.getPanelData().g2d;
        try {
            this.pdf.newDocument(printLayout.paperWidth, printLayout.paperHeight, bl);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("Producer", JSVersion.VERSION);
            hashtable.put("Creator", "JSpecView " + JSVersion.VERSION);
            hashtable.put("Author", "JSpecView");
            if (this.date != null) {
                hashtable.put("CreationDate", this.date);
            }
            this.pdf.addInfo(hashtable);
            jSVPanel.getPanelData().printPdf(this, printLayout);
            this.pdf.closeDocument();
        }
        catch (Exception exception) {
            jSVPanel.showMessage(exception.toString(), "PDF Creation Error");
        }
    }

    @Override
    public boolean canDoLineTo() {
        return true;
    }

    @Override
    public void doStroke(Object object, boolean bl) {
        this.inPath = bl;
        if (!this.inPath) {
            this.pdf.stroke();
        }
    }

    @Override
    public void drawCircle(Object object, int n, int n2, int n3) {
        this.pdf.doCircle(n, n2, (int)((double)n3 / 2.0), false);
    }

    @Override
    public void drawLine(Object object, int n, int n2, int n3, int n4) {
        this.pdf.moveto(n, n2);
        this.pdf.lineto(n3, n4);
        if (!this.inPath) {
            this.pdf.stroke();
        }
    }

    @Override
    public void drawPolygon(Object object, int[] nArray, int[] nArray2, int n) {
        this.pdf.doPolygon(nArray, nArray2, n, false);
    }

    @Override
    public void drawRect(Object object, int n, int n2, int n3, int n4) {
        this.pdf.doRect(n, n2, n3, n4, false);
    }

    @Override
    public void drawString(Object object, String string, int n, int n2) {
        this.pdf.drawStringRotated(string, n, n2, 0);
    }

    @Override
    public void drawStringRotated(Object object, String string, int n, int n2, double d) {
        this.pdf.drawStringRotated(string, n, n2, (int)d);
    }

    @Override
    public void fillBackground(Object object, GenericColor genericColor) {
    }

    @Override
    public void fillCircle(Object object, int n, int n2, int n3) {
        this.pdf.doCircle(n, n2, (int)((double)n3 / 2.0), true);
    }

    @Override
    public void fillPolygon(Object object, int[] nArray, int[] nArray2, int n) {
        this.pdf.doPolygon(nArray2, nArray, n, true);
    }

    @Override
    public void fillRect(Object object, int n, int n2, int n3, int n4) {
        this.pdf.doRect(n, n2, n3, n4, true);
    }

    @Override
    public void lineTo(Object object, int n, int n2) {
        this.pdf.lineto(n, n2);
    }

    @Override
    public void setGraphicsColor(Object object, GenericColor genericColor) {
        CU.toRGB3f(genericColor.getRGB(), this.rgb);
        this.pdf.setColor(this.rgb, true);
        this.pdf.setColor(this.rgb, false);
    }

    @Override
    public Font setFont(Object object, Font font) {
        String string = "/Helvetica";
        switch (font.idFontStyle) {
            case 1: {
                string = String.valueOf(string) + "-Bold";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "-BoldOblique";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "-Oblique";
            }
        }
        this.pdf.setFont(string, font.fontSizeNominal);
        return font;
    }

    @Override
    public void setStrokeBold(Object object, boolean bl) {
        this.pdf.setLineWidth(bl ? 2 : 1);
    }

    @Override
    public void translateScale(Object object, double d, double d2, double d3) {
        this.pdf.translateScale((float)d, (float)d2, (float)d3);
    }

    @Override
    public Object newGrayScaleImage(Object object, Object object2, int n, int n2, int[] nArray) {
        this.pdf.addImageResource(object2, n, n2, nArray, false);
        return object2;
    }

    @Override
    public void drawGrayScaleImage(Object object, Object object2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.pdf.drawImage(object2, n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public void setWindowParameters(int n, int n2) {
    }

    @Override
    public GenericColor getColor1(int n) {
        return this.g2d.getColor1(n);
    }

    @Override
    public GenericColor getColor3(int n, int n2, int n3) {
        return this.g2d.getColor3(n, n2, n3);
    }

    @Override
    public GenericColor getColor4(int n, int n2, int n3, int n4) {
        return this.g2d.getColor4(n, n2, n3, n4);
    }
}

