/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public class MOReader
extends BasisFunctionReader {
    public int shellCount = 0;
    public int gaussianCount = 0;
    public float[][] gaussians;
    protected String energyUnits = "";
    protected Lst<String> moTypes;
    private boolean getNBOs;
    private boolean getNBOCharges;
    protected boolean haveNboCharges;
    protected boolean haveNboOrbitals;
    protected boolean orbitalsRead;
    private Map<String, Object> lastMoData;
    protected boolean allowNoOrbitals;
    protected final int HEADER_GAMESS_UK_MO = 3;
    protected final int HEADER_GAMESS_OCCUPANCIES = 2;
    protected final int HEADER_GAMESS_ORIGINAL = 1;
    protected final int HEADER_NONE = 0;
    private boolean haveCoeffMap;
    private static final String P_LIST = "(PX)  (PY)  (PZ)";
    private static final String DS_LIST = "(D5)  (D2)  (D3)  (D4)  (D1)";
    private static final String DC_LIST = "(D1)  (D4)  (D6)  (D2)  (D3)  (D5)";
    private static final String FS_LIST = "(F1)  (F2)  (F3)  (F4)  (F5)  (F6)  (F7)";
    private static String FC_LIST = "(F1)  (F2)  (F10) (F4)  (F2)  (F3)  (F6)  (F9)  (F8)  (F5)";
    private int iMo0 = 1;

    @Override
    protected void initializeReader() throws Exception {
        this.line = "\nNBOs";
        this.getNBOs = this.filter != null && this.filterMO();
        this.line = "\nNBOCHARGES";
        this.getNBOCharges = this.filter != null && this.filterMO();
        this.checkAndRemoveFilterKey("NBOCHARGES");
    }

    public boolean checkAndRemoveFilterKey(String string) {
        if (!this.checkFilterKey(string)) {
            return false;
        }
        this.filter = PT.rep(this.filter, string, "");
        if (this.filter.length() < 3) {
            this.filter = null;
        }
        return true;
    }

    protected boolean checkNboLine() throws Exception {
        if (this.getNBOs) {
            if (this.line.indexOf("(Occupancy)   Bond orbital/ Coefficients/ Hybrids") >= 0) {
                this.getNboTypes();
                return false;
            }
            if (this.line.indexOf("NBOs in the AO basis:") >= 0) {
                this.readMolecularOrbitals(0);
                return false;
            }
            if (this.line.indexOf(" SECOND ORDER PERTURBATION THEORY ANALYSIS") >= 0) {
                this.readSecondOrderData();
                return false;
            }
        }
        if (this.getNBOCharges && this.line.indexOf("Summary of Natural Population Analysis:") >= 0) {
            this.getNboCharges();
            return true;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void getNboCharges() throws Exception {
        if (this.haveNboCharges) {
            return;
        }
        this.discardLinesUntilContains("----");
        this.discardLinesUntilContains("----");
        this.haveNboCharges = true;
        var1_1 = this.asc.ac;
        var2_2 = this.asc.getLastAtomSetAtomIndex();
        var3_3 = this.asc.atoms;
        var4_4 = var2_2;
        ** GOTO lbl24
        {
            ++var4_4;
            do {
                if (var3_3[var4_4].elementNumber == 0) continue block0;
                var5_5 = PT.getTokens(this.rd());
                if (var5_5 == null || var5_5.length < 3 || Float.isNaN(var6_6 = this.parseFloatStr(var5_5[2]))) {
                    Logger.info("Error reading NBO charges: " + this.line);
                    return;
                }
                var3_3[var4_4].partialCharge = var6_6;
                if (this.debugging) {
                    Logger.debug("Atom " + var4_4 + " using NBOcharge: " + var6_6);
                }
                ++var4_4;
lbl24:
                // 2 sources

            } while (var4_4 < var1_1);
        }
        Logger.info("Using NBO charges for Model " + this.asc.atomSetCount);
    }

    protected void getNboTypes() throws Exception {
        this.moTypes = new Lst();
        this.iMo0 = (this.orbitals == null ? 0 : this.orbitals.size()) + 1;
        this.rd();
        this.rd();
        int n = 0;
        int n2 = 0;
        while (this.line != null && (n2 = this.line.indexOf(".")) >= 0 && n2 < 10) {
            if (this.parseIntRange(this.line, 0, n2) != n + 1) break;
            this.moTypes.add(n++, this.line.substring(n2 + 1, Math.min(40, this.line.length())).trim());
            while (this.rd() != null && this.line.startsWith("       ")) {
            }
        }
        Logger.info(String.valueOf(n) + " natural bond AO basis functions found");
    }

    protected void readMolecularOrbitals(int n) throws Exception {
        if (this.ignoreMOs) {
            this.rd();
            return;
        }
        this.dfCoefMaps = null;
        if (this.haveNboOrbitals) {
            this.orbitals = new Lst();
            this.alphaBeta = "";
        }
        this.haveNboOrbitals = true;
        this.orbitalsRead = true;
        Map<K, V>[] mapArray = null;
        Lst<type>[] lstArray = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        this.rd();
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (this.line.indexOf("---") >= 0) {
            this.rd();
        }
        while (this.rd() != null) {
            int n7;
            int n8;
            Object object;
            int n9;
            String string4;
            String[] stringArray = this.getTokens();
            if (this.debugging) {
                Logger.debug(String.valueOf(stringArray.length) + " --- " + this.line);
            }
            if (this.line.indexOf("end") >= 0) break;
            if (this.line.indexOf(" ALPHA SET ") >= 0) {
                this.alphaBeta = "alpha";
                if (this.rd() == null) {
                    break;
                }
            } else if (this.line.indexOf(" BETA SET ") >= 0) {
                if (bl) break;
                this.alphaBeta = "beta";
                if (this.rd() == null) break;
            }
            if ((string4 = this.line.toUpperCase()).length() == 0 || string4.indexOf("--") >= 0 || string4.indexOf(".....") >= 0 || string4.indexOf("NBO BASIS") >= 0 || string4.indexOf("CI EIGENVECTORS WILL BE LABELED") >= 0 || string4.indexOf("LZ VALUE") >= 0 || string4.indexOf("   THIS LOCALIZATION HAD") >= 0) {
                if (!this.haveCoeffMap) {
                    this.haveCoeffMap = true;
                    n9 = 1;
                    if (string3.length() > 0) {
                        n9 = this.getDFMap("P", string3, 1, P_LIST, 4);
                    }
                    if (string.length() > 0) {
                        n9 = string.indexOf("X") >= 0 ? (int)(this.getDFMap("DC", string, 4, "DXX   DYY   DZZ   DXY   DXZ   DYZ", 2) ? 1 : 0) : (string.indexOf("(D6)") >= 0 ? (int)(this.getDFMap("DC", string, 4, DC_LIST, 4) ? 1 : 0) : (int)(this.getDFMap("DS", string, 3, DS_LIST, 4) ? 1 : 0));
                    }
                    if (string2.length() > 0) {
                        n9 = string2.indexOf("X") >= 0 ? (int)(this.getDFMap("FC", string2, 6, "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ", 2) ? 1 : 0) : (string2.indexOf("(F10)") >= 0 ? (int)(this.getDFMap("FC", string2, 6, FC_LIST, 5) ? 1 : 0) : (int)(this.getDFMap("FS", string2, 5, FS_LIST, 4) ? 1 : 0));
                    }
                }
                n6 = string4.length() == 0 ? ++n6 : 0;
                if (n6 == 2) break;
                if (string4.indexOf("LZ VALUE") >= 0) {
                    this.discardLinesUntilBlank();
                }
                n9 = 0;
                while (n9 < n4) {
                    object = new float[lstArray[n9].size()];
                    n8 = 0;
                    while (n8 < ((float[])object).length) {
                        object[n8] = this.parseFloatStr((String)lstArray[n9].get(n8));
                        ++n8;
                    }
                    bl = true;
                    this.addCoef((Map<String, Object>)mapArray[n9], (float[])object, null, Float.NaN, Float.NaN, n5++);
                    ++n9;
                }
                n4 = 0;
                if (this.line.length() != 0) break;
                continue;
            }
            n6 = 0;
            if (n4 == 0) {
                n4 = stringArray.length;
                if (stringArray[0].equals("AO")) {
                    --n4;
                    n2 = 16;
                    n3 = 8;
                }
                if (mapArray == null || n4 > mapArray.length) {
                    mapArray = AU.createArrayOfHashtable(n4);
                    lstArray = AU.createArrayOfArrayList(n4);
                }
                n9 = 0;
                while (n9 < n4) {
                    mapArray[n9] = new Hashtable();
                    lstArray[n9] = new Lst();
                    ++n9;
                }
                this.getMOHeader(n, stringArray, mapArray, n4);
                continue;
            }
            n9 = stringArray.length - n4;
            object = stringArray[n9 - 1];
            if (((String)object).charAt(0) == '(') {
                n8 = ((String)object).charAt(1);
                if (!this.haveCoeffMap) {
                    switch (n8) {
                        case 112: {
                            string3 = String.valueOf(string3) + " " + ((String)object).toUpperCase();
                            break;
                        }
                        case 100: {
                            string = String.valueOf(string) + " " + MOReader.canonicalizeQuantumSubshellTag(((String)object).toUpperCase());
                            break;
                        }
                        case 102: {
                            string2 = String.valueOf(string2) + " " + MOReader.canonicalizeQuantumSubshellTag(((String)object).toUpperCase());
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                n7 = ((String)object).length();
                int n10 = n7 < 4 ? 83 : (n7 == 4 ? 71 : (n8 = n7 == 5 ? 72 : 63));
                if (!this.haveCoeffMap && n7 == 3) {
                    string2 = String.valueOf(string2) + " " + MOReader.canonicalizeQuantumSubshellTag(((String)object).toUpperCase());
                } else if (!this.haveCoeffMap && n7 == 2) {
                    string = String.valueOf(string) + " " + MOReader.canonicalizeQuantumSubshellTag(((String)object).toUpperCase());
                }
            }
            if (QS.isQuantumBasisSupported((char)n8)) {
                if (n2 < 0) {
                    n7 = 0;
                    while (n7 < n4) {
                        lstArray[n7].addLast(stringArray[n7 + n9]);
                        ++n7;
                    }
                } else {
                    n7 = n2;
                    int n11 = 0;
                    while (n11 < n4) {
                        lstArray[n11].addLast(this.line.substring(n7, n7 + n3).trim());
                        ++n11;
                        n7 += n3;
                    }
                }
            }
            this.line = "";
        }
        this.energyUnits = "a.u.";
        this.setMOData(!this.alphaBeta.equals("alpha"));
        this.haveCoeffMap = false;
        this.dfCoefMaps = null;
    }

    public void addCoef(Map<String, Object> map, float[] fArray, String string, float f, float f2, int n) {
        map.put("coefficients", fArray);
        if (this.moTypes != null) {
            string = (String)this.moTypes.get(n % this.moTypes.size());
            f2 = string.indexOf("*") >= 0 ? 0 : 2;
        } else if (this.alphaBeta.length() > 0) {
            string = this.alphaBeta;
        }
        if (string != null) {
            map.put("type", string);
        }
        if (!Float.isNaN(f)) {
            map.put("energy", Float.valueOf(f));
        }
        if (!Float.isNaN(f2)) {
            map.put("occupancy", Float.valueOf(f2));
        }
        this.setMO(map);
    }

    protected void getMOHeader(int n, String[] stringArray, Map<String, Object>[] mapArray, int n2) throws Exception {
        int n3;
        this.rd();
        switch (n) {
            default: {
                return;
            }
            case 3: {
                int n4 = 0;
                while (n4 < n2) {
                    mapArray[n4].put("energy", Float.valueOf(stringArray[n4]));
                    ++n4;
                }
                this.readLines(5);
                return;
            }
            case 1: {
                stringArray = this.getTokens();
                if (stringArray.length == 0) {
                    stringArray = PT.getTokens(this.rd());
                }
                n3 = 0;
                while (n3 < n2) {
                    mapArray[n3].put("energy", Float.valueOf(stringArray[n3]));
                    ++n3;
                }
                this.rd();
                break;
            }
            case 2: {
                n3 = this.line.length() <= 0 && this.rd() == null ? 0 : 1;
                stringArray = this.getTokens();
                int n5 = 0;
                while (n5 < n2) {
                    mapArray[n5].put("occupancy", Float.valueOf(stringArray[n5].charAt(0) == '-' ? 2.0f : this.parseFloatStr(stringArray[n5])));
                    ++n5;
                }
                this.rd();
                if (n3 != 0) break;
                return;
            }
        }
        if (this.line.length() > 0) {
            stringArray = this.getTokens();
            n3 = 0;
            while (n3 < n2) {
                mapArray[n3].put("symmetry", stringArray[n3]);
                ++n3;
            }
        }
    }

    protected void addMOData(int n, Lst<String>[] lstArray, Map<String, Object>[] mapArray) {
        int n2 = 0;
        while (n2 < n) {
            float[] fArray = new float[lstArray[n2].size()];
            int n3 = fArray.length;
            while (--n3 >= 0) {
                fArray[n3] = this.parseFloatStr((String)lstArray[n2].get(n3));
            }
            mapArray[n2].put("coefficients", fArray);
            this.setMO(mapArray[n2]);
            ++n2;
        }
    }

    public void setMOData(boolean bl) {
        if (this.shells != null && this.gaussians != null && (this.allowNoOrbitals || this.orbitals.size() != 0)) {
            this.moData.put("calculationType", this.calculationType);
            this.moData.put("energyUnits", this.energyUnits);
            this.moData.put("shells", this.shells);
            this.moData.put("gaussians", this.gaussians);
            this.moData.put("mos", this.orbitals);
            this.lastMoData = this.moData;
            this.finalizeMOData(this.lastMoData);
        }
        if (bl) {
            this.clearOrbitals();
        }
    }

    private void readSecondOrderData() throws Exception {
        this.readLines(5);
        if (this.lastMoData == null || this.moTypes == null) {
            return;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n = this.moTypes.size();
        while (--n >= 0) {
            hashtable.put(PT.rep(((String)this.moTypes.get(n)).substring(10), " ", ""), n + this.iMo0);
        }
        Lst<String[]> lst = new Lst<String[]>();
        while (this.rd() != null && this.line.indexOf("NBO") < 0) {
            if (this.line.length() < 5 || this.line.charAt(4) != '.') continue;
            lst.addLast(new String[]{PT.rep(this.line.substring(5, 27).trim(), " ", ""), PT.rep(this.line.substring(32, 54).trim(), " ", ""), this.line.substring(55, 62).trim(), this.line.substring(71).trim()});
        }
        float[][] fArray = new float[lst.size()][4];
        this.lastMoData.put("secondOrderData", fArray);
        this.lastMoData = null;
        int n2 = lst.size();
        while (--n2 >= 0) {
            String[] stringArray = (String[])lst.get(n2);
            Integer n3 = (Integer)hashtable.get(stringArray[0]);
            if (n3 != null) {
                fArray[n2][0] = n3.intValue();
            }
            if ((n3 = (Integer)hashtable.get(stringArray[1])) != null) {
                fArray[n2][1] = n3.intValue();
            }
            fArray[n2][2] = this.parseFloatStr(stringArray[2]);
            fArray[n2][3] = this.parseFloatStr(stringArray[3]);
        }
    }
}

