/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Arrays;
import java.util.Comparator;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.MeshSurface;

public class MeshData
extends MeshSurface {
    public static final int MODE_GET_VERTICES = 1;
    public static final int MODE_GET_COLOR_INDEXES = 2;
    public static final int MODE_PUT_SETS = 3;
    public static final int MODE_PUT_VERTICES = 4;
    private boolean setsSuccessful;
    public int vertexIncrement = 1;
    public String polygonColorData;

    public int addVertexCopy(T3 t3, float f, int n, boolean bl) {
        if (n < 0) {
            this.vertexIncrement = -n;
        }
        return this.addVCVal(t3, f, bl);
    }

    public BS[] getSurfaceSet() {
        return this.surfaceSet == null ? this.getSurfaceSetForLevel(0) : this.surfaceSet;
    }

    private BS[] getSurfaceSetForLevel(int n) {
        int n2;
        int n3;
        if (n == 0) {
            this.surfaceSet = new BS[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        int n4 = 0;
        while (n4 < this.pc) {
            if (this.pis[n4] != null && (this.bsSlabDisplay == null || this.bsSlabDisplay.get(n4))) {
                int[] nArray = this.pis[n4];
                n3 = this.findSet(nArray[0]);
                n2 = this.findSet(nArray[1]);
                int n5 = this.findSet(nArray[2]);
                if (n3 < 0 && n2 < 0 && n5 < 0) {
                    this.createSet(nArray[0], nArray[1], nArray[2]);
                } else if (n3 != n2 || n2 != n5) {
                    if (n3 >= 0) {
                        this.surfaceSet[n3].set(nArray[1]);
                        this.surfaceSet[n3].set(nArray[2]);
                        if (n2 >= 0 && n2 != n3) {
                            this.mergeSets(n3, n2);
                        }
                        if (n5 >= 0 && n5 != n3 && n5 != n2) {
                            this.mergeSets(n3, n5);
                        }
                    } else if (n2 >= 0) {
                        this.surfaceSet[n2].set(nArray[0]);
                        this.surfaceSet[n2].set(nArray[2]);
                        if (n5 >= 0 && n5 != n2) {
                            this.mergeSets(n2, n5);
                        }
                    } else {
                        this.surfaceSet[n5].set(nArray[0]);
                        this.surfaceSet[n5].set(nArray[1]);
                    }
                }
            }
            ++n4;
        }
        n4 = 0;
        int n6 = 0;
        while (n6 < this.nSets) {
            if (this.surfaceSet[n6] != null) {
                ++n4;
            }
            ++n6;
        }
        BS[] bSArray = new BS[this.surfaceSet.length];
        n4 = 0;
        n3 = 0;
        while (n3 < this.nSets) {
            if (this.surfaceSet[n3] != null) {
                bSArray[n4++] = this.surfaceSet[n3];
            }
            ++n3;
        }
        this.nSets = n4;
        this.surfaceSet = bSArray;
        if (!this.setsSuccessful && n < 2) {
            this.getSurfaceSetForLevel(n + 1);
        }
        if (n == 0) {
            SSet[] sSetArray = new SSet[this.nSets];
            n2 = 0;
            while (n2 < this.nSets) {
                sSetArray[n2] = new SSet(this.surfaceSet[n2]);
                ++n2;
            }
            Arrays.sort(sSetArray, new SortSet());
            n2 = 0;
            while (n2 < this.nSets) {
                this.surfaceSet[n2] = sSetArray[n2].bs;
                ++n2;
            }
            this.setVertexSets(false);
        }
        return this.surfaceSet;
    }

    public void setVertexSets(boolean bl) {
        int n;
        if (this.surfaceSet == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.nSets) {
            if (this.surfaceSet[n3] != null && this.surfaceSet[n3].nextSetBit(0) < 0) {
                this.surfaceSet[n3] = null;
            }
            if (this.surfaceSet[n3] == null) {
                ++n2;
            }
            ++n3;
        }
        if (n2 > 0) {
            BS[] bSArray = new BS[this.nSets - n2];
            n = 0;
            int n4 = 0;
            while (n < this.nSets) {
                if (this.surfaceSet[n] != null) {
                    bSArray[n4++] = this.surfaceSet[n];
                }
                ++n;
            }
            this.surfaceSet = bSArray;
            this.nSets -= n2;
        } else if (bl) {
            return;
        }
        this.vertexSets = new int[this.vc];
        int n5 = 0;
        while (n5 < this.nSets) {
            n = this.surfaceSet[n5].nextSetBit(0);
            while (n >= 0) {
                this.vertexSets[n] = n5;
                n = this.surfaceSet[n5].nextSetBit(n + 1);
            }
            ++n5;
        }
    }

    private int findSet(int n) {
        int n2 = 0;
        while (n2 < this.nSets) {
            if (this.surfaceSet[n2] != null && this.surfaceSet[n2].get(n)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void createSet(int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < this.nSets) {
            if (this.surfaceSet[n4] == null) break;
            ++n4;
        }
        if (n4 == this.surfaceSet.length) {
            this.surfaceSet = (BS[])AU.ensureLength(this.surfaceSet, this.surfaceSet.length + 100);
        }
        this.surfaceSet[n4] = new BS();
        this.surfaceSet[n4].set(n);
        this.surfaceSet[n4].set(n2);
        this.surfaceSet[n4].set(n3);
        if (n4 == this.nSets) {
            ++this.nSets;
        }
    }

    private void mergeSets(int n, int n2) {
        this.surfaceSet[n].or(this.surfaceSet[n2]);
        this.surfaceSet[n2] = null;
    }

    public void invalidateSurfaceSet(int n) {
        int n2 = this.surfaceSet[n].nextSetBit(0);
        while (n2 >= 0) {
            this.vvs[n2] = Float.NaN;
            n2 = this.surfaceSet[n].nextSetBit(n2 + 1);
        }
        this.surfaceSet[n] = null;
    }

    public static boolean checkCutoff(int n, int n2, int n3, float[] fArray) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            return false;
        }
        float f = fArray[n];
        float f2 = fArray[n2];
        float f3 = fArray[n3];
        return f >= 0.0f && f2 >= 0.0f && f3 >= 0.0f || f <= 0.0f && f2 <= 0.0f && f3 <= 0.0f;
    }

    public static Object calculateVolumeOrArea(MeshData meshData, int n, boolean bl, boolean bl2) {
        if (bl2 || meshData.nSets <= 0) {
            meshData.getSurfaceSet();
        }
        boolean bl3 = n >= -1;
        int n2 = bl3 || meshData.nSets <= 0 ? 1 : meshData.nSets;
        double[] dArray = new double[n2];
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n3 = meshData.pc;
        while (--n3 >= 0) {
            int n4;
            if (meshData.setABC(n3) == null) continue;
            int n5 = n4 = meshData.nSets <= 0 ? 0 : meshData.vertexSets[meshData.iA];
            if (n >= 0 && n4 != n) continue;
            if (bl) {
                v3.sub2(meshData.vs[meshData.iB], meshData.vs[meshData.iA]);
                v32.sub2(meshData.vs[meshData.iC], meshData.vs[meshData.iA]);
                v33.cross(v3, v32);
                int n6 = bl3 ? 0 : n4;
                dArray[n6] = dArray[n6] + (double)v33.length();
                continue;
            }
            v3.setT(meshData.vs[meshData.iB]);
            v32.setT(meshData.vs[meshData.iC]);
            v33.cross(v3, v32);
            v32.setT(meshData.vs[meshData.iA]);
            int n7 = bl3 ? 0 : n4;
            dArray[n7] = dArray[n7] + (double)v32.dot(v33);
        }
        double d = bl ? 2 : 6;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = n8++;
            dArray[n9] = dArray[n9] / d;
        }
        if (bl3) {
            return Float.valueOf((float)dArray[0]);
        }
        return dArray;
    }

    public void updateInvalidatedVertices(BS bS) {
        bS.clearAll();
        int n = 0;
        while (n < this.vc) {
            if (Float.isNaN(this.vvs[n])) {
                bS.set(n);
            }
            n += this.vertexIncrement;
        }
    }

    public void invalidateVertices(BS bS) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.vvs[n] = Float.NaN;
            n = bS.nextSetBit(n + 1);
        }
    }

    private class SSet {
        BS bs;
        int n;

        protected SSet(BS bS) {
            this.bs = bS;
            this.n = bS.cardinality();
        }
    }

    protected class SortSet
    implements Comparator<SSet> {
        protected SortSet() {
        }

        @Override
        public int compare(SSet sSet, SSet sSet2) {
            return sSet.n > sSet2.n ? -1 : (sSet.n < sSet2.n ? 1 : 0);
        }
    }
}

