/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.ForceFieldMMFF;
import org.jmol.minimize.forcefield.MMFFAngleCalc;
import org.jmol.minimize.forcefield.MMFFDistanceCalc;
import org.jmol.minimize.forcefield.MMFFESCalc;
import org.jmol.minimize.forcefield.MMFFOOPCalc;
import org.jmol.minimize.forcefield.MMFFSBCalc;
import org.jmol.minimize.forcefield.MMFFTorsionCalc;
import org.jmol.minimize.forcefield.MMFFVDWCalc;

class CalculationsMMFF
extends Calculations {
    static final double FPAR = 143.9325;
    public static final int DA_D = 68;
    public static final int DA_DA = 133;
    Calculation bondCalc;
    Calculation angleCalc;
    Calculation torsionCalc;
    Calculation oopCalc;
    Calculation vdwCalc;
    Calculation esCalc;
    Calculation sbCalc;
    ForceFieldMMFF mmff;

    CalculationsMMFF(ForceField forceField, Map<Object, Object> map, MinAtom[] minAtomArray, MinBond[] minBondArray, MinAngle[] minAngleArray, MinTorsion[] minTorsionArray, MinPosition[] minPositionArray, Lst<Object[]> lst) {
        super(forceField, minAtomArray, minBondArray, minAngleArray, minTorsionArray, minPositionArray, lst);
        this.mmff = (ForceFieldMMFF)forceField;
        this.ffParams = map;
        this.bondCalc = new MMFFDistanceCalc().set(this);
        this.angleCalc = new MMFFAngleCalc().set(this);
        this.sbCalc = new MMFFSBCalc().set(this);
        this.torsionCalc = new MMFFTorsionCalc().set(this);
        this.oopCalc = new MMFFOOPCalc().set(this);
        this.vdwCalc = new MMFFVDWCalc().set(this);
        this.esCalc = new MMFFESCalc().set(this);
    }

    @Override
    String getUnits() {
        return "kcal";
    }

    @Override
    boolean setupCalculations() {
        MMFFDistanceCalc mMFFDistanceCalc = (MMFFDistanceCalc)new MMFFDistanceCalc().set(this);
        Lst<Object> lst = this.calculations[0] = new Lst<Object[]>();
        int n = 0;
        while (n < this.bondCount) {
            mMFFDistanceCalc.setData(lst, this.minBonds[n]);
            ++n;
        }
        this.calculations[1] = new Lst();
        lst = this.calculations[1];
        MMFFAngleCalc mMFFAngleCalc = (MMFFAngleCalc)new MMFFAngleCalc().set(this);
        int n2 = 0;
        while (n2 < this.angleCount) {
            mMFFAngleCalc.setData(lst, this.minAngles[n2]);
            ++n2;
        }
        this.calculations[2] = new Lst();
        lst = this.calculations[2];
        MMFFSBCalc mMFFSBCalc = (MMFFSBCalc)new MMFFSBCalc().set(this);
        int n3 = 0;
        while (n3 < this.angleCount) {
            mMFFSBCalc.setData(lst, this.minAngles[n3]);
            ++n3;
        }
        this.calculations[3] = new Lst();
        lst = this.calculations[3];
        MMFFTorsionCalc mMFFTorsionCalc = (MMFFTorsionCalc)new MMFFTorsionCalc().set(this);
        int n4 = 0;
        while (n4 < this.torsionCount) {
            mMFFTorsionCalc.setData(lst, this.minTorsions[n4]);
            ++n4;
        }
        this.calculations[4] = new Lst();
        lst = this.calculations[4];
        MMFFOOPCalc mMFFOOPCalc = (MMFFOOPCalc)new MMFFOOPCalc().set(this);
        int n5 = 0;
        while (n5 < this.ac) {
            if (CalculationsMMFF.isInvertible(this.minAtoms[n5])) {
                mMFFOOPCalc.setData(lst, n5);
            }
            ++n5;
        }
        this.calculations[5] = new Lst<Object[]>();
        this.calculations[6] = new Lst<Object[]>();
        this.pairSearch(this.calculations[5], new MMFFVDWCalc().set(this), this.calculations[6], new MMFFESCalc().set(this));
        return true;
    }

    @Override
    protected boolean isLinear(int n) {
        return MinAtom.isLinear(this.minAtoms[n]);
    }

    private static boolean isInvertible(MinAtom minAtom) {
        switch (minAtom.ffType) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 10: 
            case 30: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 63: 
            case 64: 
            case 67: 
            case 69: 
            case 78: 
            case 80: 
            case 81: 
        }
        return true;
    }

    @Override
    double compute(int n, Object[] objectArray) {
        switch (n) {
            case 0: {
                return this.bondCalc.compute(objectArray);
            }
            case 1: {
                return this.angleCalc.compute(objectArray);
            }
            case 2: {
                return this.sbCalc.compute(objectArray);
            }
            case 3: {
                return this.torsionCalc.compute(objectArray);
            }
            case 4: {
                return this.oopCalc.compute(objectArray);
            }
            case 5: {
                return this.vdwCalc.compute(objectArray);
            }
            case 6: {
                return this.esCalc.compute(objectArray);
            }
        }
        return 0.0;
    }

    @Override
    Object getParameterObj(MinObject minObject) {
        return minObject.key == null || minObject.ddata != null ? minObject.ddata : (double[])this.ffParams.get(minObject.key);
    }

    @Override
    String getDebugHeader(int n) {
        switch (n) {
            case -1: {
                return "MMFF94 Force Field -- T. A. Halgren, J. Comp. Chem. 5 & 6 490-519ff (1996).\n";
            }
            case 3: {
                return "\nT O R S I O N A L (" + this.minTorsions.length + " torsions)\n\n" + "      ATOMS           ATOM TYPES          TORSION\n" + "  I   J   K   L   I     J     K     L      ANGLE       V1       V2       V3     ENERGY\n" + "--------------------------------------------------------------------------------------\n";
            }
        }
        return this.getDebugHeader2(n);
    }

    @Override
    String getDebugLine(int n, Calculation calculation) {
        float f = this.ff.toUserUnits(calculation.energy);
        switch (n) {
            case 1: 
            case 2: {
                return PT.sprintf("%11s  %-5s %-5s %-5s  %8.3f  %8.3f     %8.3f   %8.3f", "ssssFI", new Object[]{MinObject.decodeKey(calculation.key), this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, this.minAtoms[calculation.ic].sType, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[1], (float)calculation.dData[0], f}, new int[]{this.minAtoms[calculation.ia].atom.getAtomNumber(), this.minAtoms[calculation.ib].atom.getAtomNumber(), this.minAtoms[calculation.ic].atom.getAtomNumber()}});
            }
            case 3: {
                return PT.sprintf("%15s  %-5s %-5s %-5s %-5s  %8.3f %8.3f %8.3f %8.3f %8.3f", "sssssF", new Object[]{MinObject.decodeKey(calculation.key), this.minAtoms[calculation.ia].sType, this.minAtoms[calculation.ib].sType, this.minAtoms[calculation.ic].sType, this.minAtoms[calculation.id].sType, new float[]{(float)(calculation.theta * 57.29577951308232), (float)calculation.dData[0], (float)calculation.dData[1], (float)calculation.dData[2], f}});
            }
        }
        return this.getDebugLineC(n, calculation);
    }
}

