/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Atom
extends Point3fi
implements Node {
    public static final int ATOM_INFRAME = 1;
    public static final int ATOM_VISSET = 2;
    public static final int ATOM_VISIBLE = 4;
    public static final int ATOM_NOTHIDDEN = 8;
    public static final int ATOM_NOFLAGS = -64;
    public static final int ATOM_INFRAME_NOTHIDDEN = 9;
    public static final int ATOM_SHAPE_VIS_MASK = -10;
    public static final int RADIUS_MAX = 16;
    public static final float RADIUS_GLOBAL = 16.1f;
    public static short MAD_GLOBAL = (short)32200;
    public char altloc = '\u0000';
    public byte atomID;
    public int atomSite;
    public Group group;
    private float userDefinedVanDerWaalRadius;
    byte valence;
    private short atomicAndIsotopeNumber;
    public BS atomSymmetry;
    private int formalChargeAndFlags;
    private static final int CHARGE_OFFSET = 24;
    private static final int FLAG_MASK = 15;
    private static final int VIBRATION_VECTOR_FLAG = 1;
    private static final int IS_HETERO_FLAG = 2;
    private static final int CIP_CHIRALITY_OFFSET = 4;
    private static final int CIP_CHIRALITY_MASK = 496;
    private static final int CIP_CHIRALITY_RULE_OFFSET = 9;
    private static final int CIP_CHIRALITY_RULE_MASK = 3584;
    private static final int CIP_MASK = 4080;
    public short madAtom;
    public short colixAtom;
    public byte paletteID;
    public Bond[] bonds;
    private int nBondsDisplayed;
    public int nBackbonesDisplayed;
    public int clickabilityFlags;
    public int shapeVisibilityFlags;

    public Atom() {
        this.paletteID = PAL.CPK.id;
        this.nBondsDisplayed = 0;
        this.nBackbonesDisplayed = 0;
    }

    public Atom setAtom(int n, int n2, P3 p3, float f, BS bS, int n3, short s, int n4, boolean bl) {
        this.mi = (short)n;
        this.atomSymmetry = bS;
        this.atomSite = n3;
        this.i = n2;
        this.atomicAndIsotopeNumber = s;
        if (bl) {
            this.formalChargeAndFlags = 2;
        }
        if (n4 != 0 && n4 != Integer.MIN_VALUE) {
            this.setFormalCharge(n4);
        }
        this.userDefinedVanDerWaalRadius = f;
        this.setT(p3);
        return this;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    public boolean isCovalentlyBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (!this.bonds[n].isCovalent() || this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(atom) == null) continue;
                return this.bonds[n];
            }
        }
        return null;
    }

    void addDisplayedBond(int n, boolean bl) {
        this.nBondsDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, this.nBondsDisplayed > 0);
    }

    void deleteBond(Bond bond) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n] != bond) continue;
                this.deleteBondAt(n);
                return;
            }
        }
    }

    private void deleteBondAt(int n) {
        this.setCIPChirality(0);
        int n2 = this.bonds.length - 1;
        if (n2 == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondArray = new Bond[n2];
        int n3 = 0;
        while (n3 < n) {
            bondArray[n3] = this.bonds[n3];
            ++n3;
        }
        while (n3 < n2) {
            bondArray[n3] = this.bonds[n3 + 1];
            ++n3;
        }
        this.bonds = bondArray;
    }

    @Override
    public int getBondedAtomIndex(int n) {
        return this.bonds[n].getOtherAtom((Atom)this).i;
    }

    public void setMadAtom(Viewer viewer, RadiusData radiusData) {
        this.madAtom = this.calculateMad(viewer, radiusData);
    }

    public short calculateMad(Viewer viewer, RadiusData radiusData) {
        if (radiusData == null) {
            return 0;
        }
        float f = radiusData.value;
        if (f == 0.0f) {
            return 0;
        }
        switch (radiusData.factorType) {
            case SCREEN: {
                return (short)f;
            }
            case OFFSET: 
            case FACTOR: {
                float f2 = 0.0f;
                switch (radiusData.vdwType) {
                    case TEMP: {
                        float f3 = viewer.ms.getBfactor100Hi();
                        f2 = f3 > 0.0f ? (float)this.getBfactor100() / f3 : 0.0f;
                        break;
                    }
                    case HYDRO: {
                        f2 = Math.abs(this.getHydrophobicity());
                        break;
                    }
                    case BONDING: {
                        f2 = this.getBondingRadius();
                        break;
                    }
                    case ADPMAX: 
                    case ADPMIN: {
                        f2 = this.getADPMinMax(radiusData.vdwType == VDW.ADPMAX);
                        break;
                    }
                    default: {
                        f2 = this.getVanderwaalsRadiusFloat(viewer, radiusData.vdwType);
                    }
                }
                if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
                    f *= f2;
                    break;
                }
                f += f2;
                break;
            }
            case ABSOLUTE: {
                if (f != 16.1f) break;
                return MAD_GLOBAL;
            }
        }
        short s = (short)(f < 0.0f ? f : f * 2000.0f);
        if (s < 0 && f > 0.0f) {
            s = 0;
        }
        return s;
    }

    public float getADPMinMax(boolean bl) {
        Object[] objectArray = this.getTensors();
        if (objectArray == null) {
            return 0.0f;
        }
        Tensor tensor = (Tensor)objectArray[0];
        if (tensor == null || tensor.iType != 1) {
            return 0.0f;
        }
        if (this.group.chain.model.ms.isModulated(this.i) && tensor.isUnmodulated) {
            tensor = (Tensor)objectArray[1];
        }
        return tensor.getFactoredValue(bl ? 2 : 1);
    }

    public Object[] getTensors() {
        return this.group.chain.model.ms.getAtomTensorList(this.i);
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    @Override
    public Edge[] getEdges() {
        return this.bonds == null ? new Edge[]{} : this.bonds;
    }

    @Override
    public int getBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colixAtom = C.getColixTranslucent3(this.colixAtom, bl, f);
    }

    @Override
    public int getElementNumber() {
        return Elements.getElementNumber(this.atomicAndIsotopeNumber);
    }

    @Override
    public int getIsotopeNumber() {
        return Elements.getIsotopeNumber(this.atomicAndIsotopeNumber);
    }

    @Override
    public int getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    public void setAtomicAndIsotopeNumber(int n) {
        if (n < 0 || (n & 0x7F) >= Elements.elementNumberMax || n > Short.MAX_VALUE) {
            n = 0;
        }
        this.atomicAndIsotopeNumber = (short)n;
    }

    public String getElementSymbolIso(boolean bl) {
        return Elements.elementSymbolFromNumber(bl ? this.atomicAndIsotopeNumber : this.atomicAndIsotopeNumber & 0x7F);
    }

    public String getElementSymbol() {
        return this.getElementSymbolIso(true);
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 2) != 0;
    }

    public boolean hasVibration() {
        return (this.formalChargeAndFlags & 1) != 0;
    }

    public void setFormalCharge(int n) {
        this.formalChargeAndFlags = this.formalChargeAndFlags & 0xF | (n == Integer.MIN_VALUE ? 0 : (n > 7 ? 7 : (n < -3 ? -3 : n))) << 24;
    }

    void setVibrationVector() {
        this.formalChargeAndFlags |= 1;
    }

    @Override
    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 24;
    }

    public int getOccupancy100() {
        float[] fArray = this.group.chain.model.ms.occupancies;
        return fArray == null ? 100 : Math.round(fArray[this.i]);
    }

    public boolean isOccupied() {
        float[] fArray = this.group.chain.model.ms.occupancies;
        return fArray == null || fArray[this.i] >= 50.0f;
    }

    public int getBfactor100() {
        short[] sArray = this.group.chain.model.ms.bfactor100s;
        return sArray == null ? 0 : sArray[this.i];
    }

    public float getHydrophobicity() {
        float[] fArray = this.group.chain.model.ms.hydrophobicities;
        return fArray == null ? Elements.getHydrophobicity(this.group.groupID) : fArray[this.i];
    }

    public boolean setRadius(float f) {
        this.userDefinedVanDerWaalRadius = f > 0.0f ? f : Float.NaN;
        return !Float.isNaN(this.userDefinedVanDerWaalRadius);
    }

    public void delete(BS bS) {
        this.valence = (byte)-1;
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                Bond bond = this.bonds[n];
                bond.getOtherAtom(this).deleteBond(bond);
                bS.set(bond.index);
            }
        }
        this.bonds = null;
    }

    @Override
    public boolean isDeleted() {
        return this.valence < 0;
    }

    public void setValence(int n) {
        if (!this.isDeleted()) {
            this.valence = (byte)(n < 0 ? 0 : (n <= 127 ? n : 127));
        }
    }

    @Override
    public int getValence() {
        if (this.isDeleted()) {
            return -1;
        }
        int n = this.valence;
        if (n == 0 && this.bonds != null) {
            int n2 = this.bonds.length;
            while (--n2 >= 0) {
                n += this.bonds[n2].getValence();
            }
        }
        return n;
    }

    @Override
    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            if ((bond.order & 0x3FF) == 0 || bond.getOtherAtom(this).isDeleted()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 0x3FF) == 0) continue;
            Atom atom = this.bonds[n2].getOtherAtom(this);
            if (atom.valence < 0 || atom.getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getImplicitHydrogenCount() {
        return this.group.chain.model.ms.getMissingHydrogenCount(this, false);
    }

    @Override
    public int getTotalHydrogenCount() {
        return this.getCovalentHydrogenCount() + this.getImplicitHydrogenCount();
    }

    @Override
    public int getTotalValence() {
        int n = this.getValence();
        if (n < 0) {
            return n;
        }
        int n2 = this.getImplicitHydrogenCount();
        int n3 = this.group.chain.model.ms.aaRet[4];
        return n + n2 + n3;
    }

    @Override
    public int getCovalentBondCountPlusMissingH() {
        return this.getCovalentBondCount() + this.getImplicitHydrogenCount();
    }

    int getTargetValence() {
        switch (this.getElementNumber()) {
            case 6: 
            case 14: 
            case 32: {
                return 4;
            }
            case 5: 
            case 7: 
            case 15: {
                return 3;
            }
            case 8: 
            case 16: {
                return 2;
            }
            case 1: 
            case 9: 
            case 17: 
            case 35: 
            case 53: {
                return 1;
            }
        }
        return -1;
    }

    public float getDimensionValue(int n) {
        return n == 0 ? this.x : (n == 1 ? this.y : this.z);
    }

    public float getVanderwaalsRadiusFloat(Viewer viewer, VDW vDW) {
        return Float.isNaN(this.userDefinedVanDerWaalRadius) ? (float)viewer.getVanderwaalsMarType(this.atomicAndIsotopeNumber, this.getVdwType(vDW)) / 1000.0f : this.userDefinedVanDerWaalRadius;
    }

    private VDW getVdwType(VDW vDW) {
        switch (vDW) {
            case AUTO: {
                vDW = this.group.chain.model.ms.getDefaultVdwType(this.mi);
                break;
            }
            case NOJMOL: {
                vDW = this.group.chain.model.ms.getDefaultVdwType(this.mi);
                if (vDW != VDW.AUTO_JMOL) break;
                vDW = VDW.AUTO_BABEL;
            }
        }
        return vDW;
    }

    public float getBondingRadius() {
        float[] fArray = this.group.chain.model.ms.bondingRadii;
        float f = fArray == null ? 0.0f : fArray[this.i];
        return f == 0.0f ? Elements.getBondingRadius(this.atomicAndIsotopeNumber, this.getFormalCharge()) : f;
    }

    float getVolume(Viewer viewer, VDW vDW) {
        float f;
        float f2 = f = vDW == null ? this.userDefinedVanDerWaalRadius : Float.NaN;
        if (Float.isNaN(f)) {
            f = (float)viewer.getVanderwaalsMarType(this.getElementNumber(), this.getVdwType(vDW)) / 1000.0f;
        }
        double d = 0.0;
        if (this.bonds != null) {
            int n = 0;
            while (n < this.bonds.length) {
                if (this.bonds[n].isCovalent()) {
                    float f3;
                    float f4;
                    Atom atom = this.bonds[n].getOtherAtom(this);
                    float f5 = f4 = vDW == null ? atom.userDefinedVanDerWaalRadius : Float.NaN;
                    if (Float.isNaN(f4)) {
                        f4 = (float)viewer.getVanderwaalsMarType(atom.getElementNumber(), atom.getVdwType(vDW)) / 1000.0f;
                    }
                    if (!((f3 = this.distance(atom)) > f + f4)) {
                        if (f3 + f <= f4) {
                            return 0.0f;
                        }
                        double d2 = (double)f - (double)(f * f + f3 * f3 - f4 * f4) / (2.0 * (double)f3);
                        d -= 1.0471975511965976 * d2 * d2 * ((double)(3.0f * f) - d2);
                    }
                }
                ++n;
            }
        }
        return (float)(d + 4.1887902047863905 * (double)f * (double)f * (double)f);
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    @Override
    public int getIndex() {
        return this.i;
    }

    @Override
    public int getAtomSite() {
        return this.atomSite;
    }

    @Override
    public void getGroupBits(BS bS) {
        this.group.setAtomBits(bS);
    }

    @Override
    public String getAtomName() {
        return this.atomID > 0 ? Group.specialAtomNames[this.atomID] : this.group.chain.model.ms.atomNames[this.i];
    }

    @Override
    public String getAtomType() {
        String[] stringArray = this.group.chain.model.ms.atomTypes;
        String string = stringArray == null ? null : stringArray[this.i];
        return string == null ? this.getAtomName() : string;
    }

    @Override
    public int getAtomNumber() {
        int[] nArray = this.group.chain.model.ms.atomSerials;
        return nArray == null ? this.i : nArray[this.i];
    }

    public int getSeqID() {
        int[] nArray = this.group.chain.model.ms.atomSeqIDs;
        return nArray == null ? 0 : nArray[this.i];
    }

    public boolean isVisible(int n) {
        return (this.shapeVisibilityFlags & n) == n;
    }

    public float getPartialCharge() {
        float[] fArray = this.group.chain.model.ms.partialCharges;
        return fArray == null ? 0.0f : fArray[this.i];
    }

    public int getSymmetryTranslation(int n, int[] nArray, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (this.atomSymmetry.get(n3 += n2)) {
                return nArray[n4];
            }
            ++n4;
        }
        return 0;
    }

    public int getCellTranslation(int n, int[] nArray, int n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5 = 0;
            while (n5 < n2) {
                if (this.atomSymmetry.get(n3) && nArray[n4] == n) {
                    return nArray[n4];
                }
                ++n5;
                ++n3;
            }
            ++n4;
        }
        return 0;
    }

    String getSymmetryOperatorList(boolean bl) {
        String string = "";
        ModelSet modelSet = this.group.chain.model.ms;
        int n = modelSet.getModelSymmetryCount(this.mi);
        if (n == 0 || this.atomSymmetry == null) {
            return "";
        }
        int[] nArray = modelSet.getModelCellRange(this.mi);
        int n2 = n;
        int n3 = nArray == null ? 1 : nArray.length;
        BS bS = bl ? null : new BS();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n) {
                if (this.atomSymmetry.get(n2++)) {
                    if (bl) {
                        string = String.valueOf(string) + "," + (n5 + 1) + nArray[n4];
                    } else {
                        bS.set(n5 + 1);
                    }
                }
                ++n5;
            }
            ++n4;
        }
        if (!bl) {
            n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                string = String.valueOf(string) + "," + n4;
                n4 = bS.nextSetBit(n4 + 1);
            }
        }
        return string.length() == 0 ? "" : string.substring(1);
    }

    @Override
    public int getModelIndex() {
        return this.mi;
    }

    @Override
    public int getMoleculeNumber(boolean bl) {
        return this.group.chain.model.ms.getMoleculeIndex(this.i, bl) + 1;
    }

    private float getFractionalCoord(boolean bl, char c, boolean bl2, P3 p3) {
        p3 = this.getFractionalCoordPt(bl, bl2, p3);
        return c == 'X' ? p3.x : (c == 'Y' ? p3.y : p3.z);
    }

    @Override
    public P3 getXYZ() {
        return this;
    }

    public P3 getFractionalCoordPt(boolean bl, boolean bl2, P3 p3) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface == null) {
            return this;
        }
        if (p3 == null) {
            p3 = P3.newP(this);
        } else {
            p3.setT(this);
        }
        symmetryInterface.toFractional(p3, bl2);
        if (bl) {
            PT.fixPtFloats(p3, 100000.0f);
        }
        return p3;
    }

    SymmetryInterface getUnitCell() {
        return this.group.chain.model.ms.getUnitCellForAtom(this.i);
    }

    private float getFractionalUnitCoord(boolean bl, char c, P3 p3) {
        p3 = this.getFractionalUnitCoordPt(bl, false, p3);
        return c == 'X' ? p3.x : (c == 'Y' ? p3.y : p3.z);
    }

    P3 getFractionalUnitCoordPt(boolean bl, boolean bl2, P3 p3) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface == null) {
            return this;
        }
        if (p3 == null) {
            p3 = P3.newP(this);
        } else {
            p3.setT(this);
        }
        if (this.group.chain.model.isJmolDataFrame) {
            symmetryInterface.toFractional(p3, false);
            if (bl2) {
                symmetryInterface.toCartesian(p3, false);
            }
        } else {
            symmetryInterface.toUnitCell(p3, null);
            if (!bl2) {
                symmetryInterface.toFractional(p3, false);
            }
        }
        if (bl) {
            PT.fixPtFloats(p3, bl2 ? 10000.0f : 100000.0f);
        }
        return p3;
    }

    float getFractionalUnitDistance(T3 t3, T3 t32, T3 t33) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface == null) {
            return this.distance(t3);
        }
        t32.setT(this);
        t33.setT(t3);
        if (this.group.chain.model.isJmolDataFrame) {
            symmetryInterface.toFractional(t32, true);
            symmetryInterface.toFractional(t33, true);
        } else {
            symmetryInterface.toUnitCell(t32, null);
            symmetryInterface.toUnitCell(t33, null);
        }
        return t32.distance(t33);
    }

    void setFractionalCoord(int n, float f, boolean bl) {
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toFractional(this, bl);
        }
        switch (n) {
            case 1111492612: 
            case 1111492615: {
                this.x = f;
                break;
            }
            case 1111492613: 
            case 1111492616: {
                this.y = f;
                break;
            }
            case 1111492614: 
            case 1111492617: {
                this.z = f;
            }
        }
        if (symmetryInterface != null) {
            symmetryInterface.toCartesian(this, bl);
        }
    }

    void setFractionalCoordTo(P3 p3, boolean bl) {
        this.setFractionalCoordPt(this, p3, bl);
    }

    public void setFractionalCoordPt(P3 p3, P3 p32, boolean bl) {
        p3.setT(p32);
        SymmetryInterface symmetryInterface = this.getUnitCell();
        if (symmetryInterface != null) {
            symmetryInterface.toCartesian(p3, bl && !this.group.chain.model.isJmolDataFrame);
        }
    }

    boolean isCursorOnTopOf(int n, int n2, int n3, Atom atom) {
        int n4;
        int n5;
        int n6;
        int n7 = this.sD / 2;
        if (n7 < n3) {
            n7 = n3;
        }
        if ((n6 = (n5 = this.sX - n) * n5) > (n4 = n7 * n7)) {
            return false;
        }
        int n8 = this.sY - n2;
        int n9 = n8 * n8;
        int n10 = n4 - (n6 + n9);
        if (n10 < 0) {
            return false;
        }
        if (atom == null) {
            return true;
        }
        int n11 = this.sZ;
        int n12 = atom.sZ;
        int n13 = atom.sD / 2;
        if (n11 < n12 - n13) {
            return true;
        }
        int n14 = atom.sX - n;
        int n15 = n14 * n14;
        int n16 = atom.sY - n2;
        int n17 = n16 * n16;
        int n18 = n13 * n13;
        int n19 = n18 - (n15 + n17);
        return (double)n11 - Math.sqrt(n10) < (double)n12 - Math.sqrt(n19);
    }

    public String getInfo() {
        return this.getIdentity(true);
    }

    public String getIdentityXYZ(boolean bl, P3 p3) {
        p3 = this.group.chain.model.isJmolDataFrame ? this.getFractionalCoordPt(!this.group.chain.model.ms.vwr.g.legacyJavaFloat, false, p3) : this;
        return String.valueOf(this.getIdentity(bl)) + " " + p3.x + " " + p3.y + " " + p3.z;
    }

    String getIdentity(boolean bl) {
        SB sB = new SB();
        String string = this.getGroup3(true);
        if (string != null && string.length() > 0 && (!string.equals("UNK") || this.group.chain.model.isBioModel)) {
            int n;
            sB.append("[");
            sB.append(string);
            sB.append("]");
            String string2 = this.group.getSeqcodeString();
            if (string2 != null) {
                sB.append(string2);
            }
            if ((n = this.group.chain.chainID) != 0 && n != 32) {
                sB.append(":");
                String string3 = this.getChainIDStr();
                if (n >= 256) {
                    string3 = PT.esc(string3);
                }
                sB.append(string3);
            }
            if (!bl) {
                return sB.toString();
            }
            sB.append(".");
        }
        sB.append(this.getAtomName());
        if (sB.length() == 0) {
            sB.append(this.getElementSymbolIso(false));
            sB.append(" ");
            sB.appendI(this.getAtomNumber());
        }
        if (this.altloc != '\u0000') {
            sB.append("%");
            sB.appendC(this.altloc);
        }
        if (this.group.chain.model.ms.mc > 1 && !this.group.chain.model.isJmolDataFrame) {
            sB.append("/");
            sB.append(this.getModelNumberForLabel());
        }
        sB.append(" #");
        sB.appendI(this.getAtomNumber());
        return sB.toString();
    }

    @Override
    public String getGroup3(boolean bl) {
        String string = this.group.getGroup3();
        return bl || string != null && string.length() > 0 ? string : "UNK";
    }

    @Override
    public String getGroup1(char c) {
        char c2 = this.group.getGroup1();
        return c2 != '\u0000' ? "" + c2 : (c != '\u0000' ? "" + c : "");
    }

    @Override
    public char getBioSmilesType() {
        return (char)(this.group.isProtein() ? 112 : (this.group.isDna() ? 100 : (this.group.isRna() ? 114 : (this.group.isCarbohydrate() ? 99 : 32))));
    }

    @Override
    public boolean isPurine() {
        return this.group.isPurine();
    }

    @Override
    public boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    @Override
    public int getResno() {
        return this.group.getResno();
    }

    public boolean isClickable() {
        return this.checkVisible() && this.clickabilityFlags != 0 && ((this.shapeVisibilityFlags | this.group.shapeVisibilityFlags) & this.clickabilityFlags) != 0;
    }

    public void setClickable(int n) {
        if (n == 0) {
            this.clickabilityFlags = 0;
        } else {
            this.clickabilityFlags |= n;
            if (n != 1040384) {
                this.shapeVisibilityFlags |= n;
            }
        }
    }

    public boolean checkVisible() {
        if (this.isVisible(2)) {
            return this.isVisible(4);
        }
        boolean bl = this.isVisible(9);
        if (bl) {
            int n = this.shapeVisibilityFlags;
            if (this.group.shapeVisibilityFlags != 0 && (this.group.shapeVisibilityFlags != 8192 || this.isLeadAtom())) {
                n |= this.group.shapeVisibilityFlags;
            }
            if ((n &= 0xFFFFFFF6) == 32 && this.clickabilityFlags == 0) {
                n = 0;
            }
            boolean bl2 = bl = n != 0;
            if (bl) {
                this.shapeVisibilityFlags |= 4;
            }
        }
        this.shapeVisibilityFlags |= 2;
        return bl;
    }

    @Override
    public boolean isLeadAtom() {
        return this.group.isLeadAtom(this.i);
    }

    @Override
    public int getChainID() {
        return this.group.chain.chainID;
    }

    @Override
    public String getChainIDStr() {
        return this.group.chain.getIDStr();
    }

    public int getSurfaceDistance100() {
        return this.group.chain.model.ms.getSurfaceDistance100(this.i);
    }

    public Vibration getVibrationVector() {
        return this.group.chain.model.ms.getVibration(this.i, false);
    }

    public JmolModulationSet getModulation() {
        return this.group.chain.model.ms.getModulation(this.i);
    }

    public String getModelNumberForLabel() {
        return this.group.chain.model.ms.getModelNumberForAtomLabel(this.mi);
    }

    public int getModelNumber() {
        return this.group.chain.model.ms.getModelNumber(this.mi) % 1000000;
    }

    @Override
    public String getBioStructureTypeName() {
        return this.group.getProteinStructureType().getBioStructureTypeName(true);
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int hashCode() {
        return this.i;
    }

    public Atom findAromaticNeighbor(int n) {
        if (this.bonds == null) {
            return null;
        }
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            Bond bond = this.bonds[n2];
            Atom atom = bond.getOtherAtom(this);
            if (!bond.isAromatic() || atom.i == n) continue;
            return atom;
        }
        return null;
    }

    public int atomPropertyInt(int n) {
        switch (n) {
            case 1094715393: {
                return this.getAtomNumber();
            }
            case 1094713365: {
                return this.getSeqID();
            }
            case 1094713346: {
                return this.atomID;
            }
            case 1094713368: {
                return Math.max(0, this.altloc - 32);
            }
            case 1094713347: {
                return this.i;
            }
            case 1228931587: {
                return this.getCovalentBondCount();
            }
            case 1094713351: {
                return this.group.chain.chainNo;
            }
            case 1765808134: {
                return this.group.chain.model.ms.vwr.gdata.getColorArgbOrGray(this.colixAtom);
            }
            case 1086326789: 
            case 1094715402: {
                return this.getElementNumber();
            }
            case 1094713353: {
                return this.atomicAndIsotopeNumber;
            }
            case 1228935687: {
                return this.group.chain.model.fileIndex + 1;
            }
            case 1631586315: {
                return this.getFormalCharge();
            }
            case 1094713356: {
                return this.group.groupID;
            }
            case 1094713357: {
                return this.group.groupIndex;
            }
            case 1094717454: {
                return this.getModelNumber();
            }
            case -1094717454: {
                return this.group.chain.model.ms.modelFileNumbers[this.mi];
            }
            case 1094713359: {
                return this.mi;
            }
            case 0x41400010: {
                return this.getMoleculeNumber(true);
            }
            case 0x41400011: {
                return this.group.getMonomerIndex() + 1;
            }
            case 1128269825: {
                return this.getOccupancy100();
            }
            case 1094713362: {
                return this.group.getBioPolymerIndexInModel() + 1;
            }
            case 1094713363: {
                return this.group.getBioPolymerLength();
            }
            case 1665140738: {
                return this.getRasMolRadius();
            }
            case 1094715412: {
                return this.getResno();
            }
            case 1094713366: {
                return this.getAtomSite();
            }
            case 1639976963: {
                return this.group.getProteinStructureType().getId();
            }
            case 1237320707: {
                return this.group.getProteinStructureSubType().getId();
            }
            case 1094713367: {
                return this.group.getStrucNo();
            }
            case 1296041986: {
                return this.getSymOp();
            }
            case 1094715417: {
                return this.getValence();
            }
        }
        return 0;
    }

    int getSymOp() {
        return this.atomSymmetry == null ? 0 : this.atomSymmetry.nextSetBit(0) + 1;
    }

    public float atomPropertyFloat(Viewer viewer, int n, P3 p3) {
        switch (n) {
            case 1111490561: {
                return this.getADPMinMax(true);
            }
            case 0x42400002: {
                return this.getADPMinMax(false);
            }
            case 1111492609: 
            case 1111492629: {
                return this.x;
            }
            case 1111492610: 
            case 1111492630: {
                return this.y;
            }
            case 1111492611: 
            case 1111492631: {
                return this.z;
            }
            case 1111490587: {
                return this.group.chain.model.ms.getAtomicDSSRData(this.i);
            }
            case 1112150019: 
            case 1112150020: 
            case 1112150021: 
            case 1112152066: 
            case 1112152070: 
            case 1112152071: 
            case 1112152073: 
            case 1112152074: 
            case 1112152076: 
            case 1112152078: 
            case 1114249217: 
            case 1649022989: {
                return viewer.shm.getAtomShapeValue(n, this.group, this.i);
            }
            case 1111492618: {
                return this.getBondingRadius();
            }
            case 1111490563: {
                return viewer.getNMRCalculation().getChemicalShift(this);
            }
            case 0x42400004: {
                return Elements.getCovalentRadius(this.atomicAndIsotopeNumber);
            }
            case 1111490565: 
            case 1111490574: 
            case 1111490576: {
                return this.group.getGroupParameter(n);
            }
            case 1111492612: 
            case 1111492615: {
                return this.getFractionalCoord(!viewer.g.legacyJavaFloat, 'X', false, p3);
            }
            case 1111492613: 
            case 1111492616: {
                return this.getFractionalCoord(!viewer.g.legacyJavaFloat, 'Y', false, p3);
            }
            case 1111492614: 
            case 1111492617: {
                return this.getFractionalCoord(!viewer.g.legacyJavaFloat, 'Z', false, p3);
            }
            case 1113589786: {
                return this.getHydrophobicity();
            }
            case 1111490566: {
                return viewer.getNMRCalculation().getMagneticShielding(this);
            }
            case 1111490567: {
                return this.getMass();
            }
            case 1128269825: {
                return (float)this.getOccupancy100() / 100.0f;
            }
            case 1111492619: {
                return this.getPartialCharge();
            }
            case 1111490568: 
            case 1111490569: 
            case 1111490570: {
                if (this.group.chain.model.isJmolDataFrame && this.group.chain.model.jmolFrameType.startsWith("plot ramachandran")) {
                    switch (n) {
                        case 1111490569: {
                            return this.getFractionalCoord(!viewer.g.legacyJavaFloat, 'X', false, p3);
                        }
                        case 1111490570: {
                            return this.getFractionalCoord(!viewer.g.legacyJavaFloat, 'Y', false, p3);
                        }
                        case 1111490568: {
                            if (!this.group.chain.model.isJmolDataFrame || !this.group.chain.model.jmolFrameType.equals("plot ramachandran")) break;
                            float f = this.getFractionalCoord(!viewer.g.legacyJavaFloat, 'Z', false, p3) - 180.0f;
                            return f < -180.0f ? 360.0f + f : f;
                        }
                    }
                }
                return this.group.getGroupParameter(n);
            }
            case 1112152075: 
            case 1665140738: {
                return this.getRadius();
            }
            case 1111490571: {
                return viewer.antialiased ? this.sX / 2 : this.sX;
            }
            case 1111490572: {
                return viewer.getScreenHeight() - (viewer.antialiased ? this.sY / 2 : this.sY);
            }
            case 1111490573: {
                return viewer.antialiased ? this.sZ / 2 : this.sZ;
            }
            case 1113589787: {
                return viewer.slm.isAtomSelected(this.i) ? 1 : 0;
            }
            case 1111490575: {
                viewer.ms.getSurfaceDistanceMax();
                return (float)this.getSurfaceDistance100() / 100.0f;
            }
            case 1111492620: {
                return (float)this.getBfactor100() / 100.0f;
            }
            case 1111490577: {
                return this.getFractionalUnitCoord(!viewer.g.legacyJavaFloat, 'X', p3);
            }
            case 1111490578: {
                return this.getFractionalUnitCoord(!viewer.g.legacyJavaFloat, 'Y', p3);
            }
            case 1111490579: {
                return this.getFractionalUnitCoord(!viewer.g.legacyJavaFloat, 'Z', p3);
            }
            case 1648363544: {
                return this.getVanderwaalsRadiusFloat(viewer, VDW.AUTO);
            }
            case 1648361473: {
                Vibration vibration = this.getVibrationVector();
                return vibration == null ? 0.0f : vibration.length() * viewer.getFloat(1648361473);
            }
            case 1111492626: {
                return this.getVib('x');
            }
            case 1111492627: {
                return this.getVib('y');
            }
            case 1111492628: {
                return this.getVib('z');
            }
            case 1111490583: {
                return this.getVib('X');
            }
            case 1111490584: {
                return this.getVib('Y');
            }
            case 1111490585: {
                return this.getVib('Z');
            }
            case 1111490586: {
                return this.getVib('O');
            }
            case 1111490580: {
                return this.getVib('1');
            }
            case 1111490581: {
                return this.getVib('2');
            }
            case 1111490582: {
                return this.getVib('3');
            }
            case 1312817669: {
                return this.getVolume(viewer, VDW.AUTO);
            }
            case 0x4440000E: 
            case 0x44400010: 
            case 1145047050: 
            case 1145047051: 
            case 1145047052: 
            case 1145047053: 
            case 1145047055: {
                T3 t3 = this.atomPropertyTuple(viewer, n, p3);
                return t3 == null ? -1.0f : t3.length();
            }
        }
        return this.atomPropertyInt(n);
    }

    public float getVib(char c) {
        return this.group.chain.model.ms.getVibCoord(this.i, c);
    }

    public int getNominalMass() {
        int n = this.getIsotopeNumber();
        return n > 0 ? n : Elements.getNaturalIsotope(this.getElementNumber());
    }

    @Override
    public float getMass() {
        float f = this.getIsotopeNumber();
        return f > 0.0f ? f : Elements.getAtomicMass(this.getElementNumber());
    }

    public String atomPropertyString(Viewer viewer, int n) {
        switch (n) {
            case 1086324739: {
                char c = this.altloc;
                return c == '\u0000' ? "" : "" + c;
            }
            case 1086326786: {
                return this.getAtomName();
            }
            case 1086326785: {
                return this.getAtomType();
            }
            case 1086326788: {
                return this.getChainIDStr();
            }
            case 1086324752: {
                return this.getCIPChirality(true);
            }
            case 1086324753: {
                return this.getCIPChiralityRule();
            }
            case 1086324744: {
                return this.getGroup1('?');
            }
            case 1086324747: {
                String string = this.group.getSeqcodeString();
                return string == null ? "" : string;
            }
            case 1086324743: {
                return this.getGroup1('\u0000');
            }
            case 1086324742: {
                return this.getGroup3(false);
            }
            case 1086326789: {
                return this.getElementSymbolIso(true);
            }
            case 1086324745: {
                return this.getIdentity(true);
            }
            case 1086324746: {
                char c = this.group.getInsertionCode();
                return c == '\u0000' ? "" : "" + c;
            }
            case 1287653388: 
            case 1825200146: {
                String string = (String)viewer.shm.getShapePropertyIndex(5, "label", this.i);
                if (string == null) {
                    string = "";
                }
                return string;
            }
            case 1639976963: {
                return this.group.getProteinStructureType().getBioStructureTypeName(false);
            }
            case 1237320707: {
                return this.group.getProteinStructureSubType().getBioStructureTypeName(false);
            }
            case 1086324749: {
                return this.group.getStructureId();
            }
            case 0x40C0000C: {
                return viewer.getHybridizationAndAxes(this.i, null, null, "d");
            }
            case 1086326798: {
                return this.getElementSymbolIso(false);
            }
            case 1088421903: {
                return this.getSymmetryOperatorList(true);
            }
        }
        return "";
    }

    @Override
    public String getCIPChirality(boolean bl) {
        int n = (this.formalChargeAndFlags & 0x1F0) >> 4;
        if (n == 0 && this.atomicAndIsotopeNumber > 1 && bl) {
            n = this.group.chain.model.ms.getAtomCIPChiralityCode(this);
            this.formalChargeAndFlags |= (n == 0 ? 3 : n) << 4;
        }
        return JC.getCIPChiralityName(n);
    }

    public String getCIPChiralityRule() {
        String string = this.getCIPChirality(true);
        int n = string.length() == 0 ? -1 : (this.formalChargeAndFlags & 0xE00) >> 9;
        return JC.getCIPRuleName(n + 1);
    }

    @Override
    public void setCIPChirality(int n) {
        this.formalChargeAndFlags = this.formalChargeAndFlags & 0xFFFFF00F | n << 4;
    }

    @Override
    public int getCIPChiralityCode() {
        return (this.formalChargeAndFlags & 0x1F0) >> 4;
    }

    @Override
    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    public T3 atomPropertyTuple(Viewer viewer, int n, P3 p3) {
        switch (n) {
            case 1073742329: {
                return P3.newP(this);
            }
            case 1145047051: {
                return this.getFractionalCoordPt(!viewer.g.legacyJavaFloat, false, p3);
            }
            case 1145047053: {
                return this.getFractionalCoordPt(!viewer.g.legacyJavaFloat, false, p3);
            }
            case 0x4440000E: {
                return this.group.chain.model.isJmolDataFrame ? this.getFractionalCoordPt(!viewer.g.legacyJavaFloat, false, p3) : this.getFractionalUnitCoordPt(!viewer.g.legacyJavaFloat, false, p3);
            }
            case 1145047052: {
                return P3.new3(viewer.antialiased ? this.sX / 2 : this.sX, viewer.getScreenHeight() - (viewer.antialiased ? this.sY / 2 : this.sY), viewer.antialiased ? this.sZ / 2 : this.sZ);
            }
            case 1145047055: {
                return this.getVibrationVector();
            }
            case 0x44400010: {
                JmolModulationSet jmolModulationSet = this.getModulation();
                return jmolModulationSet == null ? null : jmolModulationSet.getV3();
            }
            case 1145047050: {
                return this;
            }
            case 1765808134: {
                return CU.colorPtFromInt(this.group.chain.model.ms.vwr.gdata.getColorArgbOrGray(this.colixAtom), p3);
            }
        }
        return null;
    }

    @Override
    public int getOffsetResidueAtom(String string, int n) {
        return this.group.getAtomIndex(string, n);
    }

    @Override
    public boolean isCrossLinked(Node node) {
        return this.group.isCrossLinked(((Atom)node).group);
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> lst, boolean bl, boolean bl2) {
        return this.group.getCrossLinkVector(lst, bl, bl2);
    }

    @Override
    public String toString() {
        return this.getInfo();
    }

    @Override
    public BS findAtomsLike(String string) {
        return this.group.chain.model.ms.vwr.getAtomBitSet(string);
    }

    public String getUnitID(int n) {
        Model model = this.group.getModel();
        return model.isBioModel ? ((BioModel)model).getUnitID(this, n) : "";
    }

    @Override
    public float getFloatProperty(String string) {
        Object object = this.group.chain.model.ms.vwr.getDataObj(string, null, 1);
        float f = Float.NaN;
        if (object != null) {
            try {
                f = ((float[])object)[this.i];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }
}

