/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.JC;

public class Bond
extends Edge {
    public static final int myVisibilityFlag = JC.getShapeVisibilityFlag(1);
    public Atom atom1;
    public Atom atom2;
    public short mad;
    public short colix;
    public int shapeVisibilityFlags;

    public Bond(Atom atom, Atom atom2, int n, short s, short s2) {
        this.atom1 = atom;
        this.atom2 = atom2;
        this.colix = s2;
        this.setOrder(n);
        this.setMad(s);
    }

    public void setMad(short s) {
        this.mad = s;
        this.setShapeVisibility(s != 0);
    }

    void setShapeVisibility(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.shapeVisibilityFlags & myVisibilityFlag) != 0;
        if (bl2 == bl) {
            return;
        }
        this.atom1.addDisplayedBond(myVisibilityFlag, bl);
        this.atom2.addDisplayedBond(myVisibilityFlag, bl);
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= myVisibilityFlag) : (this.shapeVisibilityFlags &= ~myVisibilityFlag);
    }

    public String getIdentity() {
        return String.valueOf(this.index + 1) + " " + Edge.getBondOrderNumberFromOrder(this.order) + " " + this.atom1.getInfo() + " -- " + this.atom2.getInfo() + " " + this.atom1.distance(this.atom2);
    }

    @Override
    public boolean isCovalent() {
        return (this.order & 0x3FF) != 0;
    }

    @Override
    public boolean isHydrogen() {
        return Bond.isOrderH(this.order);
    }

    boolean isStereo() {
        return (this.order & 0x400) != 0;
    }

    boolean isPartial() {
        return (this.order & 0xE0) != 0;
    }

    boolean isAromatic() {
        return (this.order & 0x200) != 0;
    }

    public float getEnergy() {
        return 0.0f;
    }

    public int getValence() {
        return !this.isCovalent() ? 0 : (this.isPartial() || this.is(515) ? 1 : this.order & 7);
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = C.getColixTranslucent3(this.colix, bl, f);
    }

    public void setOrder(int n) {
        if (this.atom1.getElementNumber() == 16 && this.atom2.getElementNumber() == 16) {
            n |= 0x100;
        }
        if (n == 512) {
            n = 515;
        }
        this.order = n | this.order & 0x20000;
    }

    @Override
    public int getAtomIndex1() {
        return this.atom1.i;
    }

    @Override
    public int getAtomIndex2() {
        return this.atom2.i;
    }

    @Override
    public int getCovalentOrder() {
        return Edge.getCovalentBondOrder(this.order);
    }

    public Atom getOtherAtom(Atom atom) {
        return this.atom1 == atom ? this.atom2 : (this.atom2 == atom ? this.atom1 : null);
    }

    public boolean is(int n) {
        return (this.order & 0xFFFDFFFF) == n;
    }

    @Override
    public SimpleNode getOtherNode(SimpleNode simpleNode) {
        return this.atom1 == simpleNode ? this.atom2 : (this.atom2 == simpleNode || simpleNode == null ? this.atom1 : null);
    }

    public void setAtropisomerOptions(BS bS, BS bS2) {
        Atom atom;
        boolean bl = bS2.get(this.atom1.i);
        BS bS3 = bl ? bS2 : bS;
        BS bS4 = bl ? bS : bS2;
        int n = Integer.MAX_VALUE;
        Bond[] bondArray = this.atom1.bonds;
        int n2 = 0;
        while (n2 < bondArray.length) {
            atom = bondArray[n2].getOtherAtom(this.atom1);
            if (bS3.get(atom.i) && atom != this.atom2) break;
            ++n2;
        }
        if (n2 < bondArray.length) {
            bondArray = this.atom2.bonds;
            n = 0;
            while (n < bondArray.length) {
                atom = bondArray[n].getOtherAtom(this.atom2);
                if (bS4.get(atom.i) && atom != this.atom1) break;
                ++n;
            }
        }
        this.order = n2 > 2 || n >= bondArray.length || n > 2 ? 1 : Bond.getAtropismOrder(n2 + 1, n + 1);
    }

    @Override
    public String getCIPChirality(boolean bl) {
        return "";
    }

    @Override
    public void setCIPChirality(int n) {
    }

    public String toString() {
        return this.atom1 + " - " + this.atom2;
    }
}

