/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Map;
import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class Measurement {
    public String thisID;
    public ModelSet ms;
    public int index;
    public boolean isVisible = true;
    public boolean isHidden = false;
    public boolean isTrajectory = false;
    public boolean isValid = true;
    public short colix;
    public short labelColix = (short)-1;
    public int mad;
    public TickInfo tickInfo;
    public int traceX = Integer.MIN_VALUE;
    public int traceY;
    public int count;
    public int[] countPlusIndices = new int[5];
    public Point3fi[] pts;
    public float value;
    public String strFormat;
    public Text text;
    private Viewer vwr;
    private String strMeasurement;
    private String type;
    private boolean tainted;
    public A4 renderAxis;
    public P3 renderArc;
    public static final int NMR_NOT = 0;
    public static final int NMR_DC = 1;
    public static final int NMR_JC = 2;

    public boolean isTainted() {
        if (this.tainted) {
            this.tainted = false;
            if (!false) {
                return true;
            }
        }
        return false;
    }

    public Measurement setM(ModelSet modelSet, Measurement measurement, float f, short s, String string, int n) {
        this.ms = modelSet;
        this.index = n;
        this.vwr = modelSet.vwr;
        this.colix = s;
        this.strFormat = string;
        if (measurement != null) {
            this.tickInfo = measurement.tickInfo;
            this.pts = measurement.pts;
            this.mad = measurement.mad;
            this.thisID = measurement.thisID;
            this.text = measurement.text;
            if (this.thisID != null && this.text != null) {
                this.labelColix = this.text.colix;
            }
        }
        if (this.pts == null) {
            this.pts = new Point3fi[4];
        }
        int[] nArray = measurement == null ? null : measurement.countPlusIndices;
        int n2 = this.count = nArray == null ? 0 : nArray[0];
        if (this.count > 0) {
            System.arraycopy(nArray, 0, this.countPlusIndices, 0, this.count + 1);
            this.isTrajectory = modelSet.isTrajectoryMeasurement(this.countPlusIndices);
        }
        this.value = Float.isNaN(f) || this.isTrajectory ? this.getMeasurement(null) : f;
        this.formatMeasurement(null);
        return this;
    }

    public Measurement setPoints(ModelSet modelSet, int[] nArray, Point3fi[] point3fiArray, TickInfo tickInfo) {
        this.ms = modelSet;
        this.countPlusIndices = nArray;
        this.count = nArray[0];
        this.pts = point3fiArray == null ? new Point3fi[4] : point3fiArray;
        this.vwr = modelSet.vwr;
        this.tickInfo = tickInfo;
        return this;
    }

    public void setCount(int n) {
        this.setCountM(n);
    }

    protected void setCountM(int n) {
        this.count = this.countPlusIndices[0] = n;
    }

    public int getAtomIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public Point3fi getAtom(int n) {
        int n2 = this.countPlusIndices[n];
        return n2 < -1 ? this.pts[-2 - n2] : this.ms.at[n2];
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String getStringUsing(Viewer viewer, String string, String string2) {
        this.vwr = viewer;
        this.value = this.getMeasurement(null);
        this.formatMeasurementAs(string, string2, true);
        if (string == null) {
            return this.getInfoAsString(string2);
        }
        return this.strMeasurement;
    }

    public String getStringDetail() {
        return String.valueOf(this.count == 2 ? "Distance" : (this.count == 3 ? "Angle" : "Torsion")) + this.getMeasurementScript(" - ", false) + " : " + this.value;
    }

    public void refresh(Point3fi[] point3fiArray) {
        this.value = this.getMeasurement(point3fiArray);
        this.isTrajectory = this.ms.isTrajectoryMeasurement(this.countPlusIndices);
        this.formatMeasurement(null);
    }

    public String getMeasurementScript(String string, boolean bl) {
        SB sB = new SB();
        boolean bl2 = string.equals(" ");
        int n = 1;
        while (n <= this.count) {
            sB.append(n > 1 ? string : " ").append(this.getLabel(n, bl2, bl));
            ++n;
        }
        return sB.toString();
    }

    public void formatMeasurementAs(String string, String string2, boolean bl) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!bl && string != null && string.indexOf(String.valueOf(this.countPlusIndices[0]) + ":") != 0) {
            return;
        }
        this.strFormat = string;
        this.formatMeasurement(string2);
    }

    protected void formatMeasurement(String string) {
        this.tainted = true;
        switch (Float.isNaN(this.value) ? 0 : this.count) {
            default: {
                this.strMeasurement = null;
                return;
            }
            case 2: {
                this.strMeasurement = this.formatDistance(string);
                return;
            }
            case 3: 
            case 4: 
        }
        this.strMeasurement = this.formatAngle(this.value);
    }

    public void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        if (this.vwr.slm.isSelected(this.countPlusIndices[1]) && this.vwr.slm.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement(null);
        }
    }

    private String formatDistance(String string) {
        int n;
        String string2 = this.getLabelString();
        if (string2 == null) {
            return "";
        }
        if (string == null) {
            n = this.strFormat.indexOf("//");
            String string3 = string = n >= 0 ? this.strFormat.substring(n + 2) : null;
            if (string == null) {
                string = this.vwr.g.measureDistanceUnits;
                this.strFormat = String.valueOf(this.strFormat) + "//" + string;
            }
        }
        string = Measurement.fixUnits(string);
        n = string2.indexOf("//");
        if (n >= 0 && (string2 = string2.substring(0, n)).length() == 0) {
            string2 = "%VALUE";
        }
        float f = this.fixValue(string, string2.indexOf("%V") >= 0);
        return this.formatString(f, string, string2);
    }

    private static String fixUnits(String string) {
        if (string.equals("nanometers")) {
            return "nm";
        }
        if (string.equals("picometers")) {
            return "pm";
        }
        if (string.equals("angstroms")) {
            return "\u00c5";
        }
        if (string.equals("vanderwaals") || string.equals("vdw")) {
            return "%";
        }
        return string;
    }

    public float fixValue(String string, boolean bl) {
        if (this.count != 2) {
            return this.value;
        }
        float f = this.value;
        if (string != null) {
            boolean bl2 = string.equals("%");
            if (bl2 || string.endsWith("hz")) {
                int n = this.getAtomIndex(1);
                int n2 = this.getAtomIndex(2);
                if (n >= 0 && n2 >= 0) {
                    boolean bl3;
                    Atom atom = (Atom)this.getAtom(1);
                    Atom atom2 = (Atom)this.getAtom(2);
                    boolean bl4 = bl3 = !bl2 && Measurement.nmrType(string) == 1;
                    String string2 = bl2 ? "percent" : (this.type = bl3 ? "dipoleCouplingConstant" : "J-CouplingConstant");
                    f = bl2 ? f / (atom.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO) + atom2.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO)) : (bl3 ? this.vwr.getNMRCalculation().getDipolarConstantHz(atom, atom2) : this.vwr.getNMRCalculation().getIsoOrAnisoHz(true, atom, atom2, string, null));
                    boolean bl5 = this.isValid = !Float.isNaN(f);
                    if (bl2) {
                        string = "pm";
                    }
                }
            }
            if (string.equals("nm")) {
                return bl ? (float)Math.round(f * 100.0f) / 1000.0f : f / 10.0f;
            }
            if (string.equals("pm")) {
                return bl ? (float)Math.round(f * 1000.0f) / 10.0f : f * 100.0f;
            }
            if (string.equals("au")) {
                return bl ? (float)Math.round(f / 0.5291772f * 1000.0f) / 1000.0f : f / 0.5291772f;
            }
            if (string.endsWith("khz")) {
                return bl ? (float)Math.round(f / 10.0f) / 100.0f : f / 1000.0f;
            }
        }
        return bl ? (float)Math.round(f * 100.0f) / 100.0f : f;
    }

    public static int nmrType(String string) {
        return string.indexOf("hz") < 0 ? 0 : (string.startsWith("dc_") || string.equals("khz") ? 1 : 2);
    }

    private String formatAngle(float f) {
        String string = this.getLabelString();
        if (string.indexOf("%V") >= 0) {
            f = (float)Math.round(f * 10.0f) / 10.0f;
        }
        return this.formatString(f, "\u00b0", string);
    }

    private String getLabelString() {
        String string = String.valueOf(this.countPlusIndices[0]) + ":";
        String string2 = null;
        if (this.strFormat != null) {
            if (this.strFormat.length() == 0) {
                return null;
            }
            String string3 = string2 = this.strFormat.length() > 2 && this.strFormat.indexOf(string) == 0 ? this.strFormat : null;
        }
        if (string2 == null) {
            this.strFormat = null;
            string2 = this.vwr.getDefaultMeasurementLabel(this.countPlusIndices[0]);
        }
        if (string2.indexOf(string) == 0) {
            string2 = string2.substring(2);
        }
        if (this.strFormat == null) {
            this.strFormat = String.valueOf(string) + string2;
        }
        return string2;
    }

    private String formatString(float f, String string, String string2) {
        return LabelToken.formatLabelMeasure(this.vwr, this, string2, f, string);
    }

    public boolean sameAsPoints(int[] nArray, Point3fi[] point3fiArray) {
        if (this.count != nArray[0]) {
            return false;
        }
        boolean bl = true;
        int n = 1;
        while (n <= this.count && bl) {
            bl = this.countPlusIndices[n] == nArray[n];
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < this.count && bl) {
                if (point3fiArray[n] != null) {
                    bl = (double)this.pts[n].distance(point3fiArray[n]) < 0.01;
                }
                ++n;
            }
        }
        if (bl) {
            return true;
        }
        switch (this.count) {
            default: {
                return true;
            }
            case 2: {
                return this.sameAsIJ(nArray, point3fiArray, 1, 2) && this.sameAsIJ(nArray, point3fiArray, 2, 1);
            }
            case 3: {
                return this.sameAsIJ(nArray, point3fiArray, 1, 3) && this.sameAsIJ(nArray, point3fiArray, 2, 2) && this.sameAsIJ(nArray, point3fiArray, 3, 1);
            }
            case 4: 
        }
        return this.sameAsIJ(nArray, point3fiArray, 1, 4) && this.sameAsIJ(nArray, point3fiArray, 2, 3) && this.sameAsIJ(nArray, point3fiArray, 3, 2) && this.sameAsIJ(nArray, point3fiArray, 4, 1);
    }

    private boolean sameAsIJ(int[] nArray, Point3fi[] point3fiArray, int n, int n2) {
        int n3 = this.countPlusIndices[n];
        int n4 = nArray[n2];
        return n3 >= 0 || n4 >= 0 ? n3 == n4 : (double)this.pts[-2 - n3].distance(point3fiArray[-2 - n4]) < 0.01;
    }

    public boolean sameAs(int n, int n2) {
        return this.sameAsIJ(this.countPlusIndices, this.pts, n, n2);
    }

    public float getMeasurement(Point3fi[] point3fiArray) {
        if (this.countPlusIndices == null) {
            return Float.NaN;
        }
        if (this.count < 2) {
            return Float.NaN;
        }
        int n = this.count;
        while (--n >= 0) {
            if (this.countPlusIndices[n + 1] != -1) continue;
            return Float.NaN;
        }
        Point3fi point3fi = point3fiArray == null ? this.getAtom(1) : point3fiArray[0];
        Point3fi point3fi2 = point3fiArray == null ? this.getAtom(2) : point3fiArray[1];
        switch (this.count) {
            case 2: {
                return point3fi.distance(point3fi2);
            }
            case 3: {
                Point3fi point3fi3 = point3fiArray == null ? this.getAtom(3) : point3fiArray[2];
                return Measure.computeAngleABC(point3fi, point3fi2, point3fi3, true);
            }
            case 4: {
                Point3fi point3fi4 = point3fiArray == null ? this.getAtom(3) : point3fiArray[2];
                Point3fi point3fi5 = point3fiArray == null ? this.getAtom(4) : point3fiArray[3];
                return Measure.computeTorsion(point3fi, point3fi2, point3fi4, point3fi5, true);
            }
        }
        return Float.NaN;
    }

    public String getLabel(int n, boolean bl, boolean bl2) {
        int n2 = this.countPlusIndices[n];
        return n2 < 0 ? String.valueOf(bl2 ? "modelIndex " + this.getAtom((int)n).mi + " " : "") + Escape.eP(this.getAtom(n)) : (bl ? "({" + n2 + "})" : this.vwr.getAtomInfo(n2));
    }

    public void setModelIndex(short s) {
        if (this.pts == null) {
            return;
        }
        int n = 0;
        while (n < this.count) {
            if (this.pts[n] != null) {
                this.pts[n].mi = s;
            }
            ++n;
        }
    }

    public boolean isValid() {
        return !(this.sameAs(1, 2) || this.count > 2 && this.sameAs(1, 3) || this.count == 4 && this.sameAs(2, 4));
    }

    public static int find(Lst<Measurement> lst, Measurement measurement) {
        int[] nArray = measurement.countPlusIndices;
        Point3fi[] point3fiArray = measurement.pts;
        int n = lst.size();
        while (--n >= 0) {
            if (!((Measurement)lst.get(n)).sameAsPoints(nArray, point3fiArray)) continue;
            return n;
        }
        return -1;
    }

    public boolean isConnected(Atom[] atomArray, int n) {
        int n2 = -1;
        int n3 = 1;
        while (n3 <= n) {
            int n4 = this.getAtomIndex(n3);
            if (n4 >= 0) {
                if (n2 >= 0 && !atomArray[n4].isBonded(atomArray[n2])) {
                    return false;
                }
                n2 = n4;
            }
            ++n3;
        }
        return true;
    }

    public String getInfoAsString(String string) {
        float f = this.fixValue(string, true);
        SB sB = new SB();
        sB.append(this.count == 2 ? (this.type == null ? "distance" : this.type) : (this.count == 3 ? "angle" : "dihedral"));
        sB.append(" \t").appendF(f);
        sB.append(" \t").append(PT.esc(this.strMeasurement));
        int n = 1;
        while (n <= this.count) {
            sB.append(" \t").append(this.getLabel(n, false, false));
            ++n;
        }
        if (this.thisID != null) {
            sB.append(" \t").append(this.thisID);
        }
        return sB.toString();
    }

    public boolean isInRange(RadiusData radiusData, float f) {
        if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
            Atom atom = (Atom)this.getAtom(1);
            Atom atom2 = (Atom)this.getAtom(2);
            float f2 = (atom.getVanderwaalsRadiusFloat(this.vwr, radiusData.vdwType) + atom2.getVanderwaalsRadiusFloat(this.vwr, radiusData.vdwType)) * radiusData.value;
            return f <= f2;
        }
        return radiusData.values[0] == Float.MAX_VALUE || f >= radiusData.values[0] && f <= radiusData.values[1];
    }

    public boolean isIntramolecular(Atom[] atomArray, int n) {
        int n2 = -1;
        int n3 = 1;
        while (n3 <= n) {
            int n4 = this.getAtomIndex(n3);
            if (n4 >= 0) {
                int n5 = atomArray[n4].getMoleculeNumber(false);
                if (n2 < 0) {
                    n2 = n5;
                } else if (n5 != n2) {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    public boolean isMin(Map<String, Integer> map) {
        String string;
        Atom atom = (Atom)this.getAtom(1);
        Atom atom2 = (Atom)this.getAtom(2);
        int n = (int)(atom2.distanceSquared(atom) * 100.0f);
        String string2 = atom.getAtomName();
        String string3 = string2.compareTo(string = atom2.getAtomName()) < 0 ? String.valueOf(string2) + string : String.valueOf(string) + string2;
        Integer n2 = map.get(string3);
        return n2 != null && n == n2;
    }
}

