/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;

public class SmilesMeasure {
    SmilesSearch search;
    int nPoints;
    int type;
    int index;
    boolean isNot;
    private int[] indices = new int[4];
    static final String TYPES = "__dat";
    private final float[] minmax;
    private static final float radiansPerDegree = (float)Math.PI / 180;
    private final P3[] points = new P3[4];

    SmilesMeasure(SmilesSearch smilesSearch, int n, int n2, boolean bl, float[] fArray) {
        this.search = smilesSearch;
        this.type = Math.min(4, Math.max(n2, 2));
        this.index = n;
        this.isNot = bl;
        this.minmax = fArray;
        int n3 = fArray.length - 2;
        while (n3 >= 0) {
            if (fArray[n3] > fArray[n3 + 1]) {
                float f = fArray[n3 + 1];
                fArray[n3 + 1] = fArray[n3];
                fArray[n3] = f;
            }
            n3 -= 2;
        }
    }

    boolean addPoint(int n) {
        if (this.nPoints == this.type) {
            return false;
        }
        if (this.nPoints == 0) {
            int n2 = 1;
            while (n2 < this.type) {
                this.indices[n2] = n + n2;
                ++n2;
            }
        }
        this.indices[this.nPoints++] = n;
        return true;
    }

    boolean check() {
        int n;
        int n2 = 0;
        while (n2 < this.type) {
            n = this.search.patternAtoms[this.indices[n2]].getMatchingAtomIndex();
            this.points[n2] = (P3)((Object)this.search.targetAtoms[n]);
            ++n2;
        }
        float f = 0.0f;
        switch (this.type) {
            case 2: {
                f = this.points[0].distance(this.points[1]);
                break;
            }
            case 3: {
                this.search.v.vA.sub2(this.points[0], this.points[1]);
                this.search.v.vB.sub2(this.points[2], this.points[1]);
                f = this.search.v.vA.angle(this.search.v.vB) / ((float)Math.PI / 180);
                break;
            }
            case 4: {
                f = SmilesMeasure.setTorsionData(this.points[0], this.points[1], this.points[2], this.points[3], this.search.v, true);
            }
        }
        n = this.minmax.length - 2;
        while (n >= 0) {
            if (f >= this.minmax[n] && f <= this.minmax[n + 1]) {
                return !this.isNot;
            }
            n -= 2;
        }
        return this.isNot;
    }

    public static float setTorsionData(T3 t3, T3 t32, T3 t33, T3 t34, VTemp vTemp, boolean bl) {
        vTemp.vTemp1.sub2(t3, t32);
        vTemp.vTemp2.sub2(t34, t33);
        if (!bl) {
            return 0.0f;
        }
        vTemp.vNorm2.sub2(t32, t33);
        vTemp.vNorm2.normalize();
        vTemp.vTemp1.cross(vTemp.vTemp1, vTemp.vNorm2);
        vTemp.vTemp1.normalize();
        vTemp.vTemp2.cross(vTemp.vTemp2, vTemp.vNorm2);
        vTemp.vTemp2.normalize();
        vTemp.vNorm3.cross(vTemp.vTemp1, vTemp.vTemp2);
        return vTemp.vTemp1.angle(vTemp.vTemp2) / ((float)Math.PI / 180) * (float)(vTemp.vNorm2.dot(vTemp.vNorm3) < 0.0f ? 1 : -1);
    }

    public String toString() {
        String string = "(." + TYPES.charAt(this.type) + this.index + ":" + PT.toJSON(null, this.minmax) + ") for";
        int n = 0;
        while (n < this.type) {
            string = String.valueOf(string) + " " + (n >= this.nPoints ? "?" : "" + this.indices[n]);
            ++n;
        }
        return string;
    }
}

