/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;

public class UnitCellIterator
implements AtomIndexIterator {
    private Atom[] atoms;
    private T3 center;
    private T3 translation;
    private int nFound;
    private float maxDistance2;
    private float distance2;
    private SymmetryInterface unitCell;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3i t;
    private P3 p;
    private int ipt = Integer.MIN_VALUE;
    private Lst<P3[]> unitList;
    private boolean done;
    private int nAtoms;
    private int listPt;

    public UnitCellIterator set(SymmetryInterface symmetryInterface, Atom atom, Atom[] atomArray, BS bS, float f) {
        this.unitCell = symmetryInterface;
        this.atoms = atomArray;
        this.addAtoms(bS);
        this.p = new P3();
        if (f > 0.0f) {
            this.setCenter(atom, f);
        }
        return this;
    }

    @Override
    public void setModel(ModelSet modelSet, int n, int n2, int n3, T3 t3, float f, RadiusData radiusData) {
    }

    @Override
    public void setCenter(T3 t3, float f) {
        if (f == 0.0f) {
            return;
        }
        this.maxDistance2 = f * f;
        this.center = t3;
        this.translation = new P3();
        P3[] p3Array = BoxInfo.unitCubePoints;
        P3 p3 = P3.new3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        P3 p32 = P3.new3(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.p = new P3();
        P3 p33 = new P3();
        p33.setT(t3);
        this.unitCell.toFractional(p33, true);
        int n = 0;
        while (n < 8) {
            this.p.scaleAdd2(-2.0f, p3Array[n], p3Array[7]);
            this.p.scaleAdd2(f, this.p, t3);
            this.unitCell.toFractional(this.p, true);
            if (p3.x > this.p.x) {
                p3.x = this.p.x;
            }
            if (p32.x < this.p.x) {
                p32.x = this.p.x;
            }
            if (p3.y > this.p.y) {
                p3.y = this.p.y;
            }
            if (p32.y < this.p.y) {
                p32.y = this.p.y;
            }
            if (p3.z > this.p.z) {
                p3.z = this.p.z;
            }
            if (p32.z < this.p.z) {
                p32.z = this.p.z;
            }
            ++n;
        }
        this.minXYZ = P3i.new3((int)Math.floor(p3.x), (int)Math.floor(p3.y), (int)Math.floor(p3.z));
        this.maxXYZ = P3i.new3((int)Math.ceil(p32.x), (int)Math.ceil(p32.y), (int)Math.ceil(p32.z));
        if (Logger.debugging) {
            Logger.info("UnitCellIterator minxyz/maxxyz " + this.minXYZ + " " + this.maxXYZ);
        }
        this.t = P3i.new3(this.minXYZ.x - 1, this.minXYZ.y, this.minXYZ.z);
        this.nextCell();
    }

    @Override
    public void addAtoms(BS bS) {
        boolean bl = this.done = bS == null;
        if (this.done) {
            return;
        }
        this.unitList = new Lst();
        String string = "";
        M4[] m4Array = this.unitCell.getSymmetryOperations();
        int n = m4Array.length;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = this.atoms[n2];
            int n3 = 0;
            while (n3 < n) {
                P3 p3 = new P3();
                p3.setT(atom);
                if (n3 > 0) {
                    this.unitCell.toFractional(p3, false);
                    m4Array[n3].rotTrans(p3);
                    this.unitCell.unitize(p3);
                    this.unitCell.toCartesian(p3, false);
                } else {
                    this.unitCell.toUnitCell(p3, null);
                }
                String string2 = "_" + (int)(p3.x * 100.0f) + "_" + (int)(p3.y * 100.0f) + "_" + (int)(p3.z * 100.0f) + "_";
                if (string.indexOf(string2) < 0) {
                    string = String.valueOf(string) + string2;
                    this.unitList.addLast(new P3[]{atom, p3});
                }
                ++n3;
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        this.nAtoms = this.unitList.size();
        boolean bl2 = this.done = this.nAtoms == 0;
        if (Logger.debugging) {
            Logger.info("UnitCellIterator " + this.nAtoms + " unique points found");
        }
    }

    @Override
    public boolean hasNext() {
        while (this.ipt < this.nAtoms || this.nextCell()) {
            float f;
            ++this.ipt;
            this.listPt = this.listPt;
            this.p.add2(((P3[])this.unitList.get(this.listPt))[1], this.translation);
            this.distance2 = this.p.distanceSquared(this.center);
            if (!(f < this.maxDistance2) || !(this.distance2 > 0.1f)) continue;
            ++this.nFound;
            return true;
        }
        return false;
    }

    private boolean nextCell() {
        if (this.done) {
            return false;
        }
        if (++this.t.x >= this.maxXYZ.x) {
            this.t.x = this.minXYZ.x;
            if (++this.t.y >= this.maxXYZ.y) {
                this.t.y = this.minXYZ.y;
                if (++this.t.z >= this.maxXYZ.z) {
                    this.done = true;
                    this.ipt = this.nAtoms;
                    return false;
                }
            }
        }
        this.translation.set(this.t.x, this.t.y, this.t.z);
        this.unitCell.toCartesian(this.translation, false);
        this.ipt = 0;
        return true;
    }

    @Override
    public int next() {
        return this.done || this.ipt < 0 ? -1 : this.getAtom().i;
    }

    private Atom getAtom() {
        return (Atom)((P3[])this.unitList.get(this.listPt))[0];
    }

    @Override
    public float foundDistance2() {
        return this.nFound > 0 ? this.distance2 : Float.MAX_VALUE;
    }

    @Override
    public P3 getPosition() {
        Atom atom = this.getAtom();
        if (Logger.debugging) {
            Logger.info("draw ID p_" + this.nFound + " " + this.p + " //" + atom + " " + this.t);
        }
        if (this.p.distanceSquared(atom) < 1.0E-4f) {
            return atom;
        }
        Point3fi point3fi = new Point3fi();
        point3fi.setT(this.p);
        point3fi.i = atom.i;
        point3fi.sD = (short)atom.getElementNumber();
        return point3fi;
    }

    @Override
    public void release() {
        this.atoms = null;
        this.center = null;
        this.translation = null;
    }
}

