/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javajs.util.PT;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileSystemView;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.webexport.LogPanel;
import org.openscience.jmol.app.webexport.PopInJmol;
import org.openscience.jmol.app.webexport.ScriptButtons;
import org.openscience.jmol.app.webexport.WebPanel;

public class WebExport
extends JPanel
implements WindowListener {
    static final String chemappsPath = "http://chemapps.stolaf.edu/jmol/jsmol";
    private static boolean showMoleculesAndOrbitals = false;
    private static final int STAND_ALONE = 0;
    private static final int IN_JMOL = 1;
    private static int runStatus = 1;
    private static HistoryFile historyFile;
    private static WebPanel[] webPanels;
    static WebExport webExport;
    private static JFrame webFrame;
    private static String windowName;
    static String remoteAppletPath;
    static String localAppletPath;
    static Properties prop;
    static String pageAuthorName;
    static int popInWidth;
    static int popInHeight;
    static int scriptButtonPercent;

    static {
        prop = new Properties();
    }

    private WebExport(Viewer viewer, HistoryFile historyFile) {
        super(new BorderLayout());
        WebExport.historyFile = historyFile;
        remoteAppletPath = WebExport.historyFile.getProperty("webMakerAppletPath", chemappsPath);
        localAppletPath = WebExport.historyFile.getProperty("webMakerLocalAppletPath", chemappsPath);
        pageAuthorName = WebExport.historyFile.getProperty("webMakerPageAuthorName", GT.$("Jmol Web Page Maker"));
        popInWidth = PT.parseInt(WebExport.historyFile.getProperty("webMakerPopInWidth", "300"));
        popInHeight = PT.parseInt(WebExport.historyFile.getProperty("webMakerPopInHeight", "300"));
        scriptButtonPercent = PT.parseInt(WebExport.historyFile.getProperty("webMakerScriptButtonPercent", "60"));
        JTabbedPane jTabbedPane = new JTabbedPane();
        JFileChooser jFileChooser = new JFileChooser();
        webPanels = new WebPanel[2];
        if (runStatus != 0) {
            JPanel jPanel = new JPanel();
            String string = "WebExportIntro";
            URL uRL = GuiMap.getHtmlResource(this, string);
            if (uRL == null) {
                System.err.println(GT.o(GT.$("Couldn't find file: {0}"), String.valueOf(string) + ".html"));
            }
            JEditorPane jEditorPane = new JEditorPane();
            if (uRL != null) {
                try {
                    jEditorPane.setPage(uRL);
                }
                catch (IOException iOException) {
                    System.err.println("Attempted to read a bad URL: " + uRL);
                }
            }
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            jScrollPane.setMaximumSize(new Dimension(450, 350));
            jScrollPane.setPreferredSize(new Dimension(400, 300));
            jPanel.setLayout(new BorderLayout());
            jPanel.add(jScrollPane);
            jPanel.setMaximumSize(new Dimension(450, 350));
            jPanel.setPreferredSize(new Dimension(400, 300));
            jTabbedPane.add(GT.$("Introduction"), jPanel);
            WebExport.webPanels[0] = new PopInJmol(viewer, jFileChooser, webPanels, 0);
            WebExport.webPanels[1] = new ScriptButtons(viewer, jFileChooser, webPanels, 1);
            int n = Integer.parseInt(WebExport.historyFile.getProperty("webMakerInfoWidth", "300"));
            int n2 = Integer.parseInt(WebExport.historyFile.getProperty("webMakerInfoHeight", "350"));
            jTabbedPane.addTab(GT.$("Pop-In Jmol"), webPanels[0].getPanel(n, n2));
            jTabbedPane.addTab(GT.$("ScriptButton Jmol"), webPanels[1].getPanel(n, n2));
        }
        showMoleculesAndOrbitals = runStatus == 0 || WebPanel.checkOption(viewer.getP("webMakerAllTabs"));
        jTabbedPane.addTab(GT.$("Log"), LogPanel.getPanel());
        this.add(jTabbedPane);
        this.add((Component)LogPanel.getMiniPanel(), "South");
    }

    static String TimeStamp_WebLink() {
        return GT.o(GT.$("Page skeleton and JavaScript generated by the Export to Web module of {0} on {1}."), new String[]{" <a href=\"http://jmol.sourceforge.net\">Jmol " + Viewer.getJmolVersion() + "</a> ", DateFormat.getDateInstance().format(new Date())});
    }

    public static void dispose() {
        webFrame.dispose();
        webFrame = null;
    }

    public static WebExport createAndShowGUI(Viewer viewer, HistoryFile historyFile, String string) {
        if (viewer == null) {
            runStatus = 0;
        }
        if (webFrame != null) {
            webFrame.setVisible(true);
            webFrame.toFront();
            return webExport;
        }
        webFrame = new JFrame(GT.$("Jmol Web Page Maker"));
        String string2 = "org/openscience/jmol/app/images/icon.png";
        URL uRL = viewer.getClass().getClassLoader().getResource(string2);
        ImageIcon imageIcon = new ImageIcon(uRL);
        webFrame.setIconImage(imageIcon.getImage());
        windowName = string;
        historyFile.repositionWindow(windowName, webFrame, 700, 400, true);
        if (runStatus == 0) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            webFrame.setDefaultCloseOperation(3);
        } else {
            webFrame.setDefaultCloseOperation(2);
        }
        webExport = new WebExport(viewer, historyFile);
        webExport.setOpaque(true);
        webFrame.setContentPane(webExport);
        webFrame.addWindowListener(webExport);
        webFrame.pack();
        webFrame.setVisible(true);
        return webExport;
    }

    public static void saveHistory() {
        if (historyFile == null) {
            return;
        }
        historyFile.addWindowInfo(windowName, webFrame, null);
        prop.setProperty("webMakerAppletPath", remoteAppletPath);
        prop.setProperty("webMakerLocalAppletPath", localAppletPath);
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static String getAppletPath(boolean bl) {
        return bl ? remoteAppletPath : localAppletPath;
    }

    static void setAppletPath(String string, boolean bl) {
        if (string == null) {
            string = chemappsPath;
        }
        if (bl) {
            remoteAppletPath = string;
            prop.setProperty("webMakerAppletPath", remoteAppletPath);
            historyFile.addProperties(prop);
        } else {
            localAppletPath = string;
            prop.setProperty("webMakerLocalAppletPath", localAppletPath);
            historyFile.addProperties(prop);
        }
    }

    static String getPageAuthorName() {
        return pageAuthorName;
    }

    static void setWebPageAuthor(String string) {
        if (string == null) {
            string = GT.$("Jmol Web Page Maker");
        }
        pageAuthorName = string;
        prop.setProperty("webMakerPageAuthorName", pageAuthorName);
        historyFile.addProperties(prop);
    }

    static void setPopInDim(int n, int n2) {
        if (n < 25 || n > 3000) {
            n = 300;
        }
        if (n2 < 25 || n2 > 3000) {
            n2 = 300;
        }
        popInWidth = n;
        popInHeight = n2;
        prop.setProperty("webMakerPopInWidth", "" + n);
        prop.setProperty("webMakerPopInHeight", "" + n2);
        historyFile.addProperties(prop);
    }

    static int getPopInWidth() {
        return popInWidth;
    }

    static int getPopInHeight() {
        return popInHeight;
    }

    static void setScriptButtonPercent(int n) {
        if (n < 10 || n > 90) {
            n = 60;
        }
        scriptButtonPercent = n;
        prop.setProperty("webMakerScriptButtonPercent", "" + n);
        historyFile.addProperties(prop);
    }

    static int getScriptButtonPercent() {
        return scriptButtonPercent;
    }

    static JFrame getFrame() {
        return webFrame;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    public void windowStateChanged(WindowEvent windowEvent) {
    }

    public static void cleanUp() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File file = fileSystemView.getHomeDirectory();
        String string = file.getPath();
        String string2 = String.valueOf(string) + "/.jmol_WPM";
        File file2 = new File(string2);
        if (file2.exists()) {
            File[] fileArray = null;
            fileArray = file2.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                fileArray[n].delete();
                ++n;
            }
        }
        WebExport.saveHistory();
    }
}

