/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public final class ExceptionDialogUtil {
    private ExceptionDialogUtil() {
    }

    private static int showErrorDialog(String msg, String title, String helpTopic) {
        return HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), new HtmlPanel(msg), title, 0, helpTopic);
    }

    public static void explainOsmApiInitializationException(OsmApiInitializationException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainOsmApiInitializationException(e), I18n.tr("Error", new Object[0]), HelpUtil.ht("/ErrorMessages#OsmApiInitializationException"));
    }

    public static void explainChangesetClosedException(ChangesetClosedException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainChangesetClosedException(e), I18n.tr("Error", new Object[0]), HelpUtil.ht("/Action/Upload#ChangesetClosed"));
    }

    public static void explainPreconditionFailed(OsmApiException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainPreconditionFailed(e), I18n.tr("Precondition violation", new Object[0]), HelpUtil.ht("/ErrorMessages#OsmApiException"));
    }

    public static void explainGeneric(Exception e) {
        Logging.error(e);
        BugReportExceptionHandler.handleException(e);
    }

    public static void explainSecurityException(OsmTransferException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainSecurityException(e), I18n.tr("Security exception", new Object[0]), HelpUtil.ht("/ErrorMessages#SecurityException"));
    }

    public static void explainNestedSocketException(OsmTransferException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainNestedSocketException(e), I18n.tr("Network exception", new Object[0]), HelpUtil.ht("/ErrorMessages#NestedSocketException"));
    }

    public static void explainNestedIOException(OsmTransferException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainNestedIOException(e), I18n.tr("IO Exception", new Object[0]), HelpUtil.ht("/ErrorMessages#NestedIOException"));
    }

    public static void explainNestedIllegalDataException(OsmTransferException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainNestedIllegalDataException(e), I18n.tr("Illegal Data", new Object[0]), HelpUtil.ht("/ErrorMessages#IllegalDataException"));
    }

    public static void explainNestedOfflineAccessException(OsmTransferException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainOfflineAccessException(e), I18n.tr("Offline mode", new Object[0]), HelpUtil.ht("/ErrorMessages#OfflineAccessException"));
    }

    public static void explainNestedInvocationTargetException(Exception e) {
        InvocationTargetException ex = ExceptionUtil.getNestedException(e, InvocationTargetException.class);
        if (ex != null) {
            BugReportExceptionHandler.handleException(ex);
        }
    }

    public static void explainInternalServerError(OsmTransferException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainInternalServerError(e), I18n.tr("Internal Server Error", new Object[0]), HelpUtil.ht("/ErrorMessages#InternalServerError"));
    }

    public static void explainBadRequest(OsmApiException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainBadRequest(e), I18n.tr("Bad Request", new Object[0]), HelpUtil.ht("/ErrorMessages#BadRequest"));
    }

    public static void explainNotFound(OsmApiException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainNotFound(e), I18n.tr("Not Found", new Object[0]), HelpUtil.ht("/ErrorMessages#NotFound"));
    }

    public static void explainConflict(OsmApiException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainConflict(e), I18n.tr("Conflict", new Object[0]), HelpUtil.ht("/ErrorMessages#Conflict"));
    }

    public static void explainAuthenticationFailed(OsmApiException e) {
        String msg = OsmApi.isUsingOAuth() ? ExceptionUtil.explainFailedOAuthAuthentication(e) : ExceptionUtil.explainFailedBasicAuthentication(e);
        ExceptionDialogUtil.showErrorDialog(msg, I18n.tr("Authentication failed", new Object[0]), HelpUtil.ht("/ErrorMessages#AuthenticationFailed"));
    }

    public static void explainAuthorizationFailed(OsmApiException e) {
        String msg;
        Matcher m;
        String url = e.getAccessedUrl();
        Pattern p = Pattern.compile("https?://.*/api/0.6/(node|way|relation)/(\\d+)/(\\d+)");
        if (url != null && (m = p.matcher(url)).matches()) {
            String type = m.group(1);
            String id = m.group(2);
            String version = m.group(3);
            msg = I18n.tr("Access to redacted version ''{0}'' of {1} {2} is forbidden.", version, I18n.tr(type, new Object[0]), id);
        } else {
            msg = OsmApi.isUsingOAuth() ? ExceptionUtil.explainFailedOAuthAuthorisation(e) : ExceptionUtil.explainFailedAuthorisation(e);
        }
        ExceptionDialogUtil.showErrorDialog(msg, I18n.tr("Authorisation Failed", new Object[0]), HelpUtil.ht("/ErrorMessages#AuthorizationFailed"));
    }

    public static void explainClientTimeout(OsmApiException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainClientTimeout(e), I18n.tr("Client Time Out", new Object[0]), HelpUtil.ht("/ErrorMessages#ClientTimeOut"));
    }

    public static void explainBandwidthLimitExceeded(OsmApiException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainBandwidthLimitExceeded(e), I18n.tr("Bandwidth Limit Exceeded", new Object[0]), HelpUtil.ht("/ErrorMessages#BandwidthLimit"));
    }

    public static void explainGenericHttpException(OsmApiException e) {
        String body = e.getErrorBody();
        Object msg = null;
        msg = "text/html".equals(e.getContentType()) && body != null && body.startsWith("<") && body.contains("<html>") ? new HtmlPanel(body) : ExceptionUtil.explainGeneric(e);
        HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg, I18n.tr("Communication with OSM server failed", new Object[0]), 0, HelpUtil.ht("/ErrorMessages#GenericCommunicationError"));
    }

    public static void explainMissingOAuthAccessTokenException(MissingOAuthAccessTokenException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainMissingOAuthAccessTokenException(e), I18n.tr("Authentication failed", new Object[0]), HelpUtil.ht("/ErrorMessages#MissingOAuthAccessToken"));
    }

    public static void explainNestedUnkonwnHostException(OsmTransferException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainNestedUnknownHostException(e), I18n.tr("Unknown host", new Object[0]), HelpUtil.ht("/ErrorMessages#UnknownHost"));
    }

    public static void explainOsmTransferException(OsmTransferException e) {
        if (ExceptionUtil.getNestedException(e, SecurityException.class) != null) {
            ExceptionDialogUtil.explainSecurityException(e);
            return;
        }
        if (ExceptionUtil.getNestedException(e, SocketException.class) != null) {
            ExceptionDialogUtil.explainNestedSocketException(e);
            return;
        }
        if (ExceptionUtil.getNestedException(e, UnknownHostException.class) != null) {
            ExceptionDialogUtil.explainNestedUnkonwnHostException(e);
            return;
        }
        if (ExceptionUtil.getNestedException(e, IOException.class) != null) {
            ExceptionDialogUtil.explainNestedIOException(e);
            return;
        }
        if (ExceptionUtil.getNestedException(e, IllegalDataException.class) != null) {
            ExceptionDialogUtil.explainNestedIllegalDataException(e);
            return;
        }
        if (ExceptionUtil.getNestedException(e, OfflineAccessException.class) != null) {
            ExceptionDialogUtil.explainNestedOfflineAccessException(e);
            return;
        }
        if (e instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
            return;
        }
        if (e instanceof ChangesetClosedException) {
            ExceptionDialogUtil.explainChangesetClosedException((ChangesetClosedException)e);
            return;
        }
        if (e instanceof MissingOAuthAccessTokenException) {
            ExceptionDialogUtil.explainMissingOAuthAccessTokenException((MissingOAuthAccessTokenException)e);
            return;
        }
        if (e instanceof OsmApiException) {
            OsmApiException oae = (OsmApiException)e;
            switch (oae.getResponseCode()) {
                case 412: {
                    ExceptionDialogUtil.explainPreconditionFailed(oae);
                    return;
                }
                case 410: {
                    ExceptionDialogUtil.explainGoneForUnknownPrimitive(oae);
                    return;
                }
                case 500: {
                    ExceptionDialogUtil.explainInternalServerError(oae);
                    return;
                }
                case 400: {
                    ExceptionDialogUtil.explainBadRequest(oae);
                    return;
                }
                case 404: {
                    ExceptionDialogUtil.explainNotFound(oae);
                    return;
                }
                case 409: {
                    ExceptionDialogUtil.explainConflict(oae);
                    return;
                }
                case 401: {
                    ExceptionDialogUtil.explainAuthenticationFailed(oae);
                    return;
                }
                case 403: {
                    ExceptionDialogUtil.explainAuthorizationFailed(oae);
                    return;
                }
                case 408: {
                    ExceptionDialogUtil.explainClientTimeout(oae);
                    return;
                }
                case 429: 
                case 509: {
                    ExceptionDialogUtil.explainBandwidthLimitExceeded(oae);
                    return;
                }
            }
            ExceptionDialogUtil.explainGenericHttpException(oae);
            return;
        }
        ExceptionDialogUtil.explainGeneric(e);
    }

    public static void explainGoneForUnknownPrimitive(OsmApiException e) {
        ExceptionDialogUtil.showErrorDialog(ExceptionUtil.explainGoneForUnknownPrimitive(e), I18n.tr("Object deleted", new Object[0]), HelpUtil.ht("/ErrorMessages#GoneForUnknownPrimitive"));
    }

    public static void explainException(Exception e) {
        if (ExceptionUtil.getNestedException(e, InvocationTargetException.class) != null) {
            ExceptionDialogUtil.explainNestedInvocationTargetException(e);
            return;
        }
        if (e instanceof OsmTransferException) {
            ExceptionDialogUtil.explainOsmTransferException((OsmTransferException)e);
            return;
        }
        ExceptionDialogUtil.explainGeneric(e);
    }
}

