/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsServer;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;
import org.bouncycastle.util.Arrays;

public class PSKTlsServer
extends AbstractTlsServer {
    public static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;
    protected int[] supportedCipherSuites;

    public PSKTlsServer(TlsCrypto tlsCrypto, TlsPSKIdentityManager tlsPSKIdentityManager) {
        this(tlsCrypto, new DefaultTlsKeyExchangeFactory(), tlsPSKIdentityManager);
    }

    public PSKTlsServer(TlsCrypto tlsCrypto, TlsKeyExchangeFactory tlsKeyExchangeFactory, TlsPSKIdentityManager tlsPSKIdentityManager) {
        super(tlsCrypto, tlsKeyExchangeFactory);
        this.pskIdentityManager = tlsPSKIdentityManager;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(tlsCrypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected int[] getCipherSuites() {
        return Arrays.clone((int[])this.supportedCipherSuites);
    }

    public TlsCredentials getCredentials() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 14: {
                return this.createPSKKeyExchange(n, this.selectDHConfig(), null);
            }
            case 24: {
                return this.createPSKKeyExchange(n, null, this.selectECConfig());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(n, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n, TlsDHConfig tlsDHConfig, TlsECConfig tlsECConfig) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeServer(n, this.supportedSignatureAlgorithms, this.pskIdentityManager, tlsDHConfig, tlsECConfig, this.serverECPointFormats);
    }
}

