/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsStreamVerifier;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.SignatureOutputStream;

public class JcaTlsRSAVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    protected RSAPublicKey pubKeyRSA;
    private Signature rawVerifier = null;

    public JcaTlsRSAVerifier(RSAPublicKey rSAPublicKey, JcaJceHelper jcaJceHelper) {
        if (rSAPublicKey == null) {
            throw new IllegalArgumentException("'pubKeyRSA' cannot be null");
        }
        this.pubKeyRSA = rSAPublicKey;
        this.helper = jcaJceHelper;
    }

    public TlsStreamVerifier getStreamVerifier(final DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() == 1 && JcaUtils.isSunMSCAPIProviderActive()) {
            try {
                Signature signature = this.getRawVerifier();
                if (JcaUtils.isSunMSCAPIProvider(signature.getProvider())) {
                    String string = JcaUtils.getJcaAlgorithmName(signatureAndHashAlgorithm);
                    final Signature signature2 = this.helper.createSignature(string);
                    signature2.initVerify(this.pubKeyRSA);
                    return new TlsStreamVerifier(){

                        public OutputStream getOutputStream() {
                            return new SignatureOutputStream(signature2);
                        }

                        public boolean isVerified() throws IOException {
                            try {
                                return signature2.verify(digitallySigned.getSignature());
                            }
                            catch (SignatureException signatureException) {
                                throw new TlsFatalAlert(80, (Throwable)signatureException);
                            }
                        }
                    };
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
            }
        }
        return null;
    }

    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        try {
            Signature signature = this.getRawVerifier();
            if (signatureAndHashAlgorithm != null) {
                if (signatureAndHashAlgorithm.getSignature() != 1) {
                    throw new IllegalStateException();
                }
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()), (ASN1Encodable)DERNull.INSTANCE);
                byte[] byArray2 = new DigestInfo(algorithmIdentifier, byArray).getEncoded();
                signature.update(byArray2, 0, byArray2.length);
            } else {
                signature.update(byArray, 0, byArray.length);
            }
            return signature.verify(digitallySigned.getSignature());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException("unable to process signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    protected Signature getRawVerifier() throws GeneralSecurityException {
        if (this.rawVerifier == null) {
            this.rawVerifier = this.helper.createSignature("NoneWithRSA");
            this.rawVerifier.initVerify(this.pubKeyRSA);
        }
        return this.rawVerifier;
    }
}

