/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.protege.owlapi.inference.cls.ChildClassExtractor;
import org.protege.owlapi.inference.cls.ParentClassExtractor;
import org.protege.owlapi.inference.orphan.TerminalElementFinder;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;

public class AssertedClassHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLClass> {
    private OWLOntologyManager owlOntologyManager;
    private ReentrantReadWriteLock.ReadLock ontologySetReadLock;
    private ReentrantReadWriteLock.WriteLock ontologySetWriteLock;
    private Collection<OWLOntology> ontologies;
    private volatile OWLClass root;
    private ParentClassExtractor parentClassExtractor;
    private ChildClassExtractor childClassExtractor;
    private OWLOntologyChangeListener listener;
    private TerminalElementFinder<OWLClass> rootFinder;
    private Set<OWLClass> nodesToUpdate = new HashSet<OWLClass>();

    public AssertedClassHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.owlOntologyManager = owlOntologyManager;
        this.ontologies = new ArrayList<OWLOntology>();
        ReentrantReadWriteLock locks = new ReentrantReadWriteLock();
        this.ontologySetReadLock = locks.readLock();
        this.ontologySetWriteLock = locks.writeLock();
        this.rootFinder = new TerminalElementFinder<OWLClass>(cls -> {
            Set<OWLClass> parents = this.getParents((OWLClass)cls);
            parents.remove(this.root);
            return parents;
        });
        this.parentClassExtractor = new ParentClassExtractor();
        this.childClassExtractor = new ChildClassExtractor();
        this.listener = this::handleChanges;
        this.getManager().addOntologyChangeListener(this.listener);
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologySetWriteLock.lock();
        try {
            this.ontologies = new ArrayList<OWLOntology>(ontologies);
            this.nodesToUpdate.clear();
            if (this.root == null) {
                this.root = this.owlOntologyManager.getOWLDataFactory().getOWLThing();
            }
            this.rebuildImplicitRoots();
            this.fireHierarchyChanged();
        }
        finally {
            this.ontologySetWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildImplicitRoots() {
        this.ontologySetReadLock.lock();
        try {
            this.rootFinder.clear();
            for (OWLOntology ont : this.ontologies) {
                Set ref = ont.getClassesInSignature();
                this.rootFinder.appendTerminalElements(ref);
            }
            this.rootFinder.finish();
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    @Override
    public void dispose() {
        this.getManager().removeOntologyChangeListener(this.listener);
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet<OWLClass> oldTerminalElements = new HashSet<OWLClass>(this.rootFinder.getTerminalElements());
        HashSet<OWLClass> changedClasses = new HashSet<OWLClass>();
        changedClasses.add(this.root);
        List<OWLAxiomChange> filteredChanges = this.filterIrrelevantChanges(changes);
        this.updateImplicitRoots(filteredChanges);
        for (OWLOntologyChange oWLOntologyChange : filteredChanges) {
            changedClasses.addAll(oWLOntologyChange.getSignature().stream().filter(entity -> entity instanceof OWLClass).filter(entity -> !entity.equals(this.root)).map(entity -> (OWLClass)entity).collect(Collectors.toList()));
        }
        for (OWLClass oWLClass : changedClasses) {
            this.registerNodeChanged(oWLClass);
        }
        for (OWLClass oWLClass : this.rootFinder.getTerminalElements()) {
            if (oldTerminalElements.contains(oWLClass)) continue;
            this.registerNodeChanged(oWLClass);
        }
        for (OWLClass oWLClass : oldTerminalElements) {
            if (this.rootFinder.getTerminalElements().contains(oWLClass)) continue;
            this.registerNodeChanged(oWLClass);
        }
        this.notifyNodeChanges();
    }

    private List<OWLAxiomChange> filterIrrelevantChanges(List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLAxiomChange> filteredChanges = new ArrayList<OWLAxiomChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology()) || !oWLOntologyChange.isAxiomChange()) continue;
            filteredChanges.add((OWLAxiomChange)oWLOntologyChange);
        }
        return filteredChanges;
    }

    private void registerNodeChanged(OWLClass node) {
        this.nodesToUpdate.add(node);
    }

    private void notifyNodeChanges() {
        for (OWLClass node : this.nodesToUpdate) {
            this.fireNodeChanged(node);
        }
        this.nodesToUpdate.clear();
    }

    private void updateImplicitRoots(List<OWLAxiomChange> changes) {
        HashSet<OWLClass> possibleTerminalElements = new HashSet<OWLClass>();
        HashSet<OWLClass> notInOntologies = new HashSet<OWLClass>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology()) || !oWLOntologyChange.isAxiomChange()) continue;
            boolean remove = oWLOntologyChange instanceof RemoveAxiom;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            for (OWLEntity entity : axiom.getSignature()) {
                if (!(entity instanceof OWLClass) || entity.equals(this.root)) continue;
                OWLClass cls = (OWLClass)entity;
                if (remove && !this.containsReference(cls)) {
                    notInOntologies.add(cls);
                    continue;
                }
                possibleTerminalElements.add(cls);
            }
        }
        possibleTerminalElements.addAll(this.rootFinder.getTerminalElements());
        possibleTerminalElements.removeAll(notInOntologies);
        this.rootFinder.findTerminalElements(possibleTerminalElements);
    }

    @Override
    public Set<OWLClass> getRoots() {
        if (this.root == null) {
            this.root = this.owlOntologyManager.getOWLDataFactory().getOWLThing();
        }
        return Collections.singleton(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<OWLClass> getUnfilteredChildren(OWLClass object) {
        this.ontologySetReadLock.lock();
        try {
            if (object.equals(this.root)) {
                HashSet<OWLClass> result = new HashSet<OWLClass>();
                result.addAll(this.rootFinder.getTerminalElements());
                result.addAll(this.extractChildren(object));
                result.remove(object);
                HashSet<OWLClass> hashSet = result;
                return hashSet;
            }
            Set<OWLClass> result = this.extractChildren(object);
            Iterator<OWLClass> it = result.iterator();
            while (it.hasNext()) {
                OWLClass curChild = it.next();
                if (!this.getAncestors(object).contains(curChild)) continue;
                it.remove();
            }
            Set<OWLClass> set = result;
            return set;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    private Set<OWLClass> extractChildren(OWLClass parent) {
        this.childClassExtractor.setCurrentParentClass(parent);
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms((OWLPrimitive)parent)) {
                if (!ax.isLogicalAxiom()) continue;
                ax.accept((OWLAxiomVisitor)this.childClassExtractor);
            }
        }
        return this.childClassExtractor.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsReference(OWLClass object) {
        this.ontologySetReadLock.lock();
        try {
            for (OWLOntology ont : this.ontologies) {
                if (!ont.containsClassInSignature(object.getIRI())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OWLClass> getParents(OWLClass object) {
        this.ontologySetReadLock.lock();
        try {
            if (object.equals(this.root)) {
                Set<OWLClass> set = Collections.emptySet();
                return set;
            }
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            if (this.rootFinder.getTerminalElements().contains(object)) {
                result.add(this.root);
            }
            this.parentClassExtractor.reset();
            this.parentClassExtractor.setCurrentClass(object);
            for (OWLOntology ont : this.ontologies) {
                for (OWLAxiom ax : ont.getAxioms(object, Imports.EXCLUDED)) {
                    ax.accept((OWLAxiomVisitor)this.parentClassExtractor);
                }
            }
            result.addAll(this.parentClassExtractor.getResult());
            HashSet<OWLClass> hashSet = result;
            return hashSet;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OWLClass> getEquivalents(OWLClass object) {
        this.ontologySetReadLock.lock();
        try {
            HashSet<OWLClass> result = new HashSet<OWLClass>();
            for (OWLOntology ont : this.ontologies) {
                for (OWLClassExpression equiv : EntitySearcher.getEquivalentClasses((OWLClass)object, (OWLOntology)ont)) {
                    if (equiv.isAnonymous()) continue;
                    result.add((OWLClass)equiv);
                }
            }
            Set<OWLClass> ancestors = this.getAncestors(object);
            if (ancestors.contains(object)) {
                for (OWLClass cls : ancestors) {
                    if (!this.getAncestors(cls).contains(object)) continue;
                    result.add(cls);
                }
                result.remove(object);
                result.remove(this.root);
            }
            HashSet<OWLClass> hashSet = result;
            return hashSet;
        }
        finally {
            this.ontologySetReadLock.unlock();
        }
    }
}

