/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.navigation;

import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.navigation.OWLEntityNavigationMediator;

public class OWLEntityNavPanel
extends JPanel {
    private OWLEditorKit editorKit;
    private OWLEntityNavigationMediator mediator;
    private Action backAction;
    private Action forwardAction;

    public OWLEntityNavPanel(OWLEditorKit owlEditorKit) {
        this.editorKit = owlEditorKit;
        this.createActions();
        this.setLayout(new GridLayout(1, 2, 0, 0));
        this.add(new JButton(this.backAction));
        this.add(new JButton(this.forwardAction));
        this.mediator = new OWLEntityNavigationMediator(this.editorKit, this.backAction, this.forwardAction);
    }

    public void dispose() {
        this.mediator.dispose();
    }

    private void createActions() {
        this.backAction = new AbstractAction("<"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionHistoryManager().goBack();
                OWLEntityNavPanel.this.editorKit.getWorkspace().displayOWLEntity(OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionModel().getSelectedEntity());
            }
        };
        this.backAction.putValue("ShortDescription", "Back");
        KeyStroke backKS = KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(backKS, "nav-back");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("nav-back", this.backAction);
        this.forwardAction = new AbstractAction(">"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionHistoryManager().goForward();
                OWLEntityNavPanel.this.editorKit.getWorkspace().displayOWLEntity(OWLEntityNavPanel.this.editorKit.getWorkspace().getOWLSelectionModel().getSelectedEntity());
            }
        };
        this.forwardAction.putValue("ShortDescription", "Forward");
        KeyStroke forwardKS = KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        inputMap.put(forwardKS, "nav-forward");
        actionMap.put("nav-forward", this.forwardAction);
    }

    protected OWLModelManager getOWLModelManager() {
        return this.editorKit.getModelManager();
    }
}

