/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.tabbedpane;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.protege.editor.core.platform.OSUtils;
import org.protege.editor.core.ui.tabbedpane.NullTabCloseHandler;
import org.protege.editor.core.ui.tabbedpane.TabCloseHandler;
import org.protege.editor.core.ui.util.UIUtil;

public class CloseableTabbedPaneUI
extends BasicTabbedPaneUI {
    public static final Color TEXT_COLOR = new Color(50, 50, 50);
    public static final Color HIGH_CONTRAST_TEXT_COLOR = new Color(20, 20, 20);
    public static final Color SEL_TEXT_COLOR = new Color(10, 10, 10);
    public static final String CLOSE_SYMBOL = "\u00d7";
    public static final int TAB_PADDING = 5;
    public static final int CLOSE_SYMBOL_PADDING = 3;
    public static final Color TAB_TOP_COLOR = new Color(197, 197, 197);
    public static final Color TAB_BOTTOM_COLOR = new Color(189, 189, 189);
    public static final Color[] tabColorGradient = new Color[]{TAB_TOP_COLOR, TAB_BOTTOM_COLOR};
    public static final float[] tabGradient = new float[]{0.0f, 1.0f};
    public static final Color SEL_TAB_TOP_COLOR = new Color(220, 220, 220);
    public static final Color SEL_TAB_BOTTOM_COLOR = new Color(213, 213, 213);
    public static final Color[] selTabColorGradient = new Color[]{SEL_TAB_TOP_COLOR, SEL_TAB_BOTTOM_COLOR};
    public static final Color TAB_BORDER_COLOR = new Color(155, 155, 155);
    public static final Color HIGH_CONTRAST_TAB_BORDER_COLOR = new Color(80, 80, 80);
    public static final Insets emptyInsets = new Insets(0, 0, 0, 0);
    public static final int TOP_CONTENT_BORDER_HEIGHT = 5;
    public static final int DROP_SHADOW_HEIGHT = 5;
    public static final float[] dropShadowGradient = new float[]{0.0f, 1.0f};
    public static final Color DROP_SHADOW_TOP_COLOR = new Color(50, 50, 50, 0);
    public static final Color DROP_SHADOW_BOTTOM_COLOR = new Color(50, 50, 50, 20);
    public static final Color[] dropShadowColorGradient = new Color[]{DROP_SHADOW_TOP_COLOR, DROP_SHADOW_BOTTOM_COLOR};
    public static final Font OS_X_FONT = new Font("Helvetica Neue", 0, CloseableTabbedPaneUI.getFontSize());
    private final TabClosability tabClosability;
    private final TabCloseHandler closeHandler;

    private static int getFontSize() {
        Font font = UIManager.getDefaults().getFont("TabbedPane.font");
        return font != null ? font.getSize() : 12;
    }

    public CloseableTabbedPaneUI(TabClosability tabClosability, TabCloseHandler closeHandler) {
        this.tabClosability = tabClosability;
        this.closeHandler = closeHandler;
    }

    public CloseableTabbedPaneUI() {
        this(TabClosability.NOT_CLOSEABLE, new NullTabCloseHandler());
    }

    public static ComponentUI createUI(JComponent x) {
        return new CloseableTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets.left = 0;
        this.tabInsets = this.selectedTabPadInsets = emptyInsets;
        if (OSUtils.isOSX()) {
            this.tabPane.setFont(OS_X_FONT);
        }
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (OSUtils.isOSX()) {
            this.tabPane.setFont(OS_X_FONT);
        } else {
            this.tabPane.setFont(UIManager.getFont("TabbedPane.font"));
        }
    }

    private Color getTextColor() {
        if (UIUtil.isHighContrastOn()) {
            return HIGH_CONTRAST_TEXT_COLOR;
        }
        return TEXT_COLOR;
    }

    private Color getSelTextColor() {
        return SEL_TEXT_COLOR;
    }

    @Override
    protected int getTabRunOverlay(int tabPlacement) {
        return 0;
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        textRect.x = tabRect.x + 5;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (CloseableTabbedPaneUI.this.tabPane == null) {
                    return;
                }
                int tabIndex = CloseableTabbedPaneUI.this.tabForCoordinate(CloseableTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                if (tabIndex != -1) {
                    CloseableTabbedPaneUI.this.handleTabClicked(e, tabIndex);
                }
            }
        });
    }

    private void handleTabClicked(MouseEvent e, int tabIndex) {
        if (this.tabClosability == TabClosability.NOT_CLOSEABLE) {
            return;
        }
        if (this.isInCloseRect(e, tabIndex)) {
            this.handleCloseTabAt(tabIndex);
        }
    }

    private boolean isInCloseRect(MouseEvent e, int tabIndex) {
        FontMetrics fm = this.getFontMetrics();
        int width = (int)fm.getStringBounds(CLOSE_SYMBOL, this.tabPane.getGraphics()).getWidth() + 5;
        Rectangle rectangle = this.getTabBounds(this.tabPane, tabIndex);
        return rectangle.getX() + rectangle.getWidth() - (double)e.getX() < (double)width;
    }

    private void handleCloseTabAt(int tabIndex) {
        if (this.closeHandler.shouldCloseTab(tabIndex, this.tabPane)) {
            this.closeHandler.handleCloseTab(tabIndex, this.tabPane);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Graphics2D g2 = (Graphics2D)g;
        Object antiAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (isSelected) {
            g.setColor(this.getSelTextColor());
        } else {
            g.setColor(this.getTextColor());
        }
        g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAliasing);
    }

    @Override
    protected View getTextViewForTab(int tabIndex) {
        return null;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return new Insets(5, 0, 0, 0);
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        return emptyInsets;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        return emptyInsets;
    }

    @Override
    protected Insets getTabAreaInsets(int tabPlacement) {
        return emptyInsets;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        Rectangle tabBounds = super.getTabBounds(pane, i);
        tabBounds.height = this.getTabHeight();
        return tabBounds;
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        return this.getTabHeight();
    }

    @Override
    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        return maxTabHeight * horizRunCount;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (this.tabPane.getComponentCount() > 1) {
            return this.getTabHeight();
        }
        return 0;
    }

    private int getTabHeight() {
        return this.getFontMetrics().getMaxAscent() + 6;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int defaultWidth = super.calculateTabWidth(tabPlacement, tabIndex, metrics) + 10;
        if (this.tabClosability == TabClosability.CLOSABLE) {
            return defaultWidth + this.getFontMetrics().stringWidth(CLOSE_SYMBOL) + 6;
        }
        return defaultWidth;
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2 = (Graphics2D)g;
        Paint paint = g2.getPaint();
        if (isSelected) {
            g2.setPaint(new LinearGradientPaint(x, y, x, y + h, tabGradient, selTabColorGradient));
        } else {
            g2.setPaint(new LinearGradientPaint(x, y, x, y + h, tabGradient, tabColorGradient));
        }
        g.fillRect(x, y, w, h);
        if (!isSelected) {
            g2.setPaint(new LinearGradientPaint(x, y + h - 5, x, y + h, dropShadowGradient, dropShadowColorGradient));
            g2.fillRect(x, y + h - 5, w, 5);
        }
        g2.setPaint(paint);
        if (isSelected) {
            g.setColor(this.getSelTextColor());
        } else {
            g.setColor(this.getTextColor());
        }
        if (this.tabClosability == TabClosability.CLOSABLE) {
            Object antialias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = this.getFontMetrics();
            int width = (int)fm.getStringBounds(CLOSE_SYMBOL, g).getWidth();
            g.drawString(CLOSE_SYMBOL, x + w - width - 5, y + (h - fm.getHeight()) / 2 + fm.getAscent());
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias);
        }
        g.setColor(this.getTabBorderColor());
        g.drawLine(x, y, x + w - 1, y);
        if (this.isFirstTabInRun(tabIndex)) {
            g.drawLine(x, y, x, y + h);
        }
        g.drawLine(x + w - 1, y, x + w - 1, y + h);
    }

    private boolean isFirstTabInRun(int tabIndex) {
        for (int i : this.tabRuns) {
            if (i != tabIndex) continue;
            return true;
        }
        return false;
    }

    private boolean isBottomRun(int tabIndex) {
        int runIndex = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        return runIndex == 0;
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(SEL_TAB_BOTTOM_COLOR);
        g.drawLine(x, y + 1, x + w, y + 1);
        Graphics2D g2 = (Graphics2D)g;
        g.fillRect(x, y + 1, w, 5);
        g.setColor(this.getTabBorderColor());
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y + 5, x + w, y + 5);
        if (this.isBottomRun(selectedIndex)) {
            g.setColor(SEL_TAB_BOTTOM_COLOR);
            Rectangle r = this.getTabBounds(this.tabPane, selectedIndex);
            g.drawLine(r.x, y, r.x + r.width - 1, y);
        }
    }

    private Color getTabBorderColor() {
        if (UIUtil.isHighContrastOn()) {
            return HIGH_CONTRAST_TAB_BORDER_COLOR;
        }
        return TAB_BORDER_COLOR;
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicTabbedPaneUI.TabbedPaneLayout(){

            @Override
            protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
                if (tabPlacement == 1 || tabPlacement == 3) {
                    super.normalizeTabRuns(tabPlacement, tabCount, start, max);
                }
            }

            @Override
            protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            }

            @Override
            protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            }
        };
    }

    public static enum TabClosability {
        CLOSABLE,
        NOT_CLOSEABLE;

    }
}

