/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_de extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Zentralafrikanische Zeit",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskauer Normalzeit",
               "MSK",
               "Moskauer Sommerzeit",
               "MSD",
               "Moskauer Zeit",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japanische Normalzeit",
               "JST",
               "Japanische Sommerzeit",
               "JDT",
               "Japanische Zeit",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistanische Normalzeit",
               "PKT",
               "Pakistanische Sommerzeit",
               "PKST",
               "Pakistanische Zeit",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Taipeh-Normalzeit",
               "CST",
               "Taipeh-Sommerzeit",
               "CDT",
               "Taipeh-Zeit",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Chowd-Normalzeit",
               "HOVT",
               "Chowd-Sommerzeit",
               "HOVST",
               "Chowd-Zeit",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Magadan-Normalzeit",
               "MAGT",
               "Magadan-Sommerzeit",
               "MAGST",
               "Magadan-Zeit",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Zentral-/Westaustralische Normalzeit",
               "ACWST",
               "Zentral-/Westaustralische Sommerzeit",
               "ACWDT",
               "Zentral-/Westaustralische Zeit",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Mitteleurop\u00e4ische Normalzeit",
               "MEZ",
               "Mitteleurop\u00e4ische Sommerzeit",
               "MESZ",
               "Mitteleurop\u00e4ische Zeit",
               "MEZ",
            };
        final String[] Sakhalin = new String[] {
               "Sachalin-Normalzeit",
               "SAKT",
               "Sachalin-Sommerzeit",
               "SAKST",
               "Sachalin-Zeit",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayanische Normalzeit",
               "PYT",
               "Paraguayanische Sommerzeit",
               "PYST",
               "Paraguayanische Zeit",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Acre-Normalzeit",
               "ACT",
               "Acre-Sommerzeit",
               "ACST",
               "Acre-Zeit",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Malaysische Zeit",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Nordamerikanische Ostk\u00fcsten-Normalzeit",
               "EST",
               "Nordamerikanische Ostk\u00fcsten-Sommerzeit",
               "EDT",
               "Nordamerikanische Ostk\u00fcstenzeit",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Howe-Normalzeit",
               "LHST",
               "Lord-Howe-Sommerzeit",
               "LHDT",
               "Lord-Howe-Zeit",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Neuseeland-Normalzeit",
               "NZST",
               "Neuseeland-Sommerzeit",
               "NZDT",
               "Neuseeland-Zeit",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indischer Ozean-Zeit",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk-Normalzeit",
               "YAKT",
               "Jakutsk-Sommerzeit",
               "YAKST",
               "Jakutsk-Zeit",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-Normalzeit",
               "MUT",
               "Mauritius-Sommerzeit",
               "MUST",
               "Mauritius-Zeit",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ostafrikanische Zeit",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Osttimor-Zeit",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Salomoninseln-Zeit",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-Zeit",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinseln-Zeit",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Osteurop\u00e4ische Normalzeit",
               "OEZ",
               "Osteurop\u00e4ische Sommerzeit",
               "OESZ",
               "Osteurop\u00e4ische Zeit",
               "OEZ",
            };
        final String[] Newfoundland = new String[] {
               "Neufundland-Normalzeit",
               "NST",
               "Neufundland-Sommerzeit",
               "NDT",
               "Neufundland-Zeit",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-Zeit",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong-Normalzeit",
               "HKT",
               "Hongkong-Sommerzeit",
               "HKST",
               "Hongkong-Zeit",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Westargentinische Normalzeit",
               "ART",
               "Westargentinische Sommerzeit",
               "ARST",
               "Westargentinische Zeit",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Atlantik-Normalzeit",
               "AST",
               "Atlantik-Sommerzeit",
               "ADT",
               "Atlantik-Zeit",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ponape-Zeit",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Bolivianische Zeit",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-und-Miquelon-Normalzeit",
               "PMST",
               "Saint-Pierre-und-Miquelon-Sommerzeit",
               "PMDT",
               "Saint-Pierre-und-Miquelon-Zeit",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indochina-Zeit",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburg-Normalzeit",
               "YEKT",
               "Jekaterinburg-Sommerzeit",
               "YEKST",
               "Jekaterinburg-Zeit",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Malediven-Zeit",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-Zeit",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Israelische Normalzeit",
               "IST",
               "Israelische Sommerzeit",
               "IDT",
               "Israelische Zeit",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Zentralindonesische Zeit",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Wallis-und-Futuna-Zeit",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "S\u00fcdafrikanische Zeit",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowa-Zeit",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Linieninseln-Zeit",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan-Normalzeit",
               "UZT",
               "Usbekistan-Sommerzeit",
               "UZST",
               "Usbekistan-Zeit",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Omsk-Normalzeit",
               "OMST",
               "Omsk-Sommerzeit",
               "OMSST",
               "Omsk-Zeit",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Seychellen-Zeit",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Uruguyanische Normalzeit",
               "UYT",
               "Uruguayanische Sommerzeit",
               "UYST",
               "Uruguayanische Zeit",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Nepalesische Zeit",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-Normalzeit",
               "ULAT",
               "Ulaanbaatar-Sommerzeit",
               "ULAST",
               "Ulaanbaatar-Zeit",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Nordamerikanische Inland-Normalzeit",
               "CST",
               "Nordamerikanische Inland-Sommerzeit",
               "CDT",
               "Nordamerikanische Inlandzeit",
               "CT",
            };
        final String[] Truk = new String[] {
               "Chuuk-Zeit",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Niue-Zeit",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Wake-Insel-Zeit",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Falklandinseln-Normalzeit",
               "FKT",
               "Falklandinseln-Sommerzeit",
               "FKST",
               "Falklandinseln-Zeit",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-Normalzeit",
               "VUT",
               "Vanuatu-Sommerzeit",
               "VUST",
               "Vanuatu-Zeit",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirsk-Normalzeit",
               "NOVT",
               "Nowosibirsk-Sommerzeit",
               "NOVST",
               "Nowosibirsk-Zeit",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Singapur-Zeit",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Azoren-Normalzeit",
               "AZOT",
               "Azoren-Sommerzeit",
               "AZOST",
               "Azoren-Zeit",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Apia-Normalzeit",
               "WSST",
               "Apia-Sommerzeit",
               "WSDT",
               "Apia-Zeit",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Bhutan-Zeit",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Suriname-Zeit",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Nauru-Zeit",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-Normalzeit",
               "KRAT",
               "Krasnojarsk-Sommerzeit",
               "KRAST",
               "Krasnojarsk-Zeit",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Westkasachische Zeit",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Myanmar-Zeit",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Weihnachtsinsel-Zeit",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazonas-Normalzeit",
               "AMT",
               "Amazonas-Sommerzeit",
               "AMST",
               "Amazonas-Zeit",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ostkasachische Zeit",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Fidschi-Normalzeit",
               "FJT",
               "Fidschi-Sommerzeit",
               "FJST",
               "Fidschi-Zeit",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union-Zeit",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Kokosinseln-Zeit",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Chatham-Normalzeit",
               "CHAST",
               "Chatham-Sommerzeit",
               "CHADT",
               "Chatham-Zeit",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Wostok-Zeit",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Argentinische Normalzeit",
               "ART",
               "Argentinische Sommerzeit",
               "ARST",
               "Argentinische Zeit",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Gambier-Zeit",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Kamtschatka-Normalzeit",
               "PETT",
               "Kamtschatka-Sommerzeit",
               "PETST",
               "Kamtschatka-Zeit",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-Zeit",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-Zeit",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Macquarieinsel-Zeit",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-Zeit",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuten-Normalzeit",
               "HAST",
               "Hawaii-Aleuten-Sommerzeit",
               "HADT",
               "Hawaii-Aleuten-Zeit",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Zentralaustralische Normalzeit",
               "ACST",
               "Zentralaustralische Sommerzeit",
               "ACDT",
               "Zentralaustralische Zeit",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Nordamerikanische Westk\u00fcsten-Normalzeit",
               "PST",
               "Nordamerikanische Westk\u00fcsten-Sommerzeit",
               "PDT",
               "Nordamerikanische Westk\u00fcstenzeit",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixinseln-Zeit",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-Normalzeit",
               "TMT",
               "Turkmenistan-Sommerzeit",
               "TMST",
               "Turkmenistan-Zeit",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Westeurop\u00e4ische Normalzeit",
               "WEZ",
               "Westeurop\u00e4ische Sommerzeit",
               "WESZ",
               "Westeurop\u00e4ische Zeit",
               "WEZ",
            };
        final String[] Cape_Verde = new String[] {
               "Kap-Verde-Normalzeit",
               "CVT",
               "Kap-Verde-Sommerzeit",
               "CVST",
               "Kap-Verde-Zeit",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinsel-Zeit",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Guyana-Zeit",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairninseln-Zeit",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Rothera-Zeit",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Samoa-Normalzeit",
               "SST",
               "Samoa-Sommerzeit",
               "SDT",
               "Samoa-Zeit",
               "ST",
            };
        final String[] Palau = new String[] {
               "Palau-Zeit",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Kaliningrader Zeit",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidschanische Normalzeit",
               "AZT",
               "Aserbaidschanische Sommerzeit",
               "AZST",
               "Aserbaidschanische Zeit",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Mawson-Zeit",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexiko Pazifikzone-Normalzeit",
               "MST",
               "Mexiko Pazifikzone-Sommerzeit",
               "MDT",
               "Mexiko Pazifikzone-Zeit",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davis-Zeit",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Kubanische Normalzeit",
               "CST",
               "Kubanische Sommerzeit",
               "CDT",
               "Kubanische Zeit",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Westafrikanische Normalzeit",
               "CAT",
               "Westafrikanische Sommerzeit",
               "CAST",
               "Westafrikanische Zeit",
               "CAT",
            };
        final String[] GMT = new String[] {
               "Mittlere Greenwich-Zeit",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Philippinische Normalzeit",
               "PHT",
               "Philippinische Sommerzeit",
               "PHST",
               "Philippinische Zeit",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Franz\u00f6sische S\u00fcd- und Antarktisgebiete-Zeit",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "S\u00fcdgeorgische Zeit",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Neukaledonische Normalzeit",
               "NCT",
               "Neukaledonische Sommerzeit",
               "NCST",
               "Neukaledonische Zeit",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Brunei-Zeit",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Iranische Normalzeit",
               "IRST",
               "Iranische Sommerzeit",
               "IRDT",
               "Iranische Zeit",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Osterinsel-Normalzeit",
               "EAST",
               "Osterinsel-Sommerzeit",
               "EASST",
               "Osterinsel-Zeit",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Mexiko Nordwestliche Zone-Normalzeit",
               "PST",
               "Mexiko Nordwestliche Zone-Sommerzeit",
               "PDT",
               "Mexiko Nordwestliche Zone-Zeit",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville-Zeit",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Tadschikistan-Zeit",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Tonganische Normalzeit",
               "TOT",
               "Tonganische Sommerzeit",
               "TOST",
               "Tonganische Zeit",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesch-Normalzeit",
               "BDT",
               "Bangladesch-Sommerzeit",
               "BDST",
               "Bangladesch-Zeit",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Peruanische Normalzeit",
               "PET",
               "Peruanische Sommerzeit",
               "PEST",
               "Peruanische Zeit",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Westgr\u00f6nland-Normalzeit",
               "WGT",
               "Westgr\u00f6nland-Sommerzeit",
               "WGST",
               "Westgr\u00f6nland-Zeit",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorianische Zeit",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ostgr\u00f6nland-Normalzeit",
               "EGT",
               "Ostgr\u00f6nland-Sommerzeit",
               "EGST",
               "Ostgr\u00f6nland-Zeit",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Golf-Zeit",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ostindonesische Zeit",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Koreanische Normalzeit",
               "KST",
               "Koreanische Sommerzeit",
               "KDT",
               "Koreanische Zeit",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Westaustralische Normalzeit",
               "AWST",
               "Westaustralische Sommerzeit",
               "AWDT",
               "Westaustralische Zeit",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisistan-Zeit",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Westindonesische Zeit",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Ostaustralische Normalzeit",
               "AEST",
               "Ostaustralische Sommerzeit",
               "AEDT",
               "Ostaustralische Zeit",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Franz\u00f6sisch-Guayana-Zeit",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Kolumbianische Normalzeit",
               "COT",
               "Kolumbianische Sommerzeit",
               "COST",
               "Kolumbianische Zeit",
               "COT",
            };
        final String[] Chile = new String[] {
               "Chilenische Normalzeit",
               "CLT",
               "Chilenische Sommerzeit",
               "CLST",
               "Chilenische Zeit",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-Inseln-Zeit",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Rocky Mountain-Normalzeit",
               "MST",
               "Rocky-Mountain-Sommerzeit",
               "MDT",
               "Rocky-Mountain-Zeit",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-Zeit",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Arabische Normalzeit",
               "AST",
               "Arabische Sommerzeit",
               "ADT",
               "Arabische Zeit",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaska-Normalzeit",
               "AKST",
               "Alaska-Sommerzeit",
               "AKDT",
               "Alaska-Zeit",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok-Normalzeit",
               "VLAT",
               "Wladiwostok-Sommerzeit",
               "VLAST",
               "Wladiwostok-Zeit",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-Zeit",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-Normalzeit",
               "IRKT",
               "Irkutsk-Sommerzeit",
               "IRKST",
               "Irkutsk-Zeit",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Georgische Normalzeit",
               "GET",
               "Georgische Sommerzeit",
               "GEST",
               "Georgische Zeit",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-Zeit",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Neuguinea-Zeit",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-Normalzeit",
               "FNT",
               "Fernando de Noronha-Sommerzeit",
               "FNST",
               "Fernando de Noronha-Zeit",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Tschoibalsan-Normalzeit",
               "CHOT",
               "Tschoibalsan-Sommerzeit",
               "CHOST",
               "Tschoibalsan-Zeit",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia-Normalzeit",
               "BRT",
               "Bras\u00edlia-Sommerzeit",
               "BRST",
               "Bras\u00edlia-Zeit",
               "BRT",
            };
        final String[] China = new String[] {
               "Chinesische Normalzeit",
               "CST",
               "Chinesische Sommerzeit",
               "CDT",
               "Chinesische Zeit",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armenische Normalzeit",
               "AMT",
               "Armenische Sommerzeit",
               "AMST",
               "Armenische Zeit",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Samara-Normalzeit",
               "SAMT",
               "Samara-Sommerzeit",
               "SAMST",
               "Samara-Zeit",
               "SAMT",
            };
        final String[] India = new String[] {
               "Indische Zeit",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Cookinseln-Normalzeit",
               "CKT",
               "Cookinseln-Sommerzeit",
               "CKHST",
               "Cookinseln-Zeit",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Mittlere Greenwich-Zeit",
                    "GMT",
                    "Britische Sommerzeit",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Mittlere Greenwich-Zeit",
                    "GMT",
                    "Irische Sommerzeit",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
