/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Argument;
import com.github.cereda.arara.model.Messages;
import com.github.cereda.arara.model.Rule;
import com.github.cereda.arara.model.RuleCommand;
import com.github.cereda.arara.utils.CommonUtils;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class RuleUtils {
    private static final LanguageController messages = LanguageController.getInstance();

    public static Rule parseRule(File file, String identifier) throws AraraException {
        Representer representer = new Representer();
        representer.addClassTag(Rule.class, new Tag("!config"));
        Yaml yaml = new Yaml(new Constructor(Rule.class), representer);
        Rule rule = null;
        try {
            rule = yaml.loadAs(new FileReader(file), Rule.class);
        }
        catch (MarkedYAMLException yamlException) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_PARSERULE_INVALID_YAML)), yamlException);
        }
        catch (Exception exception) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_PARSERULE_GENERIC_ERROR)));
        }
        RuleUtils.validateHeader(rule, identifier);
        RuleUtils.validateBody(rule);
        return rule;
    }

    private static void validateHeader(Rule rule, String identifier) throws AraraException {
        if (rule.getIdentifier() != null) {
            if (!rule.getIdentifier().equals(identifier)) {
                throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEHEADER_WRONG_IDENTIFIER, rule.getIdentifier(), identifier)));
            }
        } else {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEHEADER_NULL_ID)));
        }
        if (rule.getName() == null) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEHEADER_NULL_NAME)));
        }
    }

    private static void validateBody(Rule rule) throws AraraException {
        int found;
        if (rule.getCommands() == null) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEBODY_NULL_COMMANDS_LIST)));
        }
        if (CollectionUtils.exists(rule.getCommands(), new Predicate<RuleCommand>(){

            @Override
            public boolean evaluate(RuleCommand command) {
                return command.getCommand() == null;
            }
        })) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEBODY_NULL_COMMAND)));
        }
        if (rule.getArguments() == null) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEBODY_ARGUMENTS_LIST)));
        }
        String[] keywords = new String[]{"file", "files", "reference"};
        ArrayList<String> arguments = new ArrayList<String>();
        for (Argument argument : rule.getArguments()) {
            if (argument.getIdentifier() != null) {
                if (argument.getFlag() != null || argument.getDefault() != null) {
                    arguments.add(argument.getIdentifier());
                    continue;
                }
                throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEBODY_MISSING_KEYS)));
            }
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEBODY_NULL_ARGUMENT_ID)));
        }
        for (String keyword : keywords) {
            if (!arguments.contains(keyword)) continue;
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEBODY_ARGUMENT_ID_IS_RESERVED, keyword)));
        }
        int expected = arguments.size();
        if (expected != (found = new HashSet(arguments).size())) {
            throw new AraraException(CommonUtils.getRuleErrorHeader().concat(messages.getMessage(Messages.ERROR_VALIDATEBODY_DUPLICATE_ARGUMENT_IDENTIFIERS)));
        }
    }
}

