#############################################################################
##
#W  fpmon.gd           GAP library        										Isabel Araújo
##
##
#Y  Copyright (C)  1997,  Lehrstuhl D für Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This file contains the declarations for finitely presented monoids. 
##

#############################################################################
##
#C  IsElementOfFpMonoid(<elm>)
##
##  <#GAPDoc Label="IsElementOfFpMonoid">
##  <ManSection>
##  <Filt Name="IsElementOfFpMonoid" Arg='elm' Type='Category'/>
##
##  <Description>
##  returns true if <A>elm</A> is an element of a finitely presented monoid. 
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareCategory( "IsElementOfFpMonoid",
    IsMultiplicativeElementWithOne and IsAssociativeElement);

#############################################################################
##
#C  IsElementOfFpMonoidCollection(<e>)
##
##  <ManSection>
##  <Filt Name="IsElementOfFpMonoidCollection" Arg='e' Type='Category'/>
##
##  <Description>
##  Created now so that lists of things in the category IsElementOfFpMonoid
##  are given the category CategoryCollections(IsElementOfFpMonoid)
##  Otherwise these lists (and other collections) won't create the 
##  collections category. See CollectionsCategory in the manual.
##   
##  </Description>
##  </ManSection>
##
DeclareCategoryCollections("IsElementOfFpMonoid");

#############################################################################
##
#A  IsSubmonoidFpMonoid( <t> )
##
##  <#GAPDoc Label="IsSubmonoidFpMonoid">
##  <ManSection>
##  <Filt Name="IsSubmonoidFpMonoid" Arg='t'/>
##
##  <Description>
##  true if <A>t</A> is a finitely presented monoid or a 
##  submonoid of a finitely presented monoid 
##  (generally speaking, such a semigroup can be constructed
##  with <C>Monoid(<A>gens</A>)</C>, where <A>gens</A> is a list of elements
##  of a finitely presented monoid).
##  <P/>
##  A submonoid of a monoid has the same identity as the monoid.
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareSynonymAttr( "IsSubmonoidFpMonoid", 
	IsMonoid and IsElementOfFpMonoidCollection );

#############################################################################
##  
#C  IsElementOfFpMonoidFamily
##
##  <ManSection>
##  <Filt Name="IsElementOfFpMonoidFamily" Arg='obj' Type='Category'/>
##
##  <Description>
##  </Description>
##  </ManSection>
##
DeclareCategoryFamily( "IsElementOfFpMonoid" );

#############################################################################
##
#F  FactorFreeMonoidByRelations( <f>, <rels> )
##
##  <ManSection>
##  <Func Name="FactorFreeMonoidByRelations" Arg='f, rels'/>
##
##  <Description>
##  <A>f</A> is a free monoid and <A>rels</A> is a list of
##  pairs of elements of <A>f</A>. Returns the fp monoid which
##  is the quotient of <A>f</A> by the least congruence on <A>f</A> generated by
##  the pairs in <A>rels</A>.
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction("FactorFreeMonoidByRelations");

#############################################################################
##  
#O  ElementOfFpMonoid( <fam>, <word> )
##
##  <ManSection>
##  <Oper Name="ElementOfFpMonoid" Arg='fam, word'/>
##
##  <Description>
##  If <A>fam</A> is the elements family of a finitely presented monoid and <A>word</A>
##  is a word in the free generators underlying this finitely presented
##  monoid, this operation creates the element with the representative <A>word</A>
##  in the free monoid.
##  </Description>
##  </ManSection>
##
DeclareOperation( "ElementOfFpMonoid",
    [ IsElementOfFpMonoidFamily, IsAssocWordWithOne ] );

#############################################################################
##
#O  FpMonoidOfElementOfFpMonoid( <elm> )
##
##  <ManSection>
##  <Oper Name="FpMonoidOfElementOfFpMonoid" Arg='elm'/>
##
##  <Description>
##  returns the fp monoid to which <A>elm</A> belongs to
##  </Description>
##  </ManSection>
##
DeclareOperation( "FpMonoidOfElementOfFpMonoid",[IsElementOfFpMonoid]);

#############################################################################
##
#P  IsFpMonoid(<m>)
##
##  <#GAPDoc Label="IsFpMonoid">
##  <ManSection>
##  <Filt Name="IsFpMonoid" Arg='m'/>
##
##  <Description>
##  is a synonym for <C>IsSubmonoidFpMonoid(<A>m</A>)</C> and 
##  <C>IsWholeFamily(<A>m</A>)</C> (this is because a submonoid 
##  of a finitely presented monoid is not necessarily finitely presented).
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##
DeclareSynonym( "IsFpMonoid",IsSubmonoidFpMonoid and IsWholeFamily);

#############################################################################
## 
#A  FreeGeneratorsOfFpMonoid( <m> )
##
##  <ManSection>
##  <Attr Name="FreeGeneratorsOfFpMonoid" Arg='m'/>
##
##  <Description>
##  returns the underlying free generators corresponding to the 
##  generators of the finitely presented monoid <A>m</A>.  
##  </Description>
##  </ManSection>
##
DeclareAttribute("FreeGeneratorsOfFpMonoid",  IsFpMonoid);

#############################################################################
## 
#A  FreeMonoidOfFpMonoid( <m> )
##
##  <ManSection>
##  <Attr Name="FreeMonoidOfFpMonoid" Arg='m'/>
##
##  <Description>
##  returns the underlying free monoid for the finitely presented 
##  monoid <A>m</A>, ie, the free monoid over which <A>m</A> is defined 
##  as a quotient
##  (this is the free monoid generated by the free generators provided 
##  by <C>FreeGeneratorsOfFpMonoid(<A>m</A>)</C>).
##  </Description>
##  </ManSection>
##
DeclareAttribute("FreeMonoidOfFpMonoid", IsFpMonoid);

############################################################################
##
#A  RelationsOfFpMonoid(<m>)
##
##  <ManSection>
##  <Attr Name="RelationsOfFpMonoid" Arg='m'/>
##
##  <Description>
##  returns the relations of the finitely presented monoid <A>m</A> as
##  pairs of words in the free generators provided by
##  <C>FreeGeneratorsOfFpMonoid(<A>m</A>)</C>.
##  </Description>
##  </ManSection>
##
DeclareAttribute("RelationsOfFpMonoid",IsFpMonoid);

############################################################################
##
#A  IsomorphismFpMonoid(<m>)
##
##  <ManSection>
##  <Attr Name="IsomorphismFpMonoid" Arg='m'/>
##
##  <Description>
##  for a monoid <A>m</A> returns an isomorphism from <A>m</A> to an fp monoid.
##  If the option <tt>relations</tt> is given, it must be a list of relations
##  given by words in the free group. The monoid then is created with these
##  relations (plus the ``inverse'' relations <A>x\cdot x^{-1}=1</A>). No
##  particular choice of generators or relations is guaranteed.
##  </Description>
##  </ManSection>
##
DeclareAttribute("IsomorphismFpMonoid",IsMonoid);

############################################################################
##
#F  IsomorphismFpMonoidInversesFirst(<G>)
##
##  <ManSection>
##  <Func Name="IsomorphismFpMonoid" Arg='G'/>
##
##  <Description>
##  for a finitely presented group <A>G</A> this function
##  returns an isomorphism from <A>G</A> to an fp monoid <A>M</A>. The
##  generators of <A>M</A> are chosen to correspond to the generators of
##  <A>G</A> in the sequence <A>x_1^{-1},x_1,x_2^{-1},x_2,\ldots</A>.
##  If the option <tt>relations</tt> is given, it must be a list of relations
##  given by words in the free group. The monoid then is created with these
##  relations (plus the ``inverse'' relations <A>x\cdot x^{-1}=1</A>).
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction("IsomorphismFpMonoidInversesFirst");

############################################################################
##
#F  IsomorphismFpMonoidGeneratorsFirst(<G>)
##
##  <ManSection>
##  <Func Name="IsomorphismFpMonoid" Arg='G'/>
##
##  <Description>
##  for a finitely presented group <A>G</A> this function
##  returns an isomorphism from <A>G</A> to an fp monoid <A>M</A>. The
##  generators of <A>M</A> are chosen to correspond to the generators of
##  <A>G</A> in the sequence <A>x_1,x_1^{-1},x_2,x_2^{-1},\ldots</A>.
##  If the option <tt>relations</tt> is given, it must be a list of relations
##  given by words in the free group. The monoid then is created with these
##  relations (plus the ``inverse'' relations <A>x\cdot x^{-1}=1</A>).
##  </Description>
##  </ManSection>
##
DeclareGlobalFunction("IsomorphismFpMonoidGeneratorsFirst");

#############################################################################
##
#E

