/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubySymbol;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveKeywordArgInstr
extends ReceiveArgBase
implements FixedArityInstr {
    public final RubySymbol key;
    public final int required;

    public ReceiveKeywordArgInstr(Variable result2, RubySymbol key2, int required) {
        super(Operation.RECV_KW_ARG, result2, -1);
        this.key = key2;
        this.required = required;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.getKey(), "req: " + this.required};
    }

    @Override
    public boolean computeScopeFlags(IRScope scope) {
        scope.getFlags().add(IRFlags.RECEIVES_KEYWORD_ARGS);
        return true;
    }

    public String getId() {
        return this.key.idString();
    }

    public RubySymbol getKey() {
        return this.key;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ReceiveKeywordArgInstr(ii.getRenamedVariable(this.result), this.getKey(), this.required);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getKey());
        e.encode(this.required);
    }

    public static ReceiveKeywordArgInstr decode(IRReaderDecoder d) {
        return new ReceiveKeywordArgInstr(d.decodeVariable(), d.decodeSymbol(), d.decodeInt());
    }

    @Override
    public IRubyObject receiveArg(ThreadContext context, IRubyObject[] args2, boolean acceptsKeywordArgument) {
        return IRRuntimeHelpers.receiveKeywordArg(context, args2, this.required, this.getKey(), acceptsKeywordArgument);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveKeywordArgInstr(this);
    }
}

