/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Arrays;
import java.util.Set;

class LongSet {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient long[] table;
    private int size;
    private volatile transient int modCount;
    private transient int threshold;

    LongSet() {
        this.init(32);
    }

    LongSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + n);
        }
        this.init(this.capacity(n));
    }

    private int capacity(int n) {
        int n2;
        int n3 = 4 * n / 3;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            for (n2 = 4; n2 < n3; n2 <<= 1) {
            }
        }
        return n2;
    }

    private void init(int n) {
        this.threshold = n * 3 / 4;
        this.table = new long[n];
    }

    LongSet(Set<Long> set) {
        this((int)((double)(1 + set.size()) * 1.1));
        this.putAll(set);
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(long l, int n) {
        int n2 = (int)(l ^ l >>> 32);
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        n2 ^= n2 >>> 7 ^ n2 >>> 4;
        return n2 & n - 1;
    }

    private static int nextKeyIndex(int n, int n2) {
        return n + 1 < n2 ? n + 1 : 0;
    }

    boolean contains(long l) {
        assert (l != 0L);
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongSet.hash(l, n);
        long l2;
        while ((l2 = lArray[n2]) != l) {
            if (l2 == 0L) {
                return false;
            }
            n2 = LongSet.nextKeyIndex(n2, n);
        }
        return true;
    }

    boolean add(long l) {
        long l2;
        assert (l != 0L);
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongSet.hash(l, n);
        while ((l2 = lArray[n2]) != 0L) {
            if (l2 == l) {
                return true;
            }
            n2 = LongSet.nextKeyIndex(n2, n);
        }
        ++this.modCount;
        lArray[n2] = l;
        if (++this.size >= this.threshold) {
            this.resize(2 * n);
        }
        return false;
    }

    private void resize(int n) {
        int n2 = n;
        long[] lArray = this.table;
        int n3 = lArray.length;
        if (n3 == 0x40000000) {
            if (this.threshold == 0x3FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x3FFFFFFF;
            return;
        }
        if (n3 >= n2) {
            return;
        }
        long[] lArray2 = new long[n2];
        this.threshold = n2 * 3 / 4;
        for (int i = 0; i < n3; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            int n4 = LongSet.hash(l, n2);
            while (lArray2[n4] != 0L) {
                n4 = LongSet.nextKeyIndex(n4, n2);
            }
            lArray2[n4] = l;
        }
        this.table = lArray2;
    }

    void putAll(Set<Long> set) {
        int n = set.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Long l : set) {
            this.add(l);
        }
    }

    boolean remove(long l) {
        long[] lArray = this.table;
        int n = lArray.length;
        int n2 = LongSet.hash(++l, n);
        while (true) {
            long l2;
            if ((l2 = lArray[n2]) == l) {
                ++this.modCount;
                --this.size;
                lArray[n2] = 0L;
                this.closeDeletion(n2);
                return true;
            }
            if (l2 == 0L) {
                return false;
            }
            n2 = LongSet.nextKeyIndex(n2, n);
        }
    }

    private void closeDeletion(int n) {
        long l;
        long[] lArray = this.table;
        int n2 = lArray.length;
        int n3 = LongSet.nextKeyIndex(n, n2);
        while ((l = lArray[n3]) != 0L) {
            int n4 = LongSet.hash(l, n2);
            if (n3 < n4 && (n4 <= n || n <= n3) || n4 <= n && n <= n3) {
                lArray[n] = l;
                lArray[n3] = 0L;
                n = n3;
            }
            n3 = LongSet.nextKeyIndex(n3, n2);
        }
    }

    void clear() {
        ++this.modCount;
        long[] lArray = this.table;
        Arrays.fill(lArray, 0L);
        this.size = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LongSet) {
            LongSet longSet = (LongSet)object;
            if (longSet.size() != this.size) {
                return false;
            }
            long[] lArray = longSet.table;
            for (int i = 0; i < lArray.length; ++i) {
                long l = lArray[i];
                if (l == 0L || this.contains(l)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        long[] lArray = this.table;
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            n += LongSet.hash(l, lArray.length);
        }
        return n;
    }
}

