/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.results.CCTNode;

public abstract class LockCCTNode
extends CCTNode {
    public static final LockCCTNode EMPTY = new LockCCTNode(null){

        @Override
        public LockCCTNode getChild(int n) {
            return null;
        }

        @Override
        public LockCCTNode[] getChildren() {
            return new LockCCTNode[0];
        }

        @Override
        public int getIndexOfChild(Object object) {
            return -1;
        }

        @Override
        public int getNChildren() {
            return 0;
        }

        @Override
        public String getNodeName() {
            return "";
        }

        @Override
        public long getTime() {
            return 0L;
        }

        @Override
        public double getTimeInPerCent() {
            return 0.0;
        }

        @Override
        public long getWaits() {
            return 0L;
        }
    };
    private List<LockCCTNode> children;
    private final LockCCTNode parent;

    LockCCTNode(LockCCTNode lockCCTNode) {
        this.parent = lockCCTNode;
    }

    @Override
    public LockCCTNode getChild(int n) {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.get(n);
    }

    public LockCCTNode[] getChildren() {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.toArray(new LockCCTNode[0]);
    }

    @Override
    public int getIndexOfChild(Object object) {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.indexOf(object);
    }

    @Override
    public int getNChildren() {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.size();
    }

    @Override
    public LockCCTNode getParent() {
        return this.parent;
    }

    void addChild(LockCCTNode lockCCTNode) {
        if (this.children == null) {
            this.children = new ArrayList<LockCCTNode>();
        }
        this.children.add(lockCCTNode);
    }

    void computeChildren() {
        this.children = new ArrayList<LockCCTNode>();
    }

    private void computeChildrenImpl() {
        this.computeChildren();
    }

    public double getTimeInPerCent() {
        LockCCTNode lockCCTNode = this.getParent();
        long l = lockCCTNode.getTime();
        double d = lockCCTNode.getTimeInPerCent();
        long l2 = this.getTime();
        return d * (double)l2 / (double)l;
    }

    public abstract String getNodeName();

    public abstract long getTime();

    public abstract long getWaits();

    public boolean isThreadLockNode() {
        return false;
    }

    public boolean isMonitorNode() {
        return false;
    }

    public String toString() {
        return this.getNodeName();
    }

    /*
     * WARNING - void declaration
     */
    public void debug() {
        if (this.parent != null) {
            void var1_2;
            String object = "";
            for (CCTNode cCTNode = this.parent; cCTNode != null; cCTNode = ((CCTNode)cCTNode).getParent()) {
                String string = (String)var1_2 + "  ";
            }
            System.out.println((String)var1_2 + this.getNodeName() + " Waits: " + this.getWaits() + " Time: " + this.getTime() + " " + NumberFormat.getPercentInstance().format(this.getTimeInPerCent() / 100.0));
        }
        for (LockCCTNode lockCCTNode : this.getChildren()) {
            if (!(lockCCTNode instanceof LockCCTNode)) continue;
            lockCCTNode.debug();
        }
    }
}

