/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include <typedef.h>
#include <getput.h>
#include <matrix.h>
#include <base.h>
#include <longtools.h>



/************************************************************************
@   Calculate the order of the cohomology group!
@
@   matrix_TYP *D:         2nd matrix returned by cohomolgy for G.
*************************************************************************/
MP_INT cohomology_size(matrix_TYP *D)
{
   int first, i;

   MP_INT coho_size;


   for (first = 0; first < D->cols && D->array.SZ[first][first] == 1; first++);

   mpz_init_set_si(&coho_size, 1);
   /* the order of the cohomology group in the product of those elementary
      divisors which are not equal 0 */
   for (i = first; i < D->cols && D->array.SZ[i][i] != 0; i++)
      mpz_mul_ui(&coho_size, &coho_size, (unsigned long) D->array.SZ[i][i]);

   return(coho_size);
}
