/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "matrix.h"
#include "bravais.h"



main (int argc, char *argv[])

{
  bravais_TYP *S;
  bravais_TYP *B;
  matrix_TYP *X;
  int i,j;

  extern char **FILENAMES;
  extern int FILEANZ;
  
  extern bravais_TYP *get_bravais();
  extern bravais_TYP *Z_class();
  read_header(argc, argv);
  if(FILEANZ != 1)
  {
    printf("usage:   gittstab 'file',\n");
    printf("where 'file' contains a group given as bravais_TYP\n");
    if (is_option('h')){
       exit(0);
    }
    else{
       exit(31);
    }
  }
/***********
  B = (bravais_TYP *) malloc(sizeof(bravais_TYP));
**************/
  B = get_bravais(FILENAMES[0]);
     for(j=0; j<B->zentr_no; j++)
     {
        X = B->zentr[j];
        S = Z_class(B, X);
        put_bravais(S, NULL, "not almost decomposable bravais-group");
        free_bravais(S);
     }


  exit(0);
}
/*{{{}}}*/
