/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"getput.h"
#include"matrix.h"
#include"symm.h"
#include"reduction.h"




main (int argc, char *argv[])
{

	matrix_TYP **Mat, *T, *Red, *SV;
        int i, anz;
        int min;

        extern char **FILENAMES;
        extern int FILEANZ;

	extern matrix_TYP *short_reduce();

        read_header(argc, argv);
        if(FILEANZ != 1)
        {
           printf("usage:  short_reduce 'file',\n");
           printf("where 'file' contains a set of positiv semidefinite matrices.\n");
           if (is_option('h')){
              exit(0);
           }
           else{
              exit(31);
           }
        }
	Mat = mget_mat (FILENAMES[0], &anz);
        if(anz > 1)
          printf("#%d\n", anz);
        for(i=0;i<anz;i++)
        {
            T = init_mat(Mat[i]->cols, Mat[i]->cols, "1");
            SV = shortest(Mat[i], &min);
            Red = short_reduce(Mat[i], SV, T);
            put_mat(Red, NULL, "reduced matrix", 2);
            if(is_option('t') == TRUE)
             put_mat(T, NULL, "Transformation matrix", 0);
            free_mat(Red);
            free_mat(T);
            free_mat(SV);
        }

   exit(0);
}
