/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.matcher;

import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.macro.matcher.ASTMatcher;
import org.codehaus.groovy.macro.matcher.ContextualClassCodeVisitor;
import org.codehaus.groovy.macro.matcher.TreeContext;

class ASTFinder
extends ContextualClassCodeVisitor {
    private final ASTNode initial;
    private final List<TreeContext> matches = new LinkedList<TreeContext>();

    ASTFinder(ASTNode initial) {
        this.initial = initial;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return null;
    }

    public List<TreeContext> getMatches() {
        return this.matches;
    }

    private void tryFind(Class<?> clazz, ASTNode node) {
        if (clazz.isAssignableFrom(this.initial.getClass()) && ASTMatcher.matches(node, this.initial)) {
            this.matches.add(this.getLastContext());
        }
    }

    @Override
    public void visitClass(ClassNode node) {
        super.visitClass(node);
        this.tryFind(ClassNode.class, node);
    }

    @Override
    public void visitPackage(PackageNode node) {
        super.visitPackage(node);
        this.tryFind(PackageNode.class, node);
    }

    @Override
    public void visitImports(ModuleNode node) {
        super.visitImports(node);
        this.tryFind(ModuleNode.class, node);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        super.visitDeclarationExpression(expression);
        this.tryFind(DeclarationExpression.class, expression);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        super.visitConstructorOrMethod(node, isConstructor);
        this.tryFind(MethodNode.class, node);
    }

    @Override
    public void visitField(FieldNode node) {
        super.visitField(node);
        this.tryFind(FieldNode.class, node);
    }

    @Override
    public void visitProperty(PropertyNode node) {
        super.visitProperty(node);
        this.tryFind(PropertyNode.class, node);
    }

    @Override
    public void visitAssertStatement(AssertStatement statement) {
        super.visitAssertStatement(statement);
        this.tryFind(AssertStatement.class, statement);
    }

    @Override
    public void visitBreakStatement(BreakStatement statement) {
        super.visitBreakStatement(statement);
        this.tryFind(BreakStatement.class, statement);
    }

    @Override
    public void visitCaseStatement(CaseStatement statement) {
        super.visitCaseStatement(statement);
        this.tryFind(CaseStatement.class, statement);
    }

    @Override
    public void visitCatchStatement(CatchStatement statement) {
        super.visitCatchStatement(statement);
        this.tryFind(CatchStatement.class, statement);
    }

    @Override
    public void visitContinueStatement(ContinueStatement statement) {
        super.visitContinueStatement(statement);
        this.tryFind(ContinueStatement.class, statement);
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement loop) {
        super.visitDoWhileLoop(loop);
        this.tryFind(DoWhileStatement.class, loop);
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement) {
        super.visitExpressionStatement(statement);
        this.tryFind(ExpressionStatement.class, statement);
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        super.visitForLoop(forLoop);
        this.tryFind(ForStatement.class, forLoop);
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        super.visitIfElse(ifElse);
        this.tryFind(IfStatement.class, ifElse);
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement) {
        super.visitReturnStatement(statement);
        this.tryFind(ReturnStatement.class, statement);
    }

    @Override
    public void visitSwitch(SwitchStatement statement) {
        super.visitSwitch(statement);
        this.tryFind(SwitchStatement.class, statement);
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement statement) {
        super.visitSynchronizedStatement(statement);
        this.tryFind(SynchronizedStatement.class, statement);
    }

    @Override
    public void visitThrowStatement(ThrowStatement statement) {
        super.visitThrowStatement(statement);
        this.tryFind(ThrowStatement.class, statement);
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement statement) {
        super.visitTryCatchFinally(statement);
        this.tryFind(TryCatchStatement.class, statement);
    }

    @Override
    public void visitWhileLoop(WhileStatement loop) {
        super.visitWhileLoop(loop);
        this.tryFind(WhileStatement.class, loop);
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        super.visitBlockStatement(block);
        this.tryFind(BlockStatement.class, block);
    }

    @Override
    protected void visitEmptyStatement(EmptyStatement statement) {
        super.visitEmptyStatement(statement);
        this.tryFind(EmptyStatement.class, statement);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call) {
        super.visitMethodCallExpression(call);
        this.tryFind(MethodCallExpression.class, call);
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        super.visitStaticMethodCallExpression(call);
        this.tryFind(StaticMethodCallExpression.class, call);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        super.visitConstructorCallExpression(call);
        this.tryFind(ConstructorCallExpression.class, call);
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        super.visitBinaryExpression(expression);
        this.tryFind(BinaryExpression.class, expression);
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression) {
        super.visitTernaryExpression(expression);
        this.tryFind(TernaryExpression.class, expression);
    }

    @Override
    public void visitShortTernaryExpression(ElvisOperatorExpression expression) {
        super.visitShortTernaryExpression(expression);
        this.tryFind(ElvisOperatorExpression.class, expression);
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression) {
        super.visitPostfixExpression(expression);
        this.tryFind(PostfixExpression.class, expression);
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression) {
        super.visitPrefixExpression(expression);
        this.tryFind(PrefixExpression.class, expression);
    }

    @Override
    public void visitBooleanExpression(BooleanExpression expression) {
        super.visitBooleanExpression(expression);
        this.tryFind(BooleanExpression.class, expression);
    }

    @Override
    public void visitNotExpression(NotExpression expression) {
        super.visitNotExpression(expression);
        this.tryFind(NotExpression.class, expression);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        super.visitClosureExpression(expression);
        this.tryFind(ClosureExpression.class, expression);
    }

    @Override
    public void visitTupleExpression(TupleExpression expression) {
        super.visitTupleExpression(expression);
        this.tryFind(TupleExpression.class, expression);
    }

    @Override
    public void visitListExpression(ListExpression expression) {
        super.visitListExpression(expression);
        this.tryFind(ListExpression.class, expression);
    }

    @Override
    public void visitArrayExpression(ArrayExpression expression) {
        super.visitArrayExpression(expression);
        this.tryFind(ArrayExpression.class, expression);
    }

    @Override
    public void visitMapExpression(MapExpression expression) {
        super.visitMapExpression(expression);
        this.tryFind(MapExpression.class, expression);
    }

    @Override
    public void visitMapEntryExpression(MapEntryExpression expression) {
        super.visitMapEntryExpression(expression);
        this.tryFind(MapEntryExpression.class, expression);
    }

    @Override
    public void visitRangeExpression(RangeExpression expression) {
        super.visitRangeExpression(expression);
        this.tryFind(RangeExpression.class, expression);
    }

    @Override
    public void visitSpreadExpression(SpreadExpression expression) {
        super.visitSpreadExpression(expression);
        this.tryFind(SpreadExpression.class, expression);
    }

    @Override
    public void visitSpreadMapExpression(SpreadMapExpression expression) {
        super.visitSpreadMapExpression(expression);
        this.tryFind(SpreadMapExpression.class, expression);
    }

    @Override
    public void visitMethodPointerExpression(MethodPointerExpression expression) {
        super.visitMethodPointerExpression(expression);
        this.tryFind(MethodPointerExpression.class, expression);
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression) {
        super.visitUnaryMinusExpression(expression);
        this.tryFind(UnaryMinusExpression.class, expression);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression) {
        super.visitUnaryPlusExpression(expression);
        this.tryFind(UnaryPlusExpression.class, expression);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression) {
        super.visitBitwiseNegationExpression(expression);
        this.tryFind(BitwiseNegationExpression.class, expression);
    }

    @Override
    public void visitCastExpression(CastExpression expression) {
        super.visitCastExpression(expression);
        this.tryFind(CastExpression.class, expression);
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression) {
        super.visitConstantExpression(expression);
        this.tryFind(ConstantExpression.class, expression);
    }

    @Override
    public void visitClassExpression(ClassExpression expression) {
        super.visitClassExpression(expression);
        this.tryFind(ClassExpression.class, expression);
    }

    @Override
    public void visitVariableExpression(VariableExpression expression) {
        super.visitVariableExpression(expression);
        this.tryFind(VariableExpression.class, expression);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression) {
        super.visitPropertyExpression(expression);
        this.tryFind(PropertyExpression.class, expression);
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression) {
        super.visitAttributeExpression(expression);
        this.tryFind(AttributeExpression.class, expression);
    }

    @Override
    public void visitFieldExpression(FieldExpression expression) {
        super.visitFieldExpression(expression);
        this.tryFind(FieldExpression.class, expression);
    }

    @Override
    public void visitGStringExpression(GStringExpression expression) {
        super.visitGStringExpression(expression);
        this.tryFind(GStringExpression.class, expression);
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        super.visitArgumentlistExpression(ale);
        this.tryFind(ArgumentListExpression.class, ale);
    }

    @Override
    public void visitClosureListExpression(ClosureListExpression cle) {
        super.visitClosureListExpression(cle);
        this.tryFind(ClosureListExpression.class, cle);
    }

    @Override
    public void visitBytecodeExpression(BytecodeExpression cle) {
        super.visitBytecodeExpression(cle);
        this.tryFind(BytecodeExpression.class, cle);
    }
}

