/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gjt.sp.jedit.bufferio.IoTask;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;

public class TaskManager {
    public static final TaskManager instance = new TaskManager();
    private final List<TaskListener> listeners = new CopyOnWriteArrayList<TaskListener>();
    private final List<Task> tasks = Collections.synchronizedList(new ArrayList());
    private final Object ioWaitLock = new Object();

    private TaskManager() {
    }

    public int countTasks() {
        return this.tasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countIoTasks() {
        int n = 0;
        List<Task> list = this.tasks;
        synchronized (list) {
            for (Task task : this.tasks) {
                if (!(task instanceof IoTask)) continue;
                ++n;
            }
        }
        return n;
    }

    public void addTaskListener(TaskListener taskListener) {
        if (!this.listeners.contains(taskListener)) {
            this.listeners.add(taskListener);
        }
    }

    public void removeTaskListener(TaskListener taskListener) {
        if (this.listeners.contains(taskListener)) {
            this.listeners.remove(taskListener);
        }
    }

    void fireWaiting(Task task) {
        this.tasks.add(task);
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.waiting(task);
        }
    }

    void fireRunning(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.running(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireDone(Task task) {
        this.tasks.remove(task);
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.done(task);
        }
        if (task instanceof IoTask) {
            AwtRunnableQueue.INSTANCE.queueAWTRunner(false);
            Object object = this.ioWaitLock;
            synchronized (object) {
                this.ioWaitLock.notifyAll();
            }
        }
    }

    void fireStatusUpdated(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.statusUpdated(task);
        }
    }

    void fireValueUpdated(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.valueUpdated(task);
        }
    }

    void fireMaximumUpdated(Task task) {
        List<TaskListener> list = this.listeners;
        for (TaskListener taskListener : list) {
            taskListener.maximumUpdated(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(TaskVisitor taskVisitor) {
        List<Task> list = this.tasks;
        synchronized (list) {
            for (Task task : this.tasks) {
                taskVisitor.visit(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIoTasks() {
        Object object = this.ioWaitLock;
        synchronized (object) {
            while (this.countIoTasks() > 0) {
                try {
                    this.ioWaitLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.log(9, this, interruptedException);
                }
            }
        }
        AwtRunnableQueue.INSTANCE.queueAWTRunner(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTasksByClass(Class<? extends Task> clazz) {
        List<Task> list = this.tasks;
        synchronized (list) {
            for (Task task : this.tasks) {
                if (!task.getClass().equals(clazz)) continue;
                task.cancel();
            }
        }
    }

    static Task decorate(Runnable runnable) {
        return new MyTask(runnable);
    }

    private static class MyTask
    extends Task {
        private final Runnable runnable;

        private MyTask(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public String getStatus() {
            return this.runnable.toString();
        }

        @Override
        public String toString() {
            return this.runnable.toString();
        }

        @Override
        public void _run() {
            this.runnable.run();
        }
    }

    public static interface TaskVisitor {
        public void visit(Task var1);
    }
}

