/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolEnvCalc;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Trajectory;
import org.jmol.modelsetbio.BioModelSet;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.Tensor;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;

public abstract class AtomCollection {
    private static final float almost180 = 2.984513f;
    private static final float sqrt3_2 = (float)(Math.sqrt(3.0) / 2.0);
    private static final V3 vRef = V3.new3(3.14159f, 2.71828f, 1.41421f);
    public Viewer vwr;
    protected GData g3d;
    public BioModelSet bioModelset;
    public Atom[] at;
    public int ac;
    public Trajectory trajectory;
    protected SymmetryInterface pointGroup;
    private LabelToken labeler;
    protected float maxBondingRadius = Float.MIN_VALUE;
    private float maxVanderwaalsRadius = Float.MIN_VALUE;
    private boolean hasBfactorRange;
    private int bfactor100Lo;
    private int bfactor100Hi;
    private boolean haveBSVisible;
    private boolean haveBSClickable;
    private BS bsSurface;
    private int nSurfaceAtoms;
    private int surfaceDistanceMax;
    protected P3 averageAtomPoint;
    protected boolean haveChirality;
    protected Bspf bspf = null;
    protected boolean preserveState = true;
    public boolean canSkipLoad = true;
    public boolean haveStraightness;
    private BS bsHidden;
    public BS bsVisible;
    public BS bsClickable;
    public BS bsModulated;
    public Object[][] atomTensorList;
    public Map<String, Lst<Object>> atomTensors;
    protected int[] surfaceDistance100s;
    public BS[] tainted;
    public static String[] userSettableValues;
    public static final int TAINT_ATOMNAME = 0;
    public static final int TAINT_ATOMTYPE = 1;
    public static final int TAINT_COORD = 2;
    public static final int TAINT_ELEMENT = 3;
    public static final int TAINT_FORMALCHARGE = 4;
    public static final int TAINT_HYDROPHOBICITY = 5;
    public static final int TAINT_BONDINGRADIUS = 6;
    public static final int TAINT_OCCUPANCY = 7;
    public static final int TAINT_PARTIALCHARGE = 8;
    public static final int TAINT_TEMPERATURE = 9;
    public static final int TAINT_VALENCE = 10;
    public static final int TAINT_VANDERWAALS = 11;
    public static final int TAINT_VIBRATION = 12;
    public static final int TAINT_ATOMNO = 13;
    public static final int TAINT_SEQID = 14;
    public static final int TAINT_RESNO = 15;
    public static final int TAINT_CHAIN = 16;
    public static final int TAINT_MAX = 17;
    String[] atomNames;
    String[] atomTypes;
    int[] atomSerials;
    int[] atomResnos;
    int[] atomSeqIDs;
    float[] dssrData;
    public Vibration[] vibrations;
    public float[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    float[] bondingRadii;
    float[] hydrophobicities;
    public BS bsPartialCharges;
    int[] aaRet;
    private int atomCapacity;

    protected void setupAC() {
        this.bsHidden = new BS();
        this.bsVisible = new BS();
        this.bsClickable = new BS();
        if (userSettableValues == null) {
            userSettableValues = "atomName atomType coord element formalCharge hydrophobicity ionic occupancy partialCharge temperature valence vanderWaals vibrationVector atomNo seqID resNo chain".split(" ");
        }
    }

    protected void releaseModelSetAC() {
        this.at = null;
        this.vwr = null;
        this.g3d = null;
        this.bspf = null;
        this.surfaceDistance100s = null;
        this.bsSurface = null;
        this.tainted = null;
        this.atomNames = null;
        this.atomTypes = null;
        this.atomResnos = null;
        this.dssrData = null;
        this.atomSerials = null;
        this.atomSeqIDs = null;
        this.vibrations = null;
        this.occupancies = null;
        this.bfactor100s = null;
        this.resetPartialCharges();
        this.bondingRadii = null;
        this.atomTensors = null;
    }

    protected void mergeAtomArrays(AtomCollection atomCollection) {
        this.tainted = atomCollection.tainted;
        this.atomNames = atomCollection.atomNames;
        this.atomTypes = atomCollection.atomTypes;
        this.atomResnos = atomCollection.atomResnos;
        this.dssrData = atomCollection.dssrData;
        this.atomSerials = atomCollection.atomSerials;
        this.atomSeqIDs = atomCollection.atomSeqIDs;
        this.vibrations = atomCollection.vibrations;
        this.occupancies = atomCollection.occupancies;
        this.bfactor100s = atomCollection.bfactor100s;
        this.bondingRadii = atomCollection.bondingRadii;
        this.partialCharges = atomCollection.partialCharges;
        this.bsPartialCharges = atomCollection.bsPartialCharges;
        this.atomTensors = atomCollection.atomTensors;
        this.atomTensorList = atomCollection.atomTensorList;
        this.bsModulated = atomCollection.bsModulated;
        this.haveStraightness = false;
        this.surfaceDistance100s = null;
    }

    public Lst<P3> getAtomPointVector(BS bS) {
        Lst<P3> lst = new Lst<P3>();
        int n = this.ac;
        if (bS != null) {
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0 && n2 < n) {
                lst.addLast(this.at[n2]);
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        return lst;
    }

    public boolean modelSetHasVibrationVectors() {
        return this.vibrations != null;
    }

    public String[] getAtomTypes() {
        return this.atomTypes;
    }

    public float[] getPartialCharges() {
        return this.partialCharges;
    }

    public float[] getBondingRadii() {
        return this.bondingRadii;
    }

    public short[] getBFactors() {
        return this.bfactor100s;
    }

    public float[] getHydrophobicity() {
        return this.hydrophobicities;
    }

    public void setBsHidden(BS bS) {
        this.bsHidden = bS;
    }

    public boolean isAtomHidden(int n) {
        return this.bsHidden.get(n);
    }

    public LabelToken getLabeler() {
        return this.labeler == null ? (this.labeler = (LabelToken)Interface.getInterface("org.jmol.modelset.LabelToken", this.vwr, "ms")) : this.labeler;
    }

    public String getAtomInfo(int n, String string, P3 p3) {
        return string == null ? this.at[n].getInfo() : this.getLabeler().formatLabel(this.vwr, this.at[n], string, p3);
    }

    public String getElementName(int n) {
        return Elements.elementNameFromNumber(this.at[n].getAtomicAndIsotopeNumber());
    }

    public Quat getQuaternion(int n, char c) {
        return n < 0 ? null : this.at[n].group.getQuaternion(c);
    }

    public int getFirstAtomIndexFromAtomNumber(int n, BS bS) {
        int n2 = 0;
        while (n2 < this.ac) {
            Atom atom = this.at[n2];
            if (atom.getAtomNumber() == n && bS.get(atom.mi)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setFormalCharges(BS bS, int n) {
        if (bS != null) {
            this.resetPartialCharges();
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                this.at[n2].setFormalCharge(n);
                this.taintAtom(n2, 4);
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
    }

    public float[] getAtomicCharges() {
        float[] fArray = new float[this.ac];
        int n = this.ac;
        while (--n >= 0) {
            fArray[n] = this.at[n].getElementNumber();
        }
        return fArray;
    }

    protected float getRadiusVdwJmol(Atom atom) {
        return (float)Elements.getVanderwaalsMar(atom.getElementNumber(), VDW.JMOL) / 1000.0f;
    }

    public float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    protected void findMaxRadii() {
        int n = this.ac;
        while (--n >= 0) {
            float f;
            float f2;
            Atom atom = this.at[n];
            float f3 = atom.getBondingRadius();
            if (f2 > this.maxBondingRadius) {
                this.maxBondingRadius = f3;
            }
            f3 = atom.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO);
            if (!(f > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = f3;
        }
    }

    public void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    private void calcBfactorRange(BS bS) {
        if (this.hasBfactorRange) {
            return;
        }
        this.bfactor100Lo = Integer.MAX_VALUE;
        this.bfactor100Hi = Integer.MIN_VALUE;
        if (bS == null) {
            int n = 0;
            while (n < this.ac) {
                this.setBf(n);
                ++n;
            }
        } else {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.setBf(n);
                n = bS.nextSetBit(n + 1);
            }
        }
        this.hasBfactorRange = true;
    }

    private void setBf(int n) {
        int n2 = this.at[n].getBfactor100();
        if (n2 < this.bfactor100Lo) {
            this.bfactor100Lo = n2;
        } else if (n2 > this.bfactor100Hi) {
            this.bfactor100Hi = n2;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.vwr.g.rangeSelected) {
                this.calcBfactorRange(this.vwr.bsA());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    public int getSurfaceDistanceMax() {
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    public float calculateVolume(BS bS, VDW vDW) {
        float f = 0.0f;
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                f += this.at[n].getVolume(this.vwr, vDW);
                n = bS.nextSetBit(n + 1);
            }
        }
        return f;
    }

    int getSurfaceDistance100(int n) {
        if (this.nSurfaceAtoms == 0) {
            return -1;
        }
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistance100s[n];
    }

    private void calcSurfaceDistances() {
        this.calculateSurface(null, -1.0f);
    }

    public P3[] calculateSurface(BS bS, float f) {
        if (f < 0.0f) {
            f = 3.0f;
        }
        JmolEnvCalc jmolEnvCalc = ((JmolEnvCalc)Interface.getOption("geodesic.EnvelopeCalculation", this.vwr, "ms")).set(this.vwr, this.ac, null);
        jmolEnvCalc.calculate(new RadiusData(null, f, RadiusData.EnumType.ABSOLUTE, null), Float.MAX_VALUE, bS, BSUtil.copyInvert(bS, this.ac), false, false, false, true);
        P3[] p3Array = jmolEnvCalc.getPoints();
        this.surfaceDistanceMax = 0;
        this.bsSurface = jmolEnvCalc.getBsSurfaceClone();
        this.surfaceDistance100s = new int[this.ac];
        this.nSurfaceAtoms = BSUtil.cardinalityOf(this.bsSurface);
        if (this.nSurfaceAtoms == 0 || p3Array == null || p3Array.length == 0) {
            return p3Array;
        }
        float f2 = f == Float.MAX_VALUE ? 0.0f : f;
        int n = 0;
        while (n < this.ac) {
            if (this.bsSurface.get(n)) {
                this.surfaceDistance100s[n] = 0;
            } else {
                float f3 = Float.MAX_VALUE;
                Atom atom = this.at[n];
                int n2 = p3Array.length;
                while (--n2 >= 0) {
                    float f4 = Math.abs(p3Array[n2].distance(atom) - f2);
                    if (f4 < 0.0f && Logger.debugging) {
                        Logger.debug("draw d" + n2 + " " + Escape.eP(p3Array[n2]) + " \"" + f4 + " ? " + atom.getInfo() + "\"");
                    }
                    f3 = Math.min(f4, f3);
                }
                n2 = this.surfaceDistance100s[n] = (int)Math.floor(f3 * 100.0f);
                this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, n2);
            }
            ++n;
        }
        return p3Array;
    }

    protected void setAtomCoord2(BS bS, int n, Object object) {
        P3 p3 = null;
        P3[] p3Array = null;
        Lst lst = null;
        int n2 = 0;
        int n3 = 1;
        if (object instanceof P3) {
            p3 = (P3)object;
        } else if (object instanceof Lst) {
            lst = (Lst)object;
            n3 = lst.size();
            if (n3 == 0) {
                return;
            }
            n2 = 1;
        } else if (AU.isAP(object)) {
            p3Array = (P3[])object;
            n3 = p3Array.length;
            if (n3 == 0) {
                return;
            }
            n2 = 2;
        } else {
            return;
        }
        int n4 = 0;
        if (bS != null) {
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0) {
                switch (n2) {
                    case 1: {
                        if (n4 >= n3) {
                            return;
                        }
                        p3 = (P3)lst.get(n4++);
                        break;
                    }
                    case 2: {
                        if (n4 >= n3) {
                            return;
                        }
                        p3 = p3Array[n4++];
                    }
                }
                if (p3 != null) {
                    switch (n) {
                        case 1145047050: {
                            this.setAtomCoord(n5, p3.x, p3.y, p3.z);
                            break;
                        }
                        case 1145047051: {
                            this.at[n5].setFractionalCoordTo(p3, true);
                            this.taintAtom(n5, 2);
                            break;
                        }
                        case 1145047053: {
                            this.at[n5].setFractionalCoordTo(p3, false);
                            this.taintAtom(n5, 2);
                            break;
                        }
                        case 1145047055: {
                            this.setAtomVibrationVector(n5, p3);
                        }
                    }
                }
                n5 = bS.nextSetBit(n5 + 1);
            }
        }
    }

    private void setAtomVibrationVector(int n, T3 t3) {
        this.setVibrationVector(n, t3);
        this.taintAtom(n, 12);
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.ac) {
            return;
        }
        Atom atom = this.at[n];
        atom.set(f, f2, f3);
        this.fixTrajectory(atom);
        this.taintAtom(n, 2);
    }

    private void fixTrajectory(Atom atom) {
        if (((ModelSet)this).isTrajectory(atom.mi)) {
            this.trajectory.fixAtom(atom);
        }
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.ac) {
            return;
        }
        Atom atom = this.at[n];
        atom.add3(f, f2, f3);
        this.fixTrajectory(atom);
        this.taintAtom(n, 2);
    }

    protected void setAtomsCoordRelative(BS bS, float f, float f2, float f3) {
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.setAtomCoordRelative(n, f, f2, f3);
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    protected void setAPa(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        int n3 = 0;
        if (fArray != null && fArray.length == 0 || bS == null) {
            return;
        }
        boolean bl = fArray != null && fArray.length == this.ac || stringArray != null && stringArray.length == this.ac;
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            block42: {
                block43: {
                    block41: {
                        if (bl) {
                            n3 = n4;
                        }
                        if (fArray == null) break block41;
                        if (n3 >= fArray.length) {
                            return;
                        }
                        if (Float.isNaN(f = fArray[n3++])) break block42;
                        n2 = (int)f;
                        break block43;
                    }
                    if (stringArray != null) {
                        if (n3 >= stringArray.length) {
                            return;
                        }
                        string = stringArray[n3++];
                    }
                }
                Atom atom = this.at[n4];
                switch (n) {
                    case 1086326786: {
                        this.setAtomName(n4, string, true);
                        break;
                    }
                    case 1086326785: {
                        this.setAtomType(n4, string);
                        break;
                    }
                    case 1086326788: {
                        this.setChainID(n4, string);
                        break;
                    }
                    case 1094715393: {
                        this.setAtomNumber(n4, n2, true);
                        break;
                    }
                    case 1094713365: {
                        this.setAtomSeqID(n4, n2);
                        break;
                    }
                    case 1111492609: 
                    case 1111492629: {
                        this.setAtomCoord(n4, f, atom.y, atom.z);
                        break;
                    }
                    case 1111492610: 
                    case 1111492630: {
                        this.setAtomCoord(n4, atom.x, f, atom.z);
                        break;
                    }
                    case 1111492611: 
                    case 1111492631: {
                        this.setAtomCoord(n4, atom.x, atom.y, f);
                        break;
                    }
                    case 1111492626: 
                    case 1111492627: 
                    case 1111492628: {
                        this.setVibrationVector2(n4, n, f);
                        break;
                    }
                    case 1111492612: 
                    case 1111492613: 
                    case 1111492614: {
                        atom.setFractionalCoord(n, f, true);
                        this.taintAtom(n4, 2);
                        break;
                    }
                    case 1111492615: 
                    case 1111492616: 
                    case 1111492617: {
                        atom.setFractionalCoord(n, f, false);
                        this.taintAtom(n4, 2);
                        break;
                    }
                    case 1086326789: 
                    case 1094715402: {
                        this.setElement(atom, n2, true);
                        break;
                    }
                    case 1631586315: {
                        this.resetPartialCharges();
                        atom.setFormalCharge(n2);
                        this.taintAtom(n4, 4);
                        break;
                    }
                    case 1113589786: {
                        this.setHydrophobicity(n4, f);
                        break;
                    }
                    case 1128269825: {
                        if (f < 2.0f && f > 0.01f) {
                            f *= 100.0f;
                        }
                        this.setOccupancy(n4, f, true);
                        break;
                    }
                    case 1111492619: {
                        this.setPartialCharge(n4, f, true);
                        break;
                    }
                    case 1111492618: {
                        this.setBondingRadius(n4, f);
                        break;
                    }
                    case 1111492620: {
                        this.setBFactor(n4, f, true);
                        break;
                    }
                    case 1094715412: {
                        this.setAtomResno(n4, n2);
                        break;
                    }
                    case 1287653388: 
                    case 1825200146: {
                        this.vwr.shm.setAtomLabel(string, n4);
                        break;
                    }
                    case 1112152075: 
                    case 1665140738: {
                        if (f < 0.0f) {
                            f = 0.0f;
                        } else if (f > 16.0f) {
                            f = 16.1f;
                        }
                        atom.madAtom = (short)(f * 2000.0f);
                        break;
                    }
                    case 1113589787: {
                        this.vwr.slm.setSelectedAtom(atom.i, f != 0.0f);
                        break;
                    }
                    case 1094715417: {
                        atom.setValence(n2);
                        this.taintAtom(n4, 10);
                        break;
                    }
                    case 1648363544: {
                        if (atom.setRadius(f)) {
                            this.taintAtom(n4, 11);
                            break;
                        }
                        this.untaint(n4, 11);
                        break;
                    }
                    default: {
                        Logger.error("unsettable atom property: " + T.nameOf(n));
                        return;
                    }
                }
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        switch (n) {
            case 1113589787: {
                this.vwr.slm.setSelectedAtom(-1, false);
                break;
            }
            case 1112152075: 
            case 1665140738: {
                this.vwr.setShapeSize(0, Integer.MAX_VALUE, bS);
            }
        }
    }

    public float getVibCoord(int n, char c) {
        JmolModulationSet jmolModulationSet = null;
        Vibration vibration = null;
        switch (c) {
            case 'x': 
            case 'y': 
            case 'z': {
                vibration = this.getVibration(n, false);
                break;
            }
            default: {
                jmolModulationSet = this.getModulation(n);
                if (jmolModulationSet == null || (vibration = jmolModulationSet.getVibration(false)) != null) break;
                vibration = (Vibration)((Object)jmolModulationSet);
            }
        }
        if (vibration == null && jmolModulationSet == null) {
            return Float.NaN;
        }
        switch (c) {
            case 'X': 
            case 'x': {
                return vibration.x;
            }
            case 'Y': 
            case 'y': {
                return vibration.y;
            }
            case 'Z': 
            case 'z': {
                return vibration.z;
            }
            case 'O': {
                return ((Float)jmolModulationSet.getModulation('O', null)).floatValue();
            }
            case '1': 
            case '2': 
            case '3': {
                T3 t3 = (T3)jmolModulationSet.getModulation('T', null);
                float f = c == '1' ? t3.x : (c == '2' ? t3.y : t3.z);
                return (float)((double)f - Math.floor(f));
            }
        }
        return Float.NaN;
    }

    public Vibration getVibration(int n, boolean bl) {
        Vibration vibration;
        Vibration vibration2 = vibration = this.vibrations == null ? null : this.vibrations[n];
        return vibration instanceof JmolModulationSet ? ((JmolModulationSet)((Object)vibration)).getVibration(bl) : (vibration == null && bl ? new Vibration() : vibration);
    }

    public JmolModulationSet getModulation(int n) {
        Vibration vibration = this.vibrations == null ? null : this.vibrations[n];
        return (JmolModulationSet)((Object)(vibration != null && vibration.modDim > 0 ? vibration : null));
    }

    protected void setVibrationVector(int n, T3 t3) {
        if (Float.isNaN(t3.x) || Float.isNaN(t3.y) || Float.isNaN(t3.z)) {
            return;
        }
        if (this.vibrations == null || this.vibrations.length < n) {
            this.vibrations = new Vibration[this.at.length];
        }
        if (t3 instanceof Vibration) {
            this.vibrations[n] = (Vibration)t3;
        } else {
            if (this.vibrations[n] == null) {
                this.vibrations[n] = new Vibration();
            }
            this.vibrations[n].setXYZ(t3);
        }
        this.at[n].setVibrationVector();
    }

    private void setVibrationVector2(int n, int n2, float f) {
        Vibration vibration = this.getVibration(n, true);
        if (vibration == null) {
            return;
        }
        switch (n2) {
            case 1111492626: {
                vibration.x = f;
                break;
            }
            case 1111492627: {
                vibration.y = f;
                break;
            }
            case 1111492628: {
                vibration.z = f;
            }
        }
        this.setAtomVibrationVector(n, vibration);
    }

    public void setAtomName(int n, String string, boolean bl) {
        byte by;
        if (bl && string.equals(this.at[n].getAtomName())) {
            return;
        }
        this.at[n].atomID = by = ((ModelSet)this).am[this.at[n].mi].isBioModel ? this.vwr.getJBR().lookupSpecialAtomID(string) : (byte)0;
        if (by <= 0) {
            if (this.atomNames == null) {
                this.atomNames = new String[this.at.length];
            }
            this.atomNames[n] = string;
        }
        if (bl) {
            this.taintAtom(n, 0);
        }
    }

    private void setAtomType(int n, String string) {
        if (string.equals(this.at[n].getAtomType())) {
            return;
        }
        if (this.atomTypes == null) {
            this.atomTypes = new String[this.at.length];
        }
        this.atomTypes[n] = string;
    }

    private void setChainID(int n, String string) {
        if (string.equals(this.at[n].getChainIDStr())) {
            return;
        }
        int n2 = this.at[n].getChainID();
        BS bS = this.getChainBits(n2);
        Chain chain = this.at[n].group.chain;
        chain.chainID = this.vwr.getChainID(string, true);
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            this.taintAtom(n3, 16);
            n3 = bS.nextSetBit(n3 + 1);
        }
    }

    public void setAtomNumber(int n, int n2, boolean bl) {
        if (bl && n2 == this.at[n].getAtomNumber()) {
            return;
        }
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.at.length];
        }
        this.atomSerials[n] = n2;
        if (bl) {
            this.taintAtom(n, 13);
        }
    }

    protected void setElement(Atom atom, int n, boolean bl) {
        if (bl && atom.getElementNumber() == n) {
            return;
        }
        atom.setAtomicAndIsotopeNumber(n);
        atom.paletteID = PAL.CPK.id;
        atom.colixAtom = this.vwr.cm.getColixAtomPalette(atom, PAL.CPK.id);
        this.resetPartialCharges();
        if (bl) {
            this.taintAtom(atom.i, 3);
        }
    }

    private void resetPartialCharges() {
        this.partialCharges = null;
        this.bsPartialCharges = null;
    }

    private void setAtomResno(int n, int n2) {
        if (n2 == this.at[n].getResno()) {
            return;
        }
        this.at[n].group.setResno(n2);
        if (this.atomResnos == null) {
            this.atomResnos = new int[this.at.length];
        }
        this.atomResnos[n] = n2;
        this.taintAtom(n, 15);
    }

    private void setAtomSeqID(int n, int n2) {
        if (n2 == this.at[n].getSeqID()) {
            return;
        }
        if (this.atomSeqIDs == null) {
            this.atomSeqIDs = new int[this.at.length];
        }
        this.atomSeqIDs[n] = n2;
        this.taintAtom(n, 14);
    }

    protected void setOccupancy(int n, float f, boolean bl) {
        if (bl && f == (float)this.at[n].getOccupancy100()) {
            return;
        }
        if (this.occupancies == null) {
            if (f == 100.0f) {
                return;
            }
            this.occupancies = new float[this.at.length];
            int n2 = this.at.length;
            while (--n2 >= 0) {
                this.occupancies[n2] = 100.0f;
            }
        }
        this.occupancies[n] = f;
        if (bl) {
            this.taintAtom(n, 7);
        }
    }

    protected void setPartialCharge(int n, float f, boolean bl) {
        if (Float.isNaN(f)) {
            return;
        }
        if (this.partialCharges == null) {
            this.bsPartialCharges = new BS();
            if (f == 0.0f) {
                return;
            }
            this.partialCharges = new float[this.at.length];
        }
        this.bsPartialCharges.set(n);
        this.partialCharges[n] = f;
        if (bl) {
            this.taintAtom(n, 8);
        }
    }

    private void setBondingRadius(int n, float f) {
        if (Float.isNaN(f) || f == this.at[n].getBondingRadius()) {
            return;
        }
        if (this.bondingRadii == null) {
            this.bondingRadii = new float[this.at.length];
        }
        this.bondingRadii[n] = f;
        this.taintAtom(n, 6);
    }

    protected void setBFactor(int n, float f, boolean bl) {
        if (Float.isNaN(f) || bl && f == (float)this.at[n].getBfactor100()) {
            return;
        }
        if (this.bfactor100s == null) {
            if (f == 0.0f) {
                return;
            }
            this.bfactor100s = new short[this.at.length];
        }
        this.bfactor100s[n] = (short)((f < -327.68f ? (double)-327.68f : ((double)f > 327.67 ? 327.67 : (double)f)) * 100.0 + (f < 0.0f ? -0.5 : 0.5));
        if (bl) {
            this.taintAtom(n, 9);
        }
    }

    private void setHydrophobicity(int n, float f) {
        if (Float.isNaN(f) || f == this.at[n].getHydrophobicity()) {
            return;
        }
        if (this.hydrophobicities == null) {
            this.hydrophobicities = new float[this.at.length];
            int n2 = 0;
            while (n2 < this.at.length) {
                this.hydrophobicities[n2] = Elements.getHydrophobicity(this.at[n2].group.groupID);
                ++n2;
            }
        }
        this.hydrophobicities[n] = f;
        this.taintAtom(n, 5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAtomData(int n, String string, String string2, boolean bl) {
        float[] fArray = null;
        BS bS = null;
        switch (n) {
            case 2: {
                this.loadCoordinates(string2, false, !bl);
                return;
            }
            case 12: {
                this.loadCoordinates(string2, true, true);
                return;
            }
            case 17: {
                fArray = new float[this.ac];
                bS = BS.newN(this.ac);
                break;
            }
        }
        int[] nArray = Parser.markLines(string2, ';');
        int n2 = 0;
        try {
            int n3 = PT.parseInt(string2.substring(0, nArray[0] - 1));
            int n4 = 1;
            while (true) {
                block27: {
                    if (n4 > n3) {
                        if (n != 17) return;
                        if (n2 <= 0) return;
                        this.vwr.setData(string, new Object[]{string, fArray, bS, 1}, 0, 0, 0, 0, 0);
                        return;
                    }
                    String[] stringArray = PT.getTokens(PT.parseTrimmed(string2.substring(nArray[n4], nArray[n4 + 1] - 1)));
                    int n5 = PT.parseInt(stringArray[0]) - 1;
                    if (n5 >= 0 && n5 < this.ac) {
                        Atom atom = this.at[n5];
                        ++n2;
                        int n6 = stringArray.length - 1;
                        float f = PT.parseFloat(stringArray[n6]);
                        switch (n) {
                            case 17: {
                                fArray[n5] = f;
                                bS.set(n5);
                                break block27;
                            }
                            case 0: {
                                this.setAtomName(n5, stringArray[n6], true);
                                break;
                            }
                            case 13: {
                                this.setAtomNumber(n5, (int)f, true);
                                break;
                            }
                            case 15: {
                                this.setAtomResno(n5, (int)f);
                                break;
                            }
                            case 14: {
                                this.setAtomSeqID(n5, (int)f);
                                break;
                            }
                            case 1: {
                                this.setAtomType(n5, stringArray[n6]);
                                break;
                            }
                            case 16: {
                                this.setChainID(n5, stringArray[n6]);
                                break;
                            }
                            case 3: {
                                atom.setAtomicAndIsotopeNumber((int)f);
                                atom.paletteID = PAL.CPK.id;
                                atom.colixAtom = this.vwr.cm.getColixAtomPalette(atom, PAL.CPK.id);
                                break;
                            }
                            case 4: {
                                atom.setFormalCharge((int)f);
                                break;
                            }
                            case 5: {
                                this.setHydrophobicity(n5, f);
                                break;
                            }
                            case 6: {
                                this.setBondingRadius(n5, f);
                                break;
                            }
                            case 8: {
                                this.setPartialCharge(n5, f, true);
                                break;
                            }
                            case 9: {
                                this.setBFactor(n5, f, true);
                                break;
                            }
                            case 10: {
                                atom.setValence((int)f);
                                break;
                            }
                            case 11: {
                                atom.setRadius(f);
                            }
                        }
                        this.taintAtom(n5, n);
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            Logger.error("AtomCollection.loadData error: " + exception);
        }
    }

    private void loadCoordinates(String string, boolean bl, boolean bl2) {
        int[] nArray = Parser.markLines(string, ';');
        V3 v3 = bl ? new V3() : null;
        try {
            int n = PT.parseInt(string.substring(0, nArray[0] - 1));
            int n2 = 1;
            while (n2 <= n) {
                String[] stringArray = PT.getTokens(PT.parseTrimmed(string.substring(nArray[n2], nArray[n2 + 1])));
                int n3 = PT.parseInt(stringArray[0]) - 1;
                float f = stringArray[3].equalsIgnoreCase("1.4E-45") ? Float.MIN_VALUE : PT.parseFloat(stringArray[3]);
                float f2 = stringArray[4].equalsIgnoreCase("1.4E-45") ? Float.MIN_VALUE : PT.parseFloat(stringArray[4]);
                float f3 = PT.parseFloat(stringArray[5]);
                if (bl) {
                    v3.set(f, f2, f3);
                    this.setAtomVibrationVector(n3, v3);
                } else {
                    this.setAtomCoord(n3, f, f2, f3);
                    if (!bl2) {
                        this.untaint(n3, 2);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Logger.error("Frame.loadCoordinate error: " + exception);
        }
    }

    public void validateBspf(boolean bl) {
        if (this.bspf != null) {
            this.bspf.isValid = bl;
        }
        this.averageAtomPoint = null;
    }

    void validateBspfForModel(int n, boolean bl) {
        if (this.bspf != null) {
            this.bspf.validateModel(n, bl);
        }
    }

    public void setPreserveState(boolean bl) {
        this.preserveState = bl;
    }

    public static int getUserSettableType(String string) {
        boolean bl = string.indexOf("property_") == 0;
        String string2 = bl ? string.substring(9) : string;
        int n = 0;
        while (n < 17) {
            if (userSettableValues[n].equalsIgnoreCase(string2)) {
                return n;
            }
            ++n;
        }
        return bl ? 17 : -1;
    }

    public BS getTaintedAtoms(int n) {
        return this.tainted == null ? null : this.tainted[n];
    }

    public void taintAtoms(BS bS, int n) {
        this.canSkipLoad = false;
        if (!this.preserveState) {
            return;
        }
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            this.taintAtom(n2, n);
            n2 = bS.nextSetBit(n2 + 1);
        }
    }

    protected void taintAtom(int n, int n2) {
        if (this.preserveState) {
            if (this.tainted == null) {
                this.tainted = new BS[17];
            }
            if (this.tainted[n2] == null) {
                this.tainted[n2] = BS.newN(this.ac);
            }
            this.tainted[n2].set(n);
        }
        if (n2 == 2) {
            this.taintModelCoord(n);
        }
    }

    private void taintModelCoord(int n) {
        Model model = ((ModelSet)this).am[this.at[n].mi];
        this.validateBspfForModel(model.trajectoryBaseIndex, false);
        if (model.isBioModel) {
            model.resetDSSR(true);
        }
        this.pointGroup = null;
    }

    private void untaint(int n, int n2) {
        if (!this.preserveState) {
            return;
        }
        if (this.tainted == null || this.tainted[n2] == null) {
            return;
        }
        this.tainted[n2].clear(n);
    }

    public void setTaintedAtoms(BS bS, int n) {
        int n2;
        if (this.preserveState) {
            if (bS == null) {
                if (this.tainted == null) {
                    return;
                }
                this.tainted[n] = null;
                return;
            }
            if (this.tainted == null) {
                this.tainted = new BS[17];
            }
            if (this.tainted[n] == null) {
                this.tainted[n] = BS.newN(this.ac);
            }
            BSUtil.copy2(bS, this.tainted[n]);
        }
        if (n == 2 && (n2 = bS.nextSetBit(0)) >= 0) {
            this.taintModelCoord(n2);
        }
    }

    public void unTaintAtoms(BS bS, int n) {
        if (this.tainted == null || this.tainted[n] == null) {
            return;
        }
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            this.tainted[n].clear(n2);
            n2 = bS.nextSetBit(n2 + 1);
        }
        if (this.tainted[n].nextSetBit(0) < 0) {
            this.tainted[n] = null;
        }
    }

    protected void findNearest2(int n, int n2, Atom[] atomArray, BS bS, int n3) {
        Atom atom = null;
        int n4 = this.ac;
        while (--n4 >= 0) {
            Atom atom2;
            if (bS != null && bS.get(n4) || !(atom2 = this.at[n4]).isClickable() || !this.isCursorOnTopOf(atom2, n, n2, n3, atom)) continue;
            atom = atom2;
        }
        atomArray[0] = atom;
    }

    boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return atom.sZ > 1 && !this.g3d.isClippedZ(atom.sZ) && this.g3d.isInDisplayRange(atom.sX, atom.sY) && atom.isCursorOnTopOf(n, n2, n3, atom2);
    }

    protected void fillADa(AtomData atomData, int n) {
        boolean bl;
        atomData.atoms = this.at;
        atomData.xyz = this.at;
        atomData.ac = this.ac;
        atomData.atomicNumber = new int[this.ac];
        boolean bl2 = bl = (n & 2) != 0;
        if (bl) {
            atomData.atomRadius = new float[this.ac];
        }
        boolean bl3 = (n & 0x10) != 0;
        int n2 = 0;
        while (n2 < this.ac) {
            Atom atom = this.at[n2];
            if (atom.isDeleted() || !bl3 && atomData.modelIndex >= 0 && atom.mi != atomData.firstModelIndex) {
                if (atomData.bsIgnored == null) {
                    atomData.bsIgnored = new BS();
                }
                atomData.bsIgnored.set(n2);
            } else {
                atomData.atomicNumber[n2] = atom.getElementNumber();
                atomData.lastModelIndex = atom.mi;
                if (bl) {
                    atomData.atomRadius[n2] = this.getWorkingRadius(atom, atomData);
                }
            }
            ++n2;
        }
    }

    private float getWorkingRadius(Atom atom, AtomData atomData) {
        float f = 0.0f;
        RadiusData radiusData = atomData.radiusData;
        switch (radiusData.factorType) {
            case ABSOLUTE: {
                f = radiusData.value;
                break;
            }
            case OFFSET: 
            case FACTOR: {
                switch (radiusData.vdwType) {
                    case BONDING: {
                        f = atom.getBondingRadius();
                        break;
                    }
                    case ADPMAX: {
                        f = atom.getADPMinMax(true);
                        break;
                    }
                    case ADPMIN: {
                        f = atom.getADPMinMax(false);
                        break;
                    }
                    default: {
                        f = atom.getVanderwaalsRadiusFloat(this.vwr, atomData.radiusData.vdwType);
                    }
                }
                if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
                    f *= radiusData.value;
                    break;
                }
                f += radiusData.value;
            }
        }
        return f + radiusData.valueExtended;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public P3[][] calculateHydrogens(BS var1_1, int[] var2_2, boolean var3_3, boolean var4_4, Lst<Atom> var5_5) {
        block32: {
            var6_6 = new V3();
            var7_7 = new V3();
            var8_8 = new P3[this.ac][];
            var9_9 = this.vwr.slm.bsDeleted;
            var11_10 = 0;
            if (var1_1 == null) break block32;
            var12_11 = var1_1.nextSetBit(0);
            while (var12_11 >= 0) {
                block31: {
                    block34: {
                        block33: {
                            if (var9_9 != null && var9_9.get(var12_11)) break block31;
                            var13_13 = this.at[var12_11];
                            var14_14 = var13_13.getElementNumber();
                            if (var4_4 && var14_14 != 6) break block31;
                            var15_15 = var14_14 <= 6 ? 1.1f : (var14_14 <= 10 ? 1.0f : 1.3f);
                            switch (var14_14) {
                                case 7: 
                                case 8: {
                                    var15_15 = 1.0f;
                                    break;
                                }
                            }
                            if (var3_3 && var13_13.getCovalentHydrogenCount() > 0 || (var16_16 = this.getMissingHydrogenCount(var13_13, false)) == 0) break block31;
                            var17_17 = this.aaRet[0];
                            var18_18 = this.aaRet[2];
                            var19_19 = this.aaRet[3];
                            if (var19_19 == 0 && var13_13.isHetero()) break block31;
                            var8_8[var12_11] = new P3[var16_16];
                            var20_20 = 0;
                            if (var19_19 != 0) break block33;
                            switch (var16_16) {
                                case 4: {
                                    var6_6.set(0.635f, 0.635f, 0.635f);
                                    var10_12 = P3.newP(var6_6);
                                    var10_12.add(var13_13);
                                    var8_8[var12_11][var20_20++] = var10_12;
                                    if (var5_5 != null) {
                                        var5_5.addLast(var13_13);
                                    }
                                }
                                case 3: {
                                    var6_6.set(-0.635f, -0.635f, 0.635f);
                                    var10_12 = P3.newP(var6_6);
                                    var10_12.add(var13_13);
                                    var8_8[var12_11][var20_20++] = var10_12;
                                    if (var5_5 != null) {
                                        var5_5.addLast(var13_13);
                                    }
                                }
                                case 2: {
                                    var6_6.set(-0.635f, 0.635f, -0.635f);
                                    var10_12 = P3.newP(var6_6);
                                    var10_12.add(var13_13);
                                    var8_8[var12_11][var20_20++] = var10_12;
                                    if (var5_5 != null) {
                                        var5_5.addLast(var13_13);
                                    }
                                }
                                case 1: {
                                    var6_6.set(0.635f, -0.635f, -0.635f);
                                    var10_12 = P3.newP(var6_6);
                                    var10_12.add(var13_13);
                                    var8_8[var12_11][var20_20++] = var10_12;
                                    if (var5_5 == null) break block34;
                                    var5_5.addLast(var13_13);
                                }
                                default: {
                                    ** break;
                                }
                                {
lbl62:
                                    // 1 sources

                                    break block34;
                                }
                            }
                        }
                        block9 : switch (var16_16) {
                            default: {
                                break;
                            }
                            case 3: {
                                this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, "sp3b", false, true);
                                var10_12 = new P3();
                                var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                var8_8[var12_11][var20_20++] = var10_12;
                                if (var5_5 != null) {
                                    var5_5.addLast(var13_13);
                                }
                                this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, "sp3c", false, true);
                                var10_12 = new P3();
                                var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                var8_8[var12_11][var20_20++] = var10_12;
                                if (var5_5 != null) {
                                    var5_5.addLast(var13_13);
                                }
                                this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, "sp3d", false, true);
                                var10_12 = new P3();
                                var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                var8_8[var12_11][var20_20++] = var10_12;
                                if (var5_5 == null) break;
                                var5_5.addLast(var13_13);
                                break;
                            }
                            case 2: {
                                v0 = var21_21 = var18_18 == 2 || var14_14 == 5 || var19_19 == 1 && var17_17 == 4 || var14_14 == 7 && this.isAdjacentSp2(var13_13) != false;
                                this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, var21_21 != false ? "sp2b" : (var17_17 == 3 ? "sp3c" : "lpa"), false, true);
                                var10_12 = P3.newP(var6_6);
                                var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                var8_8[var12_11][var20_20++] = var10_12;
                                if (var5_5 != null) {
                                    var5_5.addLast(var13_13);
                                }
                                this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, var21_21 != false ? "sp2c" : (var17_17 == 3 ? "sp3d" : "lpb"), false, true);
                                var10_12 = P3.newP(var6_6);
                                var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                var8_8[var12_11][var20_20++] = var10_12;
                                if (var5_5 == null) break;
                                var5_5.addLast(var13_13);
                                break;
                            }
                            case 1: {
                                switch (var17_17 - var19_19) {
                                    case 1: {
                                        if (var14_14 == 8 && var13_13 == var13_13.group.getCarbonylOxygenAtom()) {
                                            var8_8[var12_11] = null;
                                            break block31;
                                        } else {
                                            if (this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, var18_18 == 2 || var14_14 == 5 || var14_14 == 7 && (var13_13.group.getNitrogenAtom() == var13_13 || this.isAdjacentSp2(var13_13) != false) ? "sp2c" : "sp3d", true, false) != null) {
                                                var10_12 = P3.newP(var6_6);
                                                var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                                var8_8[var12_11][var20_20++] = var10_12;
                                                if (var5_5 == null) break block9;
                                                var5_5.addLast(var13_13);
                                                break block9;
                                            }
                                            var8_8[var12_11] = new P3[0];
                                            break block9;
                                        }
                                    }
                                    case 2: {
                                        this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, var17_17 == 4 ? "sp2c" : "sp2b", false, false);
                                        var10_12 = P3.newP(var6_6);
                                        var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                        var8_8[var12_11][var20_20++] = var10_12;
                                        if (var5_5 == null) break block9;
                                        var5_5.addLast(var13_13);
                                        break block9;
                                    }
                                    case 3: {
                                        this.getHybridizationAndAxes(var12_11, var14_14, var6_6, var7_7, "spb", false, true);
                                        var10_12 = P3.newP(var6_6);
                                        var10_12.scaleAdd2(var15_15, var6_6, var13_13);
                                        var8_8[var12_11][var20_20++] = var10_12;
                                        if (var5_5 == null) break block9;
                                        var5_5.addLast(var13_13);
                                    }
                                }
                            }
                        }
                    }
                    var11_10 += var20_20;
                }
                var12_11 = var1_1.nextSetBit(var12_11 + 1);
            }
        }
        var2_2[0] = var11_10;
        return var8_8;
    }

    private boolean isAdjacentSp2(Atom atom) {
        Bond[] bondArray = atom.bonds;
        int n = 0;
        while (n < bondArray.length) {
            Bond[] bondArray2 = bondArray[n].getOtherAtom((Atom)atom).bonds;
            int n2 = 0;
            while (n2 < bondArray2.length) {
                switch (bondArray2[n2].order) {
                    case 2: 
                    case 3: 
                    case 514: 
                    case 515: {
                        return true;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public int getMissingHydrogenCount(Atom atom, boolean bl) {
        int n;
        String string;
        int n2 = atom.getTargetValence();
        if (n2 < 0) {
            return 0;
        }
        int n3 = atom.getFormalCharge();
        int n4 = atom.getValence();
        Model model = ((ModelSet)this).am[atom.mi];
        String string2 = string = model.isBioModel && !model.isPdbWithMultipleBonds ? atom.group.getGroup3() : null;
        if (this.aaRet == null) {
            this.aaRet = new int[5];
        }
        this.aaRet[0] = n2;
        this.aaRet[1] = n3;
        this.aaRet[2] = 0;
        this.aaRet[3] = atom.getCovalentBondCount();
        int n5 = this.aaRet[4] = string == null ? 0 : n4;
        if (string != null && n3 == 0 && this.bioModelset.getAminoAcidValenceAndCharge(string, atom.getAtomName(), this.aaRet)) {
            n2 = this.aaRet[0];
            n3 = this.aaRet[1];
        }
        if (n3 != 0) {
            this.aaRet[0] = n2 += n2 == 4 ? -Math.abs(n3) : n3;
        }
        return (n = n2 - n4) < 0 && !bl ? 0 : n;
    }

    public int fixFormalCharges(BS bS) {
        int n = 0;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = this.at[n2];
            int n3 = this.getMissingHydrogenCount(atom, true);
            if (n3 != 0) {
                int n4 = atom.getFormalCharge();
                int n5 = n4 - n3;
                atom.setFormalCharge(n5);
                this.taintAtom(n2, 4);
                if (Logger.debugging) {
                    Logger.debug("atom " + atom + " formal charge " + n4 + " -> " + n5);
                }
                ++n;
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        return n;
    }

    public String getHybridizationAndAxes(int n, int n2, V3 v3, V3 v32, String string, boolean bl, boolean bl2) {
        String string2;
        String string3 = string2 = string.length() > 0 && string.charAt(0) == '-' ? string.substring(1) : string;
        if (string.indexOf("d") >= 0 && !string.endsWith("sp3d")) {
            return this.getHybridizationAndAxesD(n, v3, v32, string2);
        }
        Atom atom = this.at[n];
        if (n2 == 0) {
            n2 = atom.getElementNumber();
        }
        Atom[] atomArray = this.getAttached(atom, 4, bl);
        int n3 = atomArray.length;
        int n4 = string2.charAt(string2.length() - 1) - 97;
        if (n4 < 0 || n4 > 6) {
            n4 = 0;
        }
        v3.set(0.0f, 0.0f, 0.0f);
        v32.set(0.0f, 0.0f, 0.0f);
        V3[] v3Array = new V3[4];
        int n5 = 0;
        while (n5 < n3) {
            v3Array[n5] = V3.newVsub(atom, atomArray[n5]);
            v3Array[n5].normalize();
            v3.add(v3Array[n5]);
            ++n5;
        }
        if (n3 > 0) {
            v32.setT(v3Array[0]);
        }
        n5 = 0;
        V3 v33 = new V3();
        if (n3 >= 3) {
            if (v32.angle(v3Array[1]) < 2.984513f) {
                v33.cross(v32, v3Array[1]);
            } else {
                v33.cross(v32, v3Array[2]);
            }
            v33.normalize();
            V3 v34 = new V3();
            if (v3Array[1].angle(v3Array[2]) < 2.984513f) {
                v34.cross(v3Array[1], v3Array[2]);
            } else {
                v34.cross(v32, v3Array[2]);
            }
            v34.normalize();
            n5 = Math.abs(v34.dot(v33)) >= 0.95f ? 1 : 0;
        }
        boolean bl3 = string2.indexOf("sp3") == 0;
        boolean bl4 = !bl3 && string2.indexOf("sp2") == 0;
        boolean bl5 = !bl3 && !bl4 && string2.indexOf("sp") == 0;
        boolean bl6 = string2.indexOf("p") == 0;
        boolean bl7 = string2.indexOf("lp") == 0;
        String string4 = null;
        if (bl) {
            if (n3 == 0) {
                return null;
            }
            if (bl3 ? n4 > 3 || n3 > 4 : (bl4 ? n4 > 2 || n3 > 3 : bl5 && (n4 > 1 || n3 > 2))) {
                return null;
            }
            switch (n3) {
                case 1: {
                    if (n2 == 1 && !bl3) {
                        return null;
                    }
                    if (bl3) {
                        string4 = "sp3";
                        break;
                    }
                    switch (atomArray[0].getCovalentBondCount()) {
                        case 1: {
                            if (atomArray[0].getValence() != 2) {
                                string4 = "sp";
                                break;
                            }
                        }
                        case 2: {
                            string4 = bl5 ? "sp" : "sp2";
                            break;
                        }
                        case 3: {
                            if (!bl4 && !bl6) {
                                return null;
                            }
                            string4 = "sp2";
                        }
                    }
                    break;
                }
                case 2: {
                    if (v3.length() < 0.1f) {
                        if (string2.indexOf("2") >= 0 || string2.indexOf("3") >= 0) {
                            return null;
                        }
                        string4 = "sp";
                        break;
                    }
                    String string5 = string4 = bl3 ? "sp3" : "sp2";
                    if (string2.indexOf("sp") == 0) break;
                    if (bl7) {
                        string4 = "lp";
                        break;
                    }
                    string4 = string2;
                    break;
                }
                default: {
                    string4 = n5 != 0 ? "sp2" : (bl7 && n3 == 3 ? "lp" : "sp3");
                }
            }
            if (string4 == null) {
                return null;
            }
            if (string2.indexOf("p") == 0 ? string4 == "sp3" : string2.indexOf(string4) < 0) {
                return null;
            }
        }
        if (n4 < n3 && !string2.startsWith("p") && !string2.startsWith("l")) {
            v3.sub2(atomArray[n4], atom);
            v3.normalize();
            return string4;
        }
        block9 : switch (n3) {
            case 0: {
                if (string2.equals("sp3c") || string2.equals("sp2d") || string2.equals("lpa")) {
                    v3.set(-0.5f, -0.7f, 1.0f);
                    v32.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                if (string2.equals("sp3b") || string2.equals("lpb")) {
                    v3.set(0.5f, -0.7f, -1.0f);
                    v32.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                if (string2.equals("sp3a")) {
                    v3.set(0.0f, 1.0f, 0.0f);
                    v32.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                v3.set(0.0f, 0.0f, 1.0f);
                v32.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                v33.setT(vRef);
                v32.cross(v33, v3);
                if (bl3) {
                    int n6 = atomArray[0].getBondCount();
                    while (--n6 >= 0) {
                        if (!atomArray[0].bonds[n6].isCovalent() || atomArray[0].getBondedAtomIndex(n6) == atom.i) continue;
                        v32.sub2(atomArray[0], atomArray[0].bonds[n6].getOtherAtom(atomArray[0]));
                        v32.cross(v3, v32);
                        if (v32.length() == 0.0f) continue;
                        v32.cross(v32, v3);
                        break;
                    }
                    v32.normalize();
                    if (Float.isNaN(v32.x)) {
                        v32.setT(vRef);
                        v32.cross(v32, v3);
                    }
                    v33.cross(v3, v32);
                    v33.normalize();
                    v3.normalize();
                    v32.scaleAdd2(2.828f, v32, v3);
                    if (n4 != 3) {
                        v32.normalize();
                        new M3().setAA(A4.new4(v3.x, v3.y, v3.z, (float)(n4 == 2 ? 1 : -1) * 2.0943952f)).rotate(v32);
                    }
                    v3.setT(v32);
                    v32.cross(v33, v3);
                    break;
                }
                v33.cross(v32, v3);
                switch (atomArray[0].getCovalentBondCount()) {
                    case 1: {
                        if (atomArray[0].getValence() != 2) break block9;
                    }
                    case 2: {
                        boolean bl8 = false;
                        Atom atom2 = atomArray[0];
                        v32.setT(v3);
                        v33.setT(vRef);
                        while (atom2 != null && atom2.getCovalentBondCount() == 2) {
                            Bond[] bondArray = atom2.bonds;
                            Atom atom3 = null;
                            bl8 = !bl8;
                            int n7 = 0;
                            while (n7 < bondArray.length) {
                                if (bondArray[n7].isCovalent() && (atom3 = bondArray[n7].getOtherAtom(atom2)) != atom) {
                                    v33.sub2(atom3, atom2);
                                    break;
                                }
                                ++n7;
                            }
                            v33.cross(v33, v32);
                            if (v33.length() > 0.1f || atom3.getCovalentBondCount() != 2) break;
                            atom = atom2;
                            atom2 = atom3;
                        }
                        if (v33.length() > 0.1f) {
                            v3.cross(v33, v32);
                            v3.normalize();
                            if (n4 == 1) {
                                v3.scale(-1.0f);
                            }
                            v3.scale(sqrt3_2);
                            v3.scaleAdd2(0.5f, v32, v3);
                            if (bl6) {
                                v33.cross(v3, v32);
                                v3.setT(v33);
                                v33.setT(v32);
                            }
                            v32.cross(v33, v3);
                            break;
                        }
                        v3.setT(v32);
                        v32.cross(vRef, v32);
                        break;
                    }
                    case 3: {
                        this.getHybridizationAndAxes(atomArray[0].i, 0, v32, v33, "pz", false, bl2);
                        v33.setT(v32);
                        if (bl4) {
                            v32.cross(v32, v3);
                            if (n4 == 1) {
                                v32.scale(-1.0f);
                            }
                            v32.scale(sqrt3_2);
                            v3.scaleAdd2(0.5f, v3, v32);
                        } else {
                            v33.setT(v3);
                            v3.setT(v32);
                        }
                        v32.cross(v33, v3);
                    }
                }
                break;
            }
            case 2: {
                if (v3.length() < 0.1f) {
                    if (!string2.equals("pz")) {
                        boolean bl9;
                        Atom atom4 = atomArray[0];
                        boolean bl10 = bl9 = atom4.getCovalentBondCount() == 3;
                        if (!bl9) {
                            atom4 = atomArray[1];
                            boolean bl11 = bl9 = atom4.getCovalentBondCount() == 3;
                        }
                        if (bl9) {
                            this.getHybridizationAndAxes(atom4.i, 0, v32, v3, "pz", false, bl2);
                            if (string2.equals("px")) {
                                v32.scale(-1.0f);
                            }
                            v3.setT(v3Array[0]);
                            break;
                        }
                        v33.setT(vRef);
                        v3.cross(v33, v32);
                        v33.cross(v3, v32);
                    }
                    v3.setT(v32);
                    v32.cross(v33, v3);
                    break;
                }
                v33.cross(v3, v32);
                if (bl4) {
                    v32.cross(v3, v33);
                    break;
                }
                if (bl3 || bl7) {
                    v33.normalize();
                    v3.normalize();
                    if (!string2.equals("lp")) {
                        if (n4 == 0 || n4 == 2) {
                            v3.scaleAdd2(-1.2f, v33, v3);
                        } else {
                            v3.scaleAdd2(1.2f, v33, v3);
                        }
                    }
                    v32.cross(v3, v33);
                    break;
                }
                v32.cross(v3, v33);
                v3.setT(v33);
                if (!(v3.z < 0.0f)) break;
                v3.scale(-1.0f);
                v32.scale(-1.0f);
                break;
            }
            default: {
                if (bl3) break;
                if (n5 == 0) {
                    v32.cross(v3, v32);
                    break;
                }
                v3.setT(v33);
                if (!(v3.z < 0.0f) || !bl2) break;
                v3.scale(-1.0f);
                v32.scale(-1.0f);
            }
        }
        v32.normalize();
        v3.normalize();
        return string4;
    }

    private String getHybridizationAndAxesD(int n, V3 v3, V3 v32, String string) {
        int n2;
        if (string.startsWith("sp3d2")) {
            string = "d2sp3" + (string.length() == 5 ? "a" : string.substring(5));
        }
        if (string.startsWith("sp3d")) {
            string = "dsp3" + (string.length() == 4 ? "a" : string.substring(4));
        }
        if (string.equals("d2sp3") || string.equals("dsp3")) {
            string = String.valueOf(string) + "a";
        }
        boolean bl = string.startsWith("dsp3");
        int n3 = string.charAt(string.length() - 1) - 97;
        if (v3 != null && (!bl && (n3 > 5 || !string.startsWith("d2sp3")) || bl && n3 > 4)) {
            return null;
        }
        Atom atom = this.at[n];
        Atom[] atomArray = this.getAttached(atom, 6, true);
        if (atomArray == null) {
            return v3 == null ? null : "?";
        }
        int n4 = atomArray.length;
        if (n4 < 3 && v3 != null) {
            return null;
        }
        boolean bl2 = n3 >= n4;
        int n5 = n4 * (n4 - 1) / 2;
        int[][] nArray = AU.newInt2(n5);
        int[] nArray2 = new int[3];
        int[][] nArray3 = new int[3][n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        int n9 = 2;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n4 - 1) {
            int n12 = n11 + 1;
            while (n12 < n4) {
                float f = Measure.computeAngleABC(atomArray[n11], atom, atomArray[n12], true);
                n2 = f < 105.0f ? n7 : (f >= 150.0f ? n9 : n8);
                nArray3[n2][nArray2[n2]] = n6;
                int n13 = n2;
                nArray2[n13] = nArray2[n13] + 1;
                nArray[n6++] = new int[]{n11, n12};
                if (n11 == 0 && n2 == n8) {
                    ++n10;
                }
                ++n12;
            }
            ++n11;
        }
        n6 = nArray2[n7] * 100 + nArray2[n8] * 10 + nArray2[n9];
        if (v3 == null) {
            switch (n6) {
                default: {
                    return "";
                }
                case 0: {
                    return "";
                }
                case 1: {
                    return "linear";
                }
                case 10: 
                case 100: {
                    return "bent";
                }
                case 111: 
                case 201: {
                    return "T-shaped";
                }
                case 30: 
                case 120: 
                case 210: 
                case 300: {
                    if (Math.abs(Measure.computeTorsion(atomArray[0], atom, atomArray[1], atomArray[2], true)) > 162.0f) {
                        return "trigonal planar";
                    }
                    return "trigonal pyramidal";
                }
                case 330: {
                    return n10 % 2 == 1 ? "tetrahedral" : "uncapped trigonal pyramid";
                }
                case 60: 
                case 150: 
                case 240: {
                    return "tetrahedral";
                }
                case 402: {
                    return "square planar";
                }
                case 411: 
                case 501: {
                    return "see-saw";
                }
                case 631: {
                    return "trigonal bipyramidal";
                }
                case 802: {
                    return "uncapped square pyramid";
                }
                case 1203: 
            }
            return "octahedral";
        }
        switch (n6) {
            default: {
                return null;
            }
            case 201: {
                break;
            }
            case 210: 
            case 330: 
            case 411: 
            case 631: {
                if (bl) break;
                return null;
            }
            case 300: 
            case 402: 
            case 501: 
            case 802: 
            case 1203: {
                if (!bl) break;
                return null;
            }
        }
        if (bl2) {
            if (bl) {
                switch (nArray2[n8]) {
                    case 0: {
                        v3.sub2(atomArray[nArray[nArray3[n7][0]][0]], atom);
                        v32.sub2(atomArray[nArray[nArray3[n7][0]][1]], atom);
                        v3.cross(v3, v32);
                        v3.normalize();
                        if (n3 == 4) {
                            v3.scale(-1.0f);
                        }
                        BS bS = this.findNotAttached(n4, nArray, nArray3[n9], nArray2[n9]);
                        int n14 = bS.nextSetBit(0);
                        v32.sub2(atomArray[n14], atom);
                        v32.normalize();
                        v32.scale(0.5f);
                        v3.scaleAdd2(sqrt3_2, v3, v32);
                        n3 = -1;
                        break;
                    }
                    case 1: {
                        if (n3 == 4) {
                            int[] nArray4 = nArray[nArray3[n8][0]];
                            v3.add2(atomArray[nArray4[0]], atomArray[nArray4[1]]);
                            v3.scaleAdd2(-2.0f, atom, v3);
                            n3 = -1;
                            break;
                        }
                        BS bS = this.findNotAttached(n4, nArray, nArray3[n8], nArray2[n8]);
                        n3 = bS.nextSetBit(0);
                        break;
                    }
                    default: {
                        BS bS = this.findNotAttached(n4, nArray, nArray3[n8], nArray2[n8]);
                        n3 = bS.nextSetBit(0);
                        break;
                    }
                }
            } else {
                boolean bl3 = false;
                if (n4 == 4) {
                    switch (nArray2[n9]) {
                        case 1: {
                            BS bS = this.findNotAttached(n4, nArray, nArray3[n9], nArray2[n9]);
                            n2 = bS.nextSetBit(0);
                            if (n3 == 4) {
                                n3 = n2;
                                break;
                            }
                            n3 = bS.nextSetBit(n2 + 1);
                            break;
                        }
                        default: {
                            bl3 = true;
                            break;
                        }
                    }
                } else {
                    BS bS = this.findNotAttached(n4, nArray, nArray3[n9], nArray2[n9]);
                    n2 = bS.nextSetBit(0);
                    int n15 = n4;
                    while (n15 < n3 && n2 >= 0) {
                        n2 = bS.nextSetBit(n2 + 1);
                        ++n15;
                    }
                    if (n2 == -1) {
                        bl3 = true;
                    } else {
                        n3 = n2;
                    }
                }
                if (bl3) {
                    v3.sub2(atomArray[nArray[nArray3[n7][0]][0]], atom);
                    v32.sub2(atomArray[nArray[nArray3[n7][0]][1]], atom);
                    v3.cross(v3, v32);
                    if (n3 == 4) {
                        v3.scale(-1.0f);
                    }
                    n3 = -1;
                }
            }
        }
        if (n3 >= 0) {
            v3.sub2(atomArray[n3], atom);
        }
        if (bl2) {
            v3.scale(-1.0f);
        }
        v3.normalize();
        return bl ? "dsp3" : "d2sp3";
    }

    private Atom[] getAttached(Atom atom, int n, boolean bl) {
        int n2 = atom.getCovalentBondCount();
        if (n2 > n) {
            return null;
        }
        Atom[] atomArray = new Atom[n2];
        if (n2 > 0) {
            Bond[] bondArray = atom.bonds;
            int n3 = 0;
            int n4 = 0;
            while (n4 < bondArray.length) {
                if (bondArray[n4].isCovalent()) {
                    atomArray[n3++] = bondArray[n4].getOtherAtom(atom);
                }
                ++n4;
            }
            if (bl) {
                Arrays.sort(atomArray, new AtomSorter());
            }
        }
        return atomArray;
    }

    private BS findNotAttached(int n, int[][] nArray, int[] nArray2, int n2) {
        BS bS = BS.newN(n);
        bS.setBits(0, n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                int[] nArray3 = nArray[nArray2[n4]];
                if (nArray3[0] == n3 || nArray3[1] == n3) {
                    bS.clear(n3);
                }
                ++n4;
            }
            ++n3;
        }
        return bS;
    }

    public BS getAtomBitsMDa(int n, Object object, BS bS) {
        int n2 = object instanceof Integer ? (Integer)object : 0;
        switch (n) {
            case 1086326785: 
            case 1086326786: {
                boolean bl = n == 1086326785;
                String string = "," + object + ",";
                int n3 = this.ac;
                while (--n3 >= 0) {
                    String string2;
                    String string3 = string2 = bl ? this.at[n3].getAtomType() : this.at[n3].getAtomName();
                    if (string.indexOf("," + string2 + ",") < 0) continue;
                    bS.set(n3);
                }
                return bS;
            }
            case 1094715393: {
                int n4 = this.ac;
                while (--n4 >= 0) {
                    if (this.at[n4].getAtomNumber() != n2) continue;
                    bS.set(n4);
                }
                return bS;
            }
            case 0x200003: {
                int n5 = this.ac;
                while (--n5 >= 0) {
                    if (this.at[n5].getCovalentBondCount() <= 0) continue;
                    bS.set(n5);
                }
                return bS;
            }
            case 0x200004: 
            case 0x20000E: 
            case 0x200010: 
            case 0x200012: 
            case 2097172: 
            case 2097174: 
            case 0x200020: 
            case 0x200024: 
            case 136314895: {
                return ((ModelSet)this).haveBioModels ? ((ModelSet)this).bioModelset.getAtomBitsBS(n, null, bS) : bS;
            }
            case 1612709900: {
                n2 = 1;
            }
            case 1094715402: {
                int n6 = this.ac;
                while (--n6 >= 0) {
                    if (this.at[n6].getElementNumber() != n2) continue;
                    bS.set(n6);
                }
                return bS;
            }
            case 0x60200006: {
                int n7 = this.ac;
                while (--n7 >= 0) {
                    if (!this.at[n7].isHetero()) continue;
                    bS.set(n7);
                }
                return bS;
            }
            case 0x40000000: {
                return this.getIdentifierOrNull((String)object);
            }
            case 0x20000D: {
                int n8 = this.ac;
                while (--n8 >= 0) {
                    if (!this.at[n8].isLeadAtom()) continue;
                    bS.set(n8);
                }
                return bS;
            }
            case 1094713362: 
            case 1639976963: {
                return ((ModelSet)this).haveBioModels ? ((ModelSet)this).bioModelset.getAtomBitsBS(n, (BS)object, bS) : bS;
            }
            case 1094715412: {
                int n9 = this.ac;
                while (--n9 >= 0) {
                    if (this.at[n9].getResno() != n2) continue;
                    bS.set(n9);
                }
                return bS;
            }
            case 1612709912: {
                int[] nArray = new int[2];
                int n10 = this.ac;
                while (--n10 >= 0) {
                    short s = this.at[n10].group.groupID;
                    if (s >= 42 && s < 45) {
                        bS.set(n10);
                        continue;
                    }
                    Atom atom = this.at[n10];
                    if (atom.getElementNumber() != 8 || atom.getCovalentBondCount() != 2) continue;
                    Bond[] bondArray = atom.bonds;
                    int n11 = 0;
                    int n12 = bondArray.length;
                    while (--n12 >= 0 && n11 < 3) {
                        Atom atom2;
                        if (!bondArray[n12].isCovalent() || (atom2 = bondArray[n12].getOtherAtom(atom)).getElementNumber() != 1) continue;
                        nArray[n11++ % 2] = atom2.i;
                    }
                    if (n11 != 2) continue;
                    bS.set(nArray[1]);
                    bS.set(nArray[0]);
                    bS.set(n10);
                }
                return bS;
            }
            case 1073742355: {
                String string = (String)object;
                int n13 = this.ac;
                while (--n13 >= 0) {
                    if (!this.isAltLoc(this.at[n13].altloc, string)) continue;
                    bS.set(n13);
                }
                return bS;
            }
            case 1073742356: {
                boolean bl;
                String string = ((String)object).toUpperCase();
                if (string.indexOf("\\?") >= 0) {
                    string = PT.rep(string, "\\?", "\u0001");
                }
                if (bl = string.startsWith("?*")) {
                    string = string.substring(1);
                }
                int n14 = this.ac;
                while (--n14 >= 0) {
                    if (!this.isAtomNameMatch(this.at[n14], string, bl, bl)) continue;
                    bS.set(n14);
                }
                return bS;
            }
            case 1073742357: {
                return BSUtil.copy(this.getChainBits(n2));
            }
            case 1073742360: {
                return this.getSpecName((String)object);
            }
            case 1073742361: {
                int n15 = this.ac;
                while (--n15 >= 0) {
                    if (this.at[n15].group.groupID != n2) continue;
                    bS.set(n15);
                }
                return bS;
            }
            case 1073742362: {
                return BSUtil.copy(this.getSeqcodeBits(n2, true));
            }
            case 5: {
                int n16 = this.ac;
                while (--n16 >= 0) {
                    if (this.at[n16].group.getInsCode() != n2) continue;
                    bS.set(n16);
                }
                return bS;
            }
            case 1296041986: {
                int n17 = this.ac;
                while (--n17 >= 0) {
                    if (this.at[n17].getSymOp() != n2) continue;
                    bS.set(n17);
                }
                return bS;
            }
        }
        BS bS2 = (BS)object;
        int n18 = bS2.nextSetBit(0);
        if (n18 < 0) {
            return bS;
        }
        switch (n) {
            case 1094717454: {
                BS bS3 = BSUtil.copy(bS2);
                int n19 = n18;
                while (n19 >= 0) {
                    bS.or(((ModelSet)this).am[this.at[n19].mi].bsAtoms);
                    bS3.andNot(bS);
                    n19 = bS3.nextSetBit(n19 + 1);
                }
                return bS;
            }
            case 1086326788: {
                BS bS4 = BSUtil.copy(bS2);
                int n20 = n18;
                while (n20 >= 0) {
                    this.at[n20].group.chain.setAtomBits(bS);
                    bS4.andNot(bS);
                    n20 = bS4.nextSetBit(n20 + 1);
                }
                return bS;
            }
            case 1086326789: {
                BS bS5 = new BS();
                int n21 = n18;
                while (n21 >= 0) {
                    bS5.set(this.at[n21].getElementNumber());
                    n21 = bS2.nextSetBit(n21 + 1);
                }
                n21 = this.ac;
                while (--n21 >= 0) {
                    if (!bS5.get(this.at[n21].getElementNumber())) continue;
                    bS.set(n21);
                }
                return bS;
            }
            case 1086324742: {
                BS bS6 = BSUtil.copy(bS2);
                int n22 = n18;
                while (n22 >= 0) {
                    this.at[n22].group.setAtomBits(bS);
                    bS6.andNot(bS);
                    n22 = bS6.nextSetBit(n22 + 1);
                }
                return bS;
            }
            case 1094713366: {
                BS bS7 = new BS();
                int n23 = n18;
                while (n23 >= 0) {
                    bS7.set(this.at[n23].atomSite);
                    n23 = bS2.nextSetBit(n23 + 1);
                }
                n23 = this.ac;
                while (--n23 >= 0) {
                    if (!bS7.get(this.at[n23].atomSite)) continue;
                    bS.set(n23);
                }
                return bS;
            }
        }
        Logger.error("MISSING getAtomBits entry for " + T.nameOf(n));
        return bS;
    }

    public BS getChainBits(int n) {
        boolean bl = this.vwr.getBoolean(603979822);
        if (n >= 0 && n < 300 && !bl) {
            n = this.chainToUpper(n);
        }
        BS bS = new BS();
        BS bS2 = BS.newN(this.ac);
        int n2 = bS2.nextClearBit(0);
        while (n2 < this.ac) {
            Chain chain = this.at[n2].group.chain;
            int n3 = chain.chainID;
            if (n == n3 || !bl && n3 >= 0 && n3 < 300 && n == this.chainToUpper(n3)) {
                chain.setAtomBits(bS);
                bS2.or(bS);
            } else {
                chain.setAtomBits(bS2);
            }
            n2 = bS2.nextClearBit(n2 + 1);
        }
        return bS;
    }

    public int chainToUpper(int n) {
        return n >= 97 && n <= 122 ? n - 32 : (n >= 256 && n < 300 ? n - 191 : n);
    }

    private boolean isAltLoc(char c, String string) {
        if (string == null) {
            return c == '\u0000';
        }
        if (string.length() != 1) {
            return false;
        }
        char c2 = string.charAt(0);
        return c2 == '*' || c2 == '?' && c != '\u0000' || c == c2;
    }

    public BS getSeqcodeBits(int n, boolean bl) {
        BS bS = new BS();
        int n2 = Group.getSeqNumberFor(n);
        boolean bl2 = n2 != Integer.MAX_VALUE;
        boolean bl3 = true;
        char c = Group.getInsertionCodeChar(n);
        switch (c) {
            case '?': {
                int n3 = this.ac;
                while (--n3 >= 0) {
                    int n4 = this.at[n3].group.seqcode;
                    if (bl2 && n2 != Group.getSeqNumberFor(n4) || Group.getInsertionCodeFor(n4) == 0) continue;
                    bS.set(n3);
                    bl3 = false;
                }
                break;
            }
            default: {
                int n5 = this.ac;
                while (--n5 >= 0) {
                    int n6 = this.at[n5].group.seqcode;
                    if (n != n6 && (bl2 || n != Group.getInsertionCodeFor(n6)) && (c != '*' || n2 != Group.getSeqNumberFor(n6))) continue;
                    bS.set(n5);
                    bl3 = false;
                }
                break block0;
            }
        }
        return !bl3 || bl ? bS : null;
    }

    private BS getIdentifierOrNull(String string) {
        BS bS = this.getSpecNameOrNull(string, false);
        if (string.indexOf("\\?") >= 0) {
            string = PT.rep(string, "\\?", "\u0001");
        }
        return bS != null || string.indexOf("?") > 0 ? bS : (string.indexOf("*") > 0 ? this.getSpecNameOrNull(string, true) : (((ModelSet)this).haveBioModels ? ((ModelSet)this).bioModelset.getIdentifierOrNull(string) : null));
    }

    private BS getSpecName(String string) {
        BS bS = this.getSpecNameOrNull(string, false);
        if (bS != null) {
            return bS;
        }
        if (string.indexOf("*") > 0) {
            bS = this.getSpecNameOrNull(string, true);
        }
        return bS == null ? new BS() : bS;
    }

    public BS getSpecNameOrNull(String string, boolean bl) {
        boolean bl2;
        BS bS = null;
        if ((string = string.toUpperCase()).indexOf("\\?") >= 0) {
            string = PT.rep(string, "\\?", "\u0001");
        }
        if (bl2 = string.startsWith("?*")) {
            string = string.substring(1);
        }
        int n = this.ac;
        while (--n >= 0) {
            String string2 = this.at[n].getGroup3(true);
            if (string2 != null && string2.length() > 0) {
                if (!PT.isMatch(string2, string, bl, true)) continue;
                if (bS == null) {
                    bS = BS.newN(n + 1);
                }
                bS.set(n);
                while (--n >= 0 && this.at[n].getGroup3(true).equals(string2)) {
                    bS.set(n);
                }
                ++n;
                continue;
            }
            if (!this.isAtomNameMatch(this.at[n], string, bl, bl2)) continue;
            if (bS == null) {
                bS = BS.newN(n + 1);
            }
            bS.set(n);
        }
        return bS;
    }

    private boolean isAtomNameMatch(Atom atom, String string, boolean bl, boolean bl2) {
        return PT.isMatch(atom.getAtomName().toUpperCase(), string, bl, bl2);
    }

    public int[] getAtomIndices(BS bS) {
        int n = 0;
        int[] nArray = new int[this.ac];
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0 && n2 < this.ac) {
            nArray[n2] = ++n;
            n2 = bS.nextSetBit(n2 + 1);
        }
        return nArray;
    }

    public BS getAtomsNearPlane(float f, P4 p4) {
        BS bS = new BS();
        int n = this.ac;
        while (--n >= 0) {
            Atom atom = this.at[n];
            float f2 = Measure.distanceToPlane(p4, atom);
            if (!(f > 0.0f && (double)f2 >= -0.1 && f2 <= f || f < 0.0f && (double)f2 <= 0.1 && f2 >= f) && (f != 0.0f || !((double)Math.abs(f2) < 0.01))) continue;
            bS.set(atom.i);
        }
        return bS;
    }

    public void clearVisibleSets() {
        this.haveBSVisible = false;
        this.haveBSClickable = false;
    }

    public void getAtomsInFrame(BS bS) {
        this.clearVisibleSets();
        bS.clearAll();
        int n = this.ac;
        while (--n >= 0) {
            if (!this.at[n].isVisible(1)) continue;
            bS.set(n);
        }
    }

    public BS getVisibleSet(boolean bl) {
        if (bl) {
            this.vwr.setModelVisibility();
            this.vwr.shm.finalizeAtoms(null, true);
        } else if (this.haveBSVisible) {
            return this.bsVisible;
        }
        this.bsVisible.clearAll();
        int n = this.ac;
        while (--n >= 0) {
            if (!this.at[n].checkVisible()) continue;
            this.bsVisible.set(n);
        }
        if (this.vwr.shm.bsSlabbedInternal != null) {
            this.bsVisible.andNot(this.vwr.shm.bsSlabbedInternal);
        }
        this.haveBSVisible = true;
        return this.bsVisible;
    }

    public BS getClickableSet(boolean bl) {
        if (bl) {
            this.vwr.setModelVisibility();
        } else if (this.haveBSClickable) {
            return this.bsClickable;
        }
        this.bsClickable.clearAll();
        int n = this.ac;
        while (--n >= 0) {
            if (!this.at[n].isClickable()) continue;
            this.bsClickable.set(n);
        }
        this.haveBSClickable = true;
        return this.bsClickable;
    }

    public boolean isModulated(int n) {
        return this.bsModulated != null && this.bsModulated.get(n);
    }

    protected void deleteModelAtoms(int n, int n2, BS bS) {
        this.at = (Atom[])AU.deleteElements(this.at, n, n2);
        this.ac = this.at.length;
        int n3 = n;
        while (n3 < this.ac) {
            this.at[n3].i = n3;
            this.at[n3].mi = (short)(this.at[n3].mi - 1);
            ++n3;
        }
        if (this.bsModulated != null) {
            BSUtil.deleteBits(this.bsModulated, bS);
        }
        this.deleteAtomTensors(bS);
        this.atomNames = (String[])AU.deleteElements(this.atomNames, n, n2);
        this.atomTypes = (String[])AU.deleteElements(this.atomTypes, n, n2);
        this.atomResnos = (int[])AU.deleteElements(this.atomResnos, n, n2);
        this.atomSerials = (int[])AU.deleteElements(this.atomSerials, n, n2);
        this.atomSeqIDs = (int[])AU.deleteElements(this.atomSeqIDs, n, n2);
        this.dssrData = (float[])AU.deleteElements(this.dssrData, n, n2);
        this.bfactor100s = (short[])AU.deleteElements(this.bfactor100s, n, n2);
        this.hasBfactorRange = false;
        this.occupancies = (float[])AU.deleteElements(this.occupancies, n, n2);
        this.resetPartialCharges();
        this.atomTensorList = (Object[][])AU.deleteElements(this.atomTensorList, n, n2);
        this.vibrations = (Vibration[])AU.deleteElements(this.vibrations, n, n2);
        this.nSurfaceAtoms = 0;
        this.bsSurface = null;
        this.surfaceDistance100s = null;
        if (this.tainted != null) {
            n3 = 0;
            while (n3 < 17) {
                BSUtil.deleteBits(this.tainted[n3], bS);
                ++n3;
            }
        }
    }

    public void getAtomIdentityInfo(int n, Map<String, Object> map, P3 p3) {
        map.put("_ipt", n);
        map.put("atomIndex", n);
        map.put("atomno", this.at[n].getAtomNumber());
        map.put("info", this.getAtomInfo(n, null, p3));
        map.put("sym", this.at[n].getElementSymbol());
    }

    public Object[] getAtomTensorList(int n) {
        return n < 0 || this.atomTensorList == null || n >= this.atomTensorList.length ? null : this.atomTensorList[n];
    }

    private void deleteAtomTensors(BS bS) {
        if (this.atomTensors == null) {
            return;
        }
        Lst<String> lst = new Lst<String>();
        for (String string : this.atomTensors.keySet()) {
            Lst<Object> lst2 = this.atomTensors.get(string);
            int n = lst2.size();
            while (--n >= 0) {
                Tensor tensor = (Tensor)lst2.get(n);
                if (!bS.get(tensor.atomIndex1) && (tensor.atomIndex2 < 0 || !bS.get(tensor.atomIndex2))) continue;
                lst2.removeItemAt(n);
            }
            if (lst2.size() != 0) continue;
            lst.addLast(string);
        }
        int n = lst.size();
        while (--n >= 0) {
            this.atomTensors.remove(lst.get(n));
        }
    }

    void setCapacity(int n) {
        this.atomCapacity += n;
    }

    public void setAtomTensors(int n, Lst<Object> lst) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        if (this.atomTensors == null) {
            this.atomTensors = new Hashtable<String, Lst<Object>>();
        }
        if (this.atomTensorList == null) {
            this.atomTensorList = new Object[this.at.length][];
        }
        this.atomTensorList = (Object[][])AU.ensureLength(this.atomTensorList, this.at.length);
        this.atomTensorList[n] = AtomCollection.getTensorList(lst);
        int n2 = lst.size();
        while (--n2 >= 0) {
            Tensor tensor = (Tensor)lst.get(n2);
            tensor.atomIndex1 = n;
            tensor.atomIndex2 = -1;
            tensor.modelIndex = this.at[n].mi;
            this.addTensor(tensor, tensor.type);
            if (tensor.altType == null) continue;
            this.addTensor(tensor, tensor.altType);
        }
    }

    public void addTensor(Tensor tensor, String string) {
        Lst<Object> lst = this.atomTensors.get(string = string.toLowerCase());
        if (lst == null) {
            lst = new Lst();
            this.atomTensors.put(string, lst);
            lst.ensureCapacity(this.atomCapacity);
        }
        lst.addLast(tensor);
    }

    private static Object[] getTensorList(Lst<Object> lst) {
        int n;
        int n2 = -1;
        boolean bl = false;
        int n3 = n = lst.size();
        while (--n3 >= 0) {
            Tensor tensor = (Tensor)lst.get(n3);
            if (tensor.forThermalEllipsoid) {
                n2 = n3;
                continue;
            }
            if (tensor.iType != 2) continue;
            bl = true;
        }
        Object[] objectArray = new Object[(n2 >= 0 || !bl ? 0 : 1) + n];
        if (n2 >= 0) {
            objectArray[0] = lst.get(n2);
            if (lst.size() == 1) {
                return objectArray;
            }
        }
        if (bl) {
            n2 = 0;
            int n4 = n;
            while (--n4 >= 0) {
                Tensor tensor = (Tensor)lst.get(n4);
                if (tensor.forThermalEllipsoid) continue;
                objectArray[++n2] = tensor;
            }
        } else {
            int n5 = 0;
            while (n5 < n) {
                objectArray[n5] = lst.get(n5);
                ++n5;
            }
        }
        return objectArray;
    }

    public Tensor getAtomTensor(int n, String string) {
        Object[] objectArray = this.getAtomTensorList(n);
        if (objectArray != null && string != null) {
            string = string.toLowerCase();
            int n2 = 0;
            while (n2 < objectArray.length) {
                Tensor tensor = (Tensor)objectArray[n2];
                if (tensor != null && (string.equals(tensor.type) || string.equals(tensor.altType))) {
                    return tensor;
                }
                ++n2;
            }
        }
        return null;
    }

    public Lst<Object> getAllAtomTensors(String string) {
        if (this.atomTensors == null) {
            return null;
        }
        if (string != null) {
            return this.atomTensors.get(string.toLowerCase());
        }
        Lst<Object> lst = new Lst<Object>();
        for (Map.Entry<String, Lst<Object>> entry : this.atomTensors.entrySet()) {
            lst.addAll((Collection)entry.getValue());
        }
        return lst;
    }

    public void scaleVectorsToMax(float f) {
        if (this.vibrations == null) {
            return;
        }
        float f2 = 0.0f;
        BS bS = BS.newN(this.ac);
        int n = this.vibrations.length;
        while (--n >= 0) {
            Vibration vibration = this.getVibration(n, false);
            if (vibration == null || vibration.modDim != -1 && vibration.modDim != -2) continue;
            f2 = Math.max(f2, vibration.length());
            bS.set(n);
        }
        if (f2 == f || f2 == 0.0f) {
            return;
        }
        f2 = f / f2;
        n = 0;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            Vibration vibration = this.getVibration(n2, false);
            JmolModulationSet jmolModulationSet = this.getModulation(n2);
            if (jmolModulationSet == null) {
                if (f2 == 0.0f) {
                    return;
                }
                vibration.scale(f2);
            } else {
                jmolModulationSet.scaleVibration(f2);
            }
            if (n == 0) {
                this.taintAtom(n2, 12);
                n = 1;
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        this.tainted[12].or(bS);
    }

    public BS getAtomsFromAtomNumberInFrame(int n) {
        BS bS = this.vwr.getFrameAtoms();
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (this.at[n2].getAtomNumber() != n) {
                bS.clear(n2);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        return bS;
    }

    public Lst<P3> generateCrystalClass(int n, P3 p3) {
        boolean bl;
        SymmetryInterface symmetryInterface = n < 0 || n >= this.ac ? null : this.at[n].getUnitCell();
        boolean bl2 = bl = p3 != null && Float.isNaN(p3.x);
        return symmetryInterface == null ? new Lst<P3>() : symmetryInterface.generateCrystalClass(bl ? null : (p3 != null ? p3 : this.at[n]));
    }

    protected class AtomSorter
    implements Comparator<Atom> {
        protected AtomSorter() {
        }

        @Override
        public int compare(Atom atom, Atom atom2) {
            return atom.i > atom2.i ? 1 : (atom.i < atom2.i ? -1 : 0);
        }
    }
}

