/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.A4;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.BasePair;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.viewer.Viewer;

public class NucleicMonomer
extends PhosphorusMonomer {
    static final byte C6 = 1;
    private static final byte O2Pr = 2;
    private static final byte C5 = 3;
    private static final byte N1 = 4;
    private static final byte C2 = 5;
    private static final byte N3 = 6;
    private static final byte C4 = 7;
    private static final byte O2 = 8;
    private static final byte N7 = 9;
    private static final byte C8 = 10;
    private static final byte N9 = 11;
    private static final byte O4 = 12;
    private static final byte O6 = 13;
    private static final byte N4 = 14;
    private static final byte NP = 15;
    private static final byte N6 = 16;
    private static final byte N2 = 17;
    private static final byte H5T = 18;
    private static final byte O5P = 19;
    private static final byte H3T = 20;
    private static final byte O3P = 21;
    private static final byte C3P = 22;
    private static final byte O1P = 23;
    private static final byte O2P = 24;
    private static final byte C1P = 25;
    private static final byte C2P = 26;
    private static final byte C4P = 27;
    private static final byte O4P = 28;
    private static final byte C5P = 29;
    static final byte[] interestingNucleicAtomIDs = new byte[]{-14, 37, -80, 36, 32, 33, 34, 35, -39, -40, -41, -42, -48, -47, -43, -14, -45, -44, -73, -7, -89, 10, 9, -75, -77, -13, -12, -9, -79, -8};
    private boolean isPurine;
    boolean isPyrimidine;
    private boolean hasRnaO2Prime;
    private static final byte[] ring6OffsetIndexes = new byte[]{3, 1, 4, 5, 6, 7};
    private static final byte[] ring5OffsetIndexes = new byte[]{3, 9, 10, 11, 7};
    private static final byte[] riboseOffsetIndexes;
    private static final byte[] heavyAtomIndexes;
    P3 baseCenter;
    private Lst<BasePair> bps;
    public P3[] dssrBox;
    public float dssrBoxHeight;
    public P3[] dssrFrame;

    static {
        byte[] byArray = new byte[9];
        byArray[0] = 25;
        byArray[1] = 26;
        byArray[2] = 22;
        byArray[3] = 27;
        byArray[4] = 28;
        byArray[5] = 21;
        byArray[6] = 29;
        byArray[7] = 19;
        riboseOffsetIndexes = byArray;
        heavyAtomIndexes = new byte[]{3, 1, 4, 5, 6, 7, 11, 10, 9, 16, 14, 8, 12, 17, 13};
    }

    private NucleicMonomer() {
    }

    public static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray) {
        byte[] byArray = NucleicMonomer.scanForOffsets(n2, nArray, interestingNucleicAtomIDs);
        if (byArray == null) {
            return null;
        }
        if (!NucleicMonomer.checkOptional(byArray, (byte)19, n2, nArray[73])) {
            return null;
        }
        NucleicMonomer.checkOptional(byArray, (byte)20, n2, nArray[89]);
        NucleicMonomer.checkOptional(byArray, (byte)18, n2, nArray[90]);
        NucleicMonomer.checkOptional(byArray, (byte)23, n2, nArray[75]);
        NucleicMonomer.checkOptional(byArray, (byte)24, n2, nArray[77]);
        return new NucleicMonomer().set4(chain, string, n, n2, n3, byArray);
    }

    private NucleicMonomer set4(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        this.set2(chain, string, n, n2, n3, byArray);
        if (!NucleicMonomer.have(byArray, (byte)15)) {
            byArray[0] = byArray[19];
            this.setLeadAtomIndex();
        }
        this.hasRnaO2Prime = NucleicMonomer.have(byArray, (byte)2);
        this.isPyrimidine = NucleicMonomer.have(byArray, (byte)8);
        this.isPurine = NucleicMonomer.have(byArray, (byte)9) && NucleicMonomer.have(byArray, (byte)10) && NucleicMonomer.have(byArray, (byte)11);
        return this;
    }

    @Override
    public boolean isNucleicMonomer() {
        return true;
    }

    @Override
    public boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    @Override
    public boolean isRna() {
        return this.hasRnaO2Prime;
    }

    @Override
    public boolean isPurine() {
        return this.isPurine || !this.isPyrimidine && this.isPurineByID();
    }

    @Override
    public boolean isPyrimidine() {
        return this.isPyrimidine || !this.isPurine && this.isPyrimidineByID();
    }

    public boolean isGuanine() {
        return NucleicMonomer.have(this.offsets, (byte)17);
    }

    @Override
    public STR getProteinStructureType() {
        return this.hasRnaO2Prime ? STR.RNA : STR.DNA;
    }

    Atom getP() {
        return this.getAtomFromOffsetIndex(0);
    }

    public Atom getC1P() {
        return this.getAtomFromOffsetIndex(25);
    }

    Atom getC2() {
        return this.getAtomFromOffsetIndex(5);
    }

    Atom getC5() {
        return this.getAtomFromOffsetIndex(3);
    }

    Atom getC6() {
        return this.getAtomFromOffsetIndex(1);
    }

    Atom getC8() {
        return this.getAtomFromOffsetIndex(10);
    }

    Atom getC4P() {
        return this.getAtomFromOffsetIndex(27);
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(4);
    }

    public Atom getN3() {
        return this.getAtomFromOffsetIndex(6);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(16);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(8);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(12);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(13);
    }

    @Override
    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(NucleicMonomer.have(this.offsets, (byte)20) ? 20 : 21);
    }

    public void getBaseRing6Points(P3[] p3Array) {
        this.getPoints(ring6OffsetIndexes, p3Array);
    }

    private void getPoints(byte[] byArray, P3[] p3Array) {
        int n = byArray.length;
        while (--n >= 0) {
            p3Array[n] = this.getAtomFromOffsetIndex(byArray[n]);
        }
    }

    public boolean maybeGetBaseRing5Points(P3[] p3Array) {
        if (this.isPurine) {
            this.getPoints(ring5OffsetIndexes, p3Array);
        }
        return this.isPurine;
    }

    public void getRiboseRing5Points(P3[] p3Array) {
        this.getPoints(riboseOffsetIndexes, p3Array);
    }

    @Override
    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        Atom atom = this.getAtomFromOffsetIndex(15);
        if (atom == null) {
            return false;
        }
        return ((NucleicMonomer)monomer).getAtomFromOffsetIndex(21).isBonded(atom) || this.isCA2(monomer);
    }

    @Override
    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        int n3;
        Atom atom = atomArray[0];
        Atom atom2 = this.getLeadAtom();
        Atom atom3 = this.getAtomFromOffsetIndex(19);
        Atom atom4 = this.getAtomFromOffsetIndex(22);
        int n4 = s / 2;
        if (n4 < 1900) {
            n4 = 1900;
        }
        if ((n3 = (int)this.scaleToScreen(atom2.sZ, n4)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom2, n, n2, n3, atom) || this.isCursorOnTopOf(atom3, n, n2, n3, atom) || this.isCursorOnTopOf(atom4, n, n2, n3, atom)) {
            atomArray[0] = atom2;
        }
    }

    public void setRingsVisible(boolean bl) {
        int n = 6;
        while (--n >= 0) {
            this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]).setShapeVisibility(32768, bl);
        }
        if (this.isPurine) {
            n = 4;
            while (--n >= 1) {
                this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]).setShapeVisibility(32768, bl);
            }
        }
    }

    public void setRingsClickable() {
        int n = 6;
        while (--n >= 0) {
            this.getAtomFromOffsetIndex(ring6OffsetIndexes[n]).setClickable(32768);
        }
        if (this.isPurine) {
            n = 4;
            while (--n >= 1) {
                this.getAtomFromOffsetIndex(ring5OffsetIndexes[n]).setClickable(32768);
            }
        }
    }

    public Atom getN0() {
        return this.getAtomFromOffsetIndex(this.isPurine ? 11 : 4);
    }

    @Override
    public Object getHelixData(int n, char c, int n2) {
        return this.getHelixData2(n, c, n2);
    }

    @Override
    P3 getQuaternionFrameCenter(char c) {
        switch (c) {
            case 'a': 
            case 'b': 
            case 'p': 
            case 'x': {
                return this.getP();
            }
            case 'c': {
                if (this.baseCenter == null) {
                    int n = 0;
                    this.baseCenter = new P3();
                    int n2 = 0;
                    while (n2 < heavyAtomIndexes.length) {
                        Atom atom = this.getAtomFromOffsetIndex(heavyAtomIndexes[n2]);
                        if (atom != null) {
                            this.baseCenter.add(atom);
                            ++n;
                        }
                        ++n2;
                    }
                    this.baseCenter.scale(1.0f / (float)n);
                }
                return this.baseCenter;
            }
        }
        return this.getN0();
    }

    @Override
    public Quat getQuaternion(char c) {
        T3 t3;
        T3 t32;
        Atom atom;
        if (this.bioPolymer == null) {
            return null;
        }
        Atom atom2 = null;
        Atom atom3 = null;
        boolean bl = false;
        boolean bl2 = false;
        switch (c) {
            case 'a': {
                atom = this.getP();
                if (this.monomerIndex == 0 || atom == null) {
                    return null;
                }
                bl = true;
                atom2 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex - 1]).getC4P();
                atom3 = this.getC4P();
                break;
            }
            case 'x': {
                atom = this.getP();
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1 || atom == null) {
                    return null;
                }
                atom2 = ((NucleicMonomer)this.bioPolymer.monomers[this.monomerIndex + 1]).getP();
                atom3 = this.getC4P();
                break;
            }
            case 'b': {
                return this.getQuaternionP();
            }
            case 'c': 
            case 'n': {
                atom = this.getN0();
                if (atom == null) {
                    return null;
                }
                bl = true;
                bl2 = true;
                atom2 = this.getAtomFromOffsetIndex(5);
                atom3 = this.getAtomFromOffsetIndex(25);
                break;
            }
            case 'p': {
                atom = this.getP();
                if (atom == null) {
                    return null;
                }
                t32 = this.getAtomFromOffsetIndex(23);
                t3 = this.getAtomFromOffsetIndex(24);
                Bond[] bondArray = atom.bonds;
                if (bondArray == null) {
                    return null;
                }
                Group group = atom.group;
                int n = 0;
                while (n < bondArray.length) {
                    Atom atom4 = bondArray[n].getOtherAtom(atom);
                    if (!(t32 != null && atom4.i == t32.i || t3 != null && atom4.i == ((Atom)t3).i)) {
                        if (atom4.group == group) {
                            atom3 = atom4;
                        } else {
                            atom2 = atom4;
                        }
                    }
                    ++n;
                }
                break;
            }
            case 'q': {
                return null;
            }
            default: {
                atom = this.getN0();
                if (atom == null) {
                    return null;
                }
                if (this.isPurine) {
                    atom2 = this.getAtomFromOffsetIndex(5);
                    atom3 = this.getAtomFromOffsetIndex(9);
                    break;
                }
                atom2 = this.getAtomFromOffsetIndex(6);
                atom3 = this.getAtomFromOffsetIndex(1);
            }
        }
        if (atom2 == null || atom3 == null) {
            return null;
        }
        t32 = V3.newVsub(atom2, atom);
        t3 = V3.newVsub(atom3, atom);
        if (bl2) {
            t3.scale(-1.0f);
        }
        return Quat.getQuaternionFrameV((V3)t32, (V3)t3, null, bl);
    }

    @Override
    public boolean isCrossLinked(Group group) {
        if (!(group instanceof NucleicMonomer) || this.isPurine == group.isPurine()) {
            return false;
        }
        NucleicMonomer nucleicMonomer = this.isPurine ? (NucleicMonomer)group : this;
        NucleicMonomer nucleicMonomer2 = this.isPurine ? this : (NucleicMonomer)group;
        Atom atom = nucleicMonomer2.getN1();
        Atom atom2 = nucleicMonomer.getN3();
        return atom.isBonded(atom2);
    }

    @Override
    public boolean getCrossLinkVector(Lst<Integer> lst, boolean bl, boolean bl2) {
        if (!bl2) {
            return false;
        }
        Atom atom = this.isPurine ? this.getN1() : this.getN3();
        Bond[] bondArray = atom.bonds;
        if (bondArray == null) {
            return false;
        }
        int n = 0;
        while (n < bondArray.length) {
            if (bondArray[n].isHydrogen()) {
                Atom atom2 = bondArray[n].getOtherAtom(atom);
                Group group = atom2.group;
                if (group instanceof NucleicMonomer) {
                    NucleicMonomer nucleicMonomer = (NucleicMonomer)group;
                    if ((this.isPurine ? nucleicMonomer.getN3() : nucleicMonomer.getN1()) == atom2) {
                        if (lst == null) {
                            return true;
                        }
                        lst.addLast(atom.i);
                        lst.addLast(atom2.i);
                        lst.addLast(nucleicMonomer.leadAtomIndex);
                    }
                }
            }
            ++n;
        }
        return lst != null && lst.size() > 0;
    }

    public boolean getEdgePoints(P3[] p3Array) {
        p3Array[0] = this.getLeadAtom();
        p3Array[1] = this.getC4P();
        p3Array[2] = p3Array[5] = this.getC1P();
        switch (this.getGroup1()) {
            case 'C': {
                p3Array[3] = this.getO2();
                p3Array[4] = this.getN4();
                return true;
            }
            case 'A': {
                p3Array[3] = this.getC2();
                p3Array[4] = this.getN6();
                return true;
            }
            case 'G': 
            case 'I': {
                p3Array[3] = this.getC2();
                p3Array[4] = this.getO6();
                return true;
            }
            case 'T': 
            case 'U': {
                p3Array[3] = this.getO2();
                p3Array[4] = this.getO4();
                return true;
            }
        }
        return false;
    }

    public void addBasePair(BasePair basePair) {
        if (this.bps == null) {
            this.bps = new Lst();
        }
        this.bps.addLast(basePair);
    }

    public void setGroup1(char c) {
        if (this.group1 == '\u0000') {
            this.group1 = c;
        }
    }

    public Lst<BasePair> getBasePairs() {
        if (this.bioPolymer != null && !((NucleicPolymer)this.bioPolymer).isDssrSet) {
            this.bioPolymer.model.ms.vwr.getAnnotationParser(true).getBasePairs(this.bioPolymer.model.ms.vwr, this.bioPolymer.model.modelIndex);
        }
        return this.bps;
    }

    @Override
    protected char getGroup1b() {
        String string = Group.group3Names[this.groupID];
        String string2 = NucleicPolymer.htGroup1 == null ? null : NucleicPolymer.htGroup1.get(string);
        return string2 == null ? Character.toLowerCase(string.charAt(string.length() - 1)) : string2.charAt(0);
    }

    public P3[] getDSSRFrame(Viewer viewer) {
        if (this.dssrFrame != null) {
            return this.dssrFrame;
        }
        if (this.dssrNT != null) {
            this.dssrFrame = viewer.getAnnotationParser(true).getDSSRFrame(this.dssrNT);
            return this.dssrFrame;
        }
        this.dssrFrame = new P3[4];
        P3[] p3Array = this.dssrFrame;
        int n = 4;
        while (--n >= 0) {
            p3Array[n] = new P3();
        }
        if (this.isPurine()) {
            P3 p3 = P3.newP(this.getC5());
            p3.sub(this.getC8());
            p3.normalize();
            p3Array[2].setT(p3);
            p3Array[2].scale(-1.0f);
            p3Array[0].scaleAdd2(4.9f, p3, this.getC8());
            P3 p32 = P3.newP(this.getN0());
            p32.sub(this.getC8());
            p3Array[3].cross(p32, p3);
            p3Array[3].normalize();
        } else {
            P3 p3 = P3.newP(this.getN0());
            p3.sub(this.getC6());
            P3 p33 = P3.newP(this.getC5());
            p33.sub(this.getC6());
            p3Array[3].cross(p3, p33);
            p3Array[3].normalize();
            p3Array[2].setT(p3);
            p3Array[2].normalize();
            A4 a4 = A4.new4(p3Array[3].x, p3Array[3].y, p3Array[3].z, 1.1623893f);
            M3 m3 = new M3();
            m3.setAA(a4);
            m3.rotate(p3Array[2]);
            p3Array[0].scaleAdd2(5.1f, p3Array[2], this.getC6());
            p3Array[2].scale(-1.0f);
        }
        p3Array[1].cross(p3Array[2], p3Array[3]);
        return this.dssrFrame;
    }
}

