/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.Vibration;

public class ModulationSet
extends Vibration
implements JmolModulationSet {
    String id;
    private P3 r0;
    private SymmetryInterface symmetry;
    float[] axesLengths;
    private int nOps;
    private int iop;
    private String strop;
    private float spinOp;
    private Matrix rsvs;
    public Vibration vib;
    private Lst<Modulation> mods;
    private boolean isSubsystem;
    private boolean isCommensurate;
    private double fileOcc;
    private double[] occParams;
    private double occSiteMultiplicity;
    boolean occAbsolute;
    private ModulationSet modCalc;
    public V3 mxyz;
    public Map<String, Float> htUij;
    public float vOcc = Float.NaN;
    private float occValue = Float.NaN;
    private P3 qtOffset = new P3();
    private boolean isQ;
    private boolean enabled;
    private float scale = 1.0f;
    private M3 gammaE;
    private Matrix gammaIinv;
    private Matrix sigma;
    private Matrix tau;
    private Matrix rI;
    private Matrix tFactorInv;
    P3 ptTemp = new P3();
    private V3 v0;

    @Override
    public SymmetryInterface getSubSystemUnitCell() {
        return this.isSubsystem ? this.symmetry : null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    public ModulationSet setMod(String string, P3 p3, P3 p32, int n, Lst<Modulation> lst, M3 m3, Matrix[] matrixArray, SymmetryInterface symmetryInterface, int n2, int n3, Vibration vibration, boolean bl) {
        this.id = string;
        this.symmetry = symmetryInterface;
        this.strop = symmetryInterface.getSpaceGroupXyz(n3, false);
        this.iop = n3;
        this.nOps = n2;
        this.r0 = p32;
        this.modDim = n;
        this.rI = new Matrix(null, n, 1);
        this.mods = lst;
        this.gammaE = m3;
        this.sigma = matrixArray[0];
        if (matrixArray[1] != null) {
            this.isSubsystem = true;
            this.tFactorInv = matrixArray[1].inverse();
        }
        if (vibration != null) {
            this.vib = vibration;
            this.vib.modScale = 1.0f;
            this.mxyz = new V3();
            this.axesLengths = symmetryInterface.getUnitCellParams();
            if (this.axesLengths == null) {
                this.axesLengths = symmetryInterface.getUnitCellParams();
            }
        }
        Matrix matrix = Matrix.newT(p3, true);
        Matrix matrix2 = Matrix.newT(p32, true);
        this.rsvs = symmetryInterface.getOperationRsVs(n3);
        this.gammaIinv = this.rsvs.getSubmatrix(3, 3, n, n).inverse();
        Matrix matrix3 = this.rsvs.getSubmatrix(3, 0, n, 3);
        Matrix matrix4 = this.rsvs.getSubmatrix(3, 3 + n, n, 1);
        this.spinOp = symmetryInterface.getSpinOp(n3);
        this.tau = this.gammaIinv.mul(this.sigma.mul(matrix2).sub(matrix3.mul(matrix)).sub(matrix4));
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET create " + string + " r0=" + Escape.eP(p32) + " tau=" + this.tau);
        }
        return this;
    }

    public synchronized ModulationSet calculate(T3 t3, boolean bl) {
        double[][] dArray;
        Object object;
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.htUij = null;
        this.vOcc = Float.NaN;
        if (this.mxyz != null) {
            this.mxyz.set(0.0f, 0.0f, 0.0f);
        }
        if (bl && this.qtOffset != null) {
            object = new Matrix(null, 3, 1);
            dArray = ((Matrix)object).getArray();
            dArray[0][0] = this.qtOffset.x;
            dArray[1][0] = this.qtOffset.y;
            dArray[2][0] = this.qtOffset.z;
            this.rI = this.sigma.mul((Matrix)object);
            dArray = this.rI.getArray();
        } else {
            dArray = this.rI.getArray();
            int n = 0;
            while (n < this.modDim) {
                dArray[n][0] = 0.0;
                ++n;
            }
        }
        if (t3 != null) {
            switch (this.modDim) {
                default: {
                    double[] dArray2 = dArray[2];
                    dArray2[0] = dArray2[0] + (double)t3.z;
                }
                case 2: {
                    double[] dArray3 = dArray[1];
                    dArray3[0] = dArray3[0] + (double)t3.y;
                }
                case 1: 
            }
            double[] dArray4 = dArray[0];
            dArray4[0] = dArray4[0] + (double)t3.x;
        }
        if (this.isSubsystem) {
            this.rI = this.tFactorInv.mul(this.rI);
        }
        this.rI = this.tau.add(this.gammaIinv.mul(this.rI));
        object = this.rI.getArray();
        int n = this.mods.size();
        while (--n >= 0) {
            ((Modulation)this.mods.get(n)).apply(this, (double[][])object);
        }
        this.gammaE.rotate(this);
        if (this.mxyz != null) {
            this.gammaE.rotate(this.mxyz);
            if (this.spinOp < 0.0f) {
                this.mxyz.scale(this.spinOp);
            }
        }
        return this;
    }

    public void addUTens(String string, float f) {
        if (this.htUij == null) {
            this.htUij = new Hashtable<String, Float>();
        }
        Float f2 = this.htUij.get(string);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET " + this.id + " utens=" + string + " f=" + f2 + " v=" + f);
        }
        if (f2 != null) {
            f += f2.floatValue();
        }
        this.htUij.put(string, Float.valueOf(f));
    }

    @Override
    public synchronized void setModTQ(T3 t3, boolean bl, T3 t32, boolean bl2, float f) {
        if (this.enabled) {
            this.addTo(t3, Float.NaN);
        }
        this.enabled = false;
        this.scale = f;
        if (t32 != null) {
            this.qtOffset.setT(t32);
            this.isQ = bl2;
            if (bl2) {
                t32 = null;
            }
            this.calculate(t32, bl2);
            if (!Float.isNaN(this.vOcc)) {
                this.occValue = this.getOccupancy();
            }
        }
        if (bl) {
            this.addTo(t3, 1.0f);
            this.enabled = true;
        }
    }

    @Override
    public void addTo(T3 t3, float f) {
        boolean bl = Float.isNaN(f);
        if (bl) {
            f = -1.0f;
        }
        this.ptTemp.setT(this);
        this.ptTemp.scale(this.scale * f);
        if (t3 != null) {
            this.symmetry.toCartesian(this.ptTemp, true);
            t3.add(this.ptTemp);
        }
        if (this.mxyz != null) {
            this.setVib(bl, f);
        }
    }

    private void setVib(boolean bl, float f) {
        if (bl) {
            this.vib.setT(this.v0);
            return;
        }
        this.ptTemp.setT(this.mxyz);
        this.symmetry.toCartesian(this.ptTemp, true);
        PT.fixPtFloats(this.ptTemp, 10000.0f);
        this.ptTemp.add(this.v0);
        this.ptTemp.scale(this.vib.modScale * f * this.scale);
        this.vib.setT(this.ptTemp);
    }

    @Override
    public String getState() {
        String string = "";
        if (this.qtOffset != null && this.qtOffset.length() > 0.0f) {
            string = String.valueOf(string) + "; modulation " + Escape.eP(this.qtOffset) + " " + this.isQ + ";\n";
        }
        string = String.valueOf(string) + "modulation {selected} " + (this.enabled ? "ON" : "OFF");
        return string;
    }

    @Override
    public T3 getModPoint(boolean bl) {
        return bl ? this : this.r0;
    }

    @Override
    public Object getModulation(char c, T3 t3) {
        this.getModCalc();
        switch (c) {
            case 'D': {
                return P3.newP(t3 == null ? this.r0 : this.modCalc.calculate(t3, false));
            }
            case 'M': {
                return P3.newP(t3 == null ? this.v0 : this.modCalc.calculate((T3)t3, (boolean)false).mxyz);
            }
            case 'T': {
                this.modCalc.calculate(t3, false);
                double[][] dArray = this.modCalc.rI.getArray();
                return P3.new3((float)dArray[0][0], this.modDim > 1 ? (float)dArray[1][0] : 0.0f, this.modDim > 2 ? (float)dArray[2][0] : 0.0f);
            }
            case 'O': {
                return Float.valueOf(Math.abs(t3 == null ? this.getOccupancy100(false) : this.modCalc.calculate(t3, false).getOccupancy100(false)));
            }
        }
        return null;
    }

    @Override
    public T3 setCalcPoint(T3 t3, T3 t32, float f, float f2) {
        if (this.enabled) {
            this.addTo(t3, Float.NaN);
            this.getModCalc().calculate(t32, false).addTo(t3, f2);
        }
        return t3;
    }

    private ModulationSet getModCalc() {
        if (this.modCalc == null) {
            this.modCalc = new ModulationSet();
            this.modCalc.axesLengths = this.axesLengths;
            this.modCalc.enabled = true;
            this.modCalc.fileOcc = this.fileOcc;
            this.modCalc.gammaE = this.gammaE;
            this.modCalc.gammaIinv = this.gammaIinv;
            this.modCalc.id = this.id;
            this.modCalc.modDim = this.modDim;
            this.modCalc.mods = this.mods;
            this.modCalc.nOps = this.nOps;
            this.modCalc.occParams = this.occParams;
            this.modCalc.occSiteMultiplicity = this.occSiteMultiplicity;
            this.modCalc.r0 = this.r0;
            this.modCalc.rI = this.rI;
            this.modCalc.sigma = this.sigma;
            this.modCalc.spinOp = this.spinOp;
            this.modCalc.symmetry = this.symmetry;
            this.modCalc.tau = this.tau;
            this.modCalc.v0 = this.v0;
            this.modCalc.vib = this.vib;
            if (this.mxyz != null) {
                this.modCalc.mxyz = new V3();
            }
        }
        return this.modCalc;
    }

    @Override
    public void getInfo(Map<String, Object> map) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", this.id);
        hashtable.put("r0", this.r0);
        hashtable.put("tau", this.tau.getArray());
        hashtable.put("modDim", this.modDim);
        hashtable.put("rsvs", this.rsvs);
        hashtable.put("sigma", this.sigma.getArray());
        hashtable.put("symop", this.iop + 1);
        hashtable.put("strop", this.strop);
        hashtable.put("unitcell", this.symmetry.getUnitCellInfo());
        Lst<Hashtable<String, Object>> lst = new Lst<Hashtable<String, Object>>();
        int n = 0;
        while (n < this.mods.size()) {
            lst.addLast(((Modulation)this.mods.get(n)).getInfo());
            ++n;
        }
        hashtable.put("mods", lst);
        map.put("modulation", hashtable);
    }

    @Override
    public void setXYZ(T3 t3) {
        if (this.vib == null) {
            return;
        }
        if (this.vib.modDim == -2 && t3.x == Float.MIN_VALUE && t3.y == Float.MIN_VALUE) {
            this.vib.modScale = t3.z;
            return;
        }
        this.vib.setT(t3);
    }

    @Override
    public Vibration getVibration(boolean bl) {
        if (this.vib == null && bl) {
            this.vib = new Vibration();
        }
        return this.vib;
    }

    @Override
    public V3 getV3() {
        return this.mxyz == null ? this : this.mxyz;
    }

    @Override
    public void scaleVibration(float f) {
        if (this.vib == null) {
            return;
        }
        if (f == 0.0f) {
            f = 1.0f / this.vib.modScale;
        }
        this.vib.scale(f);
        this.vib.modScale *= f;
    }

    @Override
    public void setMoment() {
        if (this.mxyz == null) {
            return;
        }
        this.symmetry.toCartesian(this.vib, true);
        this.v0 = V3.newV(this.vib);
    }

    @Override
    public boolean isNonzero() {
        return this.x != 0.0f || this.y != 0.0f || this.z != 0.0f || this.mxyz != null && (this.mxyz.x != 0.0f || this.mxyz.y != 0.0f || this.mxyz.z != 0.0f);
    }

    public float setOccupancy(double[] dArray, double d, double d2) {
        this.occParams = dArray;
        this.fileOcc = d;
        this.occSiteMultiplicity = d2;
        return this.getOccupancy();
    }

    @Override
    public int getOccupancy100(boolean bl) {
        if (this.isCommensurate || Float.isNaN(this.vOcc)) {
            return Integer.MIN_VALUE;
        }
        if (!bl && !this.enabled) {
            return (int)(-this.fileOcc * 100.0);
        }
        if (bl && this.modCalc != null) {
            this.modCalc.getOccupancy();
            return this.modCalc.getOccupancy100(false);
        }
        return (int)(this.occValue * 100.0f);
    }

    private float getOccupancy() {
        double d;
        if (this.occAbsolute) {
            d = this.vOcc;
        } else if (this.occParams == null) {
            d = this.fileOcc + (double)this.vOcc;
        } else if (this.occSiteMultiplicity > 0.0) {
            double d2 = this.fileOcc * this.occSiteMultiplicity / (double)this.nOps / this.occParams[1];
            d = d2 * (this.occParams[1] + (double)this.vOcc);
        } else {
            d = this.occParams[0] * (this.occParams[1] + (double)this.vOcc);
        }
        d = d > 0.49 && d < 0.5 ? 0.489 : Math.min(1.0, Math.max(0.0, d));
        this.occValue = (float)d;
        return this.occValue;
    }
}

