/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.CaseFoldCodeItem;
import org.jcodings.Encoding;
import org.joni.MinMaxLen;
import org.joni.OptAnchorInfo;

final class OptMapInfo {
    final MinMaxLen mmd = new MinMaxLen();
    final OptAnchorInfo anchor = new OptAnchorInfo();
    int value;
    final byte[] map = new byte[256];
    private static final int z = 32768;
    static final short[] ByteValTable = new short[]{5, 1, 1, 1, 1, 1, 1, 1, 1, 10, 10, 1, 1, 10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 12, 4, 7, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 6, 5, 5, 5, 5, 6, 6, 6, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 1};

    OptMapInfo() {
    }

    void clear() {
        this.mmd.clear();
        this.anchor.clear();
        this.value = 0;
        for (int i2 = 0; i2 < this.map.length; ++i2) {
            this.map[i2] = 0;
        }
    }

    void copy(OptMapInfo other) {
        this.mmd.copy(other.mmd);
        this.anchor.copy(other.anchor);
        this.value = other.value;
        System.arraycopy(other.map, 0, this.map, 0, other.map.length);
    }

    void addChar(byte c, Encoding enc) {
        int c_ = c & 0xFF;
        if (this.map[c_] == 0) {
            this.map[c_] = 1;
            this.value += OptMapInfo.positionValue(enc, c_);
        }
    }

    void addCharAmb(byte[] bytes2, int p2, int end2, Encoding enc, int caseFoldFlag) {
        this.addChar(bytes2[p2], enc);
        CaseFoldCodeItem[] items = enc.caseFoldCodesByString(caseFoldFlag &= 0xBFFFFFFF, bytes2, p2, end2);
        byte[] buf = new byte[7];
        for (int i2 = 0; i2 < items.length; ++i2) {
            enc.codeToMbc(items[i2].code[0], buf, 0);
            this.addChar(buf[0], enc);
        }
    }

    void select(OptMapInfo alt) {
        if (alt.value == 0) {
            return;
        }
        if (this.value == 0) {
            this.copy(alt);
            return;
        }
        int v1 = 32768 / this.value;
        int v2 = 32768 / alt.value;
        if (this.mmd.compareDistanceValue(alt.mmd, v1, v2) > 0) {
            this.copy(alt);
        }
    }

    void altMerge(OptMapInfo other, Encoding enc) {
        if (this.value == 0) {
            return;
        }
        if (other.value == 0 || this.mmd.max < other.mmd.max) {
            this.clear();
            return;
        }
        this.mmd.altMerge(other.mmd);
        int val = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (other.map[i2] != 0) {
                this.map[i2] = 1;
            }
            if (this.map[i2] == 0) continue;
            val += OptMapInfo.positionValue(enc, i2);
        }
        this.value = val;
        this.anchor.altMerge(other.anchor);
    }

    static int positionValue(Encoding enc, int i2) {
        if (i2 < ByteValTable.length) {
            if (i2 == 0 && enc.minLength() > 1) {
                return 20;
            }
            return ByteValTable[i2];
        }
        return 4;
    }
}

