/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen.tokenAttributes;

import net.java.sen.dictionary.Morpheme;
import org.apache.lucene.analysis.gosen.ToStringUtil;
import org.apache.lucene.analysis.gosen.tokenAttributes.ConjugationAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class ConjugationAttributeImpl
extends AttributeImpl
implements ConjugationAttribute,
Cloneable {
    private static final long serialVersionUID = 1L;
    private transient Morpheme morpheme;

    @Override
    public String getConjugationalForm() {
        return this.morpheme == null ? null : this.morpheme.getConjugationalForm();
    }

    @Override
    public String getConjugationalType() {
        return this.morpheme == null ? null : this.morpheme.getConjugationalType();
    }

    @Override
    public void setMorpheme(Morpheme morpheme) {
        this.morpheme = morpheme;
    }

    public void clear() {
        this.morpheme = null;
    }

    public void copyTo(AttributeImpl target) {
        ConjugationAttribute t = (ConjugationAttribute)target;
        t.setMorpheme(this.morpheme);
    }

    public void reflectWith(AttributeReflector reflector) {
        String conjugationalForm = this.getConjugationalForm();
        String conjugationalType = this.getConjugationalType();
        String enForm = conjugationalForm == null ? null : ToStringUtil.getConjFormTranslation(conjugationalForm);
        String enType = conjugationalType == null ? null : ToStringUtil.getConjTypeTranslation(conjugationalType);
        reflector.reflect(ConjugationAttribute.class, "conjugationalForm", (Object)conjugationalForm);
        reflector.reflect(ConjugationAttribute.class, "conjugationalForm (en)", (Object)enForm);
        reflector.reflect(ConjugationAttribute.class, "conjugationalType", (Object)conjugationalType);
        reflector.reflect(ConjugationAttribute.class, "conjugationalType (en)", (Object)enType);
    }
}

