/****************************************************************************
**
*W  vec8bit.h                    GAP source                     Steve Linton
**
**
*Y  Copyright (C)  1997,  St Andrews
*/

#ifndef libGAP_GAP_VEC8BIT_H
#define libGAP_GAP_VEC8BIT_H


/****************************************************************************
**
*F  RewriteGF2Vec( <vec>, <q> ) . . .
**                convert a GF(2) vector into a GF(2^k) vector in place
**
*/

extern void libGAP_RewriteGF2Vec( libGAP_Obj vec, libGAP_UInt q);


/****************************************************************************
**
*F  IS_VEC8BIT_REP( <obj> )  . . . . . . check that <obj> is in 8bit GFQ vector rep
*/
extern libGAP_Obj libGAP_IsVec8bitRep;

#define libGAP_IS_VEC8BIT_REP(obj) \
  (libGAP_TNUM_OBJ(obj)==libGAP_T_DATOBJ && libGAP_True == libGAP_DoFilter(libGAP_IsVec8bitRep,obj))



/****************************************************************************
**
*F  PlainVec8Bit( <list> ) . . . convert an 8bit vector into an ordinary list
**
**  'PlainVec8Bit' converts the  vector <list> to a plain list.
*/
extern void libGAP_PlainVec8Bit ( libGAP_Obj                 list );

/****************************************************************************
**
*F  FuncASS_VEC8BIT( <self>, <list>, <pos>, <elm> ) set an elm of a GF2 vector
**
*/
extern libGAP_Obj libGAP_FuncASS_VEC8BIT (
    libGAP_Obj                 self,
    libGAP_Obj                 list,
    libGAP_Obj                 pos,
    libGAP_Obj                 elm );

/****************************************************************************
**
*F * * * * * * * * * * * * * initialize package * * * * * * * * * * * * * * *
*/


/****************************************************************************
**

*F  InitInfoVec8bit()  . . . . . . . . . . . . . . . . table of init functions
*/
extern libGAP_StructInitInfo * libGAP_InitInfoVec8bit ( void );


#endif // GAP_VEC8BIT_H

/****************************************************************************
**

*E  vecgf2.h  . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
