/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import java.util.Collections;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.ParseFilter;

public class DefaultParseFilter
extends ParseFilter {
    @Deprecated
    public static final int MAX_RESPONSE_BODY_SIZE = 512000;
    private static final Pattern SVN_SQLITE_FILENAME_PATTERN = Pattern.compile(".*/\\.svn/wc.db$");
    private static final Pattern SVN_XML_FILENAME_PATTERN = Pattern.compile(".*/\\.svn/entries$");
    private static final Pattern GIT_FILENAME_PATTERN = Pattern.compile(".*/\\.git/index$");
    private final SpiderParam params;
    private final ParseFilter.FilterResult filterResultEmpty;
    private final ParseFilter.FilterResult filterResultMaxSize;
    private final ParseFilter.FilterResult filterResultNotText;

    @Deprecated
    public DefaultParseFilter() {
        this(new SpiderParam(), new ResourceBundle(){

            @Override
            public Enumeration<String> getKeys() {
                return Collections.emptyEnumeration();
            }

            @Override
            protected Object handleGetObject(String key) {
                return "";
            }
        });
    }

    public DefaultParseFilter(SpiderParam params, ResourceBundle resourceBundle) {
        if (params == null) {
            throw new IllegalArgumentException("Parameter params must not be null.");
        }
        if (resourceBundle == null) {
            throw new IllegalArgumentException("Parameter resourceBundle must not be null.");
        }
        this.params = params;
        this.filterResultEmpty = new ParseFilter.FilterResult(resourceBundle.getString("spider.parsefilter.reason.empty"));
        this.filterResultMaxSize = new ParseFilter.FilterResult(resourceBundle.getString("spider.parsefilter.reason.maxsize"));
        this.filterResultNotText = new ParseFilter.FilterResult(resourceBundle.getString("spider.parsefilter.reason.nottext"));
    }

    @Override
    public ParseFilter.FilterResult filtered(HttpMessage responseMessage) {
        if (responseMessage == null || responseMessage.getRequestHeader().isEmpty() || responseMessage.getResponseHeader().isEmpty()) {
            return this.filterResultEmpty;
        }
        String fullfilename = responseMessage.getRequestHeader().getURI().getEscapedPath();
        if (fullfilename != null && (SVN_SQLITE_FILENAME_PATTERN.matcher(fullfilename).find() || SVN_XML_FILENAME_PATTERN.matcher(fullfilename).find() || GIT_FILENAME_PATTERN.matcher(fullfilename).find())) {
            return ParseFilter.FilterResult.NOT_FILTERED;
        }
        if (responseMessage.getResponseBody().length() > this.params.getMaxParseSizeBytes()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource too large: " + responseMessage.getRequestHeader().getURI()));
            }
            return this.filterResultMaxSize;
        }
        if (HttpStatusCode.isRedirection(responseMessage.getResponseHeader().getStatusCode())) {
            return ParseFilter.FilterResult.NOT_FILTERED;
        }
        if (!responseMessage.getResponseHeader().isText()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource is not text: " + responseMessage.getRequestHeader().getURI()));
            }
            return this.filterResultNotText;
        }
        return ParseFilter.FilterResult.NOT_FILTERED;
    }
}

