/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.EntrySupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Utilities;

class EntrySupportDefault
extends EntrySupport {
    private List<Children.Entry> entries = Collections.emptyList();
    private static final Reference<ChildrenArray> EMPTY = new WeakReference<Object>(null);
    private Reference<ChildrenArray> array = EMPTY;
    private Map<Children.Entry, Info> map;
    private static final Object LOCK = new Object();
    private static final Logger LOGGER = Logger.getLogger(EntrySupportDefault.class.getName());
    private Thread initThread;
    private boolean inited = false;
    private boolean mustNotifySetEnties = false;

    public EntrySupportDefault(Children children) {
        super(children);
    }

    public String toString() {
        return super.toString() + " array: " + this.array.get();
    }

    @Override
    public boolean isInitialized() {
        ChildrenArray childrenArray = this.array.get();
        return this.inited && childrenArray != null && childrenArray.isInitialized();
    }

    @Override
    List<Node> snapshot() {
        Node[] nodeArray = this.getNodes();
        try {
            Children.PR.enterReadAccess();
            DefaultSnapshot defaultSnapshot = this.createSnapshot();
            return defaultSnapshot;
        }
        finally {
            Children.PR.exitReadAccess();
        }
    }

    DefaultSnapshot createSnapshot() {
        return new DefaultSnapshot(this.getNodes(), this.array.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node[] getNodes() {
        Node[] nodeArray;
        boolean bl = LOGGER.isLoggable(Level.FINER);
        if (bl) {
            LOGGER.finer("getNodes() " + this);
        }
        boolean[] blArray = new boolean[2];
        do {
            ChildrenArray childrenArray = this.getArray(blArray);
            try {
                Children.PR.enterReadAccess();
                if (this != this.children.getEntrySupport()) {
                    Node[] nodeArray2 = new Node[]{};
                    return nodeArray2;
                }
                blArray[1] = this.isInitialized();
                nodeArray = childrenArray.nodes();
            }
            finally {
                Children.PR.exitReadAccess();
            }
            if (bl) {
                LOGGER.finer("  length     : " + (nodeArray == null ? "nodes is null" : Integer.valueOf(nodeArray.length)));
                LOGGER.finer("  init now   : " + this.isInitialized());
            }
            if (!blArray[1]) continue;
            return nodeArray;
        } while (!blArray[0]);
        this.notifySetEntries();
        return nodeArray == null ? new Node[]{} : nodeArray;
    }

    @Override
    public Node[] getNodes(boolean bl) {
        boolean bl2 = LOGGER.isLoggable(Level.FINER);
        ChildrenArray childrenArray = null;
        Node node = null;
        if (bl) {
            if (bl2) {
                LOGGER.finer("computing optimal result");
            }
            childrenArray = this.getArray(null);
            if (bl2) {
                LOGGER.finer("optimal result is here: " + childrenArray);
            }
            node = this.children.findChild(null);
            if (bl2) {
                LOGGER.finer("Find child got: " + node);
            }
            Children.LOG.log(Level.FINEST, "after findChild: {0}", bl);
        }
        return this.getNodes();
    }

    @Override
    public final int getNodesCount(boolean bl) {
        return this.getNodes(bl).length;
    }

    @Override
    public Node getNodeAt(int n) {
        Node[] nodeArray = this.getNodes();
        return n < nodeArray.length ? nodeArray[n] : null;
    }

    final Node[] justComputeNodes() {
        Object object;
        if (this.map == null) {
            this.map = Collections.synchronizedMap(new HashMap(17));
            LOGGER.finer("Map initialized");
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Children.Entry entry : this.entries) {
            object = this.findInfo(entry);
            linkedList.addAll(((Info)object).nodes(false));
        }
        Node[] nodeArray = linkedList.toArray(new Node[linkedList.size()]);
        for (int i = 0; i < nodeArray.length; ++i) {
            object = nodeArray[i];
            if (object == null) {
                LOGGER.warning("null node among children!");
                for (int j = 0; j < nodeArray.length; ++j) {
                    LOGGER.log(Level.WARNING, "  {0} = {1}", new Object[]{j, nodeArray[j]});
                }
                for (Children.Entry entry : this.entries) {
                    Info info = this.findInfo(entry);
                    LOGGER.log(Level.WARNING, "  entry: {0} info {1} nodes: {2}", new Object[]{entry, info, info.nodes(false)});
                }
                throw new NullPointerException("arr[" + i + "] is null");
            }
            ((Node)object).assignTo(this.children, i);
            ((Node)object).fireParentNodeChange(null, this.children.parent);
        }
        return nodeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info findInfo(Children.Entry entry) {
        Map<Children.Entry, Info> map = this.map;
        synchronized (map) {
            Info info = this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                this.map.put(entry, info);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Put: " + entry + " info: " + info);
                }
            }
            return info;
        }
    }

    @Override
    void notifySetEntries() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(this + " mustNotifySetEntries()");
        }
        this.mustNotifySetEnties = true;
    }

    private void checkConsistency() {
        assert (this.map.size() == this.entries.size()) : "map.size()=" + this.map.size() + " entries.size()=" + this.entries.size();
    }

    @Override
    protected void setEntries(Collection<? extends Children.Entry> collection, boolean bl) {
        List<Info> list;
        Node[] nodeArray;
        assert (bl || Children.MUTEX.isWriteAccess());
        boolean bl2 = LOGGER.isLoggable(Level.FINER);
        ChildrenArray childrenArray = this.array.get();
        if (bl2) {
            LOGGER.finer("setEntries for " + this + " on " + Thread.currentThread());
            LOGGER.finer("       values: " + collection);
            LOGGER.finer("       holder: " + childrenArray);
            LOGGER.finer("       mustNotifySetEntries: " + this.mustNotifySetEnties);
        }
        Node[] nodeArray2 = nodeArray = childrenArray == null ? null : childrenArray.nodes();
        if (this.mustNotifySetEnties) {
            if (childrenArray == null) {
                childrenArray = this.getArray(null);
            }
            if (nodeArray == null) {
                childrenArray.entrySupport = this;
                nodeArray = childrenArray.nodes();
            }
            this.mustNotifySetEnties = false;
        } else if (childrenArray == null || nodeArray == null) {
            this.entries = new ArrayList<Children.Entry>(collection);
            if (this.map != null) {
                this.map.keySet().retainAll(new HashSet<Children.Entry>(this.entries));
            }
            return;
        }
        this.checkConsistency();
        LinkedHashSet<Children.Entry> linkedHashSet = new LinkedHashSet<Children.Entry>(this.entries);
        HashSet<? extends Children.Entry> hashSet = new HashSet<Children.Entry>(collection);
        linkedHashSet.removeAll(hashSet);
        if (!linkedHashSet.isEmpty()) {
            this.updateRemove(nodeArray, linkedHashSet);
            nodeArray = childrenArray.nodes();
        }
        if (!(list = this.updateOrder(nodeArray, collection)).isEmpty()) {
            this.updateAdd(list, new ArrayList<Children.Entry>(collection));
        }
    }

    private void checkInfo(Info info, Children.Entry entry, Collection<? extends Children.Entry> collection, Map<Children.Entry, Info> map) {
        if (info == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error in ").append(this.getClass().getName()).append(" with entry ").append(entry).append(" from among entries:");
            for (Children.Entry object : collection) {
                stringBuilder.append("\n  ").append(object).append(" contained: ").append(map.containsKey(object));
            }
            stringBuilder.append("\nprobably caused by faulty key implementation. The key hashCode() and equals() methods must behave as for an IMMUTABLE object and the hashCode() must return the same value for equals() keys.");
            stringBuilder.append("\nmapping:");
            for (Map.Entry entry2 : map.entrySet()) {
                stringBuilder.append("\n  ").append(entry2.getKey()).append(" => ").append(entry2.getValue());
            }
            throw new IllegalStateException(stringBuilder.toString());
        }
    }

    private void updateRemove(Node[] nodeArray, Set<Children.Entry> set) {
        assert (Children.MUTEX.isWriteAccess());
        LinkedList<Node> linkedList = new LinkedList<Node>();
        ChildrenArray childrenArray = this.array.get();
        for (Children.Entry entry : set) {
            Info info = this.map.remove(entry);
            this.checkInfo(info, entry, new ArrayList(), this.map);
            linkedList.addAll(info.nodes(true));
            childrenArray.remove(info);
        }
        this.entries.removeAll(set);
        this.checkConsistency();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Current : " + this.entries);
            LOGGER.finer("Removing: " + set);
        }
        if (!linkedList.isEmpty()) {
            this.clearNodes();
            this.notifyRemove(linkedList, nodeArray);
        }
    }

    private List<Info> updateOrder(Node[] nodeArray, Collection<? extends Children.Entry> collection) {
        Object object;
        assert (Children.MUTEX.isWriteAccess());
        LinkedList<Info> linkedList = new LinkedList<Info>();
        HashMap<Info, Integer> hashMap = new HashMap<Info, Integer>();
        int n = 0;
        for (Children.Entry entry : this.entries) {
            object = this.map.get(entry);
            this.checkInfo((Info)object, entry, this.entries, this.map);
            hashMap.put((Info)object, n);
            n += ((Info)object).length();
        }
        int[] nArray = new int[nodeArray.length];
        int n2 = 0;
        int n3 = 0;
        object = null;
        for (Children.Entry entry : collection) {
            Info info = this.map.get(entry);
            if (info == null) {
                info = new Info(entry);
                linkedList.add(info);
            } else {
                int n4 = info.length();
                if (object == null) {
                    object = new LinkedList();
                }
                object.add(entry);
                Integer n5 = (Integer)hashMap.get(info);
                int n6 = n5;
                if (n2 != n6) {
                    for (int i = 0; i < n4; ++i) {
                        nArray[n6 + i] = 1 + n2 + i;
                    }
                    n3 += n4;
                }
            }
            n2 += info.length();
        }
        if (n3 > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    nArray[i] = i;
                    continue;
                }
                int n4 = i;
                nArray[n4] = nArray[n4] - 1;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Entries before reordering: " + this.entries);
                LOGGER.finer("Entries after reordering: " + object);
            }
            this.entries = object;
            this.checkConsistency();
            this.clearNodes();
            Node node = this.children.parent;
            if (node != null) {
                node.fireReorderChange(nArray);
            }
        }
        return linkedList;
    }

    private void updateAdd(Collection<Info> collection, List<Children.Entry> list) {
        assert (Children.MUTEX.isWriteAccess());
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Info info : collection) {
            linkedList.addAll(info.nodes(false));
            this.map.put(info.entry, info);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Entries before updateAdd(): " + this.entries);
            LOGGER.finer("Entries after updateAdd(): " + list);
        }
        this.entries = list;
        this.checkConsistency();
        if (!linkedList.isEmpty()) {
            this.clearNodes();
            this.notifyAdd(linkedList);
        }
    }

    @Override
    final void refreshEntry(Children.Entry entry) {
        Collection<Node> collection;
        ChildrenArray childrenArray = this.array.get();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("refreshEntry: " + entry + " holder=" + childrenArray);
        }
        if (childrenArray == null) {
            return;
        }
        Node[] nodeArray = childrenArray.nodes();
        if (nodeArray == null) {
            return;
        }
        this.checkConsistency();
        Info info = this.map.get(entry);
        if (info == null) {
            return;
        }
        Collection<Node> collection2 = info.nodes(false);
        if (collection2.equals(collection = info.entry.nodes(null))) {
            return;
        }
        HashSet<Node> hashSet = new HashSet<Node>(collection2);
        hashSet.removeAll(new HashSet<Node>(collection));
        if (!hashSet.isEmpty()) {
            collection2.removeAll(hashSet);
            this.clearNodes();
            this.notifyRemove(hashSet, nodeArray);
            nodeArray = childrenArray.nodes();
        }
        List<Node> list = this.refreshOrder(entry, collection2, collection);
        info.useNodes(collection);
        if (!list.isEmpty()) {
            this.clearNodes();
            this.notifyAdd(list);
        }
    }

    private List<Node> refreshOrder(Children.Entry entry, Collection<Node> collection, Collection<Node> collection2) {
        Object object;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        HashSet<Node> hashSet = new HashSet<Node>(collection);
        HashSet<Node> hashSet2 = new HashSet<Node>(hashSet);
        Node[] nodeArray = new Node[collection.size()];
        Iterator<Node> iterator = collection2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (hashSet.remove(object)) {
                nodeArray[n++] = object;
                continue;
            }
            if (!hashSet2.contains(object)) {
                linkedList.add((Node)object);
                continue;
            }
            iterator.remove();
        }
        object = NodeOp.computePermutation(collection.toArray(new Node[collection.size()]), nodeArray);
        if (object != null) {
            this.clearNodes();
            this.findInfo(entry).useNodes(Arrays.asList(nodeArray));
            Node node = this.children.parent;
            if (node != null) {
                node.fireReorderChange((int[])object);
            }
        }
        return linkedList;
    }

    Node[] notifyRemove(Collection<Node> collection, Node[] nodeArray) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("notifyRemove: " + collection);
            LOGGER.finer("Current     : " + Arrays.asList(nodeArray));
        }
        Node[] nodeArray2 = collection.toArray(new Node[collection.size()]);
        if (this.children.parent != null) {
            if (this.children.getEntrySupport() == this) {
                this.children.parent.fireSubNodesChange(false, nodeArray2, nodeArray);
            }
            for (Node node : collection) {
                node.deassignFrom(this.children);
                node.fireParentNodeChange(this.children.parent, null);
            }
        }
        this.children.destroyNodes(nodeArray2);
        return nodeArray2;
    }

    void notifyAdd(Collection<Node> collection) {
        Node node2;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("notifyAdd: " + collection);
        }
        for (Node node2 : collection) {
            node2.assignTo(this.children, -1);
            node2.fireParentNodeChange(null, this.children.parent);
        }
        Node[] nodeArray = collection.toArray(new Node[collection.size()]);
        node2 = this.children.parent;
        if (node2 != null && this.children.getEntrySupport() == this) {
            node2.fireSubNodesChange(true, nodeArray, null);
        }
    }

    @Override
    public Node[] testNodes() {
        ChildrenArray childrenArray = this.array.get();
        if (childrenArray == null) {
            return null;
        }
        try {
            Children.PR.enterReadAccess();
            Node[] nodeArray = childrenArray.nodes();
            return nodeArray;
        }
        finally {
            Children.PR.exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChildrenArray getArray(boolean[] blArray) {
        ChildrenArray childrenArray;
        block27: {
            Object object;
            boolean bl;
            block26: {
                class SetAndNotify
                implements Runnable {
                    public ChildrenArray toSet;
                    public Children whatSet;

                    SetAndNotify() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = LOCK;
                        synchronized (object) {
                            EntrySupportDefault.this.initThread = null;
                            LOCK.notifyAll();
                        }
                        if (bl) {
                            LOGGER.finer("notifyAll done");
                        }
                    }
                }
                block25: {
                    bl = LOGGER.isLoggable(Level.FINER);
                    boolean bl2 = false;
                    object = LOCK;
                    synchronized (object) {
                        childrenArray = this.array.get();
                        if (childrenArray == null) {
                            childrenArray = new ChildrenArray();
                            this.registerChildrenArray(childrenArray, true);
                            bl2 = true;
                            this.initThread = Thread.currentThread();
                        }
                    }
                    if (!bl2) break block26;
                    if (bl) {
                        LOGGER.finer("Initialize " + this + " on " + Thread.currentThread());
                    }
                    try {
                        this.children.callAddNotify();
                        if (!bl) break block25;
                        LOGGER.finer("addNotify successfully called for " + this + " on " + Thread.currentThread());
                    }
                    catch (Throwable throwable) {
                        boolean bl3 = Children.MUTEX.isReadAccess();
                        if (bl) {
                            LOGGER.finer("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl3);
                        }
                        childrenArray.entrySupport = this;
                        this.inited = true;
                        SetAndNotify setAndNotify = new SetAndNotify();
                        setAndNotify.toSet = childrenArray;
                        setAndNotify.whatSet = this.children;
                        if (bl3) {
                            Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                        } else {
                            setAndNotify.run();
                        }
                        throw throwable;
                    }
                }
                boolean bl4 = Children.MUTEX.isReadAccess();
                if (bl) {
                    LOGGER.finer("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + bl4);
                }
                childrenArray.entrySupport = this;
                this.inited = true;
                SetAndNotify setAndNotify = new SetAndNotify();
                setAndNotify.toSet = childrenArray;
                setAndNotify.whatSet = this.children;
                if (bl4) {
                    Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                } else {
                    setAndNotify.run();
                }
                break block27;
            }
            if (this.initThread != null) {
                if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
                    if (bl) {
                        LOGGER.log(Level.FINER, "cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + Children.MUTEX.isReadAccess() + " write access: " + Children.MUTEX.isWriteAccess() + " initThread: " + this.initThread);
                    }
                    if (blArray != null) {
                        blArray[0] = true;
                    }
                    childrenArray.entrySupport = this;
                    return childrenArray;
                }
                object = LOCK;
                synchronized (object) {
                    while (this.initThread != null) {
                        if (bl) {
                            LOGGER.finer("waiting for children for " + this + " on " + Thread.currentThread());
                        }
                        try {
                            LOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (bl) {
                    LOGGER.finer(" children are here for " + this + " on " + Thread.currentThread() + " children " + this.children);
                }
            }
        }
        return childrenArray;
    }

    private void clearNodes() {
        ChildrenArray childrenArray;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("  clearNodes()");
        }
        if ((childrenArray = this.array.get()) != null) {
            childrenArray.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerChildrenArray(ChildrenArray childrenArray, boolean bl) {
        boolean bl2 = LOGGER.isLoggable(Level.FINER);
        if (bl2) {
            LOGGER.finer("registerChildrenArray: " + childrenArray + " weak: " + bl);
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.array != null && this.array.get() == childrenArray && ((ChArrRef)this.array).isWeak() == bl) {
                return;
            }
            this.array = new ChArrRef(childrenArray, bl);
        }
        if (bl2) {
            LOGGER.finer("pointed by: " + childrenArray + " to: " + this.array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finalizedChildrenArray(Reference reference) {
        assert (reference.get() == null) : "Should be null";
        try {
            Children.PR.enterWriteAccess();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("previous array: " + this.array + " caller: " + reference);
            }
            Object object = LOCK;
            synchronized (object) {
                if (this.array == reference && this.children.getEntrySupport() == this) {
                    this.mustNotifySetEnties = false;
                    this.array = EMPTY;
                    this.inited = false;
                    this.children.callRemoveNotify();
                    assert (this.array == EMPTY);
                }
            }
        }
        finally {
            Children.PR.exitWriteAccess();
        }
    }

    @Override
    protected List<Children.Entry> getEntries() {
        return new ArrayList<Children.Entry>(this.entries);
    }

    private class ChArrRef
    extends WeakReference<ChildrenArray>
    implements Runnable {
        private final ChildrenArray chArr;

        public ChArrRef(ChildrenArray childrenArray, boolean bl) {
            super(childrenArray, Utilities.activeReferenceQueue());
            this.chArr = bl ? null : childrenArray;
        }

        @Override
        public ChildrenArray get() {
            return this.chArr != null ? this.chArr : (ChildrenArray)super.get();
        }

        boolean isWeak() {
            return this.chArr == null;
        }

        @Override
        public void run() {
            EntrySupportDefault.this.finalizedChildrenArray(this);
        }
    }

    static class DefaultSnapshot
    extends AbstractList<Node> {
        private Node[] nodes;
        Object holder;

        public DefaultSnapshot(Node[] nodeArray, ChildrenArray childrenArray) {
            this.nodes = nodeArray;
            this.holder = childrenArray;
        }

        @Override
        public Node get(int n) {
            return this.nodes != null && n < this.nodes.length ? this.nodes[n] : null;
        }

        @Override
        public int size() {
            return this.nodes != null ? this.nodes.length : 0;
        }
    }

    final class Info {
        int length;
        final Children.Entry entry;

        public Info(Children.Entry entry) {
            this.entry = entry;
        }

        public Collection<Node> nodes(boolean bl) {
            assert (!bl || EntrySupportDefault.this.array.get() != null) : "ChildrenArray is not initialized";
            ChildrenArray childrenArray = EntrySupportDefault.this.getArray(null);
            return childrenArray.nodesFor(this, bl);
        }

        public void useNodes(Collection<Node> collection) {
            ChildrenArray childrenArray = EntrySupportDefault.this.getArray(null);
            childrenArray.useNodes(this, collection);
            for (Node node : collection) {
                node.assignTo(EntrySupportDefault.this.children, -1);
                node.fireParentNodeChange(null, EntrySupportDefault.this.children.parent);
            }
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return "Children.Info[" + this.entry + ",length=" + this.length + "]";
        }
    }
}

