/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class Macros {
    private static String systemMacroPath;
    private static String userMacroPath;
    private static List<Handler> macroHandlers;
    private static ActionSet macroActionSet;
    private static Vector macroHierarchy;
    private static Map<String, Macro> macroHash;
    private static Macro lastMacro;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showRunScriptDialog(View view) {
        String[] stringArray = GUIUtilities.showVFSFileDialog(view, null, 0, true);
        if (stringArray != null) {
            Buffer buffer = view.getBuffer();
            try {
                buffer.beginCompoundEdit();
                for (String string : stringArray) {
                    Macros.runScript(view, string, false);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }

    public static void runScript(View view, String string, boolean bl) {
        Handler handler = Macros.getHandlerForPathName(string);
        if (handler != null) {
            try {
                Macro macro = handler.createMacro(MiscUtilities.getFileName(string), string);
                macro.invoke(view);
            }
            catch (Exception exception) {
                Log.log(9, Macros.class, exception);
                return;
            }
            return;
        }
        if (bl) {
            Log.log(5, Macros.class, string + ": Cannot find a suitable macro handler");
        } else {
            Log.log(9, Macros.class, string + ": Cannot find a suitable macro handler, " + "assuming BeanShell");
            Macros.getHandler("beanshell").createMacro(string, string).invoke(view);
        }
    }

    public static void message(final Component component, final String string) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            JOptionPane.showMessageDialog(component, string, jEdit.getProperty("macro-message.title"), 1);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Macros.message(component, string);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void error(final Component component, final String string) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            JOptionPane.showMessageDialog(component, string, jEdit.getProperty("macro-message.title"), 0);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Macros.message(component, string);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String input(Component component, String string) {
        GUIUtilities.hideSplashScreen();
        return Macros.input(component, string, null);
    }

    public static String input(final Component component, final String string, final String string2) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return (String)JOptionPane.showInputDialog(component, string, jEdit.getProperty("macro-input.title"), 3, null, null, string2);
        }
        final String[] stringArray = new String[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    stringArray[0] = Macros.input(component, string, string2);
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
        return stringArray[0];
    }

    public static int confirm(final Component component, final String string, final int n) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return JOptionPane.showConfirmDialog(component, string, jEdit.getProperty("macro-confirm.title"), n, 3);
        }
        final int[] nArray = new int[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = Macros.confirm(component, string, n);
                }
            });
        }
        catch (Exception exception) {
            return 2;
        }
        return nArray[0];
    }

    public static int confirm(final Component component, final String string, final int n, final int n2) {
        if (EventQueue.isDispatchThread()) {
            GUIUtilities.hideSplashScreen();
            return JOptionPane.showConfirmDialog(component, string, jEdit.getProperty("macro-confirm.title"), n, n2);
        }
        final int[] nArray = new int[1];
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nArray[0] = Macros.confirm(component, string, n, n2);
                }
            });
        }
        catch (Exception exception) {
            return 2;
        }
        return nArray[0];
    }

    public static void loadMacros() {
        jEdit.removeActionSet(macroActionSet);
        macroActionSet.removeAllActions();
        macroHierarchy.removeAllElements();
        macroHash.clear();
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            userMacroPath = MiscUtilities.constructPath(string, "macros");
            Macros.loadMacros(macroHierarchy, "", new File(userMacroPath));
        }
        if (jEdit.getJEditHome() != null) {
            systemMacroPath = MiscUtilities.constructPath(jEdit.getJEditHome(), "macros");
            Macros.loadMacros(macroHierarchy, "", new File(systemMacroPath));
        }
        jEdit.addActionSet(macroActionSet);
        EditBus.send(new DynamicMenuChanged("macros"));
    }

    public static void registerHandler(Handler handler) {
        if (Macros.getHandler(handler.getName()) != null) {
            Log.log(9, Macros.class, "Cannot register more than one macro handler with the same name");
            return;
        }
        Log.log(1, Macros.class, "Registered " + handler.getName() + " macro handler");
        macroHandlers.add(handler);
    }

    public static void unregisterHandler(Handler handler) {
        if (macroHandlers.remove(handler)) {
            Log.log(1, Macros.class, "Unregistered " + handler.getName() + " macro handler");
        } else {
            Log.log(9, Macros.class, "Cannot unregister " + handler.getName() + " macro handler - it is not registered.");
        }
    }

    public static Handler[] getHandlers() {
        Handler[] handlerArray = new Handler[macroHandlers.size()];
        return macroHandlers.toArray(handlerArray);
    }

    public static Handler getHandlerForPathName(String string) {
        for (Handler handler : macroHandlers) {
            if (!handler.accept(string)) continue;
            return handler;
        }
        return null;
    }

    public static Handler getHandler(String string) {
        for (Handler handler : macroHandlers) {
            if (!handler.getName().equals(string)) continue;
            return handler;
        }
        return null;
    }

    public static Vector getMacroHierarchy() {
        return macroHierarchy;
    }

    public static ActionSet getMacroActionSet() {
        return macroActionSet;
    }

    public static Macro getMacro(String string) {
        return macroHash.get(string);
    }

    public static Macro getLastMacro() {
        return lastMacro;
    }

    public static void setLastMacro(Macro macro) {
        lastMacro = macro;
    }

    public static void recordTemporaryMacro(View view) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            GUIUtilities.error(view, "no-settings", new String[0]);
            return;
        }
        if (view.getMacroRecorder() != null) {
            GUIUtilities.error(view, "already-recording", new String[0]);
            return;
        }
        Buffer buffer = jEdit.openFile((View)null, string + File.separator + "macros", "Temporary_Macro.bsh", true, null);
        if (buffer == null) {
            return;
        }
        buffer.remove(0, buffer.getLength());
        buffer.insert(0, jEdit.getProperty("macro.temp.header"));
        Macros.recordMacro(view, buffer, true);
    }

    public static void recordMacro(View view) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            GUIUtilities.error(view, "no-settings", new String[0]);
            return;
        }
        if (view.getMacroRecorder() != null) {
            GUIUtilities.error(view, "already-recording", new String[0]);
            return;
        }
        String string2 = GUIUtilities.input(view, "record", null);
        if (string2 == null) {
            return;
        }
        Buffer buffer = jEdit.openFile((View)null, null, MiscUtilities.constructPath(string, "macros", (string2 = string2.replace(' ', '_')) + ".bsh"), true, null);
        if (buffer == null) {
            return;
        }
        buffer.remove(0, buffer.getLength());
        buffer.insert(0, jEdit.getProperty("macro.header"));
        Macros.recordMacro(view, buffer, false);
    }

    public static void stopRecording(View view) {
        Recorder recorder = view.getMacroRecorder();
        if (recorder == null) {
            GUIUtilities.error(view, "macro-not-recording", null);
        } else {
            view.setMacroRecorder(null);
            if (!recorder.temporary) {
                view.setBuffer(recorder.buffer);
            }
            recorder.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTemporaryMacro(View view) {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            GUIUtilities.error(view, "no-settings", null);
            return;
        }
        String string2 = MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "macros", "Temporary_Macro.bsh");
        if (jEdit.getBuffer(string2) == null) {
            GUIUtilities.error(view, "no-temp-macro", null);
            return;
        }
        Handler handler = Macros.getHandler("beanshell");
        Macro macro = handler.createMacro(string2, string2);
        Buffer buffer = view.getBuffer();
        try {
            buffer.beginCompoundEdit();
            macro.invoke(view);
        }
        finally {
            if (buffer.insideCompoundEdit()) {
                buffer.endCompoundEdit();
            }
        }
    }

    private static void loadMacros(List list, String string, File file) {
        lastMacro = null;
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = file2.getName();
            if (file2.isHidden()) continue;
            if (file2.isDirectory()) {
                String string3 = string2.replace('_', ' ');
                List<String> list2 = null;
                for (Object e : list) {
                    List list3;
                    if (!(e instanceof List) || !string3.equals((list3 = (List)e).get(0))) continue;
                    list2 = list3;
                    break;
                }
                if (list2 == null) {
                    list2 = new Vector<String>();
                    list2.add(string3);
                    list.add(list2);
                }
                Macros.loadMacros(list2, string + string2 + '/', file2);
                continue;
            }
            Macros.addMacro(file2, string, list);
        }
    }

    private static void addMacro(File file, String string, List list) {
        String string2 = file.getName();
        Handler handler = Macros.getHandlerForPathName(file.getPath());
        if (handler == null) {
            return;
        }
        try {
            String string3 = (string + string2).replace(' ', '_');
            Macro macro = handler.createMacro(string3, file.getPath());
            if (macroHash.get(macro.getName()) != null) {
                return;
            }
            list.add(macro.getName());
            jEdit.setTemporaryProperty(macro.getName() + ".label", macro.label);
            jEdit.setTemporaryProperty(macro.getName() + ".mouse-over", handler.getLabel() + " - " + file.getPath());
            macroActionSet.addAction(macro);
            macroHash.put(macro.getName(), macro);
        }
        catch (Exception exception) {
            Log.log(9, Macros.class, exception);
            macroHandlers.remove(handler);
        }
    }

    private static void recordMacro(View view, Buffer buffer, boolean bl) {
        view.setMacroRecorder(new Recorder(view, buffer, bl));
        view.getStatus().setMessage(null);
    }

    static {
        macroHandlers = new ArrayList<Handler>();
        Macros.registerHandler(new BeanShellHandler());
        macroActionSet = new ActionSet(jEdit.getProperty("action-set.macros"));
        jEdit.addActionSet(macroActionSet);
        macroHierarchy = new Vector();
        macroHash = new Hashtable<String, Macro>();
    }

    private static class BeanShellHandler
    extends Handler {
        BeanShellHandler() {
            super("beanshell");
        }

        @Override
        public Macro createMacro(String string, String string2) {
            string = string.substring(0, string.length() - 4);
            return new Macro(this, string, Macro.macroNameToLabel(string), string2);
        }

        @Override
        public void runMacro(View view, Macro macro) {
            BeanShell.runScript(view, macro.getPath(), null, true);
        }

        @Override
        public void runMacro(View view, Macro macro, boolean bl) {
            BeanShell.runScript(view, macro.getPath(), null, bl);
        }
    }

    public static abstract class Handler {
        private String name;
        private String label;
        private Pattern filter;

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public boolean accept(String string) {
            return this.filter.matcher(MiscUtilities.getFileName(string)).matches();
        }

        public abstract Macro createMacro(String var1, String var2);

        public abstract void runMacro(View var1, Macro var2);

        public void runMacro(View view, Macro macro, boolean bl) {
            this.runMacro(view, macro);
        }

        protected Handler(String string) {
            this.name = string;
            this.label = jEdit.getProperty("macro-handler." + string + ".label", string);
            try {
                this.filter = Pattern.compile(StandardUtilities.globToRE(jEdit.getProperty("macro-handler." + string + ".glob")));
            }
            catch (Exception exception) {
                throw new InternalError("Missing or invalid glob for handler " + string);
            }
        }
    }

    public static class Recorder {
        View view;
        Buffer buffer;
        boolean temporary;
        boolean lastWasInput;
        boolean lastWasOverwrite;
        int overwriteCount;

        public Recorder(View view, Buffer buffer, boolean bl) {
            this.view = view;
            this.buffer = buffer;
            this.temporary = bl;
            EditBus.addToBus(this);
        }

        public void record(String string) {
            if (BeanShell.isScriptRunning()) {
                return;
            }
            this.flushInput();
            this.append("\n");
            this.append(string);
        }

        public void record(int n, String string) {
            if (n == 1) {
                this.record(string);
            } else {
                this.record("for(int i = 1; i <= " + n + "; i++)\n" + "{\n" + string + '\n' + '}');
            }
        }

        public void recordInput(int n, char c, boolean bl) {
            if (c == '\n') {
                this.record(n, "textArea.userInput('\\n');");
            } else if (c == '\t') {
                this.record(n, "textArea.userInput('\\t');");
            } else {
                StringBuilder stringBuilder = new StringBuilder(n);
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(c);
                }
                this.recordInput(stringBuilder.toString(), bl);
            }
        }

        public void recordInput(String string, boolean bl) {
            String string2 = StandardUtilities.charsToEscapes(string);
            if (bl) {
                if (this.lastWasOverwrite) {
                    ++this.overwriteCount;
                    this.append(string2);
                } else {
                    this.flushInput();
                    this.overwriteCount = 1;
                    this.lastWasOverwrite = true;
                    this.append("\ntextArea.setSelectedText(\"" + string2);
                }
            } else if (this.lastWasInput) {
                this.append(string2);
            } else {
                this.flushInput();
                this.lastWasInput = true;
                this.append("\ntextArea.setSelectedText(\"" + string2);
            }
        }

        @EditBus.EBHandler
        public void handleBufferUpdate(BufferUpdate bufferUpdate) {
            if (bufferUpdate.getWhat() == BufferUpdate.CLOSED && bufferUpdate.getBuffer() == this.buffer) {
                Macros.stopRecording(this.view);
            }
        }

        private void append(String string) {
            this.buffer.insert(this.buffer.getLength(), string);
        }

        private void dispose() {
            this.flushInput();
            for (int i = 0; i < this.buffer.getLineCount(); ++i) {
                this.buffer.indentLine(i, true);
            }
            EditBus.removeFromBus(this);
            this.view.getStatus().setMessage(null);
        }

        private void flushInput() {
            if (this.lastWasInput) {
                this.lastWasInput = false;
                this.append("\");");
            }
            if (this.lastWasOverwrite) {
                this.lastWasOverwrite = false;
                this.append("\");\n");
                this.append("offset = buffer.getLineEndOffset(textArea.getCaretLine()) - 1;\n");
                this.append("buffer.remove(textArea.getCaretPosition(),Math.min(" + this.overwriteCount + ",offset - " + "textArea.getCaretPosition()));");
            }
        }
    }

    public static class Macro
    extends EditAction {
        private Handler handler;
        private String path;
        String label;

        public Macro(Handler handler, String string, String string2, String string3) {
            super(string);
            this.handler = handler;
            this.label = string2;
            this.path = string3;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public void invoke(View view) {
            Macros.setLastMacro(this);
            if (view == null) {
                this.handler.runMacro(null, this);
            } else {
                try {
                    view.getBuffer().beginCompoundEdit();
                    this.handler.runMacro(view, this);
                }
                finally {
                    view.getBuffer().endCompoundEdit();
                }
            }
        }

        @Override
        public String getCode() {
            return "Macros.getMacro(\"" + this.getName() + "\").invoke(view);";
        }

        public static String macroNameToLabel(String string) {
            int n = string.lastIndexOf(47);
            return string.substring(n + 1).replace('_', ' ');
        }
    }
}

