/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowAnalyzer;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ControlFlowFactory {
    private final ConcurrentMap<PsiElement, ConcurrentList<ControlFlowContext>> cachedFlows = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private static final NotNullLazyKey<ControlFlowFactory, Project> INSTANCE_KEY = ServiceManager.createLazyKey(ControlFlowFactory.class);

    public static ControlFlowFactory getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public ControlFlowFactory(PsiManagerEx psiManager) {
        psiManager.registerRunnableToRunOnChange(() -> this.clearCache());
    }

    private void clearCache() {
        this.cachedFlows.clear();
    }

    void registerSubRange(PsiElement codeFragment, ControlFlowSubRange flow, boolean evaluateConstantIfConfition, boolean enableShortCircuit, ControlFlowPolicy policy) {
        this.registerControlFlow(codeFragment, flow, evaluateConstantIfConfition, enableShortCircuit, policy);
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy) throws AnalysisCanceledException {
        if (element == null) {
            ControlFlowFactory.$$$reportNull$$$0(0);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(1);
        }
        ControlFlow controlFlow = this.getControlFlow(element, policy, true, true);
        if (controlFlow == null) {
            ControlFlowFactory.$$$reportNull$$$0(2);
        }
        return controlFlow;
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy, boolean evaluateConstantIfCondition) throws AnalysisCanceledException {
        if (element == null) {
            ControlFlowFactory.$$$reportNull$$$0(3);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(4);
        }
        ControlFlow controlFlow = this.getControlFlow(element, policy, true, evaluateConstantIfCondition);
        if (controlFlow == null) {
            ControlFlowFactory.$$$reportNull$$$0(5);
        }
        return controlFlow;
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element, @NotNull ControlFlowPolicy policy, boolean enableShortCircuit, boolean evaluateConstantIfCondition) throws AnalysisCanceledException {
        ControlFlowContext context2;
        if (element == null) {
            ControlFlowFactory.$$$reportNull$$$0(6);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(7);
        }
        if (!element.isPhysical()) {
            ControlFlow controlFlow = new ControlFlowAnalyzer(element, policy, enableShortCircuit, evaluateConstantIfCondition).buildControlFlow();
            if (controlFlow == null) {
                ControlFlowFactory.$$$reportNull$$$0(8);
            }
            return controlFlow;
        }
        long modificationCount = element.getManager().getModificationTracker().getModificationCount();
        ConcurrentList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element);
        for (ControlFlowContext context2 : cached) {
            if (!context2.isFor(policy, evaluateConstantIfCondition, enableShortCircuit, modificationCount)) continue;
            ControlFlow controlFlow = context2.controlFlow;
            if (controlFlow == null) {
                ControlFlowFactory.$$$reportNull$$$0(9);
            }
            return controlFlow;
        }
        ControlFlow controlFlow = new ControlFlowAnalyzer(element, policy, enableShortCircuit, evaluateConstantIfCondition).buildControlFlow();
        context2 = ControlFlowFactory.createContext(evaluateConstantIfCondition, enableShortCircuit, policy, controlFlow, modificationCount);
        cached.addIfAbsent(context2);
        ControlFlow controlFlow2 = controlFlow;
        if (controlFlow2 == null) {
            ControlFlowFactory.$$$reportNull$$$0(10);
        }
        return controlFlow2;
    }

    @NotNull
    private static ControlFlowContext createContext(boolean evaluateConstantIfCondition, boolean enableShortCircuit, @NotNull ControlFlowPolicy policy, @NotNull ControlFlow controlFlow, long modificationCount) {
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(11);
        }
        if (controlFlow == null) {
            ControlFlowFactory.$$$reportNull$$$0(12);
        }
        ControlFlowContext controlFlowContext = new ControlFlowContext(evaluateConstantIfCondition, enableShortCircuit, policy, modificationCount, controlFlow);
        if (controlFlowContext == null) {
            ControlFlowFactory.$$$reportNull$$$0(13);
        }
        return controlFlowContext;
    }

    private void registerControlFlow(@NotNull PsiElement element, @NotNull ControlFlow flow, boolean evaluateConstantIfCondition, boolean enableShortCircuit, @NotNull ControlFlowPolicy policy) {
        if (element == null) {
            ControlFlowFactory.$$$reportNull$$$0(14);
        }
        if (flow == null) {
            ControlFlowFactory.$$$reportNull$$$0(15);
        }
        if (policy == null) {
            ControlFlowFactory.$$$reportNull$$$0(16);
        }
        long modificationCount = element.getManager().getModificationTracker().getModificationCount();
        ControlFlowContext controlFlowContext = ControlFlowFactory.createContext(evaluateConstantIfCondition, enableShortCircuit, policy, flow, modificationCount);
        ConcurrentList<ControlFlowContext> cached = this.getOrCreateCachedFlowsForElement(element);
        cached.addIfAbsent(controlFlowContext);
    }

    @NotNull
    private ConcurrentList<ControlFlowContext> getOrCreateCachedFlowsForElement(@NotNull PsiElement element) {
        ConcurrentList<ControlFlowContext> cached;
        if (element == null) {
            ControlFlowFactory.$$$reportNull$$$0(17);
        }
        if ((cached = (ConcurrentList<ControlFlowContext>)this.cachedFlows.get(element)) == null) {
            cached = ContainerUtil.createConcurrentList();
            this.cachedFlows.put(element, cached);
        }
        ConcurrentList<ControlFlowContext> concurrentList = cached;
        if (concurrentList == null) {
            ControlFlowFactory.$$$reportNull$$$0(18);
        }
        return concurrentList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowFactory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowFactory";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCachedFlowsForElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerControlFlow";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCachedFlowsForElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ControlFlowContext {
        private final ControlFlowPolicy policy;
        private final boolean evaluateConstantIfCondition;
        private final boolean enableShortCircuit;
        private final long modificationCount;
        private final ControlFlow controlFlow;

        /*
         * WARNING - void declaration
         */
        private ControlFlowContext(boolean evaluateConstantIfCondition, boolean enableShortCircuit, @NotNull ControlFlowPolicy policy, long modificationCount, @NotNull ControlFlow controlFlow) {
            void controlFlow2;
            if (policy == null) {
                ControlFlowContext.$$$reportNull$$$0(0);
            }
            if (controlFlow == null) {
                ControlFlowContext.$$$reportNull$$$0(1);
            }
            this.evaluateConstantIfCondition = evaluateConstantIfCondition;
            this.enableShortCircuit = enableShortCircuit;
            this.policy = policy;
            this.modificationCount = modificationCount;
            this.controlFlow = controlFlow2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ControlFlowContext that = (ControlFlowContext)o;
            return this.isFor(that);
        }

        public int hashCode() {
            int result2 = this.policy.hashCode();
            result2 = 31 * result2 + (this.evaluateConstantIfCondition ? 1 : 0);
            result2 = 31 * result2 + (int)(this.modificationCount ^ this.modificationCount >>> 32);
            return result2;
        }

        private boolean isFor(@NotNull ControlFlowPolicy policy, boolean evaluateConstantIfCondition, boolean enableShortCircuit, long modificationCount) {
            if (policy == null) {
                ControlFlowContext.$$$reportNull$$$0(2);
            }
            if (modificationCount != this.modificationCount) {
                return false;
            }
            if (!policy.equals(this.policy)) {
                return false;
            }
            if (enableShortCircuit != this.enableShortCircuit) {
                return false;
            }
            if (this.evaluateConstantIfCondition && !this.controlFlow.isConstantConditionOccurred()) {
                return true;
            }
            return evaluateConstantIfCondition == this.evaluateConstantIfCondition;
        }

        private boolean isFor(@NotNull ControlFlowContext that) {
            if (that == null) {
                ControlFlowContext.$$$reportNull$$$0(3);
            }
            return this.isFor(that.policy, that.evaluateConstantIfCondition, that.enableShortCircuit, that.modificationCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controlFlow";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowFactory$ControlFlowContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

